/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.sitemesh;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.ContentProcessor;
import com.opensymphony.sitemesh.Decorator;
import com.opensymphony.sitemesh.DecoratorSelector;
import com.opensymphony.sitemesh.SiteMeshContext;
import com.opensymphony.sitemesh.webapp.ContainerTweaks;
import com.opensymphony.sitemesh.webapp.ContentBufferingResponse;
import com.opensymphony.sitemesh.webapp.SiteMeshFilter;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.sitemesh.FactoryHolder;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.web.util.UrlPathHelper;

public class GrailsPageFilter
extends SiteMeshFilter {
    private static final Log LOG = LogFactory.getLog(GrailsPageFilter.class);
    private static final String ALREADY_APPLIED_KEY = "com.opensymphony.sitemesh.APPLIED_ONCE";
    private static final String HTML_EXT = ".html";
    private static final String UTF_8_ENCODING = "UTF-8";
    private static final String CONFIG_OPTION_GSP_ENCODING = "grails.views.gsp.encoding";
    private FilterConfig filterConfig;
    private ContainerTweaks containerTweaks;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this.filterConfig = filterConfig;
        this.containerTweaks = new ContainerTweaks();
        FactoryHolder.setFactory(Factory.getInstance((Config)new Config(filterConfig)));
    }

    public void destroy() {
        super.destroy();
        FactoryHolder.setFactory(null);
    }

    public void doFilter(ServletRequest rq, ServletResponse rs, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)rq;
        HttpServletResponse response = (HttpServletResponse)rs;
        ServletContext servletContext = this.filterConfig.getServletContext();
        SiteMeshWebAppContext webAppContext = new SiteMeshWebAppContext(request, response, servletContext);
        ContentProcessor contentProcessor = this.initContentProcessor(webAppContext);
        DecoratorSelector decoratorSelector = this.initDecoratorSelector(webAppContext);
        if (this.filterAlreadyAppliedForRequest(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (!contentProcessor.handles((SiteMeshContext)webAppContext)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.containerTweaks.shouldAutoCreateSession()) {
            request.getSession(true);
        }
        try {
            Content content = this.obtainContent(contentProcessor, webAppContext, request, response, chain);
            if (content == null) {
                return;
            }
            this.detectContentTypeFromPage(content, response);
            Decorator decorator = decoratorSelector.selectDecorator(content, (SiteMeshContext)webAppContext);
            decorator.render(content, (SiteMeshContext)webAppContext);
        }
        catch (IllegalStateException e) {
            if (!this.containerTweaks.shouldIgnoreIllegalStateExceptionOnErrorPage()) {
                throw e;
            }
        }
        catch (RuntimeException e) {
            if (this.containerTweaks.shouldLogUnhandledExceptions()) {
                servletContext.log("Unhandled exception occurred whilst decorating page", (Throwable)e);
            }
            throw e;
        }
        catch (ServletException e) {
            request.setAttribute(ALREADY_APPLIED_KEY, null);
            throw e;
        }
    }

    private Content obtainContent(ContentProcessor contentProcessor, SiteMeshWebAppContext webAppContext, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        ContentBufferingResponse contentBufferingResponse = new ContentBufferingResponse(response, contentProcessor, webAppContext){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sendError(int sc) throws IOException {
                GrailsWebRequest webRequest = WebUtils.retrieveGrailsWebRequest();
                try {
                    super.sendError(sc);
                }
                finally {
                    WebUtils.storeGrailsWebRequest(webRequest);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sendError(int sc, String msg) throws IOException {
                GrailsWebRequest webRequest = WebUtils.retrieveGrailsWebRequest();
                try {
                    super.sendError(sc, msg);
                }
                finally {
                    WebUtils.storeGrailsWebRequest(webRequest);
                }
            }
        };
        this.setDefaultConfiguredEncoding(request, contentBufferingResponse);
        chain.doFilter((ServletRequest)request, (ServletResponse)contentBufferingResponse);
        webAppContext.setUsingStream(contentBufferingResponse.isUsingStream());
        return contentBufferingResponse.getContent();
    }

    private void setDefaultConfiguredEncoding(HttpServletRequest request, ContentBufferingResponse contentBufferingResponse) {
        UrlPathHelper urlHelper = new UrlPathHelper();
        String requestURI = urlHelper.getOriginatingRequestUri(request);
        if (requestURI.endsWith(HTML_EXT)) {
            String encoding = (String)ConfigurationHolder.getFlatConfig().get(CONFIG_OPTION_GSP_ENCODING);
            if (encoding == null) {
                encoding = UTF_8_ENCODING;
            }
            contentBufferingResponse.setContentType("text/html;charset=" + encoding);
        }
    }

    private boolean filterAlreadyAppliedForRequest(HttpServletRequest request) {
        if (request.getAttribute(ALREADY_APPLIED_KEY) == Boolean.TRUE) {
            return true;
        }
        request.setAttribute(ALREADY_APPLIED_KEY, (Object)Boolean.TRUE);
        return false;
    }

    private void detectContentTypeFromPage(Content page, HttpServletResponse response) {
        String contentType = page.getProperty("meta.http-equiv.Content-Type");
        if (contentType != null && "text/html".equals(response.getContentType())) {
            response.setContentType(contentType);
        }
    }
}

