/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaProperty;
import groovy.lang.Script;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.pages.FastStringWriter;
import org.codehaus.groovy.grails.web.pages.TagLibraryLookup;
import org.codehaus.groovy.grails.web.pages.exceptions.GroovyPagesException;
import org.codehaus.groovy.grails.web.pages.ext.jsp.TagLibraryResolver;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.taglib.GroovyPageTagWriter;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;

public abstract class GroovyPage
extends Script {
    private static final Log LOG = LogFactory.getLog(GroovyPage.class);
    public static final String REQUEST = "request";
    public static final String SERVLET_CONTEXT = "application";
    public static final String RESPONSE = "response";
    public static final String OUT = "out";
    public static final String ATTRIBUTES = "attributes";
    public static final String APPLICATION_CONTEXT = "applicationContext";
    public static final String SESSION = "session";
    public static final String PARAMS = "params";
    public static final String FLASH = "flash";
    public static final String PLUGIN_CONTEXT_PATH = "pluginContextPath";
    public static final String EXTENSION = ".gsp";
    public static final String WEB_REQUEST = "webRequest";
    public static final String DEFAULT_NAMESPACE = "g";
    public static final String TEMPLATE_NAMESPACE = "tmpl";
    public static final String PAGE_SCOPE = "pageScope";
    public static final String CONTROLLER_NAME = "controllerName";
    public static final String ACTION_NAME = "actionName";
    public static final Collection<String> RESERVED_NAMES = new ArrayList<String>(){
        {
            this.add(GroovyPage.REQUEST);
            this.add(GroovyPage.SERVLET_CONTEXT);
            this.add(GroovyPage.RESPONSE);
            this.add(GroovyPage.OUT);
            this.add(GroovyPage.ATTRIBUTES);
            this.add(GroovyPage.APPLICATION_CONTEXT);
            this.add(GroovyPage.SESSION);
            this.add(GroovyPage.PARAMS);
            this.add(GroovyPage.FLASH);
            this.add(GroovyPage.PLUGIN_CONTEXT_PATH);
            this.add(GroovyPage.PAGE_SCOPE);
        }
    };
    private static final String BINDING = "binding";
    private static final String BLANK_STRING = "";
    private Map jspTags = Collections.EMPTY_MAP;
    private TagLibraryResolver jspTagLibraryResolver;
    private TagLibraryLookup gspTagLibraryLookup;

    public void setJspTagLibraryResolver(TagLibraryResolver jspTagLibraryResolver) {
        this.jspTagLibraryResolver = jspTagLibraryResolver;
    }

    public void setGspTagLibraryLookup(TagLibraryLookup gspTagLibraryLookup) {
        this.gspTagLibraryLookup = gspTagLibraryLookup;
    }

    TagLibraryResolver getTagLibraryResolver() {
        return this.jspTagLibraryResolver;
    }

    public Object evaluate(String exprText, int lineNumber, Object outerIt, Closure evaluator) {
        try {
            return evaluator.call(outerIt);
        }
        catch (Exception e) {
            throw new GroovyPagesException("Error evaluating expression [" + exprText + "] on line [" + lineNumber + "]: " + e.getMessage(), e, lineNumber, this.getGroovyPageFileName());
        }
    }

    public abstract String getGroovyPageFileName();

    public Object getProperty(String property) {
        if (BINDING.equals(property)) {
            return this.getBinding();
        }
        MetaProperty mp = this.getMetaClass().getMetaProperty(property);
        if (mp != null) {
            return mp.getProperty((Object)this);
        }
        Object value = this.getBinding().getVariables().get(property);
        if (value == null) {
            Object object = value = this.gspTagLibraryLookup != null ? this.gspTagLibraryLookup.lookupNamespaceDispatcher(property) : null;
        }
        if (value == null && this.jspTags.containsKey(property)) {
            TagLibraryResolver tagResolver = this.getTagLibraryResolver();
            String uri = (String)this.jspTags.get(property);
            if (uri != null) {
                value = tagResolver.resolveTagLibrary(uri);
            }
        }
        return value;
    }

    public void invokeTag(String tagName, Map attrs, Closure body) {
        this.invokeTag(tagName, DEFAULT_NAMESPACE, attrs, body);
    }

    public void invokeTag(String tagName, String tagNamespace, Map attrs, Closure body) {
        this.invokeTag(tagName, tagNamespace, -1, attrs, body);
    }

    public void invokeTag(String tagName, String tagNamespace, int lineNumber, Map attrs, Closure body) {
        block17: {
            if (tagNamespace.equals(TEMPLATE_NAMESPACE)) {
                final String tmpTagName = tagName;
                final Map tmpAttrs = attrs;
                tagName = "render";
                tagNamespace = DEFAULT_NAMESPACE;
                attrs = new HashMap(){
                    {
                        this.put("model", tmpAttrs);
                        this.put("template", tmpTagName);
                    }
                };
            }
            GrailsWebRequest webRequest = (GrailsWebRequest)this.getBinding().getVariable(WEB_REQUEST);
            Writer out = webRequest.getOut();
            try {
                if (this.gspTagLibraryLookup.hasNamespace(tagNamespace)) {
                    GroovyObject tagLib = this.getTagLib(tagName, tagNamespace);
                    if (tagLib != null) {
                        Object tagLibProp = tagLib.getProperty(tagName);
                        if (tagLibProp instanceof Closure) {
                            Closure tag = (Closure)((Closure)tagLibProp).clone();
                            switch (tag.getParameterTypes().length) {
                                case 1: {
                                    tag.call(new Object[]{attrs});
                                    if (body == null) break;
                                    body.call();
                                    break;
                                }
                                case 2: {
                                    if (tag.getParameterTypes().length != 2) break;
                                    tag.call(new Object[]{attrs, body});
                                }
                            }
                            break block17;
                        }
                        throw new GrailsTagException("Tag [" + tagName + "] does not exist in tag library [" + tagLib.getClass().getName() + "]", this.getGroovyPageFileName(), lineNumber);
                    }
                    throw new GrailsTagException("Tag [" + tagName + "] does not exist. No tag library found for namespace: " + tagNamespace, this.getGroovyPageFileName(), lineNumber);
                }
                StringBuilder plainTag = new StringBuilder();
                String fullTagName = tagNamespace + ":" + tagName;
                plainTag.append("<").append(fullTagName);
                Iterator i$ = attrs.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    plainTag.append(" ").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
                }
                plainTag.append(">");
                try {
                    Object bodyOutput;
                    out.write(plainTag.toString());
                    if (body != null && (bodyOutput = body.call()) != null) {
                        out.write(bodyOutput.toString());
                    }
                    out.write("</" + fullTagName + ">");
                }
                catch (IOException e) {
                    throw new GrailsTagException("I/O error invoking tag library closure as method", this.getGroovyPageFileName(), 0);
                }
            }
            catch (Exception e) {
                throw new GrailsTagException("Error executing tag <" + tagNamespace + ":" + tagName + ">: " + e.getMessage(), this.getGroovyPageFileName(), lineNumber);
            }
            finally {
                this.getBinding().setVariable(OUT, (Object)out);
                webRequest.setOut(out);
            }
        }
    }

    private GroovyObject getTagLib(String tagName) {
        return this.getTagLib(tagName, DEFAULT_NAMESPACE);
    }

    private GroovyObject getTagLib(String tagName, String namespace) {
        return this.gspTagLibraryLookup != null ? this.gspTagLibraryLookup.lookupTagLibrary(namespace, tagName) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeMethod(String methodName, Object args) {
        if (methodName.equals("invokeTag")) {
            return super.invokeMethod(methodName, args);
        }
        Map attrs = null;
        Object body = null;
        GroovyObject tagLib = this.getTagLib(methodName);
        if (tagLib != null) {
            GrailsWebRequest webRequest = (GrailsWebRequest)this.getBinding().getVariable(WEB_REQUEST);
            Writer originalOut = webRequest.getOut();
            try {
                if (args instanceof Object[]) {
                    Object[] argArray = (Object[])args;
                    if (argArray.length > 0 && argArray[0] instanceof Map) {
                        attrs = (Map)argArray[0];
                    }
                    if (argArray.length > 1) {
                        body = argArray[1];
                    }
                } else if (args instanceof Map) {
                    attrs = (HashMap)args;
                }
                if (attrs == null) {
                    attrs = new HashMap();
                }
                String string = GroovyPage.captureTagOutput(tagLib, methodName, attrs, body, webRequest);
                return string;
            }
            finally {
                this.getBinding().setVariable(OUT, (Object)originalOut);
                webRequest.setOut(originalOut);
            }
        }
        return super.invokeMethod(methodName, args);
    }

    public static String captureTagOutput(GroovyObject tagLib, String methodName, Map attrs, Object body, GrailsWebRequest webRequest) {
        Writer originalOut = webRequest.getOut();
        try {
            GroovyPageTagWriter out = new GroovyPageTagWriter(new FastStringWriter());
            webRequest.setOut(out);
            Closure actualBody = GroovyPage.createTagOutputCapturingClosure(tagLib, methodName, out, body);
            Object tagLibProp = tagLib.getProperty(methodName);
            if (tagLibProp instanceof Closure) {
                Closure tag = (Closure)((Closure)tagLibProp).clone();
                if (tag.getParameterTypes().length == 1) {
                    tag.call(new Object[]{attrs});
                    if (actualBody != null) {
                        actualBody.call();
                    }
                } else if (tag.getParameterTypes().length == 2) {
                    tag.call(new Object[]{attrs, actualBody});
                } else {
                    throw new GrailsTagException("Tag [" + methodName + "] does not specify expected number of params in tag library [" + tagLib.getClass().getName() + "]");
                }
                String string = out.getValue();
                return string;
            }
            throw new GrailsTagException("Tag [" + methodName + "] does not exist in tag library [" + tagLib.getClass().getName() + "]");
        }
        finally {
            webRequest.setOut(originalOut);
        }
    }

    private static Closure createTagOutputCapturingClosure(Object wrappedInstance, final String methodName, final Writer out, final Object body1) {
        return new Closure(wrappedInstance){

            public Object doCall(Object obj) {
                return this.call(new Object[]{obj});
            }

            public Object doCall() {
                return this.call(new Object[0]);
            }

            public Object doCall(Object[] args) {
                return this.call(args);
            }

            public Object call(Object[] args) {
                if (body1 != null) {
                    Object bodyResponse = body1 instanceof Closure ? (args != null && args.length > 0 ? ((Closure)body1).call(args) : ((Closure)body1).call()) : body1;
                    if (bodyResponse != null && !(bodyResponse instanceof Writer)) {
                        try {
                            out.write(bodyResponse.toString());
                        }
                        catch (IOException e) {
                            throw new GrailsTagException("I/O error invoking tag library closure [" + methodName + "] as method");
                        }
                    }
                }
                return GroovyPage.BLANK_STRING;
            }
        };
    }

    public static boolean isReservedName(String name) {
        return RESERVED_NAMES.contains(name);
    }

    public void setJspTags(Map jspTags) {
        this.jspTags = jspTags;
    }
}

