/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.errors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.grails.commons.ApplicationHolder;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.exceptions.GrailsException;
import org.codehaus.groovy.grails.exceptions.SourceCodeAware;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.servlet.DefaultGrailsApplicationAttributes;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class GrailsWrappedRuntimeException
extends GrailsException {
    private static final Pattern PARSE_DETAILS_STEP1 = Pattern.compile("\\((\\w+)\\.groovy:(\\d+)\\)");
    private static final Pattern PARSE_DETAILS_STEP2 = Pattern.compile("at\\s{1}(\\w+)\\$_closure\\d+\\.doCall\\(\\1:(\\d+)\\)");
    private static final Pattern PARSE_DETAILS_STEP3 = Pattern.compile("\\p{Upper}(\\S+?)\\$_closure\\d+\\.doCall\\(\\1:(\\d+)\\)");
    private static final Pattern PARSE_GSP_DETAILS_STEP1 = Pattern.compile("(\\S+?)_\\S+?_gsp.run\\((\\S+?\\.gsp):(\\d+)\\)");
    public static final String URL_PREFIX = "/WEB-INF/grails-app/";
    private static final Log LOG = LogFactory.getLog(GrailsWrappedRuntimeException.class);
    private String className;
    private int lineNumber;
    private String stackTrace;
    private String[] codeSnippet;
    private String gspFile;
    private Throwable cause;
    private PathMatchingResourcePatternResolver resolver;
    private String[] stackTraceLines;
    private static final String UNKNOWN = "Unknown";
    private String fileName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrailsWrappedRuntimeException(ServletContext servletContext, Throwable t) {
        block44: {
            super(t.getMessage(), t);
            this.className = UNKNOWN;
            this.lineNumber = -1;
            this.codeSnippet = new String[0];
            this.resolver = new PathMatchingResourcePatternResolver();
            this.cause = t;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.cause.printStackTrace(pw);
            this.stackTrace = sw.toString();
            while (this.cause.getCause() != this.cause && this.cause.getCause() != null) {
                this.cause = this.cause.getCause();
            }
            this.stackTraceLines = this.stackTrace.split("\\n");
            if (this.cause instanceof MultipleCompilationErrorsException) {
                MultipleCompilationErrorsException mcee = (MultipleCompilationErrorsException)this.cause;
                Object message = mcee.getErrorCollector().getErrors().iterator().next();
                if (message instanceof SyntaxErrorMessage) {
                    SyntaxErrorMessage sem = (SyntaxErrorMessage)message;
                    this.lineNumber = sem.getCause().getLine();
                    sem.write(pw);
                }
            } else {
                Matcher m1 = PARSE_DETAILS_STEP1.matcher(this.stackTrace);
                Matcher m2 = PARSE_DETAILS_STEP2.matcher(this.stackTrace);
                Matcher gsp = PARSE_GSP_DETAILS_STEP1.matcher(this.stackTrace);
                try {
                    if (gsp.find()) {
                        this.className = gsp.group(2);
                        this.lineNumber = Integer.parseInt(gsp.group(3));
                        this.gspFile = "/WEB-INF/grails-app/views/" + gsp.group(1) + '/' + this.className;
                    } else if (m1.find()) {
                        this.className = m1.group(1);
                        this.lineNumber = Integer.parseInt(m1.group(2));
                    } else if (m2.find()) {
                        this.className = m2.group(1);
                        this.lineNumber = Integer.parseInt(m2.group(2));
                    }
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            BufferedReader reader = null;
            try {
                InputStream in;
                block45: {
                    String fileLocation;
                    this.checkIfSourceCodeAware(t);
                    this.checkIfSourceCodeAware(this.cause);
                    if (this.getLineNumber() <= -1) break block44;
                    String url = null;
                    if (this.fileName != null) {
                        fileLocation = this.fileName;
                    } else {
                        String fileName = this.className.replace('.', '/') + ".groovy";
                        String urlPrefix = "";
                        if (this.gspFile == null) {
                            GrailsApplication application = ApplicationHolder.getApplication();
                            if (application.isArtefactOfType("Controller", this.className)) {
                                urlPrefix = urlPrefix + "/controllers/";
                            } else if (application.isArtefactOfType("TagLib", this.className)) {
                                urlPrefix = urlPrefix + "/taglib/";
                            } else if (application.isArtefactOfType("Service", this.className)) {
                                urlPrefix = urlPrefix + "/services/";
                            }
                            url = URL_PREFIX + urlPrefix + fileName;
                        } else {
                            url = this.gspFile;
                            DefaultGrailsApplicationAttributes attrs = new DefaultGrailsApplicationAttributes(servletContext);
                            GroovyPagesTemplateEngine engine = attrs.getPagesTemplateEngine();
                            int[] lineNumbers = engine.calculateLineNumbersForPage(servletContext, url);
                            if (this.lineNumber < lineNumbers.length) {
                                this.lineNumber = lineNumbers[this.lineNumber - 1];
                            }
                        }
                        fileLocation = "grails-app" + urlPrefix + fileName;
                    }
                    in = null;
                    if (!StringUtils.isBlank(url)) {
                        in = servletContext.getResourceAsStream(url);
                        LOG.debug((Object)("Attempting to display code snippet found in url " + url));
                    }
                    if (in == null) {
                        Resource r = null;
                        try {
                            r = this.resolver.getResource(fileLocation);
                            in = r.getInputStream();
                        }
                        catch (Throwable e) {
                            r = this.resolver.getResource("file:" + fileLocation);
                            if (!r.exists()) break block45;
                            try {
                                in = r.getInputStream();
                            }
                            catch (IOException e1) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (in != null) {
                    reader = new LineNumberReader(new InputStreamReader(in));
                    String currentLine = ((LineNumberReader)reader).readLine();
                    StringBuilder buf = new StringBuilder();
                    while (currentLine != null) {
                        int currentLineNumber = ((LineNumberReader)reader).getLineNumber();
                        if (currentLineNumber == this.lineNumber) {
                            buf.append(currentLineNumber).append(": ").append(currentLine).append("\n");
                        } else if (currentLineNumber == this.lineNumber + 1) {
                            buf.append(currentLineNumber).append(": ").append(currentLine);
                            break;
                        }
                        currentLine = ((LineNumberReader)reader).readLine();
                    }
                    this.codeSnippet = buf.toString().split("\n");
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("[GrailsWrappedRuntimeException] I/O error reading line diagnostics: " + e.getMessage()), (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private void checkIfSourceCodeAware(Throwable cause) {
        if (cause instanceof SourceCodeAware) {
            SourceCodeAware codeAware = (SourceCodeAware)cause;
            if (codeAware.getFileName() != null) {
                if (this.className == null || UNKNOWN.equals(this.className)) {
                    this.className = codeAware.getFileName();
                }
                this.fileName = codeAware.getFileName();
            }
            if (codeAware.getLineNumber() > -1) {
                this.lineNumber = codeAware.getLineNumber();
            }
        }
    }

    public String[] getCodeSnippet() {
        return this.codeSnippet;
    }

    public String getClassName() {
        return this.className;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getStackTraceText() {
        return this.stackTrace;
    }

    public String[] getStackTraceLines() {
        return this.stackTraceLines;
    }

    public String getMessage() {
        return this.cause.getMessage();
    }
}

