/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.servlet.view;

import grails.util.CacheEntry;
import grails.util.GrailsUtil;
import groovy.lang.GroovyObject;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.grails.gsp.GroovyPagesTemplateEngine;
import org.grails.gsp.io.GroovyPageScriptSource;
import org.grails.web.gsp.io.GrailsConventionGroovyPageLocator;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.servlet.view.GrailsViewResolver;
import org.grails.web.servlet.view.GroovyPageView;
import org.grails.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

public class GroovyPageViewResolver
extends InternalResourceViewResolver
implements GrailsViewResolver {
    private static final Logger LOG = LoggerFactory.getLogger(GroovyPageViewResolver.class);
    public static final String GSP_SUFFIX = ".gsp";
    public static final String JSP_SUFFIX = ".jsp";
    protected GroovyPagesTemplateEngine templateEngine;
    protected GrailsConventionGroovyPageLocator groovyPageLocator;
    private ConcurrentMap<String, CacheEntry<View>> viewCache = new ConcurrentHashMap<String, CacheEntry<View>>();
    private boolean allowGrailsViewCaching = !GrailsUtil.isDevelopmentEnv();
    private long cacheTimeout = -1L;
    private boolean resolveJspView = false;

    public GroovyPageViewResolver() {
        this.setCache(false);
        this.setOrder(2147483627);
    }

    public GroovyPageViewResolver(GroovyPagesTemplateEngine templateEngine, GrailsConventionGroovyPageLocator groovyPageLocator) {
        this();
        this.templateEngine = templateEngine;
        this.groovyPageLocator = groovyPageLocator;
    }

    public void setGroovyPageLocator(GrailsConventionGroovyPageLocator groovyPageLocator) {
        this.groovyPageLocator = groovyPageLocator;
    }

    public View resolveViewName(String viewName, Locale locale) throws Exception {
        return super.resolveViewName(WebUtils.addViewPrefix((String)viewName), locale);
    }

    protected View loadView(String viewName, Locale locale) throws Exception {
        Assert.notNull((Object)this.templateEngine, (String)"Property [templateEngine] cannot be null");
        if (viewName.endsWith(GSP_SUFFIX)) {
            viewName = viewName.substring(0, viewName.length() - GSP_SUFFIX.length());
        }
        if (!this.allowGrailsViewCaching) {
            return this.createGrailsView(viewName);
        }
        String viewCacheKey = this.groovyPageLocator.resolveViewFormat(viewName);
        String currentControllerKeyPrefix = this.resolveCurrentControllerKeyPrefixes();
        if (currentControllerKeyPrefix != null) {
            viewCacheKey = currentControllerKeyPrefix + ':' + viewCacheKey;
        }
        CacheEntry entry = (CacheEntry)this.viewCache.get(viewCacheKey);
        final String lookupViewName = viewName;
        Callable<View> updater = new Callable<View>(){

            @Override
            public View call() throws Exception {
                try {
                    return GroovyPageViewResolver.this.createGrailsView(lookupViewName);
                }
                catch (Exception e) {
                    throw new WrappedInitializationException(e);
                }
            }
        };
        View view = null;
        if (entry == null) {
            try {
                return (View)CacheEntry.getValue(this.viewCache, (Object)viewCacheKey, (long)this.cacheTimeout, (Callable)updater);
            }
            catch (CacheEntry.UpdateException e) {
                e.rethrowCause();
                return null;
            }
        }
        try {
            view = (View)entry.getValue(this.cacheTimeout, (Callable)updater, true, null);
        }
        catch (WrappedInitializationException e) {
            e.rethrowCause();
        }
        return view;
    }

    protected String resolveCurrentControllerKeyPrefixes() {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest != null) {
            String namespace = webRequest.getControllerNamespace();
            String pluginContextPath = webRequest.getAttributes() != null && webRequest.getCurrentRequest() != null ? webRequest.getAttributes().getPluginContextPath(webRequest.getCurrentRequest()) : null;
            return (pluginContextPath != null ? pluginContextPath : "-") + "," + (namespace != null ? namespace : "-");
        }
        return null;
    }

    protected View createGrailsView(String viewName) throws Exception {
        GroovyPageScriptSource scriptSource;
        GroovyObject controller = null;
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest != null) {
            HttpServletRequest request = webRequest.getCurrentRequest();
            controller = webRequest.getAttributes().getController((ServletRequest)request);
        }
        if (controller == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Locating GSP view for path {}", (Object)viewName);
            }
            scriptSource = this.groovyPageLocator.findViewByPath(viewName);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Locating GSP view for controller {} and path {}", (Object)controller, (Object)viewName);
            }
            scriptSource = this.groovyPageLocator.findView(controller, viewName);
        }
        if (scriptSource != null) {
            return this.createGroovyPageView(scriptSource.getURI(), (ScriptSource)scriptSource);
        }
        return this.createFallbackView(viewName);
    }

    private View createGroovyPageView(String gspView, ScriptSource scriptSource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolved GSP view at URI [" + gspView + "]");
        }
        GroovyPageView gspSpringView = new GroovyPageView();
        gspSpringView.setServletContext(this.getServletContext());
        gspSpringView.setUrl(gspView);
        gspSpringView.setApplicationContext(this.getApplicationContext());
        gspSpringView.setTemplateEngine(this.templateEngine);
        gspSpringView.setScriptSource(scriptSource);
        try {
            gspSpringView.afterPropertiesSet();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initialized GSP view for URI [{}]", (Object)gspView);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing GroovyPageView", e);
        }
        return gspSpringView;
    }

    protected View createFallbackView(String viewName) throws Exception {
        if (this.resolveJspView) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No GSP view found, falling back to locating JSTL view for name [{}]", (Object)viewName);
            }
            return this.createJstlView(viewName);
        }
        return null;
    }

    protected View createJstlView(String viewName) throws Exception {
        AbstractUrlBasedView view = this.buildView(viewName);
        view.setApplicationContext(this.getApplicationContext());
        view.afterPropertiesSet();
        return view;
    }

    @Autowired(required=true)
    @Qualifier(value="groovyPagesTemplateEngine")
    public void setTemplateEngine(GroovyPagesTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public long getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(long cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    public void clearCache() {
        super.clearCache();
        this.viewCache.clear();
    }

    public boolean isAllowGrailsViewCaching() {
        return this.allowGrailsViewCaching;
    }

    public void setAllowGrailsViewCaching(boolean allowGrailsViewCaching) {
        this.allowGrailsViewCaching = allowGrailsViewCaching;
    }

    public void setResolveJspView(boolean resolveJspView) {
        this.resolveJspView = resolveJspView;
    }

    private static class WrappedInitializationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public WrappedInitializationException(Throwable cause) {
            super(cause);
        }

        public void rethrowCause() throws Exception {
            if (this.getCause() instanceof Exception) {
                throw (Exception)this.getCause();
            }
            throw this;
        }
    }
}

