/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages.discovery;

import grails.util.CacheEntry;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.groovy.grails.web.pages.discovery.GroovyPageStaticResourceLocator;
import org.springframework.core.io.Resource;

public class CachingGroovyPageStaticResourceLocator
extends GroovyPageStaticResourceLocator {
    private ConcurrentMap<String, CacheEntry<Resource>> uriResolveCache = new ConcurrentHashMap<String, CacheEntry<Resource>>();
    private long cacheTimeout = -1L;

    @Override
    public Resource findResourceForURI(final String uri) {
        Callable<Resource> updater = new Callable<Resource>(){

            @Override
            public Resource call() {
                Resource resource = CachingGroovyPageStaticResourceLocator.super.findResourceForURI(uri);
                if (resource == null) {
                    resource = NULL_RESOURCE;
                }
                return resource;
            }
        };
        Resource resource = (Resource)CacheEntry.getValue(this.uriResolveCache, (Object)uri, (long)this.cacheTimeout, (Callable)updater);
        return resource == NULL_RESOURCE ? null : resource;
    }

    public long getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(long cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }
}

