/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.Environment;
import groovy.lang.Binding;
import groovy.lang.Writable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.pages.GroovyPage;
import org.codehaus.groovy.grails.web.pages.GroovyPageBinding;
import org.codehaus.groovy.grails.web.pages.GroovyPageMetaInfo;
import org.codehaus.groovy.grails.web.pages.GroovyPageRequestBinding;
import org.codehaus.groovy.grails.web.pages.exceptions.GroovyPagesException;
import org.codehaus.groovy.grails.web.servlet.WrappedResponseHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.web.context.request.RequestContextHolder;

class GroovyPageWritable
implements Writable {
    private static final Log LOG = LogFactory.getLog(GroovyPageWritable.class);
    private static final String ATTRIBUTE_NAME_DEBUG_TEMPLATES_ID_COUNTER = "org.codehaus.groovy.grails.web.pages.DEBUG_TEMPLATES_COUNTER";
    private static final String GSP_NONE_CODEC_NAME = "none";
    private HttpServletResponse response;
    private HttpServletRequest request;
    private GroovyPageMetaInfo metaInfo;
    private boolean showSource;
    private boolean debugTemplates;
    private AtomicInteger debugTemplatesIdCounter;
    private GrailsWebRequest webRequest;
    private boolean allowSettingContentType;
    private Map additionalBinding = new HashMap();
    private static final String GROOVY_SOURCE_CONTENT_TYPE = "text/plain";
    private static final GspNoneCodec gspNoneCodeInstance = new GspNoneCodec();

    public GroovyPageWritable(GroovyPageMetaInfo metaInfo, boolean allowSettingContentType) {
        this.metaInfo = metaInfo;
        this.allowSettingContentType = allowSettingContentType;
        this.webRequest = (GrailsWebRequest)RequestContextHolder.getRequestAttributes();
        if (this.webRequest != null) {
            this.request = this.webRequest.getCurrentRequest();
            HttpServletResponse wrapped = WrappedResponseHolder.getWrappedResponse();
            this.response = wrapped != null ? wrapped : this.webRequest.getCurrentResponse();
        }
        this.showSource = this.shouldShowGroovySource();
        this.debugTemplates = this.shouldDebugTemplates();
        if (this.debugTemplates) {
            this.debugTemplatesIdCounter = (AtomicInteger)this.request.getAttribute(ATTRIBUTE_NAME_DEBUG_TEMPLATES_ID_COUNTER);
            if (this.debugTemplatesIdCounter == null) {
                this.debugTemplatesIdCounter = new AtomicInteger(0);
                this.request.setAttribute(ATTRIBUTE_NAME_DEBUG_TEMPLATES_ID_COUNTER, (Object)this.debugTemplatesIdCounter);
            }
        }
    }

    private boolean shouldDebugTemplates() {
        return this.request != null && this.request.getParameter("debugTemplates") != null && Environment.getCurrent() == Environment.DEVELOPMENT;
    }

    private boolean shouldShowGroovySource() {
        return this.request != null && this.request.getParameter("showSource") != null && Environment.getCurrent() == Environment.DEVELOPMENT && this.metaInfo.getGroovySource() != null;
    }

    public void setBinding(Map binding) {
        if (binding != null) {
            this.additionalBinding = binding;
        }
    }

    public void setShowSource(boolean showSource) {
        this.showSource = showSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer writeTo(Writer out) throws IOException {
        try {
            Writer writer = this.doWriteTo(out);
            return writer;
        }
        finally {
            this.doCleanUp(out);
        }
    }

    protected void doCleanUp(Writer out) {
        this.metaInfo.writeToFinished(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Writer doWriteTo(Writer out) throws IOException {
        block18: {
            long debugStartTimeMs;
            int debugId;
            GroovyPage page;
            block15: {
                String previousGspCode;
                block19: {
                    GroovyPageBinding parentBinding;
                    block16: {
                        block17: {
                            if (!this.showSource) break block17;
                            this.response.setContentType(GROOVY_SOURCE_CONTENT_TYPE);
                            this.writeGroovySourceToResponse(this.metaInfo, out);
                            break block18;
                        }
                        if (this.metaInfo.getCompilationException() != null) {
                            throw this.metaInfo.getCompilationException();
                        }
                        parentBinding = null;
                        boolean hasRequest = this.request != null;
                        boolean newParentCreated = false;
                        if (hasRequest && (parentBinding = (GroovyPageBinding)((Object)this.request.getAttribute("org.codehaus.groovy.grails.PAGE_SCOPE"))) == null && this.webRequest != null) {
                            parentBinding = new GroovyPageBinding(new GroovyPageRequestBinding(this.webRequest));
                            parentBinding.setRoot(true);
                            newParentCreated = true;
                        }
                        if (this.allowSettingContentType && this.response != null) {
                            boolean contentTypeAlreadySet;
                            boolean bl = contentTypeAlreadySet = this.response.isCommitted() || this.response.getContentType() != null;
                            if (!contentTypeAlreadySet) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Writing response to [" + this.response.getClass() + "] with content type: " + this.metaInfo.getContentType()));
                                }
                                this.response.setContentType(this.metaInfo.getContentType());
                            }
                        }
                        GroovyPageBinding binding = this.createBinding(parentBinding);
                        previousGspCode = GSP_NONE_CODEC_NAME;
                        if (hasRequest) {
                            this.request.setAttribute("org.codehaus.groovy.grails.PAGE_SCOPE", (Object)binding);
                            previousGspCode = (String)this.request.getAttribute("org.codehaus.groovy.grails.GSP_CODEC");
                        }
                        this.makeLegacyCodecVariablesAvailable(hasRequest, binding);
                        binding.setVariableDirectly("response", this.response);
                        binding.setVariableDirectly("request", this.request);
                        page = null;
                        try {
                            page = (GroovyPage)((Object)this.metaInfo.getPageClass().newInstance());
                        }
                        catch (Exception e) {
                            throw new GroovyPagesException("Problem instantiating page class", e);
                        }
                        page.setBinding(binding);
                        binding.setOwner(page);
                        page.initRun(out, this.webRequest, this.metaInfo);
                        debugId = 0;
                        debugStartTimeMs = 0L;
                        if (this.debugTemplates) {
                            debugId = this.debugTemplatesIdCounter.incrementAndGet();
                            out.write("<!-- GSP #");
                            out.write(String.valueOf(debugId));
                            out.write(" START template: ");
                            out.write(page.getGroovyPageFileName());
                            out.write(" precompiled: ");
                            out.write(String.valueOf(this.metaInfo.isPrecompiledMode()));
                            out.write(" lastmodified: ");
                            out.write(DateFormat.getDateTimeInstance(3, 3).format(new Date(this.metaInfo.getLastModified())));
                            out.write(" -->");
                            debugStartTimeMs = System.currentTimeMillis();
                        }
                        try {
                            page.run();
                            page.cleanup();
                            if (!hasRequest) break block15;
                            if (!newParentCreated) break block16;
                        }
                        catch (Throwable throwable) {
                            page.cleanup();
                            if (hasRequest) {
                                if (newParentCreated) {
                                    this.request.removeAttribute("org.codehaus.groovy.grails.PAGE_SCOPE");
                                } else {
                                    this.request.setAttribute("org.codehaus.groovy.grails.PAGE_SCOPE", (Object)parentBinding);
                                }
                                this.request.setAttribute("org.codehaus.groovy.grails.GSP_CODEC", (Object)(previousGspCode != null ? previousGspCode : GSP_NONE_CODEC_NAME));
                            }
                            throw throwable;
                        }
                        this.request.removeAttribute("org.codehaus.groovy.grails.PAGE_SCOPE");
                        break block19;
                    }
                    this.request.setAttribute("org.codehaus.groovy.grails.PAGE_SCOPE", (Object)parentBinding);
                }
                this.request.setAttribute("org.codehaus.groovy.grails.GSP_CODEC", (Object)(previousGspCode != null ? previousGspCode : GSP_NONE_CODEC_NAME));
            }
            if (this.debugTemplates) {
                out.write("<!-- GSP #");
                out.write(String.valueOf(debugId));
                out.write(" END template: ");
                out.write(page.getGroovyPageFileName());
                out.write(" rendering time: ");
                out.write(String.valueOf(System.currentTimeMillis() - debugStartTimeMs));
                out.write(" ms -->");
            }
        }
        return out;
    }

    private void makeLegacyCodecVariablesAvailable(boolean hasRequest, GroovyPageBinding binding) {
        if (this.metaInfo.getExpressionEncoder() != null) {
            if (hasRequest) {
                this.request.setAttribute("org.codehaus.groovy.grails.GSP_CODEC", (Object)this.metaInfo.getExpressionEncoder().getCodecIdentifier().getCodecName());
            }
            binding.setVariableDirectly("Codec", this.metaInfo.getExpressionEncoder());
        } else {
            if (hasRequest) {
                this.request.setAttribute("org.codehaus.groovy.grails.GSP_CODEC", (Object)GSP_NONE_CODEC_NAME);
            }
            binding.setVariableDirectly("Codec", gspNoneCodeInstance);
        }
    }

    private GroovyPageBinding createBinding(Binding parent) {
        GroovyPageBinding binding = new GroovyPageBinding();
        binding.setParent(parent);
        binding.setVariableDirectly("it", null);
        if (this.additionalBinding != null) {
            binding.addMap(this.additionalBinding);
        }
        if (parent == null || parent instanceof GroovyPageBinding && ((GroovyPageBinding)parent).isRoot() || "".equals(this.metaInfo.getPluginPath())) {
            binding.setPluginContextPath(this.metaInfo.getPluginPath());
        }
        binding.setPagePlugin(this.metaInfo.getPagePlugin());
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInputStreamToResponse(InputStream in, Writer out) throws IOException {
        try {
            int read;
            in.reset();
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            char[] buf = new char[8192];
            while ((read = reader.read(buf)) > 0) {
                out.write(buf, 0, read);
            }
        }
        finally {
            out.close();
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeGroovySourceToResponse(GroovyPageMetaInfo info, Writer out) throws IOException {
        InputStream in = info.getGroovySource();
        if (in == null) {
            return;
        }
        try {
            try {
                in.reset();
            }
            catch (IOException e) {
                // empty catch block
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            int lineNum = 1;
            int maxPaddingSize = 3;
            StringBuilder paddingBuffer = new StringBuilder(maxPaddingSize);
            for (int i = 0; i < maxPaddingSize; ++i) {
                paddingBuffer.append(' ');
            }
            String padding = paddingBuffer.toString();
            String line = reader.readLine();
            while (line != null) {
                String numberText = String.valueOf(lineNum);
                if (padding.length() + numberText.length() > 4) {
                    paddingBuffer.deleteCharAt(padding.length() - 1);
                    padding = paddingBuffer.toString();
                }
                out.write(padding);
                out.write(numberText);
                out.write(": ");
                out.write(line);
                out.write(10);
                line = reader.readLine();
                ++lineNum;
            }
        }
        finally {
            out.close();
            in.close();
        }
    }

    private static final class GspNoneCodec {
        private GspNoneCodec() {
        }

        public final Object encode(Object object) {
            return object;
        }
    }
}

