/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.CacheEntry;
import grails.util.Environment;
import grails.util.GrailsNameUtils;
import groovy.text.Template;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletRequest;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsStringUtils;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.codehaus.groovy.grails.support.encoding.EncodedAppenderWriterFactory;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.StreamingEncoder;
import org.codehaus.groovy.grails.support.encoding.StreamingEncoderWriter;
import org.codehaus.groovy.grails.web.pages.FastStringWriter;
import org.codehaus.groovy.grails.web.pages.GroovyPageBinding;
import org.codehaus.groovy.grails.web.pages.GroovyPageMetaInfo;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.pages.discovery.GrailsConventionGroovyPageLocator;
import org.codehaus.groovy.grails.web.pages.discovery.GroovyPageScriptSource;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;
import org.codehaus.groovy.grails.web.util.CodecPrintWriter;
import org.codehaus.groovy.grails.web.util.WithCodecHelper;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class GroovyPagesTemplateRenderer
implements InitializingBean {
    private GrailsConventionGroovyPageLocator groovyPageLocator;
    private GroovyPagesTemplateEngine groovyPagesTemplateEngine;
    private ConcurrentMap<String, CacheEntry<Template>> templateCache = new ConcurrentHashMap<String, CacheEntry<Template>>();
    private Object scaffoldingTemplateGenerator;
    private Map<String, Collection<String>> scaffoldedActionMap;
    private Map<String, GrailsDomainClass> controllerToScaffoldedDomainClassMap;
    private Method generateViewMethod;
    private boolean reloadEnabled;
    private boolean cacheEnabled = !Environment.isDevelopmentMode();

    public void afterPropertiesSet() throws Exception {
        if (this.scaffoldingTemplateGenerator != null) {
            this.generateViewMethod = ReflectionUtils.findMethod(this.scaffoldingTemplateGenerator.getClass(), (String)"generateView", (Class[])new Class[]{GrailsDomainClass.class, String.class, Writer.class});
        }
        this.reloadEnabled = this.groovyPagesTemplateEngine.isReloadEnabled();
    }

    public void clearCache() {
        this.templateCache.clear();
    }

    public void render(GrailsWebRequest webRequest, GroovyPageBinding pageScope, Map<String, Object> attrs, Object body, Writer out) throws IOException {
        String pluginName;
        Assert.state((this.groovyPagesTemplateEngine != null ? 1 : 0) != 0, (String)"Property [groovyPagesTemplateEngine] must be set!");
        String templateName = this.getStringValue(attrs, "template");
        if (GrailsStringUtils.isBlank((String)templateName)) {
            throw new GrailsTagException("Tag [render] is missing required attribute [template]");
        }
        String uri = webRequest.getAttributes().getTemplateUri((CharSequence)templateName, (ServletRequest)webRequest.getRequest());
        String contextPath = this.getStringValue(attrs, "contextPath");
        Template t = this.findAndCacheTemplate(pageScope, templateName, contextPath, pluginName = this.getStringValue(attrs, "plugin"), uri);
        if (t == null) {
            throw new GrailsTagException("Template not found for name [" + templateName + "] and path [" + uri + "]");
        }
        this.makeTemplate(webRequest, t, attrs, body, out);
    }

    private Template findAndCacheTemplate(GroovyPageBinding pageScope, String templateName, String contextPath, String pluginName, final String uri) throws IOException {
        String templatePath = GrailsStringUtils.isNotEmpty((String)contextPath) ? GrailsResourceUtils.appendPiecesForUri((String[])new String[]{contextPath, templateName}) : templateName;
        final GroovyPageScriptSource scriptSource = pluginName == null ? this.groovyPageLocator.findTemplateInBinding(templatePath, pageScope) : this.groovyPageLocator.findTemplateInBinding(pluginName, templatePath, pageScope);
        String cacheKey = scriptSource == null ? contextPath + pluginName + uri : scriptSource.getURI();
        return (Template)CacheEntry.getValue(this.templateCache, (Object)cacheKey, (long)(this.reloadEnabled ? GroovyPageMetaInfo.LASTMODIFIED_CHECK_INTERVAL : -1L), null, (Callable)new Callable<CacheEntry<Template>>(){

            @Override
            public CacheEntry<Template> call() {
                return new CacheEntry<Template>(){
                    boolean allowCaching;
                    boolean neverExpire;
                    {
                        this.allowCaching = GroovyPagesTemplateRenderer.this.cacheEnabled;
                        this.neverExpire = false;
                    }

                    protected boolean hasExpired(long timeout, Object cacheRequestObject) {
                        return this.neverExpire ? false : (this.allowCaching ? super.hasExpired(timeout, cacheRequestObject) : true);
                    }

                    public boolean isInitialized() {
                        return this.allowCaching ? super.isInitialized() : false;
                    }

                    public void setValue(Template val) {
                        if (this.allowCaching) {
                            super.setValue((Object)val);
                        }
                    }

                    protected Template updateValue(Template oldValue, Callable<Template> updater, Object cacheRequestObject) throws Exception {
                        Template t = null;
                        if (scriptSource != null) {
                            t = GroovyPagesTemplateRenderer.this.groovyPagesTemplateEngine.createTemplate(scriptSource);
                        }
                        if (t == null && GroovyPagesTemplateRenderer.this.scaffoldingTemplateGenerator != null) {
                            t = GroovyPagesTemplateRenderer.this.generateScaffoldedTemplate(GrailsWebRequest.lookup(), uri);
                            this.allowCaching = true;
                            this.neverExpire = true;
                        }
                        return t;
                    }
                };
            }
        }, (boolean)true, null);
    }

    private void makeTemplate(GrailsWebRequest webRequest, Template t, Map<String, Object> attrs, Object body, Writer out) throws IOException {
        Writer newOut = this.wrapWriterWithEncoder(webRequest, attrs, out);
        boolean writerWrapped = newOut != out;
        out = newOut;
        String var = this.getStringValue(attrs, "var");
        LinkedHashMap<String, Object> b = new LinkedHashMap<String, Object>();
        b.put("body", body);
        if (attrs.get("model") instanceof Map) {
            b.putAll((Map)attrs.get("model"));
        }
        if (attrs.containsKey("bean")) {
            if (GrailsStringUtils.isNotBlank((String)var)) {
                b.put(var, attrs.get("bean"));
            } else {
                b.put("it", attrs.get("bean"));
            }
        }
        if (attrs.containsKey("collection")) {
            String key = null;
            Iterator iterator = InvokerHelper.asIterator((Object)attrs.get("collection"));
            while (iterator.hasNext()) {
                Object it = iterator.next();
                if (key == null && GrailsStringUtils.isBlank((String)var) && it != null) {
                    key = GrailsNameUtils.getPropertyName(it.getClass());
                }
                LinkedHashMap<String, Object> itmap = new LinkedHashMap<String, Object>();
                itmap.putAll(b);
                if (GrailsStringUtils.isNotBlank((String)var)) {
                    itmap.put(var, it);
                } else {
                    itmap.put("it", it);
                    itmap.put(key, it);
                }
                t.make(itmap).writeTo(out);
            }
        } else {
            t.make(b).writeTo(out);
        }
        if (writerWrapped) {
            out.flush();
        }
    }

    private Writer wrapWriterWithEncoder(GrailsWebRequest webRequest, Map<String, Object> attrs, Writer out) {
        Map<String, Object> codecSettings;
        String codecForTaglibs;
        Object encodeAs = attrs.get("encodeAs");
        if (encodeAs != null && (codecForTaglibs = (String)(codecSettings = WithCodecHelper.makeSettingsCanonical(encodeAs)).get("taglib")) != null) {
            Encoder encoder = WithCodecHelper.lookupEncoder(webRequest.getAttributes().getGrailsApplication(), codecForTaglibs);
            out = out instanceof EncodedAppenderWriterFactory ? ((EncodedAppenderWriterFactory)out).getWriterForEncoder(encoder, webRequest.getEncodingStateRegistry()) : (encoder instanceof StreamingEncoder ? new StreamingEncoderWriter((Writer)out, (StreamingEncoder)encoder, webRequest.getEncodingStateRegistry()) : new CodecPrintWriter((Writer)out, encoder, webRequest.getEncodingStateRegistry()));
        }
        return out;
    }

    private Template generateScaffoldedTemplate(GrailsWebRequest webRequest, String uri) throws IOException {
        GrailsDomainClass domainClass;
        Template t = null;
        Collection<String> controllerActions = this.scaffoldedActionMap.get(webRequest.getControllerName());
        if (controllerActions != null && controllerActions.contains(webRequest.getActionName()) && (domainClass = this.controllerToScaffoldedDomainClassMap.get(webRequest.getControllerName())) != null) {
            String scaffoldedtemplateName;
            int i = uri.lastIndexOf(47);
            String string = scaffoldedtemplateName = i > -1 ? uri.substring(i) : uri;
            if (scaffoldedtemplateName.toLowerCase().endsWith(".gsp")) {
                scaffoldedtemplateName = scaffoldedtemplateName.substring(0, scaffoldedtemplateName.length() - 4);
            }
            FastStringWriter sw = new FastStringWriter();
            ReflectionUtils.invokeMethod((Method)this.generateViewMethod, (Object)this.scaffoldingTemplateGenerator, (Object[])new Object[]{domainClass, scaffoldedtemplateName, sw});
            t = this.groovyPagesTemplateEngine.createTemplate(sw.toString(), uri);
        }
        return t;
    }

    private String getStringValue(Map<String, Object> attrs, String key) {
        Object val = attrs.get(key);
        if (val == null) {
            return "";
        }
        return String.valueOf(val);
    }

    public void setGroovyPageLocator(GrailsConventionGroovyPageLocator locator) {
        this.groovyPageLocator = locator;
    }

    public void setGroovyPagesTemplateEngine(GroovyPagesTemplateEngine engine) {
        this.groovyPagesTemplateEngine = engine;
    }

    public void setScaffoldingTemplateGenerator(Object generator) {
        this.scaffoldingTemplateGenerator = generator;
    }

    public void setScaffoldedActionMap(Map map) {
        this.scaffoldedActionMap = map;
    }

    public void setControllerToScaffoldedDomainClassMap(Map map) {
        this.controllerToScaffoldedDomainClassMap = map;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }
}

