/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages.discovery;

import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.grails.web.pages.discovery.GroovyPageStaticResourceLocator;
import org.codehaus.groovy.grails.web.util.CacheEntry;
import org.springframework.core.io.Resource;

public class CachingGroovyPageStaticResourceLocator
extends GroovyPageStaticResourceLocator {
    private Map<String, CacheEntry<Resource>> uriResolveCache = new ConcurrentHashMap<String, CacheEntry<Resource>>();
    private long cacheTimeout = -1L;

    @Override
    public Resource findResourceForURI(final String uri) {
        PrivilegedAction<Resource> updater = new PrivilegedAction<Resource>(){

            @Override
            public Resource run() {
                Resource resource = CachingGroovyPageStaticResourceLocator.super.findResourceForURI(uri);
                if (resource == null) {
                    resource = NULL_RESOURCE;
                }
                return resource;
            }
        };
        Resource resource = null;
        CacheEntry<Resource> entry = this.uriResolveCache.get(uri);
        if (entry == null) {
            resource = (Resource)updater.run();
            this.uriResolveCache.put(uri, (CacheEntry<Resource>)new CacheEntry((Object)resource));
        } else {
            resource = (Resource)entry.getValue(this.cacheTimeout, (PrivilegedAction)updater);
        }
        return resource == NULL_RESOURCE ? null : resource;
    }

    public long getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(long cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }
}

