/*
 * Decompiled with CFR 0.152.
 */
package org.grails.validation;

import grails.core.GrailsApplication;
import grails.core.GrailsDomainClass;
import grails.core.GrailsDomainClassProperty;
import grails.core.support.GrailsApplicationAware;
import grails.validation.CascadingValidator;
import grails.validation.ConstrainedProperty;
import groovy.lang.GString;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.Validator;

public class GrailsDomainClassValidator
implements CascadingValidator,
GrailsApplicationAware {
    private static final List<String> EMBEDDED_EXCLUDES = Arrays.asList("id", "version");
    protected Class<?> targetClass;
    protected GrailsDomainClass domainClass;
    protected MessageSource messageSource;
    protected GrailsApplication grailsApplication;

    public boolean supports(Class clazz) {
        return this.targetClass.equals(clazz);
    }

    @Override
    public void validate(Object obj, Errors errors, boolean cascade) {
        GrailsDomainClassProperty[] persistentProperties;
        if (obj == null) {
            throw new IllegalArgumentException("Argument [" + obj + "] is not an instance of [" + this.domainClass.getClazz() + "] which this validator is configured for");
        }
        BeanWrapperImpl bean = new BeanWrapperImpl(obj);
        Map constrainedProperties = this.domainClass.getConstrainedProperties();
        HashSet constrainedPropertyNames = new HashSet(constrainedProperties.keySet());
        for (Object key : constrainedProperties.keySet()) {
            String propertyName = (String)key;
            this.validatePropertyWithConstraint(propertyName, obj, errors, (BeanWrapper)bean, constrainedProperties);
        }
        for (GrailsDomainClassProperty persistentProperty : persistentProperties = this.domainClass.getPersistentProperties()) {
            String propertyName = persistentProperty.getName();
            if ((persistentProperty.isAssociation() || persistentProperty.isEmbedded()) && cascade) {
                this.cascadeToAssociativeProperty(errors, (BeanWrapper)bean, persistentProperty);
            }
            constrainedPropertyNames.remove(propertyName);
        }
        this.postValidate(obj, errors);
    }

    protected void postValidate(Object obj, Errors errors) {
    }

    public void validate(Object obj, Errors errors) {
        this.validate(obj, errors, false);
    }

    protected void cascadeToAssociativeProperty(Errors errors, BeanWrapper bean, GrailsDomainClassProperty persistentProperty) {
        String propertyName = persistentProperty.getName();
        if (errors.hasFieldErrors(propertyName)) {
            return;
        }
        if (persistentProperty.isManyToOne() || persistentProperty.isOneToOne() || persistentProperty.isEmbedded()) {
            Object associatedObject = bean.getPropertyValue(propertyName);
            this.cascadeValidationToOne(errors, bean, associatedObject, persistentProperty, propertyName, null);
        } else if (persistentProperty.isOneToMany()) {
            this.cascadeValidationToMany(errors, bean, persistentProperty, propertyName);
        }
    }

    protected void cascadeValidationToMany(Errors errors, BeanWrapper bean, GrailsDomainClassProperty persistentProperty, String propertyName) {
        block4: {
            Object collection;
            block5: {
                block3: {
                    collection = bean.getPropertyValue(propertyName);
                    if (!(collection instanceof List) && !(collection instanceof SortedSet)) break block3;
                    int idx = 0;
                    for (Object associatedObject : (Collection)collection) {
                        this.cascadeValidationToOne(errors, bean, associatedObject, persistentProperty, propertyName, idx++);
                    }
                    break block4;
                }
                if (!(collection instanceof Collection)) break block5;
                Integer index = 0;
                for (Object associatedObject : (Collection)collection) {
                    Integer n = index;
                    Integer n2 = index = Integer.valueOf(index + 1);
                    this.cascadeValidationToOne(errors, bean, associatedObject, persistentProperty, propertyName, n);
                }
                break block4;
            }
            if (!(collection instanceof Map)) break block4;
            this.filterGStringKeys((Map)collection);
            Iterator i$ = ((Map)collection).entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry entryObject;
                Map.Entry entry = entryObject = i$.next();
                this.cascadeValidationToOne(errors, bean, entry.getValue(), persistentProperty, propertyName, entry.getKey());
            }
        }
    }

    private void filterGStringKeys(Map collection) {
        Set set = collection.keySet();
        HashSet<GString> gstrings = new HashSet<GString>();
        for (Object o : set) {
            if (!(o instanceof GString)) continue;
            gstrings.add((GString)o);
        }
        for (GString gstring : gstrings) {
            Object value = collection.remove(gstring);
            collection.put(gstring.toString(), value);
        }
    }

    private void validatePropertyWithConstraint(String propertyName, Object obj, Errors errors, BeanWrapper bean, Map constrainedProperties) {
        int i = propertyName.lastIndexOf(".");
        String constrainedPropertyName = i > -1 ? propertyName.substring(i + 1, propertyName.length()) : propertyName;
        FieldError fieldError = errors.getFieldError(constrainedPropertyName);
        if (fieldError == null) {
            ConstrainedProperty c = (ConstrainedProperty)constrainedProperties.get(constrainedPropertyName);
            c.setMessageSource(this.messageSource);
            c.validate(obj, bean.getPropertyValue(constrainedPropertyName), errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeValidationToOne(Errors errors, BeanWrapper bean, Object associatedObject, GrailsDomainClassProperty persistentProperty, String propertyName, Object indexOrKey) {
        if (associatedObject == null) {
            return;
        }
        GrailsDomainClass associatedDomainClass = this.getAssociatedDomainClass(associatedObject, persistentProperty);
        if (associatedDomainClass == null || !this.isOwningInstance(bean, associatedDomainClass) && !persistentProperty.isExplicitSaveUpdateCascade()) {
            return;
        }
        GrailsDomainClassProperty otherSide = null;
        if (persistentProperty.isBidirectional()) {
            otherSide = persistentProperty.getOtherSide();
        }
        Map associatedConstraintedProperties = associatedDomainClass.getConstrainedProperties();
        GrailsDomainClassProperty[] associatedPersistentProperties = associatedDomainClass.getPersistentProperties();
        String nestedPath = errors.getNestedPath();
        try {
            errors.setNestedPath(this.buildNestedPath(nestedPath, propertyName, indexOrKey));
            for (GrailsDomainClassProperty associatedPersistentProperty : associatedPersistentProperties) {
                if (persistentProperty.isEmbedded() && EMBEDDED_EXCLUDES.contains(associatedPersistentProperty.getName())) continue;
                String associatedPropertyName = associatedPersistentProperty.getName();
                if (associatedConstraintedProperties.containsKey(associatedPropertyName)) {
                    this.validatePropertyWithConstraint(errors.getNestedPath() + associatedPropertyName, associatedObject, errors, (BeanWrapper)new BeanWrapperImpl(associatedObject), associatedConstraintedProperties);
                }
                if (associatedPersistentProperty.equals(otherSide) || !associatedPersistentProperty.isAssociation()) continue;
                this.cascadeToAssociativeProperty(errors, (BeanWrapper)new BeanWrapperImpl(associatedObject), associatedPersistentProperty);
            }
        }
        finally {
            errors.setNestedPath(nestedPath);
        }
    }

    private String buildNestedPath(String nestedPath, String componentName, Object indexOrKey) {
        if (indexOrKey == null) {
            return nestedPath + componentName;
        }
        if (indexOrKey instanceof Integer) {
            return nestedPath + componentName + "[" + indexOrKey + "]";
        }
        return nestedPath + componentName + "['" + indexOrKey + "']";
    }

    private GrailsDomainClass getAssociatedDomainClass(Object associatedObject, GrailsDomainClassProperty persistentProperty) {
        if (persistentProperty.isEmbedded()) {
            return persistentProperty.getComponent();
        }
        if (this.grailsApplication != null) {
            return this.getAssociatedDomainClassFromApplication(associatedObject);
        }
        return persistentProperty.getReferencedDomainClass();
    }

    protected GrailsDomainClass getAssociatedDomainClassFromApplication(Object associatedObject) {
        String associatedObjectType = associatedObject.getClass().getName();
        return (GrailsDomainClass)this.grailsApplication.getArtefact("Domain", associatedObjectType);
    }

    private boolean isOwningInstance(BeanWrapper bean, GrailsDomainClass associatedDomainClass) {
        for (Class currentClass = bean.getWrappedClass(); currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            if (!associatedDomainClass.isOwningClass(currentClass)) continue;
            return true;
        }
        return false;
    }

    public void setDomainClass(GrailsDomainClass domainClass) {
        this.domainClass = domainClass;
        domainClass.setValidator((Validator)this);
        this.targetClass = domainClass.getClazz();
    }

    public GrailsDomainClass getDomainClass() {
        return this.domainClass;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }
}

