/*
 * Decompiled with CFR 0.152.
 */
package org.grails.validation;

import grails.core.GrailsDomainClass;
import grails.core.GrailsDomainClassProperty;
import grails.io.IOUtils;
import grails.persistence.PersistenceMethod;
import grails.util.GrailsClassUtils;
import grails.validation.Constrained;
import grails.validation.ConstrainedProperty;
import grails.validation.ConstraintsEvaluator;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.Script;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.grails.core.artefact.AnnotationDomainClassArtefactHandler;
import org.grails.core.artefact.DomainClassArtefactHandler;
import org.grails.core.exceptions.GrailsConfigurationException;
import org.grails.core.support.GrailsDomainConfigurationUtil;
import org.grails.validation.ConstrainedPropertyBuilder;
import org.springframework.beans.BeanUtils;

public class DefaultConstraintEvaluator
implements ConstraintsEvaluator,
org.codehaus.groovy.grails.validation.ConstraintsEvaluator {
    private static final Log LOG = LogFactory.getLog(DefaultConstraintEvaluator.class);
    private final Map<String, Object> defaultConstraints;

    public DefaultConstraintEvaluator(Map<String, Object> defaultConstraints) {
        this.defaultConstraints = defaultConstraints != null ? defaultConstraints : Collections.emptyMap();
    }

    public DefaultConstraintEvaluator() {
        this(null);
    }

    public Map<String, Object> getDefaultConstraints() {
        return this.defaultConstraints;
    }

    public Map<String, Constrained> evaluate(Class cls) {
        return this.evaluateConstraints(cls, null);
    }

    public Map<String, Constrained> evaluate(Class cls, boolean defaultNullable) {
        return this.evaluateConstraints(cls, null, defaultNullable);
    }

    public Map<String, Constrained> evaluate(Class<?> cls, boolean defaultNullable, boolean useOnlyAdHocConstraints, Closure ... adHocConstraintsClosures) {
        return this.evaluateConstraints(cls, null, defaultNullable, useOnlyAdHocConstraints, adHocConstraintsClosures);
    }

    public Map<String, Constrained> evaluate(GrailsDomainClass cls) {
        return this.evaluateConstraints(cls.getClazz(), cls.getPersistentProperties());
    }

    public Map<String, Constrained> evaluate(Object object, GrailsDomainClassProperty[] properties) {
        return this.evaluateConstraints(object.getClass(), properties);
    }

    public Map<String, Constrained> evaluate(Class<?> cls, GrailsDomainClassProperty[] properties) {
        return this.evaluateConstraints(cls, properties);
    }

    protected Map<String, Constrained> evaluateConstraints(Class<?> theClass, GrailsDomainClassProperty[] domainClassProperties) {
        return this.evaluateConstraints(theClass, domainClassProperties, false);
    }

    protected Map<String, Constrained> evaluateConstraints(Class<?> theClass, GrailsDomainClassProperty[] domainClassProperties, boolean defaultNullable) {
        List<Closure> constraintsClosures = this.retrieveConstraintsClosures(theClass);
        Map<String, Constrained> constraintMap = this.evaluateConstraintsMap(constraintsClosures, theClass);
        return this.evaluateConstraints(constraintMap, theClass, domainClassProperties, defaultNullable);
    }

    protected Map<String, Constrained> evaluateConstraints(Class<?> theClass, GrailsDomainClassProperty[] domainClassProperties, boolean defaultNullable, boolean useOnlyAdHocConstraints, Closure[] adHocConstraintsClosures) {
        ArrayList<Closure> constraintsClosures = new ArrayList<Closure>();
        if (!useOnlyAdHocConstraints) {
            constraintsClosures.addAll(this.retrieveConstraintsClosures(theClass));
        }
        if (adHocConstraintsClosures != null) {
            constraintsClosures.addAll(Arrays.asList(adHocConstraintsClosures));
        }
        Map<String, Constrained> constraintMap = this.evaluateConstraintsMap(constraintsClosures, theClass);
        return this.evaluateConstraints(constraintMap, theClass, domainClassProperties, defaultNullable);
    }

    protected Map<String, Constrained> evaluateConstraints(Map<String, Constrained> constraintMap, Class<?> theClass, GrailsDomainClassProperty[] domainClassProperties, boolean defaultNullable) {
        if (constraintMap.isEmpty() && AnnotationDomainClassArtefactHandler.isJPADomainClass(theClass)) {
            return constraintMap;
        }
        boolean isDomainClass = DomainClassArtefactHandler.isDomainClass(theClass);
        Map<String, GrailsDomainClassProperty> domainClassPropertyMap = this.indexPropertiesByPropertyName(domainClassProperties);
        Map<String, Method> constrainablePropertyMap = this.getConstrainablePropertyMap(theClass, isDomainClass);
        for (String propertyName : constrainablePropertyMap.keySet()) {
            Constrained constrained;
            boolean isPersistentProperty;
            GrailsDomainClassProperty domainClassProperty = domainClassPropertyMap.get(propertyName);
            boolean bl = isPersistentProperty = isDomainClass && domainClassProperty != null;
            if (isDomainClass) {
                if (this.isAssociationIdProperty(propertyName, domainClassPropertyMap) || !isPersistentProperty || !this.canPropertyBeConstrained(domainClassProperty)) continue;
                if (domainClassProperty.isDerived() && constraintMap.remove(propertyName) != null) {
                    LOG.warn((Object)("Derived domainClassProperties may not be constrained. Property [" + propertyName + "] of domain class " + theClass.getName() + " will not be checked during validation."));
                    continue;
                }
            }
            if ((constrained = constraintMap.get(propertyName)) == null) {
                if (this.defaultConstraints.isEmpty() && defaultNullable) continue;
                ConstrainedProperty constrainedProperty = new ConstrainedProperty(theClass, propertyName, constrainablePropertyMap.get(propertyName).getReturnType());
                constrainedProperty.setOrder(constraintMap.size() + 1);
                constraintMap.put(propertyName, constrainedProperty);
                constrained = constrainedProperty;
            }
            if (isPersistentProperty) {
                this.applyDefaultConstraints(domainClassProperty, constrained, this.defaultConstraints);
            } else {
                this.applyDefaultConstraints(propertyName, constrained);
            }
            if (isPersistentProperty) {
                this.applyDefaultNullableConstraint(domainClassProperty, constrained);
                continue;
            }
            this.applyDefaultNullableConstraint(constrained, defaultNullable);
        }
        return constraintMap;
    }

    protected List<Closure> retrieveConstraintsClosures(Class<?> theClass) {
        ArrayList<Closure> constraintsClosureList = new ArrayList<Closure>();
        for (Object aClassChain : GrailsDomainConfigurationUtil.getSuperClassChain(theClass)) {
            Class clazz = (Class)aClassChain;
            Closure<?> c = (Closure<?>)GrailsClassUtils.getStaticFieldValue((Class)clazz, (String)"constraints");
            if (c == null) {
                c = this.getConstraintsFromScript(theClass);
            }
            if (c != null) {
                constraintsClosureList.add(c);
                continue;
            }
            LOG.debug((Object)("User-defined constraints not found on class [" + clazz + "], applying default constraints"));
        }
        return constraintsClosureList;
    }

    protected Map<String, Constrained> evaluateConstraintsMap(List<Closure> constraintsClosureList, Class<?> theClass) {
        ConstrainedPropertyBuilder delegate = new ConstrainedPropertyBuilder(theClass);
        for (Closure c : constraintsClosureList) {
            c = (Closure)c.clone();
            c.setResolveStrategy(3);
            c.setDelegate((Object)delegate);
            c.call();
        }
        Map<String, Constrained> constraintMap = delegate.getConstrainedProperties();
        this.applySharedConstraints(delegate, constraintMap);
        return constraintMap;
    }

    protected boolean isAssociationIdProperty(String propertyName, Map<String, GrailsDomainClassProperty> domainClassPropertyMap) {
        GrailsDomainClassProperty associationProperty;
        boolean isPersistentProperty;
        boolean bl = isPersistentProperty = domainClassPropertyMap.get(propertyName) != null;
        if (isPersistentProperty) {
            return false;
        }
        return propertyName.endsWith("Id") && (associationProperty = domainClassPropertyMap.get(propertyName.replaceFirst("Id$", ""))) != null && associationProperty.isAssociation();
    }

    protected Map<String, GrailsDomainClassProperty> indexPropertiesByPropertyName(GrailsDomainClassProperty[] properties) {
        HashMap<String, GrailsDomainClassProperty> indexed = new HashMap<String, GrailsDomainClassProperty>();
        if (properties != null) {
            for (GrailsDomainClassProperty p : properties) {
                indexed.put(p.getName(), p);
            }
        }
        return indexed;
    }

    protected void applySharedConstraints(ConstrainedPropertyBuilder constrainedPropertyBuilder, Map<String, Constrained> constraintMap) {
        for (Map.Entry<String, Constrained> entry : constraintMap.entrySet()) {
            String propertyName = entry.getKey();
            Constrained constrained = entry.getValue();
            String sharedConstraintReference = constrainedPropertyBuilder.getSharedConstraint(propertyName);
            if (sharedConstraintReference == null) continue;
            Object o = this.defaultConstraints.get(sharedConstraintReference);
            if (o instanceof Map) {
                Map constraintsWithinSharedConstraint = (Map)o;
                for (Map.Entry e : constraintsWithinSharedConstraint.entrySet()) {
                    constrained.applyConstraint((String)e.getKey(), e.getValue());
                }
                continue;
            }
            throw new GrailsConfigurationException("Property [" + constrained.getOwner().getName() + '.' + propertyName + "] references shared constraint [" + sharedConstraintReference + ":" + o + "], which doesn't exist!");
        }
    }

    protected boolean canPropertyBeConstrained(GrailsDomainClassProperty property) {
        return true;
    }

    protected Closure<?> getConstraintsFromScript(Class<?> theClass) {
        String className = theClass.getName();
        String constraintsScript = className.replaceAll("\\.", "/") + "Constraints.groovy";
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(constraintsScript);
        if (stream != null) {
            GroovyClassLoader gcl = new GroovyClassLoader();
            try {
                Class scriptClass = gcl.parseClass(IOUtils.toString((InputStream)stream, (String)"UTF-8"));
                Script script = (Script)scriptClass.newInstance();
                script.run();
                Binding binding = script.getBinding();
                if (binding.getVariables().containsKey("constraints")) {
                    return (Closure)binding.getVariable("constraints");
                }
                LOG.warn((Object)("Unable to evaluate constraints from [" + constraintsScript + "], constraints closure not found!"));
                return null;
            }
            catch (CompilationFailedException e) {
                LOG.error((Object)("Compilation error evaluating constraints for class [" + className + "]: " + e.getMessage()), (Throwable)e);
                return null;
            }
            catch (InstantiationException e) {
                LOG.error((Object)("Instantiation error evaluating constraints for class [" + className + "]: " + e.getMessage()), (Throwable)e);
                return null;
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)("Illegal access error evaluating constraints for class [" + className + "]: " + e.getMessage()), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    protected void applyDefaultConstraints(GrailsDomainClassProperty domainClassProperty, Constrained constrained, Map<String, Object> defaultConstraints) {
        Object o;
        if (defaultConstraints.containsKey("*") && (o = defaultConstraints.get("*")) instanceof Map) {
            Map globalConstraints = (Map)o;
            this.applyMapOfConstraints(globalConstraints, domainClassProperty.getName(), domainClassProperty, constrained);
        }
    }

    protected void applyDefaultConstraints(String propertyName, Constrained constrained) {
        Object o;
        if (this.defaultConstraints.containsKey("*") && (o = this.defaultConstraints.get("*")) instanceof Map) {
            Map globalConstraints = (Map)o;
            this.applyMapOfConstraints(globalConstraints, propertyName, null, constrained);
        }
    }

    protected void applyDefaultNullableConstraint(GrailsDomainClassProperty domainClassProperty, Constrained constrained) {
        if (this.canApplyNullableConstraint(domainClassProperty.getName(), domainClassProperty, constrained)) {
            this.applyDefaultNullableConstraint(constrained, false);
        }
    }

    protected void applyDefaultNullableConstraint(Constrained constrained, boolean defaultNullable) {
        if (!constrained.hasAppliedConstraint("nullable")) {
            boolean isCollection = Collection.class.isAssignableFrom(constrained.getPropertyType()) || Map.class.isAssignableFrom(constrained.getPropertyType());
            constrained.applyConstraint("nullable", (Object)(isCollection || defaultNullable ? 1 : 0));
        }
    }

    protected Map<String, Method> getConstrainablePropertyMap(Class theClass, boolean isDomainClass) {
        Field[] declaredFields;
        HashSet<String> ignoredProperties = new HashSet<String>();
        ignoredProperties.add("class");
        ignoredProperties.add("metaClass");
        ignoredProperties.add("errors");
        if (isDomainClass) {
            PropertyDescriptor[] propertyDescriptors;
            ignoredProperties.add("properties");
            ignoredProperties.add("id");
            ignoredProperties.add("version");
            ignoredProperties.add("dirtyPropertyNames");
            ignoredProperties.add("dirty");
            ignoredProperties.add("attached");
            Object transients = GrailsClassUtils.getStaticPropertyValue((Class)theClass, (String)"transients");
            if (transients instanceof List) {
                ignoredProperties.addAll((List)transients);
            }
            for (PropertyDescriptor descriptor : propertyDescriptors = BeanUtils.getPropertyDescriptors((Class)theClass)) {
                PersistenceMethod annotation;
                Method readMethod = descriptor.getReadMethod();
                Method writeMethod = descriptor.getWriteMethod();
                if (readMethod == null) {
                    ignoredProperties.add(descriptor.getName());
                    continue;
                }
                if (writeMethod != null && !Modifier.isTransient(readMethod.getModifiers()) || (annotation = readMethod.getAnnotation(PersistenceMethod.class)) != null) continue;
                ignoredProperties.add(descriptor.getName());
            }
        }
        for (Field field : declaredFields = theClass.getDeclaredFields()) {
            if (!Modifier.isTransient(field.getModifiers())) continue;
            ignoredProperties.add(field.getName());
        }
        HashMap<String, Method> propertyMap = new HashMap<String, Method>();
        for (Object aClassChain : GrailsDomainConfigurationUtil.getSuperClassChain((Class)theClass)) {
            Class clazz = (Class)aClassChain;
            for (Method method : clazz.getDeclaredMethods()) {
                String propertyName;
                if (!GrailsClassUtils.isPropertyGetter((Method)method) || (propertyName = GrailsClassUtils.getPropertyForGetter((String)method.getName(), method.getReturnType())) == null || ignoredProperties.contains(propertyName)) continue;
                propertyMap.put(propertyName, method);
            }
        }
        return propertyMap;
    }

    protected boolean canApplyNullableConstraint(String propertyName, GrailsDomainClassProperty property, Constrained constrained) {
        if (property == null || property.getType() == null) {
            return false;
        }
        GrailsDomainClass domainClass = property.getDomainClass();
        if (!GroovyObject.class.isAssignableFrom(domainClass.getClazz())) {
            return false;
        }
        GrailsDomainClassProperty versionProperty = domainClass.getVersion();
        boolean isVersion = versionProperty != null && versionProperty.equals(property);
        return !constrained.hasAppliedConstraint("nullable") && this.isConstrainableProperty(property, propertyName) && !property.isIdentity() && !isVersion && !property.isDerived();
    }

    protected void applyMapOfConstraints(Map<String, Object> constraints, String propertyName, GrailsDomainClassProperty domainClassProperty, Constrained constrained) {
        for (Map.Entry<String, Object> entry : constraints.entrySet()) {
            String constraintName = entry.getKey();
            Object constrainingValue = entry.getValue();
            if (constrained.hasAppliedConstraint(constraintName) || !constrained.supportsContraint(constraintName)) continue;
            if ("nullable".equals(constraintName)) {
                if (!this.isConstrainableProperty(domainClassProperty, propertyName)) continue;
                constrained.applyConstraint(constraintName, constrainingValue);
                continue;
            }
            constrained.applyConstraint(constraintName, constrainingValue);
        }
    }

    protected boolean isConstrainableProperty(GrailsDomainClassProperty domainClassProperty, String propertyName) {
        if (domainClassProperty == null) {
            return true;
        }
        return !propertyName.equals("dateCreated") && !propertyName.equals("lastUpdated") && (!domainClassProperty.isOneToOne() && !domainClassProperty.isManyToOne() || !domainClassProperty.isCircular());
    }
}

