/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import grails.validation.Constrained;
import groovy.lang.MissingPropertyException;
import groovy.lang.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.validation.BlankConstraint;
import org.codehaus.groovy.grails.validation.Constraint;
import org.codehaus.groovy.grails.validation.ConstraintFactory;
import org.codehaus.groovy.grails.validation.CreditCardConstraint;
import org.codehaus.groovy.grails.validation.EmailConstraint;
import org.codehaus.groovy.grails.validation.InListConstraint;
import org.codehaus.groovy.grails.validation.MatchesConstraint;
import org.codehaus.groovy.grails.validation.MaxConstraint;
import org.codehaus.groovy.grails.validation.MaxSizeConstraint;
import org.codehaus.groovy.grails.validation.MinConstraint;
import org.codehaus.groovy.grails.validation.MinSizeConstraint;
import org.codehaus.groovy.grails.validation.NotEqualConstraint;
import org.codehaus.groovy.grails.validation.NullableConstraint;
import org.codehaus.groovy.grails.validation.RangeConstraint;
import org.codehaus.groovy.grails.validation.ScaleConstraint;
import org.codehaus.groovy.grails.validation.SizeConstraint;
import org.codehaus.groovy.grails.validation.UrlConstraint;
import org.codehaus.groovy.grails.validation.ValidatorConstraint;
import org.codehaus.groovy.grails.validation.VetoingConstraint;
import org.codehaus.groovy.grails.validation.exceptions.ConstraintException;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.MessageSource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;

public class ConstrainedProperty
implements Constrained {
    static final String DEFAULT_NULL_MESSAGE_CODE = "default.null.message";
    static final String DEFAULT_INVALID_MIN_SIZE_MESSAGE_CODE = "default.invalid.min.size.message";
    static final String DEFAULT_INVALID_MAX_SIZE_MESSAGE_CODE = "default.invalid.max.size.message";
    static final String DEFAULT_NOT_EQUAL_MESSAGE_CODE = "default.not.equal.message";
    static final String DEFAULT_INVALID_MIN_MESSAGE_CODE = "default.invalid.min.message";
    static final String DEFAULT_INVALID_MAX_MESSAGE_CODE = "default.invalid.max.message";
    static final String DEFAULT_INVALID_SIZE_MESSAGE_CODE = "default.invalid.size.message";
    static final String DEFAULT_NOT_INLIST_MESSAGE_CODE = "default.not.inlist.message";
    static final String DEFAULT_INVALID_RANGE_MESSAGE_CODE = "default.invalid.range.message";
    static final String DEFAULT_INVALID_EMAIL_MESSAGE_CODE = "default.invalid.email.message";
    static final String DEFAULT_INVALID_CREDIT_CARD_MESSAGE_CODE = "default.invalid.creditCard.message";
    static final String DEFAULT_INVALID_URL_MESSAGE_CODE = "default.invalid.url.message";
    static final String DEFAULT_INVALID_VALIDATOR_MESSAGE_CODE = "default.invalid.validator.message";
    static final String DEFAULT_DOESNT_MATCH_MESSAGE_CODE = "default.doesnt.match.message";
    static final String DEFAULT_BLANK_MESSAGE_CODE = "default.blank.message";
    protected static final ResourceBundle bundle = ResourceBundle.getBundle("org.codehaus.groovy.grails.validation.DefaultErrorMessages");
    private static final String DEFAULT_BLANK_MESSAGE = bundle.getString("default.blank.message");
    private static final String DEFAULT_DOESNT_MATCH_MESSAGE = bundle.getString("default.doesnt.match.message");
    private static final String DEFAULT_INVALID_URL_MESSAGE = bundle.getString("default.invalid.url.message");
    private static final String DEFAULT_INVALID_CREDIT_CARD_MESSAGE = bundle.getString("default.invalid.creditCard.message");
    private static final String DEFAULT_INVALID_EMAIL_MESSAGE = bundle.getString("default.invalid.email.message");
    private static final String DEFAULT_INVALID_RANGE_MESSAGE = bundle.getString("default.invalid.range.message");
    private static final String DEFAULT_NOT_IN_LIST_MESSAGE = bundle.getString("default.not.inlist.message");
    private static final String DEFAULT_INVALID_SIZE_MESSAGE = bundle.getString("default.invalid.size.message");
    private static final String DEFAULT_INVALID_MAX_MESSAGE = bundle.getString("default.invalid.max.message");
    private static final String DEFAULT_INVALID_MIN_MESSAGE = bundle.getString("default.invalid.min.message");
    private static final String DEFAULT_NOT_EQUAL_MESSAGE = bundle.getString("default.not.equal.message");
    private static final String DEFAULT_INVALID_MAX_SIZE_MESSAGE = bundle.getString("default.invalid.max.size.message");
    private static final String DEFAULT_INVALID_MIN_SIZE_MESSAGE = bundle.getString("default.invalid.min.size.message");
    private static final String DEFAULT_NULL_MESSAGE = bundle.getString("default.null.message");
    private static final String DEFAULT_INVALID_VALIDATOR_MESSAGE = bundle.getString("default.invalid.validator.message");
    public static final String CREDIT_CARD_CONSTRAINT = "creditCard";
    public static final String EMAIL_CONSTRAINT = "email";
    public static final String BLANK_CONSTRAINT = "blank";
    public static final String RANGE_CONSTRAINT = "range";
    public static final String IN_LIST_CONSTRAINT = "inList";
    public static final String URL_CONSTRAINT = "url";
    public static final String MATCHES_CONSTRAINT = "matches";
    public static final String SIZE_CONSTRAINT = "size";
    public static final String MIN_CONSTRAINT = "min";
    public static final String MAX_CONSTRAINT = "max";
    public static final String MAX_SIZE_CONSTRAINT = "maxSize";
    public static final String MIN_SIZE_CONSTRAINT = "minSize";
    public static final String SCALE_CONSTRAINT = "scale";
    public static final String NOT_EQUAL_CONSTRAINT = "notEqual";
    public static final String NULLABLE_CONSTRAINT = "nullable";
    public static final String VALIDATOR_CONSTRAINT = "validator";
    protected static final String INVALID_SUFFIX = ".invalid";
    protected static final String EXCEEDED_SUFFIX = ".exceeded";
    protected static final String NOTMET_SUFFIX = ".notmet";
    protected static final String NOT_PREFIX = "not.";
    protected static final String TOOBIG_SUFFIX = ".toobig";
    protected static final String TOOLONG_SUFFIX = ".toolong";
    protected static final String TOOSMALL_SUFFIX = ".toosmall";
    protected static final String TOOSHORT_SUFFIX = ".tooshort";
    protected static Map<String, List<Object>> constraints = new HashMap<String, List<Object>>();
    protected static final Map<String, String> DEFAULT_MESSAGES = new HashMap<String, String>();
    protected static final Log LOG;
    protected String propertyName;
    protected Class<?> propertyType;
    protected Map<String, Constraint> appliedConstraints = new LinkedHashMap<String, Constraint>();
    protected Class<?> owningClass;
    private BeanWrapper bean;
    private boolean display = true;
    private boolean editable = true;
    private int order;
    private String format;
    private String widget;
    private boolean password;
    private Map attributes = Collections.EMPTY_MAP;
    protected MessageSource messageSource;
    private Map<String, Object> metaConstraints = new HashMap<String, Object>();

    public ConstrainedProperty(Class<?> clazz, String propertyName, Class<?> propertyType) {
        this.owningClass = clazz;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.bean = new BeanWrapperImpl((Object)this);
    }

    public static void removeConstraint(String name, Class<?> constraintClass) {
        Assert.hasLength((String)name, (String)"Argument [name] cannot be null");
        List<Object> objects = ConstrainedProperty.getOrInitializeConstraint(name);
        objects.remove(constraintClass);
        ArrayList<Object> toRemove = new ArrayList<Object>();
        for (Object object : objects) {
            if (!constraintClass.isInstance(object)) continue;
            toRemove.add(object);
        }
        objects.removeAll(toRemove);
    }

    public static void removeConstraint(String name) {
        Assert.hasLength((String)name, (String)"Argument [name] cannot be null");
        List<Object> objects = ConstrainedProperty.getOrInitializeConstraint(name);
        objects.clear();
    }

    public static void registerNewConstraint(String name, Class<?> constraintClass) {
        Assert.hasLength((String)name, (String)"Argument [name] cannot be null");
        if (constraintClass == null || !Constraint.class.isAssignableFrom(constraintClass)) {
            throw new IllegalArgumentException("Argument [constraintClass] with value [" + constraintClass + "] is not a valid constraint");
        }
        List<Object> objects = ConstrainedProperty.getOrInitializeConstraint(name);
        objects.add(constraintClass);
    }

    private static List<Object> getOrInitializeConstraint(String name) {
        List<Object> objects = constraints.get(name);
        if (objects == null) {
            objects = new ArrayList<Object>();
            constraints.put(name, objects);
        }
        return objects;
    }

    public static void registerNewConstraint(String name, ConstraintFactory factory) {
        Assert.hasLength((String)name, (String)"Argument [name] cannot be null or blank");
        Assert.notNull((Object)factory, (String)"Argument [factory] cannot be null");
        List<Object> objects = ConstrainedProperty.getOrInitializeConstraint(name);
        objects.add(factory);
    }

    public static boolean hasRegisteredConstraint(String constraintName) {
        return constraints.containsKey(constraintName) && constraints.get(constraintName).size() > 0;
    }

    public Collection<Constraint> getAppliedConstraints() {
        return this.appliedConstraints.values();
    }

    public Constraint getAppliedConstraint(String name) {
        return this.appliedConstraints.get(name);
    }

    public boolean hasAppliedConstraint(String constraintName) {
        return this.appliedConstraints.containsKey(constraintName);
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public Comparable getMax() {
        Comparable maxValue = null;
        MaxConstraint maxConstraint = (MaxConstraint)this.appliedConstraints.get(MAX_CONSTRAINT);
        RangeConstraint rangeConstraint = (RangeConstraint)this.appliedConstraints.get(RANGE_CONSTRAINT);
        if (maxConstraint != null || rangeConstraint != null) {
            Comparable rangeConstraintHighValue;
            Comparable maxConstraintValue = maxConstraint == null ? null : maxConstraint.getMaxValue();
            Comparable comparable = rangeConstraintHighValue = rangeConstraint == null ? null : rangeConstraint.getRange().getTo();
            if (maxConstraintValue != null && rangeConstraintHighValue != null) {
                maxValue = maxConstraintValue.compareTo(rangeConstraintHighValue) < 0 ? maxConstraintValue : rangeConstraintHighValue;
            } else if (maxConstraintValue == null && rangeConstraintHighValue != null) {
                maxValue = rangeConstraintHighValue;
            } else if (maxConstraintValue != null && rangeConstraintHighValue == null) {
                maxValue = maxConstraintValue;
            }
        }
        return maxValue;
    }

    public void setMax(Comparable max) {
        if (max == null) {
            this.appliedConstraints.remove(MAX_CONSTRAINT);
            return;
        }
        if (!this.propertyType.equals(max.getClass())) {
            throw new MissingPropertyException(MAX_CONSTRAINT, this.propertyType);
        }
        Range r = this.getRange();
        if (r != null) {
            LOG.warn((Object)("Range constraint already set ignoring constraint [max] for value [" + max + "]"));
            return;
        }
        Constraint c = this.appliedConstraints.get(MAX_CONSTRAINT);
        if (c == null) {
            c = new MaxConstraint();
            c.setOwningClass(this.owningClass);
            c.setPropertyName(this.propertyName);
            this.appliedConstraints.put(MAX_CONSTRAINT, c);
        }
        c.setParameter(max);
    }

    public Comparable getMin() {
        Comparable minValue = null;
        MinConstraint minConstraint = (MinConstraint)this.appliedConstraints.get(MIN_CONSTRAINT);
        RangeConstraint rangeConstraint = (RangeConstraint)this.appliedConstraints.get(RANGE_CONSTRAINT);
        if (minConstraint != null || rangeConstraint != null) {
            Comparable rangeConstraintLowValue;
            Comparable minConstraintValue = minConstraint != null ? minConstraint.getMinValue() : null;
            Comparable comparable = rangeConstraintLowValue = rangeConstraint != null ? rangeConstraint.getRange().getFrom() : null;
            if (minConstraintValue != null && rangeConstraintLowValue != null) {
                minValue = minConstraintValue.compareTo(rangeConstraintLowValue) > 0 ? minConstraintValue : rangeConstraintLowValue;
            } else if (minConstraintValue == null && rangeConstraintLowValue != null) {
                minValue = rangeConstraintLowValue;
            } else if (minConstraintValue != null && rangeConstraintLowValue == null) {
                minValue = minConstraintValue;
            }
        }
        return minValue;
    }

    public void setMin(Comparable min) {
        if (min == null) {
            this.appliedConstraints.remove(MIN_CONSTRAINT);
            return;
        }
        if (!this.propertyType.equals(min.getClass())) {
            throw new MissingPropertyException(MIN_CONSTRAINT, this.propertyType);
        }
        Range r = this.getRange();
        if (r != null) {
            LOG.warn((Object)("Range constraint already set ignoring constraint [min] for value [" + min + "]"));
            return;
        }
        Constraint c = this.appliedConstraints.get(MIN_CONSTRAINT);
        if (c == null) {
            c = new MinConstraint();
            c.setOwningClass(this.owningClass);
            c.setPropertyName(this.propertyName);
            this.appliedConstraints.put(MIN_CONSTRAINT, c);
        }
        c.setParameter(min);
    }

    public List getInList() {
        InListConstraint c = (InListConstraint)this.appliedConstraints.get(IN_LIST_CONSTRAINT);
        return c == null ? null : c.getList();
    }

    public void setInList(List inList) {
        Constraint c = this.appliedConstraints.get(IN_LIST_CONSTRAINT);
        if (inList == null) {
            this.appliedConstraints.remove(IN_LIST_CONSTRAINT);
        } else {
            if (c == null) {
                c = new InListConstraint();
                c.setOwningClass(this.owningClass);
                c.setPropertyName(this.propertyName);
                this.appliedConstraints.put(IN_LIST_CONSTRAINT, c);
            }
            c.setParameter(inList);
        }
    }

    public Range getRange() {
        RangeConstraint c = (RangeConstraint)this.appliedConstraints.get(RANGE_CONSTRAINT);
        return c == null ? null : c.getRange();
    }

    public void setRange(Range range) {
        if (this.appliedConstraints.containsKey(MAX_CONSTRAINT)) {
            LOG.warn((Object)("Setting range constraint on property [" + this.propertyName + "] of class [" + this.owningClass + "] forced removal of max constraint"));
            this.appliedConstraints.remove(MAX_CONSTRAINT);
        }
        if (this.appliedConstraints.containsKey(MIN_CONSTRAINT)) {
            LOG.warn((Object)("Setting range constraint on property [" + this.propertyName + "] of class [" + this.owningClass + "] forced removal of min constraint"));
            this.appliedConstraints.remove(MIN_CONSTRAINT);
        }
        if (range == null) {
            this.appliedConstraints.remove(RANGE_CONSTRAINT);
        } else {
            Constraint c = this.appliedConstraints.get(RANGE_CONSTRAINT);
            if (c == null) {
                c = new RangeConstraint();
                c.setOwningClass(this.owningClass);
                c.setPropertyName(this.propertyName);
                this.appliedConstraints.put(RANGE_CONSTRAINT, c);
            }
            c.setParameter(range);
        }
    }

    public Integer getScale() {
        ScaleConstraint scaleConstraint = (ScaleConstraint)this.appliedConstraints.get(SCALE_CONSTRAINT);
        return scaleConstraint == null ? null : Integer.valueOf(scaleConstraint.getScale());
    }

    public Range getSize() {
        SizeConstraint c = (SizeConstraint)this.appliedConstraints.get(SIZE_CONSTRAINT);
        return c == null ? null : c.getRange();
    }

    public void setSize(Range size) {
        Constraint c = this.appliedConstraints.get(SIZE_CONSTRAINT);
        if (size == null) {
            this.appliedConstraints.remove(SIZE_CONSTRAINT);
        } else {
            if (c == null) {
                c = new SizeConstraint();
                c.setOwningClass(this.owningClass);
                c.setPropertyName(this.propertyName);
                this.appliedConstraints.put(SIZE_CONSTRAINT, c);
            }
            c.setParameter(size);
        }
    }

    public boolean isBlank() {
        Constraint cons = this.appliedConstraints.get(BLANK_CONSTRAINT);
        return cons == null || (Boolean)((BlankConstraint)cons).getParameter() != false;
    }

    public void setBlank(boolean blank) {
        if (this.isNotValidStringType()) {
            throw new MissingPropertyException("Blank constraint can only be applied to a String property", BLANK_CONSTRAINT, this.owningClass);
        }
        if (blank) {
            Constraint c = this.appliedConstraints.get(BLANK_CONSTRAINT);
            if (c == null) {
                c = new BlankConstraint();
                c.setOwningClass(this.owningClass);
                c.setPropertyName(this.propertyName);
                this.appliedConstraints.put(BLANK_CONSTRAINT, c);
            }
            c.setParameter(blank);
        } else {
            this.appliedConstraints.remove(BLANK_CONSTRAINT);
        }
    }

    public boolean isEmail() {
        if (this.isNotValidStringType()) {
            throw new MissingPropertyException("Email constraint only applies to a String property", EMAIL_CONSTRAINT, this.owningClass);
        }
        return this.appliedConstraints.containsKey(EMAIL_CONSTRAINT);
    }

    public void setEmail(boolean email) {
        if (this.isNotValidStringType()) {
            throw new MissingPropertyException("Email constraint can only be applied to a String property", EMAIL_CONSTRAINT, this.owningClass);
        }
        Constraint c = this.appliedConstraints.get(EMAIL_CONSTRAINT);
        if (email) {
            if (c == null) {
                c = new EmailConstraint();
                c.setOwningClass(this.owningClass);
                c.setPropertyName(this.propertyName);
                this.appliedConstraints.put(EMAIL_CONSTRAINT, c);
            }
            c.setParameter(true);
        } else if (c != null) {
            this.appliedConstraints.remove(EMAIL_CONSTRAINT);
        }
    }

    private boolean isNotValidStringType() {
        return !CharSequence.class.isAssignableFrom(this.propertyType);
    }

    public boolean isCreditCard() {
        if (this.isNotValidStringType()) {
            throw new MissingPropertyException("CreditCard constraint only applies to a String property", CREDIT_CARD_CONSTRAINT, this.owningClass);
        }
        return this.appliedConstraints.containsKey(CREDIT_CARD_CONSTRAINT);
    }

    public void setCreditCard(boolean creditCard) {
        if (this.isNotValidStringType()) {
            throw new MissingPropertyException("CreditCard constraint only applies to a String property", CREDIT_CARD_CONSTRAINT, this.owningClass);
        }
        Constraint c = this.appliedConstraints.get(CREDIT_CARD_CONSTRAINT);
        if (creditCard) {
            if (c == null) {
                c = new CreditCardConstraint();
                c.setOwningClass(this.owningClass);
                c.setPropertyName(this.propertyName);
                this.appliedConstraints.put(CREDIT_CARD_CONSTRAINT, c);
            }
            c.setParameter(true);
        } else if (c != null) {
            this.appliedConstraints.remove(CREDIT_CARD_CONSTRAINT);
        }
    }

    public String getMatches() {
        if (this.isNotValidStringType()) {
            throw new MissingPropertyException("Matches constraint only applies to a String property", MATCHES_CONSTRAINT, this.owningClass);
        }
        MatchesConstraint c = (MatchesConstraint)this.appliedConstraints.get(MATCHES_CONSTRAINT);
        return c == null ? null : c.getRegex();
    }

    public void setMatches(String regex) {
        if (this.isNotValidStringType()) {
            throw new MissingPropertyException("Matches constraint can only be applied to a String property", MATCHES_CONSTRAINT, this.owningClass);
        }
        Constraint c = this.appliedConstraints.get(MATCHES_CONSTRAINT);
        if (regex == null) {
            this.appliedConstraints.remove(MATCHES_CONSTRAINT);
        } else {
            if (c == null) {
                c = new MatchesConstraint();
                c.setOwningClass(this.owningClass);
                c.setPropertyName(this.propertyName);
                this.appliedConstraints.put(MATCHES_CONSTRAINT, c);
            }
            c.setParameter(regex);
        }
    }

    public Object getNotEqual() {
        NotEqualConstraint c = (NotEqualConstraint)this.appliedConstraints.get(NOT_EQUAL_CONSTRAINT);
        return c == null ? null : c.getNotEqualTo();
    }

    public Integer getMaxSize() {
        Integer maxSize = null;
        MaxSizeConstraint maxSizeConstraint = (MaxSizeConstraint)this.appliedConstraints.get(MAX_SIZE_CONSTRAINT);
        SizeConstraint sizeConstraint = (SizeConstraint)this.appliedConstraints.get(SIZE_CONSTRAINT);
        if (maxSizeConstraint != null || sizeConstraint != null) {
            int maxSizeConstraintValue = maxSizeConstraint == null ? Integer.MAX_VALUE : maxSizeConstraint.getMaxSize();
            int sizeConstraintHighValue = sizeConstraint == null ? Integer.MAX_VALUE : sizeConstraint.getRange().getToInt();
            maxSize = Math.min(maxSizeConstraintValue, sizeConstraintHighValue);
        }
        return maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        Constraint c = this.appliedConstraints.get(MAX_SIZE_CONSTRAINT);
        if (c == null) {
            c = new MaxSizeConstraint();
            c.setOwningClass(this.owningClass);
            c.setPropertyName(this.propertyName);
            this.appliedConstraints.put(MAX_SIZE_CONSTRAINT, c);
        }
        c.setParameter(maxSize);
    }

    public Integer getMinSize() {
        Integer minSize = null;
        MinSizeConstraint minSizeConstraint = (MinSizeConstraint)this.appliedConstraints.get(MIN_SIZE_CONSTRAINT);
        SizeConstraint sizeConstraint = (SizeConstraint)this.appliedConstraints.get(SIZE_CONSTRAINT);
        if (minSizeConstraint != null || sizeConstraint != null) {
            int minSizeConstraintValue = minSizeConstraint == null ? Integer.MIN_VALUE : minSizeConstraint.getMinSize();
            int sizeConstraintLowValue = sizeConstraint == null ? Integer.MIN_VALUE : sizeConstraint.getRange().getFromInt();
            minSize = Math.max(minSizeConstraintValue, sizeConstraintLowValue);
        }
        return minSize;
    }

    public void setMinSize(Integer minSize) {
        Constraint c = this.appliedConstraints.get(MIN_SIZE_CONSTRAINT);
        if (c == null) {
            c = new MinSizeConstraint();
            c.setOwningClass(this.owningClass);
            c.setPropertyName(this.propertyName);
            this.appliedConstraints.put(MIN_SIZE_CONSTRAINT, c);
        }
        c.setParameter(minSize);
    }

    public void setNotEqual(Object notEqual) {
        if (notEqual == null) {
            this.appliedConstraints.remove(NOT_EQUAL_CONSTRAINT);
        } else {
            NotEqualConstraint c = new NotEqualConstraint();
            c.setOwningClass(this.owningClass);
            c.setPropertyName(this.propertyName);
            c.setParameter(notEqual);
            this.appliedConstraints.put(NOT_EQUAL_CONSTRAINT, c);
        }
    }

    public boolean isNullable() {
        if (this.appliedConstraints.containsKey(NULLABLE_CONSTRAINT)) {
            NullableConstraint nc = (NullableConstraint)this.appliedConstraints.get(NULLABLE_CONSTRAINT);
            return nc.isNullable();
        }
        return false;
    }

    public void setNullable(boolean nullable) {
        NullableConstraint nc = (NullableConstraint)this.appliedConstraints.get(NULLABLE_CONSTRAINT);
        if (nc == null) {
            nc = new NullableConstraint();
            nc.setOwningClass(this.owningClass);
            nc.setPropertyName(this.propertyName);
            this.appliedConstraints.put(NULLABLE_CONSTRAINT, nc);
        }
        nc.setParameter(nullable);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public boolean isUrl() {
        if (this.isNotValidStringType()) {
            throw new MissingPropertyException("URL constraint can only be applied to a String property", URL_CONSTRAINT, this.owningClass);
        }
        return this.appliedConstraints.containsKey(URL_CONSTRAINT);
    }

    public void setUrl(boolean url) {
        if (this.isNotValidStringType()) {
            throw new MissingPropertyException("URL constraint can only be applied to a String property", URL_CONSTRAINT, this.owningClass);
        }
        Constraint c = this.appliedConstraints.get(URL_CONSTRAINT);
        if (url) {
            if (c == null) {
                c = new UrlConstraint();
                c.setOwningClass(this.owningClass);
                c.setPropertyName(this.propertyName);
                this.appliedConstraints.put(URL_CONSTRAINT, c);
            }
            c.setParameter(true);
        } else if (c != null) {
            this.appliedConstraints.remove(URL_CONSTRAINT);
        }
    }

    public boolean isDisplay() {
        return this.display;
    }

    public void setDisplay(boolean display) {
        this.display = display;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean password) {
        this.password = password;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public String getWidget() {
        return this.widget;
    }

    public void setWidget(String widget) {
        this.widget = widget;
    }

    public void setMessageSource(MessageSource source) {
        this.messageSource = source;
    }

    public void validate(Object target, Object propertyValue, Errors errors) {
        ArrayList<Constraint> delayedConstraints = new ArrayList<Constraint>();
        for (Constraint c : this.appliedConstraints.values()) {
            if (c instanceof VetoingConstraint) {
                c.setMessageSource(this.messageSource);
                if (!((VetoingConstraint)c).validateWithVetoing(target, propertyValue, errors)) continue;
                return;
            }
            delayedConstraints.add(c);
        }
        for (Constraint c : delayedConstraints) {
            c.setMessageSource(this.messageSource);
            c.validate(target, propertyValue, errors);
        }
    }

    public boolean supportsContraint(String constraintName) {
        if (!constraints.containsKey(constraintName)) {
            return this.bean.isWritableProperty(constraintName);
        }
        try {
            Constraint c = this.instantiateConstraint(constraintName, false);
            return c != null && c.supports(this.propertyType);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception thrown instantiating constraint [" + constraintName + "] to class [" + this.owningClass + "]"), (Throwable)e);
            throw new ConstraintException("Exception thrown instantiating  constraint [" + constraintName + "] to class [" + this.owningClass + "]");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyConstraint(String constraintName, Object constrainingValue) {
        if (constraints.containsKey(constraintName)) {
            if (constrainingValue == null) {
                this.appliedConstraints.remove(constraintName);
                return;
            } else {
                try {
                    Constraint c = this.instantiateConstraint(constraintName, true);
                    if (c == null) return;
                    c.setParameter(constrainingValue);
                    this.appliedConstraints.put(constraintName, c);
                    return;
                }
                catch (Exception e) {
                    LOG.error((Object)("Exception thrown applying constraint [" + constraintName + "] to class [" + this.owningClass + "] for value [" + constrainingValue + "]: " + e.getMessage()), (Throwable)e);
                    throw new ConstraintException("Exception thrown applying constraint [" + constraintName + "] to class [" + this.owningClass + "] for value [" + constrainingValue + "]: " + e.getMessage(), e);
                }
            }
        } else {
            if (!this.bean.isWritableProperty(constraintName)) throw new ConstraintException("Constraint [" + constraintName + "] is not supported for property [" + this.propertyName + "] of class [" + this.owningClass + "] with type [" + this.propertyType + "]");
            this.bean.setPropertyValue(constraintName, constrainingValue);
        }
    }

    public Class getOwner() {
        return this.owningClass;
    }

    private Constraint instantiateConstraint(String constraintName, boolean validate) throws InstantiationException, IllegalAccessException {
        List<Object> candidateConstraints = constraints.get(constraintName);
        for (Object constraintFactory : candidateConstraints) {
            Constraint c = constraintFactory instanceof ConstraintFactory ? ((ConstraintFactory)constraintFactory).newInstance() : (Constraint)((Class)constraintFactory).newInstance();
            c.setOwningClass(this.owningClass);
            c.setPropertyName(this.propertyName);
            if (validate && c.isValid()) {
                return c;
            }
            if (validate) continue;
            return c;
        }
        return null;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append(this.owningClass).append((Object)this.propertyName).append(this.propertyType).append(this.appliedConstraints).toString();
    }

    public void addMetaConstraint(String name, Object value) {
        this.metaConstraints.put(name, value);
    }

    public Object getMetaConstraintValue(String name) {
        return this.metaConstraints.get(name);
    }

    static {
        DEFAULT_MESSAGES.put(DEFAULT_BLANK_MESSAGE_CODE, DEFAULT_BLANK_MESSAGE);
        DEFAULT_MESSAGES.put(DEFAULT_DOESNT_MATCH_MESSAGE_CODE, DEFAULT_DOESNT_MATCH_MESSAGE);
        DEFAULT_MESSAGES.put(DEFAULT_INVALID_CREDIT_CARD_MESSAGE_CODE, DEFAULT_INVALID_CREDIT_CARD_MESSAGE);
        DEFAULT_MESSAGES.put(DEFAULT_INVALID_EMAIL_MESSAGE_CODE, DEFAULT_INVALID_EMAIL_MESSAGE);
        DEFAULT_MESSAGES.put(DEFAULT_INVALID_MAX_MESSAGE_CODE, DEFAULT_INVALID_MAX_MESSAGE);
        DEFAULT_MESSAGES.put(DEFAULT_INVALID_MAX_SIZE_MESSAGE_CODE, DEFAULT_INVALID_MAX_SIZE_MESSAGE);
        DEFAULT_MESSAGES.put(DEFAULT_INVALID_MIN_MESSAGE_CODE, DEFAULT_INVALID_MIN_MESSAGE);
        DEFAULT_MESSAGES.put(DEFAULT_INVALID_MIN_SIZE_MESSAGE_CODE, DEFAULT_INVALID_MIN_SIZE_MESSAGE);
        DEFAULT_MESSAGES.put(DEFAULT_INVALID_RANGE_MESSAGE_CODE, DEFAULT_INVALID_RANGE_MESSAGE);
        DEFAULT_MESSAGES.put(DEFAULT_INVALID_SIZE_MESSAGE_CODE, DEFAULT_INVALID_SIZE_MESSAGE);
        DEFAULT_MESSAGES.put(DEFAULT_INVALID_URL_MESSAGE_CODE, DEFAULT_INVALID_URL_MESSAGE);
        DEFAULT_MESSAGES.put(DEFAULT_NOT_EQUAL_MESSAGE_CODE, DEFAULT_NOT_EQUAL_MESSAGE);
        DEFAULT_MESSAGES.put(DEFAULT_NOT_INLIST_MESSAGE_CODE, DEFAULT_NOT_IN_LIST_MESSAGE);
        DEFAULT_MESSAGES.put(DEFAULT_NULL_MESSAGE_CODE, DEFAULT_NULL_MESSAGE);
        DEFAULT_MESSAGES.put(DEFAULT_INVALID_VALIDATOR_MESSAGE_CODE, DEFAULT_INVALID_VALIDATOR_MESSAGE);
        constraints.put(CREDIT_CARD_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(CreditCardConstraint.class);
            }
        });
        constraints.put(EMAIL_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(EmailConstraint.class);
            }
        });
        constraints.put(BLANK_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(BlankConstraint.class);
            }
        });
        constraints.put(RANGE_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(RangeConstraint.class);
            }
        });
        constraints.put(IN_LIST_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(InListConstraint.class);
            }
        });
        constraints.put(URL_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(UrlConstraint.class);
            }
        });
        constraints.put(SIZE_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(SizeConstraint.class);
            }
        });
        constraints.put(MATCHES_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(MatchesConstraint.class);
            }
        });
        constraints.put(MIN_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(MinConstraint.class);
            }
        });
        constraints.put(MAX_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(MaxConstraint.class);
            }
        });
        constraints.put(MAX_SIZE_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(MaxSizeConstraint.class);
            }
        });
        constraints.put(MIN_SIZE_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(MinSizeConstraint.class);
            }
        });
        constraints.put(SCALE_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(ScaleConstraint.class);
            }
        });
        constraints.put(NULLABLE_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(NullableConstraint.class);
            }
        });
        constraints.put(NOT_EQUAL_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(NotEqualConstraint.class);
            }
        });
        constraints.put(VALIDATOR_CONSTRAINT, (List<Object>)new ArrayList<Object>(){
            {
                this.add(ValidatorConstraint.class);
            }
        });
        LOG = LogFactory.getLog(ConstrainedProperty.class);
    }
}

