/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.web.mapping.UrlMappingData;
import org.springframework.util.Assert;

public class DefaultUrlMappingData
implements UrlMappingData {
    private static final String CAPTURED_WILDCARD = "(*)";
    private static final String CAPTURED_DOUBLE_WILDCARD = "(**)";
    private static final String QUESTION_MARK = "?";
    private static final String SLASH = "/";
    private final String urlPattern;
    private final String[] logicalUrls;
    private final String[] tokens;
    private List<Boolean> optionalTokens = new ArrayList<Boolean>();
    private boolean hasOptionalExtension;

    public DefaultUrlMappingData(String urlPattern) {
        String configuredPattern;
        Assert.hasLength((String)urlPattern, (String)"Argument [urlPattern] cannot be null or blank");
        Assert.isTrue((boolean)urlPattern.startsWith(SLASH), (String)"Argument [urlPattern] is not a valid URL. It must start with '/' !");
        this.urlPattern = configuredPattern = this.configureUrlPattern(urlPattern);
        this.tokens = this.tokenizeUrlPattern(configuredPattern);
        ArrayList<String> urls = new ArrayList<String>();
        this.parseUrls(urls, this.tokens, this.optionalTokens);
        this.logicalUrls = urls.toArray(new String[urls.size()]);
    }

    public boolean hasOptionalExtension() {
        return this.hasOptionalExtension;
    }

    private String[] tokenizeUrlPattern(String urlPattern) {
        return urlPattern.substring(1).split(SLASH);
    }

    private String configureUrlPattern(String urlPattern) {
        return StringUtils.replace((String)urlPattern, (String)"(*)**", (String)CAPTURED_DOUBLE_WILDCARD);
    }

    private DefaultUrlMappingData(String urlPattern, String[] logicalUrls, String[] tokens, List<Boolean> optionalTokens) {
        this.urlPattern = urlPattern;
        this.logicalUrls = logicalUrls;
        this.tokens = tokens;
        this.optionalTokens = optionalTokens;
    }

    private void parseUrls(List<String> urls, String[] tokens, List<Boolean> optionalTokens) {
        StringBuilder buf = new StringBuilder();
        String optionalExtensionPattern = "(.(*))?";
        String optionalExtension = null;
        if (tokens.length > 0) {
            String lastToken = tokens[tokens.length - 1];
            this.hasOptionalExtension = lastToken.endsWith(optionalExtensionPattern);
            if (this.hasOptionalExtension) {
                int i = lastToken.indexOf(optionalExtensionPattern);
                optionalExtension = lastToken.substring(i, lastToken.length());
                tokens[tokens.length - 1] = lastToken.substring(0, i);
            }
        }
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i].trim();
            if (token.equals(SLASH)) continue;
            boolean isOptional = false;
            if (token.endsWith(QUESTION_MARK)) {
                if (optionalExtension != null) {
                    urls.add(buf.toString() + optionalExtension);
                } else {
                    urls.add(buf.toString());
                }
                buf.append(SLASH).append(token);
                isOptional = true;
            } else {
                buf.append(SLASH).append(token);
            }
            if (CAPTURED_WILDCARD.equals(token)) {
                if (isOptional) {
                    optionalTokens.add(Boolean.TRUE);
                } else {
                    optionalTokens.add(Boolean.FALSE);
                }
            }
            if (!CAPTURED_DOUBLE_WILDCARD.equals(token)) continue;
            optionalTokens.add(Boolean.TRUE);
        }
        if (optionalExtension != null) {
            urls.add(buf.toString() + optionalExtension);
        } else {
            urls.add(buf.toString());
        }
        Collections.reverse(urls);
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public String[] getLogicalUrls() {
        return this.logicalUrls;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public boolean isOptional(int index) {
        if (index >= this.optionalTokens.size()) {
            return true;
        }
        return this.optionalTokens.get(index).equals(Boolean.TRUE);
    }

    public UrlMappingData createRelative(String path) {
        Assert.hasLength((String)path, (String)"Argument [path] cannot be null or blank");
        String newPattern = this.urlPattern + this.configureUrlPattern(path);
        String[] tokens = this.tokenizeUrlPattern(newPattern);
        ArrayList<String> urls = new ArrayList<String>();
        ArrayList<Boolean> optionalTokens = new ArrayList<Boolean>();
        this.parseUrls(urls, tokens, optionalTokens);
        String[] logicalUrls = urls.toArray(new String[urls.size()]);
        return new DefaultUrlMappingData(newPattern, logicalUrls, tokens, optionalTokens);
    }
}

