/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.web.mapping.UrlCreator;
import org.codehaus.groovy.grails.web.pages.FastStringWriter;
import org.codehaus.groovy.grails.web.servlet.mvc.DefaultRequestStateLookupStrategy;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.springframework.web.context.request.RequestContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUrlCreator
implements UrlCreator {
    private static final char SLASH = '/';
    private final String controllerName;
    private final String actionName;
    public static final String ARGUMENT_ID = "id";
    private static final String ENTITY_AMPERSAND = "&";

    public DefaultUrlCreator(String controller, String action) {
        this.controllerName = controller;
        this.actionName = action;
    }

    public String createURL(Map parameterValues, String encoding) {
        if (parameterValues == null) {
            parameterValues = Collections.EMPTY_MAP;
        }
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.getRequestAttributes();
        return this.createURLWithWebRequest(parameterValues, webRequest, true);
    }

    public String createURL(Map parameterValues, String encoding, String fragment) {
        String url = this.createURL(parameterValues, encoding);
        return this.createUrlWithFragment(encoding, fragment, url);
    }

    private String createURLWithWebRequest(Map parameterValues, GrailsWebRequest webRequest, boolean includeContextPath) {
        Object o;
        DefaultRequestStateLookupStrategy requestStateLookupStrategy = new DefaultRequestStateLookupStrategy(webRequest);
        String encoding = requestStateLookupStrategy.getCharacterEncoding();
        String id = null;
        if (parameterValues.containsKey(ARGUMENT_ID) && (o = parameterValues.get(ARGUMENT_ID)) != null) {
            id = o.toString();
        }
        FastStringWriter actualUriBuf = new FastStringWriter();
        if (includeContextPath) {
            actualUriBuf.append((CharSequence)requestStateLookupStrategy.getContextPath());
        }
        if (this.actionName != null) {
            if (this.actionName.indexOf(47) > -1) {
                actualUriBuf.append((CharSequence)this.actionName);
            } else if (this.controllerName != null) {
                this.appendUrlToken(actualUriBuf, this.controllerName, encoding);
            } else {
                this.appendUrlToken(actualUriBuf, requestStateLookupStrategy.getControllerName(), encoding);
            }
            this.appendUrlToken(actualUriBuf, this.actionName, encoding);
        }
        if (id != null) {
            this.appendUrlToken(actualUriBuf, id, encoding);
        }
        this.appendRequestParams(actualUriBuf, parameterValues, encoding);
        return actualUriBuf.toString();
    }

    public String createURL(String controller, String action, Map parameterValues, String encoding) {
        return this.createURL(controller, action, null, parameterValues, encoding);
    }

    public String createURL(String controller, String action, String pluginName, Map parameterValues, String encoding) {
        return this.createURLInternal(controller, action, parameterValues, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createURLInternal(String controller, String action, Map<String, String> parameterValues, boolean includeContextPath) {
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.getRequestAttributes();
        if (parameterValues == null) {
            parameterValues = new HashMap<String, String>();
        }
        boolean blankController = StringUtils.isBlank((String)controller);
        boolean blankAction = StringUtils.isBlank((String)action);
        if (!blankController) {
            parameterValues.put("controller", controller);
        }
        if (!blankAction) {
            parameterValues.put("action", action);
        }
        try {
            String string = this.createURLWithWebRequest(parameterValues, webRequest, includeContextPath);
            return string;
        }
        finally {
            if (!blankController) {
                parameterValues.remove("controller");
            }
            if (!blankAction) {
                parameterValues.remove("action");
            }
        }
    }

    public String createRelativeURL(String controller, String action, Map parameterValues, String encoding) {
        return this.createRelativeURL(controller, action, null, parameterValues, encoding);
    }

    public String createRelativeURL(String controller, String action, String pluginName, Map parameterValues, String encoding) {
        return this.createURLInternal(controller, action, parameterValues, false);
    }

    public String createRelativeURL(String controller, String action, Map parameterValues, String encoding, String fragment) {
        return this.createRelativeURL(controller, action, null, parameterValues, encoding, fragment);
    }

    public String createRelativeURL(String controller, String action, String pluginName, Map parameterValues, String encoding, String fragment) {
        String url = this.createURLInternal(controller, action, parameterValues, false);
        return this.createUrlWithFragment(encoding, fragment, url);
    }

    public String createURL(String controller, String action, Map parameterValues, String encoding, String fragment) {
        return this.createURL(controller, action, null, parameterValues, encoding, fragment);
    }

    public String createURL(String controller, String action, String pluginName, Map parameterValues, String encoding, String fragment) {
        String url = this.createURL(controller, action, pluginName, parameterValues, encoding);
        return this.createUrlWithFragment(encoding, fragment, url);
    }

    private String createUrlWithFragment(String encoding, String fragment, String url) {
        if (fragment != null) {
            try {
                return url + '#' + URLEncoder.encode(fragment, encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new ControllerExecutionException("Error creating URL  [" + url + "], problem encoding URL fragment [" + fragment + "]: " + ex.getMessage(), (Throwable)ex);
            }
        }
        return url;
    }

    private void appendRequestParams(FastStringWriter actualUriBuf, Map<Object, Object> params, String encoding) {
        boolean querySeparator = false;
        for (Map.Entry<Object, Object> entry : params.entrySet()) {
            Object currentValue;
            Object name = entry.getKey();
            if (name.equals("controller") || name.equals("action") || name.equals(ARGUMENT_ID)) continue;
            if (!querySeparator) {
                actualUriBuf.append('?');
                querySeparator = true;
            } else {
                actualUriBuf.append((CharSequence)ENTITY_AMPERSAND);
            }
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                Iterator valueIterator = values.iterator();
                while (valueIterator.hasNext()) {
                    currentValue = valueIterator.next();
                    this.appendRequestParam(actualUriBuf, name, currentValue, encoding);
                    if (!valueIterator.hasNext()) continue;
                    actualUriBuf.append((CharSequence)ENTITY_AMPERSAND);
                }
                continue;
            }
            if (value != null && value.getClass().isArray()) {
                Object[] array = (Object[])value;
                for (int j = 0; j < array.length; ++j) {
                    currentValue = array[j];
                    this.appendRequestParam(actualUriBuf, name, currentValue, encoding);
                    if (j >= array.length - 1) continue;
                    actualUriBuf.append((CharSequence)ENTITY_AMPERSAND);
                }
                continue;
            }
            this.appendRequestParam(actualUriBuf, name, value, encoding);
        }
    }

    private void appendRequestParam(FastStringWriter actualUriBuf, Object name, Object value, String encoding) {
        if (value == null) {
            value = "";
        }
        actualUriBuf.append((CharSequence)this.urlEncode(name, encoding)).append('=').append((CharSequence)this.urlEncode(value, encoding));
    }

    private String urlEncode(Object obj, String charset) {
        try {
            return URLEncoder.encode(obj.toString(), charset != null ? charset : "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ControllerExecutionException("Error creating URL, cannot URLEncode to the client's character encoding: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void appendUrlToken(FastStringWriter actualUriBuf, Object token, String charset) {
        actualUriBuf.append('/').append((CharSequence)this.urlEncode(token, charset));
    }
}

