/*
 * Decompiled with CFR 0.152.
 */
package grails.rest.render.errors;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import grails.rest.render.RenderContext;
import grails.rest.render.errors.AbstractVndErrorRenderer;
import grails.util.GrailsWebUtil;
import grails.web.mime.MimeType;
import groovy.lang.MetaClass;
import java.util.Iterator;
import java.util.Locale;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;

public class VndErrorJsonRenderer
extends AbstractVndErrorRenderer {
    public static final MimeType MIME_TYPE;
    public static final String LINKS_ATTRIBUTE = "_links";
    public static final String FOUR_SPACES = "    ";
    private MimeType[] mimeTypes;
    @Autowired(required=false)
    private Gson gson;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public VndErrorJsonRenderer() {
        Gson gson;
        MimeType[] mimeTypeArray = new MimeType[]{MIME_TYPE, MimeType.HAL_JSON, MimeType.JSON, MimeType.TEXT_JSON};
        this.mimeTypes = mimeTypeArray;
        this.gson = gson = new Gson();
    }

    @Override
    public void render(Errors object, RenderContext context) {
        if (this.getMessageSource() == null) {
            throw (Throwable)new IllegalStateException("messageSource property null");
        }
        if (object instanceof BeanPropertyBindingResult) {
            context.setContentType(GrailsWebUtil.getContentType((String)MIME_TYPE.getName(), (String)this.getEncoding()));
            context.setStatus(HttpStatus.UNPROCESSABLE_ENTITY);
            Locale locale = context.getLocale();
            Object target = ((BeanPropertyBindingResult)ScriptBytecodeAdapter.castToType((Object)object, BeanPropertyBindingResult.class)).getTarget();
            JsonWriter writer = new JsonWriter(context.getWriter());
            if (this.getPrettyPrint()) {
                String string = FOUR_SPACES;
                writer.setIndent(string);
            }
            writer.beginArray();
            ObjectError oe = null;
            Iterator iterator = object.getAllErrors().iterator();
            while (iterator.hasNext()) {
                oe = (ObjectError)ScriptBytecodeAdapter.castToType(iterator.next(), ObjectError.class);
                String msg = this.getMessageSource().getMessage((MessageSourceResolvable)oe, locale);
                String logref = this.resolveLogRef(target, oe);
                writer.beginObject().name(AbstractVndErrorRenderer.LOGREF_ATTRIBUTE).value(logref).name(AbstractVndErrorRenderer.MESSAGE_ATTRIBUTE).value(msg).name(LINKS_ATTRIBUTE).beginObject().name(AbstractVndErrorRenderer.RESOURCE_ATTRIBUTE).beginObject().name(AbstractVndErrorRenderer.HREF_ATTRIBUTE).value(this.getLinkGenerator().link(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"resource", target, "method", HttpMethod.GET, "absolute", this.getAbsoluteLinks()}))).endObject().endObject().endObject();
            }
            writer.endArray();
            writer.flush();
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != VndErrorJsonRenderer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        MimeType mimeType;
        MIME_TYPE = mimeType = new MimeType("application/vnd.error+json", "json");
    }

    public MimeType[] getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(MimeType ... mimeTypeArray) {
        this.mimeTypes = mimeTypeArray;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }
}

