/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller;

import groovy.lang.Closure;
import org.codehaus.groovy.grails.web.converters.Converter;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureOjectMarshaller<T extends Converter>
implements ObjectMarshaller<T> {
    private Class<?> clazz;
    private Closure closure;

    public ClosureOjectMarshaller(Class<?> clazz, Closure closure) {
        this.clazz = clazz;
        this.closure = closure;
    }

    @Override
    public boolean supports(Object object) {
        return this.clazz.isAssignableFrom(object.getClass());
    }

    @Override
    public void marshalObject(Object object, T converter) throws ConverterException {
        try {
            int argCount = this.closure.getParameterTypes().length;
            Object result = null;
            if (argCount <= 1) {
                result = this.closure.call(object);
            } else if (argCount == 2) {
                result = this.closure.call(new Object[]{object, converter});
            } else {
                throw new ConverterException("Invalid Parameter count for registered Object Marshaller for class " + this.clazz.getName());
            }
            if (result != null && result != object && result != converter) {
                converter.convertAnother(result);
            }
        }
        catch (Exception e) {
            throw e instanceof ConverterException ? (ConverterException)e : new ConverterException(e);
        }
    }
}

