/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.configuration;

import grails.util.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.grails.support.proxy.DefaultProxyHandler;
import org.codehaus.groovy.grails.support.proxy.ProxyHandler;
import org.codehaus.groovy.grails.web.converters.Converter;
import org.codehaus.groovy.grails.web.converters.configuration.ConverterConfiguration;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedConverterConfiguration<C extends Converter>
implements ConverterConfiguration<C> {
    private List<ObjectMarshaller<C>> marshallerList;
    private ChainedObjectMarshaller<C> root;
    private final String encoding;
    private final Converter.CircularReferenceBehaviour circularReferenceBehaviour;
    private final boolean prettyPrint;
    private ProxyHandler proxyHandler;
    private final boolean cacheObjectMarshallerByClass;
    private Map<Integer, ObjectMarshaller<C>> objectMarshallerForClassCache;
    private final boolean developmentMode = Environment.isDevelopmentMode();
    private final ObjectMarshaller<C> NULL_HOLDER = new ObjectMarshaller<C>(){

        @Override
        public boolean supports(Object object) {
            return false;
        }

        @Override
        public void marshalObject(Object object, C converter) throws ConverterException {
        }
    };

    public ChainedConverterConfiguration(ConverterConfiguration<C> cfg) {
        this(cfg, (ProxyHandler)new DefaultProxyHandler());
    }

    public ChainedConverterConfiguration(ConverterConfiguration<C> cfg, ProxyHandler proxyHandler) {
        this.marshallerList = cfg.getOrderedObjectMarshallers();
        this.proxyHandler = proxyHandler;
        this.encoding = cfg.getEncoding();
        this.prettyPrint = cfg.isPrettyPrint();
        this.cacheObjectMarshallerByClass = cfg.isCacheObjectMarshallerByClass();
        if (this.cacheObjectMarshallerByClass) {
            this.objectMarshallerForClassCache = new ConcurrentHashMap<Integer, ObjectMarshaller<C>>();
        }
        this.circularReferenceBehaviour = cfg.getCircularReferenceBehaviour();
        ArrayList<ObjectMarshaller<C>> oms = new ArrayList<ObjectMarshaller<C>>(this.marshallerList);
        Collections.reverse(oms);
        ChainedObjectMarshaller prev = null;
        for (ObjectMarshaller objectMarshaller : oms) {
            prev = new ChainedObjectMarshaller(objectMarshaller, prev);
        }
        this.root = prev;
    }

    @Override
    public ObjectMarshaller<C> getMarshaller(Object o) {
        ObjectMarshaller<C> marshaller = null;
        Integer cacheKey = null;
        if (!this.developmentMode && this.cacheObjectMarshallerByClass && o != null && (marshaller = this.objectMarshallerForClassCache.get(cacheKey = Integer.valueOf(System.identityHashCode(o.getClass())))) != this.NULL_HOLDER && marshaller != null && !marshaller.supports(o)) {
            marshaller = null;
        }
        if (marshaller == null) {
            marshaller = this.root.findMarhallerFor(o);
            if (cacheKey != null) {
                this.objectMarshallerForClassCache.put(cacheKey, marshaller != null ? marshaller : this.NULL_HOLDER);
            }
        }
        return marshaller != this.NULL_HOLDER ? marshaller : null;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Converter.CircularReferenceBehaviour getCircularReferenceBehaviour() {
        return this.circularReferenceBehaviour;
    }

    @Override
    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @Override
    public List<ObjectMarshaller<C>> getOrderedObjectMarshallers() {
        return this.marshallerList;
    }

    @Override
    public ProxyHandler getProxyHandler() {
        return this.proxyHandler;
    }

    @Override
    public boolean isCacheObjectMarshallerByClass() {
        return this.cacheObjectMarshallerByClass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChainedObjectMarshaller<C extends Converter>
    implements ObjectMarshaller<C> {
        private ObjectMarshaller<C> om;
        private ChainedObjectMarshaller<C> next;

        public ChainedObjectMarshaller(ObjectMarshaller<C> om, ChainedObjectMarshaller<C> next) {
            this.om = om;
            this.next = next;
        }

        public ObjectMarshaller<C> findMarhallerFor(Object o) {
            if (this.supports(o)) {
                return this.om;
            }
            return this.next != null ? this.next.findMarhallerFor(o) : null;
        }

        @Override
        public boolean supports(Object object) {
            return this.om.supports(object);
        }

        @Override
        public void marshalObject(Object object, C converter) throws ConverterException {
            this.om.marshalObject(object, converter);
        }
    }
}

