/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller.json;

import grails.converters.JSON;
import java.util.Locale;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;
import org.codehaus.groovy.grails.web.json.JSONWriter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationErrorsMarshaller
implements ObjectMarshaller<JSON>,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Override
    public boolean supports(Object object) {
        return object instanceof Errors;
    }

    @Override
    public void marshalObject(Object object, JSON json) throws ConverterException {
        Errors errors = (Errors)object;
        JSONWriter writer = json.getWriter();
        try {
            writer.object();
            writer.key("errors");
            writer.array();
            for (Object o : errors.getAllErrors()) {
                if (!(o instanceof FieldError)) continue;
                FieldError fe = (FieldError)o;
                writer.object();
                json.property("object", fe.getObjectName());
                json.property("field", fe.getField());
                json.property("rejected-value", fe.getRejectedValue());
                Locale locale = LocaleContextHolder.getLocale();
                if (this.applicationContext != null) {
                    json.property("message", this.applicationContext.getMessage((MessageSourceResolvable)fe, locale));
                } else {
                    json.property("message", fe.getDefaultMessage());
                }
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConverterException("Error converting Bean with class " + object.getClass().getName(), e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

