/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.metaclass;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MissingMethodException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.metaclass.AbstractDynamicMethodInvocation;
import org.codehaus.groovy.grails.web.mapping.LinkGenerator;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.RedirectEventListener;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.CannotRedirectException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.Errors;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.support.RequestDataValueProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedirectDynamicMethod
extends AbstractDynamicMethodInvocation {
    public static final String METHOD_SIGNATURE = "redirect";
    public static final Pattern METHOD_PATTERN = Pattern.compile("^redirect$");
    public static final String GRAILS_VIEWS_ENABLE_JSESSIONID = "grails.views.enable.jsessionid";
    public static final String GRAILS_REDIRECT_ISSUED = "org.codehaus.groovy.grails.REDIRECT_ISSUED";
    public static final String ARGUMENT_ERRORS = "errors";
    public static final String ARGUMENT_PERMANENT = "permanent";
    private static final Log LOG = LogFactory.getLog(RedirectDynamicMethod.class);
    private static final String BLANK = "";
    private boolean useJessionId = false;
    private Collection<RedirectEventListener> redirectListeners;
    private LinkGenerator linkGenerator;
    private RequestDataValueProcessor requestDataValueProcessor;

    public RedirectDynamicMethod(Collection<RedirectEventListener> redirectListeners) {
        super(METHOD_PATTERN);
        this.redirectListeners = redirectListeners;
    }

    @Deprecated
    public RedirectDynamicMethod(ApplicationContext applicationContext) {
        super(METHOD_PATTERN);
    }

    public RedirectDynamicMethod() {
        super(METHOD_PATTERN);
    }

    public void setLinkGenerator(LinkGenerator linkGenerator) {
        this.linkGenerator = linkGenerator;
    }

    public void setRedirectListeners(Collection<RedirectEventListener> redirectListeners) {
        this.redirectListeners = redirectListeners;
    }

    public void setUseJessionId(boolean useJessionId) {
        this.useJessionId = useJessionId;
    }

    public Object invoke(Object target, String methodName, Object[] arguments) {
        Map argMap;
        if (arguments.length == 0) {
            throw new MissingMethodException(METHOD_SIGNATURE, target.getClass(), arguments);
        }
        Map map = argMap = arguments[0] instanceof Map ? (Map)arguments[0] : Collections.EMPTY_MAP;
        if (argMap.isEmpty()) {
            throw new MissingMethodException(METHOD_SIGNATURE, target.getClass(), arguments);
        }
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        LinkGenerator requestLinkGenerator = this.getLinkGenerator(webRequest);
        HttpServletRequest request = webRequest.getCurrentRequest();
        if (request.getAttribute(GRAILS_REDIRECT_ISSUED) != null) {
            throw new CannotRedirectException("Cannot issue a redirect(..) here. A previous call to redirect(..) has already redirected the response.");
        }
        HttpServletResponse response = webRequest.getCurrentResponse();
        if (response.isCommitted()) {
            throw new CannotRedirectException("Cannot issue a redirect(..) here. The response has already been committed either by another redirect or by directly writing to the response.");
        }
        GroovyObject controller = (GroovyObject)target;
        Errors controllerErrors = (Errors)controller.getProperty(ARGUMENT_ERRORS);
        Errors errors = (Errors)argMap.get(ARGUMENT_ERRORS);
        if (controllerErrors != null && errors != null) {
            controllerErrors.addAllErrors(errors);
        } else {
            controller.setProperty(ARGUMENT_ERRORS, (Object)errors);
        }
        boolean permanent = DefaultGroovyMethods.asBoolean(argMap.get(ARGUMENT_PERMANENT));
        Object action = argMap.get("action");
        if (action != null) {
            argMap.put("action", this.establishActionName(action, controller));
        }
        argMap.put("contextPath", BLANK);
        return this.redirectResponse(requestLinkGenerator.getServerBaseURL(), requestLinkGenerator.link(argMap), request, response, permanent);
    }

    private LinkGenerator getLinkGenerator(GrailsWebRequest webRequest) {
        ApplicationContext applicationContext;
        if (this.linkGenerator == null && (applicationContext = webRequest.getApplicationContext()) != null) {
            this.linkGenerator = (LinkGenerator)applicationContext.getBean("grailsLinkGenerator", LinkGenerator.class);
        }
        return this.linkGenerator;
    }

    private Object redirectResponse(String serverBaseURL, String actualUri, HttpServletRequest request, HttpServletResponse response, boolean permanent) {
        String processedActualUri;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Dynamic method [redirect] forwarding request to [" + actualUri + "]"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing redirect with response [" + response + "]"));
        }
        String absoluteURL = (processedActualUri = this.processedUrl(actualUri, request)).contains("://") ? processedActualUri : serverBaseURL + processedActualUri;
        String redirectUrl = this.useJessionId ? response.encodeRedirectURL(absoluteURL) : absoluteURL;
        int status = permanent ? 301 : 302;
        response.setStatus(status);
        response.setHeader("Location", redirectUrl);
        if (this.redirectListeners != null) {
            for (RedirectEventListener redirectEventListener : this.redirectListeners) {
                redirectEventListener.responseRedirected(redirectUrl);
            }
        }
        request.setAttribute(GRAILS_REDIRECT_ISSUED, (Object)processedActualUri);
        return null;
    }

    private String establishActionName(Object actionRef, Object target) {
        String actionName = null;
        if (actionRef instanceof String) {
            actionName = (String)actionRef;
        } else if (actionRef instanceof CharSequence) {
            actionName = actionRef.toString();
        } else if (actionRef instanceof Closure) {
            actionName = GrailsClassUtils.findPropertyNameForValue((Object)target, (Object)actionRef);
        }
        return actionName;
    }

    private void initRequestDataValueProcessor() {
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        ApplicationContext applicationContext = webRequest.getApplicationContext();
        if (this.requestDataValueProcessor == null && applicationContext.containsBean("requestDataValueProcessor")) {
            this.requestDataValueProcessor = (RequestDataValueProcessor)applicationContext.getBean("requestDataValueProcessor", RequestDataValueProcessor.class);
        }
    }

    private String processedUrl(String link, HttpServletRequest request) {
        this.initRequestDataValueProcessor();
        if (this.requestDataValueProcessor != null) {
            link = this.requestDataValueProcessor.processUrl(request, link);
        }
        return link;
    }
}

