/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.codecs;

import grails.converters.XML;
import org.codehaus.groovy.grails.plugins.codecs.AbstractCharReplacementEncoder;
import org.codehaus.groovy.grails.support.encoding.CodecIdentifier;
import org.codehaus.groovy.grails.support.encoding.DefaultCodecIdentifier;
import org.springframework.util.ClassUtils;

public class XMLEncoder
extends AbstractCharReplacementEncoder {
    private static final String ESCAPED_APOS = XMLEncoder.xmlEscapeCharacter('\'');
    private static final String ESCAPED_QUOTE = "&quot;";
    private static final String ESCAPED_GT = "&gt;";
    private static final String ESCAPED_LT = "&lt;";
    private static final String ESCAPED_AMP = "&amp;";
    private static final String ESCAPED_BACKSLASH = XMLEncoder.xmlEscapeCharacter('\\');
    private static final char NBSP = '\u00a0';
    private static final String ESCAPED_NON_BREAKING_SPACE = XMLEncoder.xmlEscapeCharacter('\u00a0');
    private static final String ESCAPED_BACKTICK = XMLEncoder.xmlEscapeCharacter('`');
    private static final String ESCAPED_AT = XMLEncoder.xmlEscapeCharacter('@');
    private static final char LINE_SEPARATOR = '\u2028';
    private static final String ESCAPED_LINE_SEPARATOR = XMLEncoder.xmlEscapeCharacter('\u2028');
    private static final char PARAGRAPH_SEPARATOR = '\u2029';
    private static final String ESCAPED_PARAGRAPH_SEPARATOR = XMLEncoder.xmlEscapeCharacter('\u2029');
    public static final CodecIdentifier XML_CODEC_IDENTIFIER = new DefaultCodecIdentifier("XML");

    protected static final String xmlEscapeCharacter(char ch) {
        return "&#" + ch + ";";
    }

    public XMLEncoder() {
        super(XML_CODEC_IDENTIFIER);
    }

    protected XMLEncoder(CodecIdentifier codecIdentifier) {
        super(codecIdentifier);
    }

    @Override
    protected String escapeCharacter(char ch, char previousChar) {
        if (ch < ' ' && ch != '\t' && ch != '\n' && ch != '\r') {
            return "";
        }
        switch (ch) {
            case '&': {
                return ESCAPED_AMP;
            }
            case '<': {
                return ESCAPED_LT;
            }
            case '>': {
                return ESCAPED_GT;
            }
            case '\"': {
                return ESCAPED_QUOTE;
            }
            case '\'': {
                return ESCAPED_APOS;
            }
            case '\\': {
                return ESCAPED_BACKSLASH;
            }
            case '@': {
                return ESCAPED_AT;
            }
            case '`': {
                return ESCAPED_BACKTICK;
            }
            case '\u00a0': {
                return ESCAPED_NON_BREAKING_SPACE;
            }
            case '\u2028': {
                return ESCAPED_LINE_SEPARATOR;
            }
            case '\u2029': {
                return ESCAPED_PARAGRAPH_SEPARATOR;
            }
        }
        return null;
    }

    @Override
    public final Object encode(Object o) {
        return this.doEncode(o);
    }

    protected Object doEncode(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence || o != null && ClassUtils.isPrimitiveOrWrapper(o.getClass())) {
            return this.doCharReplacementEncoding(o);
        }
        return this.encodeToXmlString(o);
    }

    protected Object encodeToXmlString(Object o) {
        return new XML(o).toString();
    }
}

