/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.codecs;

import grails.util.GrailsNameUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsCodecClass;
import org.codehaus.groovy.grails.plugins.codecs.NoneEncoder;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.support.encoding.CodecIdentifierProvider;
import org.codehaus.groovy.grails.support.encoding.CodecLookup;
import org.codehaus.groovy.grails.support.encoding.Decoder;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.OrderComparator;

public class DefaultCodecLookup
implements GrailsApplicationAware,
InitializingBean,
CodecLookup {
    private static final String NONE_CODEC_NAME = "none";
    protected ApplicationContext applicationContext;
    protected GrailsApplication grailsApplication;
    protected Map<String, Encoder> encoders;
    protected Map<String, Decoder> decoders;
    public static final Encoder NONE_ENCODER = NONE_ENCODER = new NoneEncoder();

    public void afterPropertiesSet() throws Exception {
        this.registerCodecs();
    }

    public void reInitialize() {
        this.registerCodecs();
    }

    public Encoder lookupEncoder(String codecName) {
        return this.lookupCodec(codecName, this.encoders, Encoder.class);
    }

    public Decoder lookupDecoder(String codecName) {
        return this.lookupCodec(codecName, this.decoders, Decoder.class);
    }

    private <T> T lookupCodec(String codecName, Map<String, T> map, Class<T> returnType) {
        if (codecName != null && codecName.length() > 0) {
            if (NONE_CODEC_NAME.equalsIgnoreCase(codecName)) {
                if (returnType == Encoder.class) {
                    return (T)NONE_ENCODER;
                }
            } else {
                return map.get(codecName);
            }
        }
        return null;
    }

    protected void registerCodecs() {
        List<GrailsClass> codecs = Arrays.asList(this.grailsApplication.getArtefacts("Codec"));
        Collections.sort(codecs, OrderComparator.INSTANCE);
        Collections.reverse(codecs);
        this.encoders = new HashMap<String, Encoder>();
        this.decoders = new HashMap<String, Decoder>();
        for (GrailsClass grailsClass : codecs) {
            this.registerCodec((GrailsCodecClass)grailsClass);
        }
    }

    private void registerCodec(GrailsCodecClass grailsClass) {
        Decoder decoder;
        grailsClass.configureCodecMethods();
        Encoder encoder = grailsClass.getEncoder();
        if (encoder != null) {
            this.registerWithNameVaritions(this.encoders, encoder);
        }
        if ((decoder = grailsClass.getDecoder()) != null) {
            this.registerWithNameVaritions(this.decoders, decoder);
        }
    }

    private <T extends CodecIdentifierProvider> void registerWithNameVaritions(Map<String, T> destinationMap, T target) {
        String name = target.getCodecIdentifier().getCodecName();
        this.registerVariationsOfName(destinationMap, target, name);
        Set aliases = target.getCodecIdentifier().getCodecAliases();
        if (aliases != null) {
            for (String alias : aliases) {
                this.registerVariationsOfName(destinationMap, target, alias);
            }
        }
    }

    private <T extends CodecIdentifierProvider> void registerVariationsOfName(Map<String, T> destinationMap, T target, String name) {
        destinationMap.put(name, target);
        destinationMap.put(name.toLowerCase(), target);
        destinationMap.put(name.toUpperCase(), target);
        destinationMap.put(GrailsNameUtils.getPropertyNameRepresentation((String)name), target);
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }
}

