/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.codecs;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.plugins.codecs.AbstractCharReplacementEncoder;
import org.codehaus.groovy.grails.support.encoding.CodecIdentifier;
import org.codehaus.groovy.grails.support.encoding.DefaultCodecIdentifier;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.util.HtmlUtils;

public class HTML4Encoder
extends AbstractCharReplacementEncoder {
    private static final Log log = LogFactory.getLog(HTML4Encoder.class);
    static final String HTML4_CODEC_NAME = "HTML4";
    static final CodecIdentifier HTML4_CODEC_IDENTIFIER = new DefaultCodecIdentifier("HTML4");

    public HTML4Encoder() {
        super(HTML4_CODEC_IDENTIFIER);
    }

    protected String escapeCharacter(char ch, char previousChar) {
        return StreamingHTMLEncoderHelper.convertToReference(ch);
    }

    private static final class StreamingHTMLEncoderHelper {
        private static Object instance;
        private static Method mapMethod;
        private static boolean disabled;

        private StreamingHTMLEncoderHelper() {
        }

        public static final String convertToReference(char c) {
            if (!disabled) {
                return (String)ReflectionUtils.invokeMethod((Method)mapMethod, (Object)instance, (Object[])new Object[]{Character.valueOf(c)});
            }
            return HtmlUtils.htmlEscape((String)String.valueOf(c));
        }

        static {
            disabled = false;
            try {
                Field instanceField = ReflectionUtils.findField(HtmlUtils.class, (String)"characterEntityReferences");
                ReflectionUtils.makeAccessible((Field)instanceField);
                instance = instanceField.get(null);
                mapMethod = ReflectionUtils.findMethod(instance.getClass(), (String)"convertToReference", (Class[])new Class[]{Character.TYPE});
                if (mapMethod != null) {
                    ReflectionUtils.makeAccessible((Method)mapMethod);
                }
            }
            catch (Exception e) {
                log.warn((Object)"Couldn't use reflection for resolving characterEntityReferences in HtmlUtils class", (Throwable)e);
                disabled = true;
            }
        }
    }
}

