/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.jdbc.connections;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.grails.datastore.gorm.jdbc.connections.DataSourceSettings;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.core.connections.DefaultConnectionSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.util.ReflectionUtils;

public class DataSourceConnectionSource
extends DefaultConnectionSource<DataSource, DataSourceSettings> {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceConnectionSource.class);

    public DataSourceConnectionSource(String name, DataSource source, DataSourceSettings settings) {
        super(name, (Object)source, (ConnectionSourceSettings)settings);
    }

    public void close() throws IOException {
        super.close();
        if (!this.closed) {
            DataSource source = (DataSource)this.getSource();
            Method closeMethod = ReflectionUtils.findMethod(source.getClass(), (String)"close");
            while (closeMethod == null && source instanceof DelegatingDataSource) {
                source = ((DelegatingDataSource)source).getTargetDataSource();
                closeMethod = ReflectionUtils.findMethod(source.getClass(), (String)"close");
            }
            if (closeMethod != null) {
                try {
                    ReflectionUtils.invokeMethod((Method)closeMethod, (Object)source);
                    this.closed = true;
                }
                catch (Throwable e) {
                    LOG.warn("Error closing JDBC connection [{}]: {}", (Object)this.getName(), (Object)e.getMessage());
                }
            }
        }
    }
}

