/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.finders;

import grails.gorm.DetachedCriteria;
import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.FetchType;
import javax.persistence.criteria.JoinType;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.datastore.gorm.finders.AbstractFinder;
import org.grails.datastore.gorm.finders.DynamicFinderInvocation;
import org.grails.datastore.gorm.finders.MatchSpec;
import org.grails.datastore.gorm.finders.MethodExpression;
import org.grails.datastore.gorm.finders.QueryBuildingFinder;
import org.grails.datastore.gorm.query.criteria.AbstractDetachedCriteria;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.BuildableCriteria;
import org.grails.datastore.mapping.query.api.QueryArgumentsAware;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.grails.datastore.mapping.reflect.NameUtils;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.StringUtils;

public abstract class DynamicFinder
extends AbstractFinder
implements QueryBuildingFinder {
    public static final String ARGUMENT_FETCH_SIZE = "fetchSize";
    public static final String ARGUMENT_TIMEOUT = "timeout";
    public static final String ARGUMENT_READ_ONLY = "readOnly";
    public static final String ARGUMENT_FLUSH_MODE = "flushMode";
    public static final String ARGUMENT_MAX = "max";
    public static final String ARGUMENT_OFFSET = "offset";
    public static final String ARGUMENT_ORDER = "order";
    public static final String ARGUMENT_SORT = "sort";
    public static final String ORDER_DESC = "desc";
    public static final String ORDER_ASC = "asc";
    public static final String ARGUMENT_FETCH = "fetch";
    public static final String ARGUMENT_IGNORE_CASE = "ignoreCase";
    public static final String ARGUMENT_CACHE = "cache";
    public static final String ARGUMENT_LOCK = "lock";
    protected Pattern pattern;
    private static final String OPERATOR_OR = "Or";
    private static final String OPERATOR_AND = "And";
    private static final String[] DEFAULT_OPERATORS = new String[]{"And", "Or"};
    private Pattern[] operatorPatterns;
    private String[] operators;
    private static Pattern methodExpressinPattern;
    private static final Pattern[] defaultOperationPatterns;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static final String NOT = "Not";
    private static final Map<String, Constructor> methodExpressions;
    protected final MappingContext mappingContext;

    protected DynamicFinder(Pattern pattern, String[] operators, Datastore datastore) {
        super(datastore);
        this.mappingContext = datastore.getMappingContext();
        this.pattern = pattern;
        this.operators = operators;
        this.operatorPatterns = new Pattern[operators.length];
        this.populateOperators(operators);
    }

    protected DynamicFinder(Pattern pattern, String[] operators, MappingContext mappingContext) {
        super(null);
        this.mappingContext = mappingContext;
        this.pattern = pattern;
        this.operators = operators;
        this.operatorPatterns = new Pattern[operators.length];
        this.populateOperators(operators);
    }

    public static void registerNewMethodExpression(Class methodExpression) {
        try {
            methodExpressions.put(methodExpression.getSimpleName(), methodExpression.getConstructor(Class.class, String.class));
            DynamicFinder.resetMethodExpressionPattern();
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Class [" + methodExpression + "] does not provide a constructor that takes parameters of type Class and String: " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class [" + methodExpression + "] does not provide a constructor that takes parameters of type Class and String: " + e.getMessage(), e);
        }
    }

    public static MatchSpec buildMatchSpec(String prefix, String methodName, int parameterCount) {
        String methodPattern = "(" + prefix + ")([A-Z]\\w*)";
        Matcher matcher = Pattern.compile(methodPattern).matcher(methodName);
        if (matcher.find()) {
            int totalRequiredArguments = 0;
            ArrayList<MethodExpression> expressions = new ArrayList<MethodExpression>();
            if (matcher.groupCount() == 2) {
                String querySequence = matcher.group(2);
                boolean containsOperator = false;
                for (int i = 0; i < DEFAULT_OPERATORS.length; ++i) {
                    String[] queryParameters;
                    Matcher currentMatcher = defaultOperationPatterns[i].matcher(querySequence);
                    if (!currentMatcher.find()) continue;
                    containsOperator = true;
                    String operatorInUse = DEFAULT_OPERATORS[i];
                    for (String queryParameter : queryParameters = querySequence.split(operatorInUse)) {
                        MethodExpression currentExpression = DynamicFinder.findMethodExpression(queryParameter);
                        totalRequiredArguments += currentExpression.argumentsRequired;
                        expressions.add(currentExpression);
                    }
                    break;
                }
                if (!containsOperator && querySequence != null) {
                    MethodExpression solo = DynamicFinder.findMethodExpression(querySequence);
                    int requiredArguments = solo.getArgumentsRequired();
                    if (requiredArguments > parameterCount) {
                        return null;
                    }
                    totalRequiredArguments += requiredArguments;
                    expressions.add(solo);
                }
                if (totalRequiredArguments > parameterCount) {
                    return null;
                }
                return new MatchSpec(methodName, prefix, querySequence, totalRequiredArguments, expressions);
            }
        }
        return null;
    }

    @Override
    public void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public boolean isMethodMatch(String methodName) {
        return this.pattern.matcher(methodName.subSequence(0, methodName.length())).find();
    }

    @Override
    public Object invoke(Class clazz, String methodName, Closure additionalCriteria, Object[] arguments) {
        DynamicFinderInvocation invocation = this.createFinderInvocation(clazz, methodName, additionalCriteria, arguments);
        return this.doInvokeInternal(invocation);
    }

    public Object invoke(Class clazz, String methodName, DetachedCriteria detachedCriteria, Object[] arguments) {
        DynamicFinderInvocation invocation = this.createFinderInvocation(clazz, methodName, null, arguments);
        if (detachedCriteria != null) {
            invocation.setDetachedCriteria(detachedCriteria);
        }
        return this.doInvokeInternal(invocation);
    }

    public DynamicFinderInvocation createFinderInvocation(Class clazz, String methodName, Closure additionalCriteria, Object[] arguments) {
        String querySequence;
        ArrayList<MethodExpression> expressions = new ArrayList<MethodExpression>();
        if (arguments == null) {
            arguments = EMPTY_OBJECT_ARRAY;
        } else {
            Object[] tmp = new Object[arguments.length];
            System.arraycopy(arguments, 0, tmp, 0, arguments.length);
            arguments = tmp;
        }
        Matcher match = this.pattern.matcher(methodName);
        match.find();
        int totalRequiredArguments = 0;
        int groupCount = match.groupCount();
        if (groupCount == 6) {
            String booleanProperty = match.group(3);
            if (booleanProperty == null) {
                booleanProperty = match.group(6);
                querySequence = null;
            } else {
                querySequence = match.group(5);
            }
            Boolean arg = Boolean.TRUE;
            if (booleanProperty.matches("Not[A-Z].*")) {
                booleanProperty = booleanProperty.substring(3);
                arg = Boolean.FALSE;
            }
            MethodExpression booleanExpression = this.findMethodExpression(clazz, booleanProperty);
            booleanExpression.setArguments(new Object[]{arg});
            expressions.add(booleanExpression);
        } else {
            querySequence = match.group(2);
        }
        boolean containsOperator = false;
        String operatorInUse = null;
        if (querySequence != null) {
            for (int i = 0; i < this.operators.length; ++i) {
                Matcher currentMatcher = this.operatorPatterns[i].matcher(querySequence);
                if (!currentMatcher.find()) continue;
                containsOperator = true;
                operatorInUse = this.operators[i];
                String[] queryParameters = querySequence.split(operatorInUse);
                int argumentCursor = 0;
                for (String queryParameter : queryParameters) {
                    MethodExpression currentExpression = this.findMethodExpression(clazz, queryParameter);
                    int requiredArgs = currentExpression.getArgumentsRequired();
                    Object[] currentArguments = new Object[requiredArgs];
                    if (argumentCursor + requiredArgs > arguments.length) {
                        throw new MissingMethodException(methodName, clazz, arguments);
                    }
                    int k = 0;
                    while (k < requiredArgs) {
                        currentArguments[k] = arguments[argumentCursor];
                        ++k;
                        ++argumentCursor;
                    }
                    currentExpression = this.getInitializedExpression(currentExpression, currentArguments);
                    PersistentEntity persistentEntity = this.mappingContext.getPersistentEntity(clazz.getName());
                    try {
                        currentExpression.convertArguments(persistentEntity);
                    }
                    catch (ConversionException e) {
                        throw new MissingMethodException(methodName, clazz, arguments);
                    }
                    totalRequiredArguments += currentExpression.argumentsRequired;
                    expressions.add(currentExpression);
                }
                break;
            }
        }
        if (!containsOperator && querySequence != null) {
            MethodExpression solo;
            block21: {
                solo = this.findMethodExpression(clazz, querySequence);
                int requiredArguments = solo.getArgumentsRequired();
                if (requiredArguments > arguments.length) {
                    throw new MissingMethodException(methodName, clazz, arguments);
                }
                totalRequiredArguments += requiredArguments;
                Object[] soloArgs = new Object[requiredArguments];
                System.arraycopy(arguments, 0, soloArgs, 0, requiredArguments);
                solo = this.getInitializedExpression(solo, arguments);
                PersistentEntity persistentEntity = this.mappingContext.getPersistentEntity(clazz.getName());
                try {
                    solo.convertArguments(persistentEntity);
                }
                catch (ConversionException e) {
                    if (persistentEntity.getPropertyByName(solo.propertyName) instanceof Basic) break block21;
                    throw new MissingMethodException(methodName, clazz, arguments);
                }
            }
            expressions.add(solo);
        }
        if (totalRequiredArguments > arguments.length) {
            throw new MissingMethodException(methodName, clazz, arguments);
        }
        Object[] remainingArguments = new Object[arguments.length - totalRequiredArguments];
        if (remainingArguments.length > 0) {
            int i = 0;
            int j = totalRequiredArguments;
            while (i < remainingArguments.length) {
                remainingArguments[i] = arguments[j];
                ++i;
                ++j;
            }
        }
        return new DynamicFinderInvocation(clazz, methodName, remainingArguments, expressions, additionalCriteria, operatorInUse);
    }

    @Override
    public Object invoke(Class clazz, String methodName, Object[] arguments) {
        return this.invoke(clazz, methodName, (Closure)null, arguments);
    }

    public static void populateArgumentsForCriteria(BuildableCriteria query, Map argMap) {
        boolean ignoreCase;
        if (argMap == null) {
            return;
        }
        String orderParam = (String)argMap.get(ARGUMENT_ORDER);
        Object fetchObj = argMap.get(ARGUMENT_FETCH);
        if (fetchObj instanceof Map) {
            Map fetch = (Map)fetchObj;
            for (Object o : fetch.keySet()) {
                FetchType fetchType;
                String associationName = (String)o;
                Object fetchValue = fetch.get(associationName);
                if (fetchValue instanceof FetchType) {
                    fetchType = (FetchType)fetchValue;
                    DynamicFinder.handleFetchType(query, associationName, fetchType);
                    continue;
                }
                if (fetchValue instanceof JoinType) {
                    JoinType joinType = (JoinType)fetchValue;
                    query.join(associationName, joinType);
                    continue;
                }
                fetchType = DynamicFinder.getFetchMode(fetchValue);
                DynamicFinder.handleFetchType(query, associationName, fetchType);
            }
        }
        if (argMap.containsKey(ARGUMENT_CACHE)) {
            query.cache(ClassUtils.getBooleanFromMap((String)ARGUMENT_CACHE, (Map)argMap));
        }
        Object sortObject = argMap.get(ARGUMENT_SORT);
        boolean bl = ignoreCase = !argMap.containsKey(ARGUMENT_IGNORE_CASE) || ClassUtils.getBooleanFromMap((String)ARGUMENT_IGNORE_CASE, (Map)argMap);
        if (sortObject != null) {
            if (sortObject instanceof CharSequence) {
                Query.Order order;
                String sort = sortObject.toString();
                Query.Order order2 = order = ORDER_DESC.equalsIgnoreCase(orderParam) ? Query.Order.desc((String)sort) : Query.Order.asc((String)sort);
                if (ignoreCase) {
                    order.ignoreCase();
                }
                query.order(order);
            } else if (sortObject instanceof Map) {
                Map sortMap = (Map)sortObject;
                for (Object key : sortMap.keySet()) {
                    Query.Order order;
                    Object value = sortMap.get(key);
                    String sort = key.toString();
                    Query.Order order3 = order = ORDER_DESC.equalsIgnoreCase(orderParam) ? Query.Order.desc((String)sort) : Query.Order.asc((String)sort);
                    if (ignoreCase) {
                        order.ignoreCase();
                    }
                    query.order(order);
                }
            }
        }
        if (query instanceof QueryArgumentsAware) {
            ((QueryArgumentsAware)query).setArguments(argMap);
        }
    }

    public static void populateArgumentsForCriteria(Class<? extends Object> targetClass, Query query, Map argMap) {
        boolean ignoreCase;
        int offset;
        if (argMap == null) {
            return;
        }
        Integer maxParam = null;
        Integer offsetParam = null;
        ConversionService conversionService = query.getEntity().getMappingContext().getConversionService();
        if (argMap.containsKey(ARGUMENT_MAX)) {
            maxParam = (Integer)conversionService.convert(argMap.get(ARGUMENT_MAX), Integer.class);
        }
        if (argMap.containsKey(ARGUMENT_OFFSET)) {
            offsetParam = (Integer)conversionService.convert(argMap.get(ARGUMENT_OFFSET), Integer.class);
        }
        String orderParam = (String)argMap.get(ARGUMENT_ORDER);
        Object fetchObj = argMap.get(ARGUMENT_FETCH);
        if (fetchObj instanceof Map) {
            Map fetch = (Map)fetchObj;
            for (Object o : fetch.keySet()) {
                FetchType fetchType;
                String associationName = (String)o;
                Object fetchValue = fetch.get(associationName);
                if (fetchValue instanceof FetchType) {
                    fetchType = (FetchType)fetchValue;
                    DynamicFinder.handleFetchType(query, associationName, fetchType);
                    continue;
                }
                if (fetchValue instanceof JoinType) {
                    JoinType joinType = (JoinType)fetchValue;
                    query.join(associationName, joinType);
                    continue;
                }
                fetchType = DynamicFinder.getFetchMode(fetchValue);
                DynamicFinder.handleFetchType(query, associationName, fetchType);
            }
        }
        if (argMap.containsKey(ARGUMENT_CACHE)) {
            query.cache(ClassUtils.getBooleanFromMap((String)ARGUMENT_CACHE, (Map)argMap));
        }
        if (argMap.containsKey(ARGUMENT_LOCK)) {
            query.lock(ClassUtils.getBooleanFromMap((String)ARGUMENT_LOCK, (Map)argMap));
        }
        int max = maxParam == null ? -1 : maxParam;
        int n = offset = offsetParam == null ? -1 : offsetParam;
        if (max > -1) {
            query.max(max);
        }
        if (offset > -1) {
            query.offset(offset);
        }
        Object sortObject = argMap.get(ARGUMENT_SORT);
        boolean bl = ignoreCase = !argMap.containsKey(ARGUMENT_IGNORE_CASE) || ClassUtils.getBooleanFromMap((String)ARGUMENT_IGNORE_CASE, (Map)argMap);
        if (sortObject != null) {
            if (sortObject instanceof CharSequence) {
                String sort = sortObject.toString();
                String order = ORDER_DESC.equalsIgnoreCase(orderParam) ? ORDER_DESC : ORDER_ASC;
                DynamicFinder.addSimpleSort(query, sort, order, ignoreCase);
            } else if (sortObject instanceof Map) {
                Map sortMap = (Map)sortObject;
                DynamicFinder.applySortForMap(query, sortMap, ignoreCase);
            }
        }
        if (query instanceof QueryArgumentsAware) {
            ((QueryArgumentsAware)query).setArguments(argMap);
        }
    }

    public static void applySortForMap(Query query, Map sortMap, boolean ignoreCase) {
        for (Object key : sortMap.keySet()) {
            Object value = sortMap.get(key);
            String sort = key.toString();
            String order = value != null ? value.toString() : ORDER_ASC;
            DynamicFinder.addSimpleSort(query, sort, order, ignoreCase);
        }
    }

    public static FetchType getFetchMode(Object object) {
        String name;
        String string = name = object != null ? object.toString() : "default";
        if (name.equalsIgnoreCase(FetchType.EAGER.toString()) || name.equalsIgnoreCase("join")) {
            return FetchType.EAGER;
        }
        if (name.equalsIgnoreCase(FetchType.LAZY.toString()) || name.equalsIgnoreCase("select")) {
            return FetchType.LAZY;
        }
        return FetchType.LAZY;
    }

    public static void applyDetachedCriteria(Query query, AbstractDetachedCriteria detachedCriteria) {
        if (detachedCriteria != null) {
            Map<String, FetchType> fetchStrategies = detachedCriteria.getFetchStrategies();
            for (Map.Entry<String, FetchType> entry : fetchStrategies.entrySet()) {
                String string = entry.getKey();
                switch (entry.getValue()) {
                    case EAGER: {
                        JoinType joinType = detachedCriteria.getJoinTypes().get(string);
                        if (joinType != null) {
                            query.join(string, joinType);
                            break;
                        }
                        query.join(string);
                        break;
                    }
                    case LAZY: {
                        query.select(string);
                    }
                }
            }
            List<Query.Criterion> criteria = detachedCriteria.getCriteria();
            for (Query.Criterion criterion : criteria) {
                query.add(criterion);
            }
            List<Query.Projection> list = detachedCriteria.getProjections();
            for (Query.Projection projection : list) {
                query.projections().add(projection);
            }
            List<Query.Order> list2 = detachedCriteria.getOrders();
            for (Query.Order order : list2) {
                query.order(order);
            }
        }
    }

    protected abstract Object doInvokeInternal(DynamicFinderInvocation var1);

    private static void handleFetchType(Query q, String associationName, FetchType fetchType) {
        switch (fetchType) {
            case LAZY: {
                q.select(associationName);
                break;
            }
            case EAGER: {
                q.join(associationName);
            }
        }
    }

    protected MethodExpression findMethodExpression(Class clazz, String expression) {
        return DynamicFinder.findMethodExpressionInternal(clazz, expression);
    }

    protected static MethodExpression findMethodExpression(String expression) {
        return DynamicFinder.findMethodExpressionInternal(null, expression);
    }

    private static MethodExpression findMethodExpressionInternal(Class clazz, String expression) {
        MethodExpression me = null;
        Matcher matcher = methodExpressinPattern.matcher(expression);
        Class methodExpressionClass = MethodExpression.Equal.class;
        Constructor methodExpressionConstructor = null;
        String clause = methodExpressionClass.getSimpleName();
        if (matcher.find() && (methodExpressionConstructor = methodExpressions.get(clause = matcher.group(1))) != null) {
            methodExpressionClass = methodExpressionConstructor.getDeclaringClass();
        }
        String propertyName = DynamicFinder.calcPropertyName(expression, methodExpressionClass.getSimpleName());
        boolean negation = false;
        if (propertyName.endsWith(NOT)) {
            int i = propertyName.lastIndexOf(NOT);
            propertyName = propertyName.substring(0, i);
            negation = true;
        }
        if (!StringUtils.hasLength((String)propertyName)) {
            throw new IllegalArgumentException("No property name specified in clause: " + clause);
        }
        propertyName = NameUtils.decapitalizeFirstChar((String)propertyName);
        if (methodExpressionConstructor != null) {
            try {
                me = (MethodExpression)methodExpressionConstructor.newInstance(clazz, propertyName);
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        if (me == null) {
            me = new MethodExpression.Equal(clazz, propertyName);
        }
        if (negation) {
            final MethodExpression.Equal finalMe = me;
            return new MethodExpression(clazz, propertyName){

                @Override
                public Query.Criterion createCriterion() {
                    return new Query.Negation().add(finalMe.createCriterion());
                }

                @Override
                public void setArguments(Object[] arguments) {
                    finalMe.setArguments(arguments);
                }

                @Override
                public int getArgumentsRequired() {
                    return finalMe.getArgumentsRequired();
                }

                @Override
                public Object[] getArguments() {
                    return finalMe.getArguments();
                }
            };
        }
        return me;
    }

    private static void handleFetchType(BuildableCriteria q, String associationName, FetchType fetchType) {
        switch (fetchType) {
            case LAZY: {
                q.select(associationName);
                break;
            }
            case EAGER: {
                q.join(associationName);
            }
        }
    }

    private static void resetMethodExpressionPattern() {
        String expressionPattern = DefaultGroovyMethods.join(methodExpressions.keySet(), (String)"|");
        methodExpressinPattern = Pattern.compile("\\p{Upper}[\\p{Lower}\\d]+(" + expressionPattern + ")");
    }

    private static void addSimpleSort(Query q, String sort, String order, boolean ignoreCase) {
        Query.Order o = ORDER_DESC.equalsIgnoreCase(order) ? Query.Order.desc((String)sort) : Query.Order.asc((String)sort);
        if (ignoreCase) {
            o = o.ignoreCase();
        }
        q.order(o);
    }

    private void populateOperators(String[] operators) {
        for (int i = 0; i < operators.length; ++i) {
            this.operatorPatterns[i] = Pattern.compile("(\\w+)(" + operators[i] + ")(\\p{Upper})(\\w+)");
        }
    }

    protected void configureQueryWithArguments(Class clazz, Query query, Object[] arguments) {
        if (arguments.length == 0 || !(arguments[0] instanceof Map)) {
            DynamicFinder.populateArgumentsForCriteria(clazz, query, Collections.emptyMap());
            return;
        }
        Map argMap = (Map)arguments[0];
        DynamicFinder.populateArgumentsForCriteria(clazz, query, argMap);
    }

    private static String calcPropertyName(String queryParameter, String clause) {
        String propName;
        if (clause != null && !clause.equals(MethodExpression.Equal.class.getSimpleName())) {
            int i = queryParameter.indexOf(clause);
            propName = queryParameter.substring(0, i);
        } else {
            propName = queryParameter;
        }
        return propName;
    }

    private MethodExpression getInitializedExpression(MethodExpression expression, Object[] arguments) {
        expression.setArguments(arguments);
        return expression;
    }

    static {
        EMPTY_OBJECT_ARRAY = new Object[0];
        methodExpressions = new LinkedHashMap<String, Constructor>();
        defaultOperationPatterns = new Pattern[2];
        for (int i = 0; i < DEFAULT_OPERATORS.length; ++i) {
            String defaultOperator = DEFAULT_OPERATORS[i];
            DynamicFinder.defaultOperationPatterns[i] = Pattern.compile("(\\w+)(" + defaultOperator + ")(\\p{Upper})(\\w+)");
        }
        try {
            Class[] classes = new Class[]{MethodExpression.Equal.class, MethodExpression.NotEqual.class, MethodExpression.NotInList.class, MethodExpression.InList.class, MethodExpression.InRange.class, MethodExpression.Between.class, MethodExpression.Like.class, MethodExpression.Ilike.class, MethodExpression.Rlike.class, MethodExpression.GreaterThanEquals.class, MethodExpression.LessThanEquals.class, MethodExpression.GreaterThan.class, MethodExpression.LessThan.class, MethodExpression.IsNull.class, MethodExpression.IsNotNull.class, MethodExpression.IsEmpty.class, MethodExpression.IsEmpty.class, MethodExpression.IsNotEmpty.class};
            Class[] constructorParamTypes = new Class[]{Class.class, String.class};
            for (Class c : classes) {
                methodExpressions.put(c.getSimpleName(), c.getConstructor(constructorParamTypes));
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        DynamicFinder.resetMethodExpressionPattern();
    }
}

