/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm;

import grails.gorm.MultiTenant;
import grails.gorm.multitenancy.Tenants;
import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaMethod;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.metaclass.MethodSelectionException;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.AbstractGormApi;
import org.grails.datastore.gorm.GormInstanceApi;
import org.grails.datastore.gorm.GormStaticApi;
import org.grails.datastore.gorm.GormValidationApi;
import org.grails.datastore.gorm.finders.CountByFinder;
import org.grails.datastore.gorm.finders.FindAllByBooleanFinder;
import org.grails.datastore.gorm.finders.FindAllByFinder;
import org.grails.datastore.gorm.finders.FindByBooleanFinder;
import org.grails.datastore.gorm.finders.FindByFinder;
import org.grails.datastore.gorm.finders.FindOrCreateByFinder;
import org.grails.datastore.gorm.finders.FindOrSaveByFinder;
import org.grails.datastore.gorm.finders.FinderMethod;
import org.grails.datastore.gorm.finders.ListOrderByFinder;
import org.grails.datastore.gorm.internal.InstanceMethodInvokingClosure;
import org.grails.datastore.gorm.internal.StaticMethodInvokingClosure;
import org.grails.datastore.gorm.query.GormQueryOperations;
import org.grails.datastore.gorm.query.NamedCriteriaProxy;
import org.grails.datastore.gorm.query.NamedQueriesBuilder;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesProvider;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesSupport;
import org.grails.datastore.mapping.core.connections.MultipleConnectionSourceCapableDatastore;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.config.GormProperties;
import org.grails.datastore.mapping.multitenancy.MultiTenancySettings;
import org.grails.datastore.mapping.multitenancy.MultiTenantCapableDatastore;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.grails.datastore.mapping.reflect.MetaClassUtils;
import org.grails.datastore.mapping.reflect.NameUtils;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionSystemException;

public class GormEnhancer
implements Closeable,
GroovyObject {
    private static final Map<String, Map<String, Closure>> NAMED_QUERIES;
    private static final Map<String, Map<String, GormStaticApi>> STATIC_APIS;
    private static final Map<String, Map<String, GormInstanceApi>> INSTANCE_APIS;
    private static final Map<String, Map<String, GormValidationApi>> VALIDATION_APIS;
    private static final Map<String, Map<String, Datastore>> DATASTORES;
    private static final Map<Class, Datastore> DATASTORES_BY_TYPE;
    private final Datastore datastore;
    private PlatformTransactionManager transactionManager;
    private List<FinderMethod> finders;
    private boolean failOnError;
    private boolean markDirty;
    private boolean includeExternal;
    private final boolean dynamicEnhance;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public GormEnhancer(Datastore datastore) {
        this(datastore, null);
    }

    public GormEnhancer(Datastore datastore, PlatformTransactionManager transactionManager, boolean failOnError, boolean dynamicEnhance, boolean markDirty) {
        this(datastore, transactionManager, new ConnectionSourceSettings().failOnError(failOnError).markDirty(Boolean.valueOf(markDirty)));
    }

    public GormEnhancer(Datastore datastore, PlatformTransactionManager transactionManager, ConnectionSourceSettings settings) {
        boolean bl;
        PlatformTransactionManager platformTransactionManager;
        boolean bl2;
        Datastore datastore2;
        MetaClass metaClass;
        boolean bl3;
        this.includeExternal = bl3 = true;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.datastore = datastore2 = datastore;
        this.failOnError = bl2 = settings.isFailOnError();
        Boolean markDirty = settings.getMarkDirty();
        Boolean bl4 = markDirty == null ? Boolean.valueOf(true) : markDirty;
        this.markDirty = DefaultTypeTransformation.booleanUnbox((Object)bl4);
        this.transactionManager = platformTransactionManager = transactionManager;
        this.dynamicEnhance = bl = false;
        if (datastore != null) {
            this.registerConstraints(datastore);
        }
        NAMED_QUERIES.clear();
        DATASTORES_BY_TYPE.put(datastore.getClass(), datastore);
        Object entity2 = null;
        for (Object entity2 : datastore.getMappingContext().getPersistentEntities()) {
            this.registerEntity((PersistentEntity)ScriptBytecodeAdapter.castToType(entity2, PersistentEntity.class));
        }
    }

    @Generated
    public GormEnhancer(Datastore datastore, PlatformTransactionManager transactionManager, boolean failOnError, boolean dynamicEnhance) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        this(datastore, transactionManager, failOnError, dynamicEnhance, true);
    }

    @Generated
    public GormEnhancer(Datastore datastore, PlatformTransactionManager transactionManager, boolean failOnError) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        this(datastore, transactionManager, failOnError, false, true);
    }

    @Generated
    public GormEnhancer(Datastore datastore, PlatformTransactionManager transactionManager) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        this(datastore, transactionManager, false, false, true);
    }

    public void registerEntity(PersistentEntity entity) {
        Datastore datastore = this.datastore;
        if (this.appliesToDatastore(datastore, entity)) {
            Class cls = entity.getJavaClass();
            List<String> qualifiers = this.allQualifiers(this.datastore, entity);
            if (!qualifiers.contains(ConnectionSource.DEFAULT)) {
                String firstQualifier = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.first(qualifiers));
                GormStaticApi staticApi = this.getStaticApi(cls, firstQualifier);
                String name = entity.getName();
                STATIC_APIS.get(ConnectionSource.DEFAULT).put(name, staticApi);
                GormInstanceApi instanceApi = this.getInstanceApi(cls, firstQualifier);
                INSTANCE_APIS.get(ConnectionSource.DEFAULT).put(name, instanceApi);
                GormValidationApi validationApi = this.getValidationApi(cls, firstQualifier);
                VALIDATION_APIS.get(ConnectionSource.DEFAULT).put(name, validationApi);
                DATASTORES.get(ConnectionSource.DEFAULT).put(name, this.datastore);
            }
            String qualifier2 = null;
            for (String qualifier2 : qualifiers) {
                GormStaticApi staticApi = this.getStaticApi(cls, ShortTypeHandling.castToString((Object)qualifier2));
                String name = entity.getName();
                STATIC_APIS.get(qualifier2).put(name, staticApi);
                GormInstanceApi instanceApi = this.getInstanceApi(cls, ShortTypeHandling.castToString((Object)qualifier2));
                INSTANCE_APIS.get(qualifier2).put(name, instanceApi);
                GormValidationApi validationApi = this.getValidationApi(cls, ShortTypeHandling.castToString((Object)qualifier2));
                VALIDATION_APIS.get(qualifier2).put(name, validationApi);
                DATASTORES.get(qualifier2).put(name, this.datastore);
            }
        }
    }

    public List<String> allQualifiers(Datastore datastore, PersistentEntity entity) {
        ArrayList<String> qualifiers = new ArrayList<String>();
        qualifiers.addAll(ConnectionSourcesSupport.getConnectionSourceNames((PersistentEntity)entity));
        if ((MultiTenant.class.isAssignableFrom(entity.getJavaClass()) || qualifiers.contains(ConnectionSource.ALL)) && datastore instanceof ConnectionSourcesProvider) {
            qualifiers.clear();
            qualifiers.add(ConnectionSource.DEFAULT);
            Iterable allConnectionSources = ((ConnectionSourcesProvider)ScriptBytecodeAdapter.castToType((Object)datastore, ConnectionSourcesProvider.class)).getConnectionSources().getAllConnectionSources();
            public final class _allQualifiers_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _allQualifiers_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Boolean doCall(ConnectionSource connectionSource) {
                    return ScriptBytecodeAdapter.compareNotEqual((Object)connectionSource.getName(), (Object)ConnectionSource.DEFAULT);
                }

                @Generated
                public Boolean call(ConnectionSource connectionSource) {
                    return this.doCall(connectionSource);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _allQualifiers_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            public final class _allQualifiers_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _allQualifiers_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public String doCall(Object it) {
                    return ((ConnectionSource)ScriptBytecodeAdapter.castToType((Object)it, ConnectionSource.class)).getName();
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public String doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _allQualifiers_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List allConnectionSourceNames = DefaultGroovyMethods.collect((Iterable)DefaultGroovyMethods.findAll((Object)allConnectionSources, (Closure)new _allQualifiers_closure1(this, this)), (Closure)new _allQualifiers_closure2(this, this));
            qualifiers.addAll(allConnectionSourceNames);
        }
        return qualifiers;
    }

    @Deprecated
    public static GormQueryOperations findNamedQuery(Class entity, String queryName) {
        return GormEnhancer.createNamedQuery(entity, queryName);
    }

    public static GormQueryOperations createNamedQuery(Class entity, String queryName) {
        return GormEnhancer.createNamedQuery(entity, queryName, new Object[]{null});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GormQueryOperations createNamedQuery(Class entity, String queryName, Object ... args) {
        className = entity.getName();
        namedQueries = (Map<String, Closure>)ScriptBytecodeAdapter.castToType(GormEnhancer.NAMED_QUERIES.get(className), Map.class);
        if (namedQueries == null == false) return GormEnhancer.buildNamedCriteriaProxy(entity, namedQueries, queryName, args);
        var5_5 = GormEnhancer.NAMED_QUERIES;
        synchronized (var5_5) {
            block4: {
                var6_6 = GormEnhancer.NAMED_QUERIES.get(className);
                namedQueries = (Map)ScriptBytecodeAdapter.castToType(var6_6, Map.class);
                if (namedQueries == null == false) return GormEnhancer.buildNamedCriteriaProxy(entity, namedQueries, queryName, args);
                cpf = ClassPropertyFetcher.forClass((Class)entity);
                closure = (Closure)ScriptBytecodeAdapter.castToType((Object)cpf.getStaticPropertyValue(GormProperties.NAMED_QUERIES, Closure.class), Closure.class);
                if (!(closure != null)) break block4;
                closure = var9_9 = (Closure)ScriptBytecodeAdapter.castToType((Object)closure.clone(), Closure.class);
                evaluator = new NamedQueriesBuilder();
                namedQueries = var11_11 = evaluator.evaluate(closure);
                GormEnhancer.NAMED_QUERIES.put(className, namedQueries);
                ** GOTO lbl34
            }
            GormEnhancer.NAMED_QUERIES.put(className, Collections.emptyMap());
            return (GormQueryOperations)ScriptBytecodeAdapter.castToType(null, GormQueryOperations.class);
lbl34:
            // 1 sources

            return GormEnhancer.buildNamedCriteriaProxy(entity, namedQueries, queryName, args);
        }
    }

    private static NamedCriteriaProxy buildNamedCriteriaProxy(Class entity, Map<String, Closure> namedQueries, String queryName, Object ... args) {
        NamedCriteriaProxy namedCriteriaProxy = null;
        GormStaticApi staticApi = GormEnhancer.findStaticApi(entity);
        Closure namedQueryClosure = (Closure)ScriptBytecodeAdapter.castToType((Object)namedQueries.get(queryName), Closure.class);
        if (namedQueryClosure != null) {
            NamedCriteriaProxy namedCriteriaProxy2;
            namedCriteriaProxy = namedCriteriaProxy2 = new NamedCriteriaProxy((Closure)ScriptBytecodeAdapter.castToType((Object)namedQueryClosure.clone(), Closure.class), staticApi.getGormPersistentEntity(), staticApi.getGormDynamicFinders());
            if (args != null) {
                namedCriteriaProxy.call(args);
            }
        }
        return namedCriteriaProxy;
    }

    protected static String findTenantId(Class entity) {
        Object v0;
        if (MultiTenant.class.isAssignableFrom(entity)) {
            Datastore defaultDatastore = GormEnhancer.findDatastore(entity, ConnectionSource.DEFAULT);
            if (defaultDatastore instanceof MultiTenantCapableDatastore) {
                MultiTenantCapableDatastore multiTenantCapableDatastore = (MultiTenantCapableDatastore)ScriptBytecodeAdapter.castToType((Object)defaultDatastore, MultiTenantCapableDatastore.class);
                if (ScriptBytecodeAdapter.compareEqual((Object)multiTenantCapableDatastore.getMultiTenancyMode(), (Object)MultiTenancySettings.MultiTenancyMode.DATABASE)) {
                    return ShortTypeHandling.castToString((Object)Tenants.currentId(multiTenantCapableDatastore));
                }
                return ConnectionSource.DEFAULT;
            }
            log.debug("Return default tenant id for non-multitenant capable datastore");
            return ConnectionSource.DEFAULT;
        }
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{entity}, new String[]{"Returning default tenant id for non-multitenant class [", "]"})));
            v0 = null;
        } else {
            v0 = null;
        }
        return ConnectionSource.DEFAULT;
    }

    public static <D> GormStaticApi<D> findStaticApi(Class<D> entity, String qualifier) {
        String className = NameUtils.getClassName(entity);
        Map<String, GormStaticApi> map = STATIC_APIS.get(qualifier);
        GormStaticApi staticApi = (GormStaticApi)ScriptBytecodeAdapter.castToType(map != null ? map.get(className) : null, GormStaticApi.class);
        if (staticApi == null) {
            throw (Throwable)GormEnhancer.stateException(entity);
        }
        return staticApi;
    }

    public static <D> GormInstanceApi<D> findInstanceApi(Class<D> entity, String qualifier) {
        Map<String, GormInstanceApi> map = INSTANCE_APIS.get(qualifier);
        GormInstanceApi instanceApi = (GormInstanceApi)ScriptBytecodeAdapter.castToType(map != null ? map.get(NameUtils.getClassName(entity)) : null, GormInstanceApi.class);
        if (instanceApi == null) {
            throw (Throwable)GormEnhancer.stateException(entity);
        }
        return instanceApi;
    }

    public static <D> GormValidationApi<D> findValidationApi(Class<D> entity, String qualifier) {
        Map<String, GormValidationApi> map = VALIDATION_APIS.get(qualifier);
        GormValidationApi instanceApi = (GormValidationApi)ScriptBytecodeAdapter.castToType(map != null ? map.get(NameUtils.getClassName(entity)) : null, GormValidationApi.class);
        if (instanceApi == null) {
            throw (Throwable)GormEnhancer.stateException(entity);
        }
        return instanceApi;
    }

    public static Datastore findDatastore(Class entity, String qualifier) {
        Map<String, Datastore> map = DATASTORES.get(qualifier);
        Datastore datastore = (Datastore)ScriptBytecodeAdapter.castToType(map != null ? map.get(entity.getName()) : null, Datastore.class);
        if (datastore == null) {
            throw (Throwable)GormEnhancer.stateException(entity);
        }
        return datastore;
    }

    public static Datastore findDatastoreByType(Class<? extends Datastore> datastoreType) {
        Datastore datastore = (Datastore)ScriptBytecodeAdapter.castToType((Object)DATASTORES_BY_TYPE.get(datastoreType), Datastore.class);
        if (datastore == null) {
            throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{datastoreType}, new String[]{"No GORM implementation configured for type [", "]. Ensure GORM has been initialized correctly"})));
        }
        return datastore;
    }

    public static Datastore findSingleDatastore() {
        Collection<Datastore> allDatastores = DATASTORES_BY_TYPE.values();
        if (allDatastores.isEmpty()) {
            throw (Throwable)new IllegalStateException("No GORM implementations configured. Ensure GORM has been initialized correctly");
        }
        if (allDatastores.size() > 1) {
            throw (Throwable)new IllegalStateException("More than one GORM implementation is configured. Specific the datastore type!");
        }
        return (Datastore)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.first(allDatastores), Datastore.class);
    }

    public static PlatformTransactionManager findSingleTransactionManager(String connectionName) {
        Datastore datastore = GormEnhancer.findSingleDatastore();
        return GormEnhancer.getTransactionManagerForConnection(datastore, connectionName);
    }

    public static PlatformTransactionManager findTransactionManager(Class<? extends Datastore> datastoreType, String connectionName) {
        Datastore datastore = GormEnhancer.findDatastoreByType(datastoreType);
        return GormEnhancer.getTransactionManagerForConnection(datastore, connectionName);
    }

    public static PersistentEntity findEntity(Class entity, String qualifier) {
        return GormEnhancer.findDatastore(entity, qualifier).getMappingContext().getPersistentEntity(entity.getName());
    }

    @Override
    public void close() throws IOException {
        this.removeConstraints();
        DATASTORES_BY_TYPE.clear();
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        Object entity2 = null;
        for (Object entity2 : this.datastore.getMappingContext().getPersistentEntities()) {
            List<String> qualifiers = this.allQualifiers(this.datastore, (PersistentEntity)ScriptBytecodeAdapter.castToType(entity2, PersistentEntity.class));
            Class cls = ((PersistentEntity)entity2).getJavaClass();
            String className = cls.getName();
            String q2 = null;
            for (String q2 : qualifiers) {
                NAMED_QUERIES.remove(className);
                Map<String, GormStaticApi> map = STATIC_APIS.get(q2);
                GormStaticApi gormStaticApi = map != null ? map.remove(className) : null;
                Map<String, GormInstanceApi> map2 = INSTANCE_APIS.get(q2);
                GormInstanceApi gormInstanceApi = map2 != null ? map2.remove(className) : null;
                Map<String, GormValidationApi> map3 = VALIDATION_APIS.get(q2);
                GormValidationApi gormValidationApi = map3 != null ? map3.remove(className) : null;
                Map<String, Datastore> map4 = DATASTORES.get(q2);
                Datastore datastore = map4 != null ? map4.remove(this.datastore) : null;
            }
            registry.removeMetaClass(cls);
        }
    }

    private static PlatformTransactionManager getTransactionManagerForConnection(Datastore datastore, String connectionName) {
        if (datastore instanceof TransactionCapableDatastore && ConnectionSource.DEFAULT.equals(connectionName)) {
            return ((TransactionCapableDatastore)ScriptBytecodeAdapter.castToType((Object)datastore, TransactionCapableDatastore.class)).getTransactionManager();
        }
        if (datastore instanceof MultipleConnectionSourceCapableDatastore) {
            Datastore datastoreForConnection = ((MultipleConnectionSourceCapableDatastore)ScriptBytecodeAdapter.castToType((Object)datastore, MultipleConnectionSourceCapableDatastore.class)).getDatastoreForConnection(connectionName);
            if (datastoreForConnection instanceof TransactionCapableDatastore) {
                return ((TransactionCapableDatastore)ScriptBytecodeAdapter.castToType((Object)datastoreForConnection, TransactionCapableDatastore.class)).getTransactionManager();
            }
        }
        throw (Throwable)new TransactionSystemException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{datastore.getClass().getName()}, new String[]{"Datastore implementation ", " does not support transactions!"})));
    }

    private static IllegalStateException stateException(Class entity) {
        return new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{entity.getName()}, new String[]{"Either class [", "] is not a domain class or GORM has not been initialized correctly or has already been shutdown. Ensure GORM is loaded and configured correctly before calling any methods on a GORM entity."})));
    }

    protected void removeConstraints() {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        try {
            String className = "org.codehaus.groovy.grails.validation.ConstrainedProperty";
            ClassLoader classLoader = (ClassLoader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callCurrent((GroovyObject)this)), ClassLoader.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call(ClassUtils.class, (Object)className, (Object)classLoader))) {
                callSiteArray[3].call(callSiteArray[4].call((Object)classLoader, (Object)className), (Object)"unique");
            }
        }
        catch (Throwable e) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call((Object)log)) ? callSiteArray[6].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[7].callGetProperty((Object)e)}, new String[]{"Not running in Grails 2 environment, cannot de-register constraints. This exception can be safely ignored if you are not using Grails 2. ", ""}), (Object)e) : null;
        }
    }

    protected void registerConstraints(Datastore datastore) {
        block6: {
            try {
                String className = "org.grails.datastore.gorm.support.ConstraintRegistrar";
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (ClassUtils.isPresent((String)className, (ClassLoader)classLoader)) {
                    DefaultGroovyMethods.newInstance(classLoader.loadClass(className), (Object[])new Object[]{datastore});
                }
            }
            catch (Throwable e) {
                Object v0;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Unable to register GORM constraints. Not running a Grails environment. This can be safely ignored if you are not running Grails: ", ""})), e);
                    v0 = null;
                    break block6;
                }
                v0 = null;
            }
        }
    }

    public List<FinderMethod> getFinders() {
        if (this.finders == null) {
            List<FinderMethod> list = Collections.unmodifiableList(this.createDynamicFinders());
            this.finders = list;
        }
        return this.finders;
    }

    public void enhance(boolean onlyExtendedMethods) {
        if (this.dynamicEnhance) {
            PersistentEntity e = null;
            Iterator iterator = this.datastore.getMappingContext().getPersistentEntities().iterator();
            while (iterator.hasNext()) {
                e = (PersistentEntity)ScriptBytecodeAdapter.castToType(iterator.next(), PersistentEntity.class);
                if (e.isExternal() && !this.includeExternal) continue;
                this.enhance(e, onlyExtendedMethods);
            }
        }
    }

    public void enhance(PersistentEntity e, boolean onlyExtendedMethods) {
        this.registerEntity(e);
        if (!GroovyObject.class.isAssignableFrom(e.getJavaClass()) || this.dynamicEnhance) {
            this.addInstanceMethods(e, onlyExtendedMethods);
            this.addStaticMethods(e, onlyExtendedMethods);
        }
    }

    protected void addStaticMethods(PersistentEntity e, boolean onlyExtendedMethods) {
        Class cls = e.getJavaClass();
        ExpandoMetaClass mc = MetaClassUtils.getExpandoMetaClass((Class)cls);
        GormStaticApi staticApiProvider = this.getStaticApi(cls);
        Method m = null;
        Iterator<Method> iterator = (onlyExtendedMethods ? staticApiProvider.getExtendedMethods() : staticApiProvider.getMethods()).iterator();
        while (iterator.hasNext()) {
            Method method = m = (Method)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Method.class);
            if (!(method != null)) continue;
            String methodName = method.getName();
            Class[] parameterTypes = method.getParameterTypes();
            if (!(parameterTypes != null)) continue;
            boolean realMethodExists = GormEnhancer.doesRealMethodExist((MetaClass)mc, methodName, parameterTypes, true);
            if (!(!realMethodExists)) continue;
            this.registerStaticMethod(mc, methodName, parameterTypes, staticApiProvider);
        }
    }

    protected void registerStaticMethod(ExpandoMetaClass mc, String methodName, Class<?>[] parameterTypes, GormStaticApi staticApiProvider) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        Object callable = callSiteArray[8].callConstructor(StaticMethodInvokingClosure.class, (Object)staticApiProvider, (Object)methodName, parameterTypes);
        Object object = callable;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[9].callGroovyObjectGetProperty((Object)mc), (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{methodName}, new String[]{"", ""})));
    }

    protected boolean appliesToDatastore(Datastore datastore, PersistentEntity entity) {
        return !entity.isExternal();
    }

    protected <D> List<AbstractGormApi<D>> getInstanceMethodApiProviders(Class<D> cls) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[10].callCurrent((GroovyObject)this, cls), callSiteArray[11].callCurrent((GroovyObject)this, cls)});
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{this.getInstanceApi(cls), this.getValidationApi(cls)});
    }

    protected void addInstanceMethods(PersistentEntity e, boolean onlyExtendedMethods) {
        Class cls = e.getJavaClass();
        ExpandoMetaClass mc = MetaClassUtils.getExpandoMetaClass((Class)cls);
        AbstractGormApi apiProvider = null;
        Iterator iterator = this.getInstanceMethodApiProviders(cls).iterator();
        while (iterator.hasNext()) {
            apiProvider = (AbstractGormApi)ScriptBytecodeAdapter.castToType(iterator.next(), AbstractGormApi.class);
            Method method = null;
            Iterator<Method> iterator2 = (onlyExtendedMethods ? apiProvider.getExtendedMethods() : apiProvider.getMethods()).iterator();
            while (iterator2.hasNext()) {
                method = (Method)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), Method.class);
                String methodName = method.getName();
                Class[] parameterTypes = method.getParameterTypes();
                if (!DefaultTypeTransformation.booleanUnbox(parameterTypes)) continue;
                List list = parameterTypes.length == 1 ? ScriptBytecodeAdapter.createList((Object[])new Object[0]) : DefaultGroovyMethods.getAt((Object[])((Object[])ScriptBytecodeAdapter.castToType(parameterTypes, Object[].class)), (IntRange)new IntRange(true, 1, Integer.valueOf(-1).intValue()));
                parameterTypes = (Class[])ScriptBytecodeAdapter.castToType((Object)list, Class[].class);
                boolean realMethodExists = GormEnhancer.doesRealMethodExist((MetaClass)mc, methodName, parameterTypes, false);
                if (!(!realMethodExists)) continue;
                this.registerInstanceMethod(cls, mc, apiProvider, methodName, parameterTypes);
            }
        }
    }

    protected Object registerInstanceMethod(Class cls, ExpandoMetaClass mc, AbstractGormApi apiProvider, String methodName, Class ... parameterTypes) {
        InstanceMethodInvokingClosure tooCall = new InstanceMethodInvokingClosure((Object)apiProvider, cls, methodName, parameterTypes);
        Class[] pt = parameterTypes;
        GroovyObject closureMethod = new GroovyObject(this, methodName, cls, (Object)tooCall, pt){
            final /* synthetic */ GormEnhancer this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                GormEnhancer gormEnhancer;
                this.this$0 = gormEnhancer = p0;
                super(ShortTypeHandling.castToString((Object)p10), ShortTypeHandling.castToClass((Object)p11), (Closure)ScriptBytecodeAdapter.castToType((Object)p12, Closure.class), (Class[])ScriptBytecodeAdapter.castToType((Object)p13, Class[].class));
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public int getModifiers() {
                return Modifier.PUBLIC;
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, GormEnhancer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                this.this$0.this$dist$set$1(name, value);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GormEnhancer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, GormEnhancer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }
        };
        mc.registerInstanceMethod((MetaMethod)closureMethod);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean doesRealMethodExist(MetaClass mc, String methodName, Class[] parameterTypes, boolean staticScope) {
        void var2_2;
        Reference methodName2 = new Reference((Object)methodName);
        Reference parameterTypes2 = new Reference((Object)var2_2);
        Reference staticScope2 = new Reference((Object)staticScope);
        boolean realMethodExists = false;
        try {
            MetaMethod existingMethod = mc.pickMethod((String)methodName2.get(), (Class[])parameterTypes2.get());
            if (DefaultTypeTransformation.booleanUnbox((Object)existingMethod) && ScriptBytecodeAdapter.compareEqual((Object)existingMethod.isStatic(), (Object)DefaultTypeTransformation.booleanUnbox((Object)staticScope2.get())) && GormEnhancer.isRealMethod(existingMethod) && ((Class[])parameterTypes2.get()).length == existingMethod.getParameterTypes().length) {
                boolean bl;
                realMethodExists = bl = true;
            }
        }
        catch (MethodSelectionException mse) {
            boolean bl;
            public final class _doesRealMethodExist_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference methodName;
                private /* synthetic */ Reference staticScope;
                private /* synthetic */ Reference parameterTypes;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _doesRealMethodExist_closure3(Object _outerInstance, Object _thisObject, Reference methodName, Reference staticScope, Reference parameterTypes) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.methodName = reference3 = methodName;
                    this.staticScope = reference2 = staticScope;
                    this.parameterTypes = reference = parameterTypes;
                }

                public Boolean doCall(MetaMethod existingMethod) {
                    return ScriptBytecodeAdapter.compareEqual((Object)existingMethod.getName(), (Object)this.methodName.get()) && ScriptBytecodeAdapter.compareEqual((Object)existingMethod.isStatic(), (Object)this.staticScope.get()) && DefaultTypeTransformation.booleanUnbox((Object)InvokerHelper.invokeStaticMethod(GormEnhancer.class, (String)"isRealMethod", (Object)new Object[]{existingMethod})) && (!DefaultTypeTransformation.booleanUnbox((Object)this.parameterTypes.get()) && !DefaultTypeTransformation.booleanUnbox((Object)existingMethod.getParameterTypes()) || ScriptBytecodeAdapter.compareEqual((Object)this.parameterTypes.get(), (Object)existingMethod.getParameterTypes()));
                }

                @Generated
                public Boolean call(MetaMethod existingMethod) {
                    return this.doCall(existingMethod);
                }

                @Generated
                public String getMethodName() {
                    return ShortTypeHandling.castToString((Object)this.methodName.get());
                }

                @Generated
                public boolean getStaticScope() {
                    return DefaultTypeTransformation.booleanUnbox((Object)this.staticScope.get());
                }

                @Generated
                public Class[] getParameterTypes() {
                    return (Class[])ScriptBytecodeAdapter.castToType((Object)this.parameterTypes.get(), Class[].class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _doesRealMethodExist_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            realMethodExists = bl = mc.getMethods().contains((Object)new _doesRealMethodExist_closure3(GormEnhancer.class, GormEnhancer.class, methodName2, staticScope2, parameterTypes2));
        }
        return realMethodExists;
    }

    protected static boolean isRealMethod(MetaMethod existingMethod) {
        return existingMethod instanceof CachedMethod;
    }

    protected <D> GormStaticApi<D> getStaticApi(Class<D> cls, String qualifier) {
        return new GormStaticApi<D>(cls, this.datastore, this.getFinders(), this.transactionManager);
    }

    protected <D> GormInstanceApi<D> getInstanceApi(Class<D> cls, String qualifier) {
        GormInstanceApi<D> instanceApi = new GormInstanceApi<D>(cls, this.datastore);
        boolean bl = this.failOnError;
        instanceApi.setFailOnError(bl);
        boolean bl2 = this.markDirty;
        instanceApi.setMarkDirty(bl2);
        return instanceApi;
    }

    protected <D> GormValidationApi<D> getValidationApi(Class<D> cls, String qualifier) {
        return new GormValidationApi<D>(cls, this.datastore);
    }

    protected List<FinderMethod> createDynamicFinders() {
        Datastore targetDatastore = this.datastore;
        return this.createDynamicFinders(targetDatastore);
    }

    protected List<FinderMethod> createDynamicFinders(Datastore targetDatastore) {
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{new FindOrCreateByFinder(targetDatastore), new FindOrSaveByFinder(targetDatastore), new FindByFinder(targetDatastore), new FindAllByFinder(targetDatastore), new FindAllByBooleanFinder(targetDatastore), new FindByBooleanFinder(targetDatastore), new CountByFinder(targetDatastore), new ListOrderByFinder(targetDatastore)});
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GormEnhancer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GormEnhancer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GormEnhancer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GormEnhancer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public static <D> GormStaticApi<D> findStaticApi(Class<D> entity) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return GormEnhancer.findStaticApi(entity, (String)callSiteArray[12].callStatic(GormEnhancer.class, entity));
        }
        return GormEnhancer.findStaticApi(entity, GormEnhancer.findTenantId(entity));
    }

    @Generated
    public static <D> GormInstanceApi<D> findInstanceApi(Class<D> entity) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return GormEnhancer.findInstanceApi(entity, (String)callSiteArray[13].callStatic(GormEnhancer.class, entity));
        }
        return GormEnhancer.findInstanceApi(entity, GormEnhancer.findTenantId(entity));
    }

    @Generated
    public static <D> GormValidationApi<D> findValidationApi(Class<D> entity) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return GormEnhancer.findValidationApi(entity, (String)callSiteArray[14].callStatic(GormEnhancer.class, entity));
        }
        return GormEnhancer.findValidationApi(entity, GormEnhancer.findTenantId(entity));
    }

    @Generated
    public static Datastore findDatastore(Class entity) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return GormEnhancer.findDatastore(entity, (String)callSiteArray[15].callStatic(GormEnhancer.class, (Object)entity));
        }
        return GormEnhancer.findDatastore(entity, GormEnhancer.findTenantId(entity));
    }

    @Generated
    public static PlatformTransactionManager findSingleTransactionManager() {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return GormEnhancer.findSingleTransactionManager(ShortTypeHandling.castToString((Object)callSiteArray[16].callGetProperty(ConnectionSource.class)));
        }
        return GormEnhancer.findSingleTransactionManager(ShortTypeHandling.castToString((Object)callSiteArray[17].callGetProperty(ConnectionSource.class)));
    }

    @Generated
    public static PlatformTransactionManager findTransactionManager(Class<? extends Datastore> datastoreType) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return GormEnhancer.findTransactionManager(datastoreType, ShortTypeHandling.castToString((Object)callSiteArray[18].callGetProperty(ConnectionSource.class)));
        }
        return GormEnhancer.findTransactionManager(datastoreType, ShortTypeHandling.castToString((Object)callSiteArray[19].callGetProperty(ConnectionSource.class)));
    }

    @Generated
    public static PersistentEntity findEntity(Class entity) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return GormEnhancer.findEntity(entity, (String)callSiteArray[20].callStatic(GormEnhancer.class, (Object)entity));
        }
        return GormEnhancer.findEntity(entity, GormEnhancer.findTenantId(entity));
    }

    @Generated
    public void enhance() {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            this.enhance(false);
        } else {
            this.enhance(false);
        }
    }

    @Generated
    public void enhance(PersistentEntity e) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        this.enhance(e, false);
    }

    @Generated
    protected <D> GormStaticApi<D> getStaticApi(Class<D> cls) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getStaticApi(cls, ShortTypeHandling.castToString((Object)callSiteArray[21].callGetProperty(ConnectionSource.class)));
        }
        return this.getStaticApi(cls, ShortTypeHandling.castToString((Object)callSiteArray[22].callGetProperty(ConnectionSource.class)));
    }

    @Generated
    protected <D> GormInstanceApi<D> getInstanceApi(Class<D> cls) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getInstanceApi(cls, ShortTypeHandling.castToString((Object)callSiteArray[23].callGetProperty(ConnectionSource.class)));
        }
        return this.getInstanceApi(cls, ShortTypeHandling.castToString((Object)callSiteArray[24].callGetProperty(ConnectionSource.class)));
    }

    @Generated
    protected <D> GormValidationApi<D> getValidationApi(Class<D> cls) {
        CallSite[] callSiteArray = GormEnhancer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getValidationApi(cls, ShortTypeHandling.castToString((Object)callSiteArray[25].callGetProperty(ConnectionSource.class)));
        }
        return this.getValidationApi(cls, ShortTypeHandling.castToString((Object)callSiteArray[26].callGetProperty(ConnectionSource.class)));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        Map map;
        Map map2;
        Map map3;
        Map map4;
        ConcurrentHashMap<String, Map<String, Closure>> concurrentHashMap = new ConcurrentHashMap<String, Map<String, Closure>>();
        NAMED_QUERIES = concurrentHashMap;
        public final class __clinit__closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public ConcurrentHashMap<String, GormStaticApi> doCall(String key) {
                return new ConcurrentHashMap<String, GormStaticApi>();
            }

            @Generated
            public ConcurrentHashMap<String, GormStaticApi> call(String key) {
                return this.doCall(key);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        STATIC_APIS = map4 = DefaultGroovyMethods.withDefault(new ConcurrentHashMap(), (Closure)new __clinit__closure4(GormEnhancer.class, GormEnhancer.class));
        public final class __clinit__closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public ConcurrentHashMap<String, GormInstanceApi> doCall(String key) {
                return new ConcurrentHashMap<String, GormInstanceApi>();
            }

            @Generated
            public ConcurrentHashMap<String, GormInstanceApi> call(String key) {
                return this.doCall(key);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        INSTANCE_APIS = map3 = DefaultGroovyMethods.withDefault(new ConcurrentHashMap(), (Closure)new __clinit__closure5(GormEnhancer.class, GormEnhancer.class));
        public final class __clinit__closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public ConcurrentHashMap<String, GormValidationApi> doCall(String key) {
                return new ConcurrentHashMap<String, GormValidationApi>();
            }

            @Generated
            public ConcurrentHashMap<String, GormValidationApi> call(String key) {
                return this.doCall(key);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        VALIDATION_APIS = map2 = DefaultGroovyMethods.withDefault(new ConcurrentHashMap(), (Closure)new __clinit__closure6(GormEnhancer.class, GormEnhancer.class));
        public final class __clinit__closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public ConcurrentHashMap<String, Datastore> doCall(String key) {
                return new ConcurrentHashMap<String, Datastore>();
            }

            @Generated
            public ConcurrentHashMap<String, Datastore> call(String key) {
                return this.doCall(key);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DATASTORES = map = DefaultGroovyMethods.withDefault(new ConcurrentHashMap(), (Closure)new __clinit__closure7(GormEnhancer.class, GormEnhancer.class));
        ConcurrentHashMap<Class, Datastore> concurrentHashMap2 = new ConcurrentHashMap<Class, Datastore>();
        DATASTORES_BY_TYPE = concurrentHashMap2;
        log = logger = LoggerFactory.getLogger((String)"org.grails.datastore.gorm.GormEnhancer");
    }

    @Generated
    public final Datastore getDatastore() {
        return this.datastore;
    }

    @Generated
    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Generated
    public void setTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.transactionManager = platformTransactionManager;
    }

    @Generated
    public void setFinders(List<FinderMethod> list) {
        this.finders = list;
    }

    @Generated
    public boolean getFailOnError() {
        return this.failOnError;
    }

    @Generated
    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Generated
    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    @Generated
    public boolean getMarkDirty() {
        return this.markDirty;
    }

    @Generated
    public boolean isMarkDirty() {
        return this.markDirty;
    }

    @Generated
    public void setMarkDirty(boolean bl) {
        this.markDirty = bl;
    }

    @Generated
    public boolean getIncludeExternal() {
        return this.includeExternal;
    }

    @Generated
    public boolean isIncludeExternal() {
        return this.includeExternal;
    }

    @Generated
    public void setIncludeExternal(boolean bl) {
        this.includeExternal = bl;
    }

    @Generated
    public final boolean getDynamicEnhance() {
        return this.dynamicEnhance;
    }

    @Generated
    public final boolean isDynamicEnhance() {
        return this.dynamicEnhance;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getClassLoader";
        stringArray[1] = "getClass";
        stringArray[2] = "isPresent";
        stringArray[3] = "removeConstraint";
        stringArray[4] = "loadClass";
        stringArray[5] = "isDebugEnabled";
        stringArray[6] = "debug";
        stringArray[7] = "message";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "static";
        stringArray[10] = "getInstanceApi";
        stringArray[11] = "getValidationApi";
        stringArray[12] = "findTenantId";
        stringArray[13] = "findTenantId";
        stringArray[14] = "findTenantId";
        stringArray[15] = "findTenantId";
        stringArray[16] = "DEFAULT";
        stringArray[17] = "DEFAULT";
        stringArray[18] = "DEFAULT";
        stringArray[19] = "DEFAULT";
        stringArray[20] = "findTenantId";
        stringArray[21] = "DEFAULT";
        stringArray[22] = "DEFAULT";
        stringArray[23] = "DEFAULT";
        stringArray[24] = "DEFAULT";
        stringArray[25] = "DEFAULT";
        stringArray[26] = "DEFAULT";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[27];
        GormEnhancer.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GormEnhancer.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GormEnhancer.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

