/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.finders;

import grails.gorm.DetachedCriteria;
import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.FetchType;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.datastore.gorm.finders.AbstractFinder;
import org.grails.datastore.gorm.finders.DynamicFinderInvocation;
import org.grails.datastore.gorm.finders.MethodExpression;
import org.grails.datastore.gorm.finders.QueryBuildingFinder;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.QueryArgumentsAware;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.StringUtils;

public abstract class DynamicFinder
extends AbstractFinder
implements QueryBuildingFinder {
    public static final String ARGUMENT_MAX = "max";
    public static final String ARGUMENT_OFFSET = "offset";
    public static final String ARGUMENT_ORDER = "order";
    public static final String ARGUMENT_SORT = "sort";
    public static final String ORDER_DESC = "desc";
    public static final String ORDER_ASC = "asc";
    public static final String ARGUMENT_FETCH = "fetch";
    public static final String ARGUMENT_IGNORE_CASE = "ignoreCase";
    public static final String ARGUMENT_CACHE = "cache";
    public static final String ARGUMENT_LOCK = "lock";
    protected Pattern pattern;
    private Pattern[] operatorPatterns;
    private String[] operators;
    private static Pattern methodExpressinPattern;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static final String NOT = "Not";
    private static final Map<String, Constructor> methodExpressions;

    static void resetMethodExpressionPattern() {
        String expressionPattern = DefaultGroovyMethods.join(methodExpressions.keySet(), (String)"|");
        methodExpressinPattern = Pattern.compile("\\p{Upper}[\\p{Lower}\\d]+(" + expressionPattern + ")");
    }

    protected DynamicFinder(Pattern pattern, String[] operators, Datastore datastore) {
        super(datastore);
        this.pattern = pattern;
        this.operators = operators;
        this.operatorPatterns = new Pattern[operators.length];
        for (int i = 0; i < operators.length; ++i) {
            this.operatorPatterns[i] = Pattern.compile("(\\w+)(" + operators[i] + ")(\\p{Upper})(\\w+)");
        }
    }

    public static void registerNewMethodExpression(Class methodExpression) {
        try {
            methodExpressions.put(methodExpression.getSimpleName(), methodExpression.getConstructor(Class.class, String.class));
            DynamicFinder.resetMethodExpressionPattern();
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Class [" + methodExpression + "] does not provide a constructor that takes parameters of type Class and String: " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class [" + methodExpression + "] does not provide a constructor that takes parameters of type Class and String: " + e.getMessage(), e);
        }
    }

    @Override
    public void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public boolean isMethodMatch(String methodName) {
        return this.pattern.matcher(methodName.subSequence(0, methodName.length())).find();
    }

    @Override
    public Object invoke(Class clazz, String methodName, Closure additionalCriteria, Object[] arguments) {
        DynamicFinderInvocation invocation = this.createFinderInvocation(clazz, methodName, additionalCriteria, arguments);
        return this.doInvokeInternal(invocation);
    }

    public Object invoke(Class clazz, String methodName, DetachedCriteria detachedCriteria, Object[] arguments) {
        DynamicFinderInvocation invocation = this.createFinderInvocation(clazz, methodName, null, arguments);
        if (detachedCriteria != null) {
            invocation.setDetachedCriteria(detachedCriteria);
        }
        return this.doInvokeInternal(invocation);
    }

    public DynamicFinderInvocation createFinderInvocation(Class clazz, String methodName, Closure additionalCriteria, Object[] arguments) {
        String querySequence;
        ArrayList<MethodExpression> expressions = new ArrayList<MethodExpression>();
        if (arguments == null) {
            arguments = EMPTY_OBJECT_ARRAY;
        } else {
            Object[] tmp = new Object[arguments.length];
            System.arraycopy(arguments, 0, tmp, 0, arguments.length);
            arguments = tmp;
        }
        Matcher match = this.pattern.matcher(methodName);
        match.find();
        int totalRequiredArguments = 0;
        int groupCount = match.groupCount();
        if (groupCount == 6) {
            String booleanProperty = match.group(3);
            if (booleanProperty == null) {
                booleanProperty = match.group(6);
                querySequence = null;
            } else {
                querySequence = match.group(5);
            }
            Boolean arg = Boolean.TRUE;
            if (booleanProperty.matches("Not[A-Z].*")) {
                booleanProperty = booleanProperty.substring(3);
                arg = Boolean.FALSE;
            }
            MethodExpression booleanExpression = this.findMethodExpression(clazz, booleanProperty);
            booleanExpression.setArguments(new Object[]{arg});
            expressions.add(booleanExpression);
        } else {
            querySequence = match.group(2);
        }
        boolean containsOperator = false;
        String operatorInUse = null;
        if (querySequence != null) {
            for (int i = 0; i < this.operators.length; ++i) {
                Matcher currentMatcher = this.operatorPatterns[i].matcher(querySequence);
                if (!currentMatcher.find()) continue;
                containsOperator = true;
                operatorInUse = this.operators[i];
                String[] queryParameters = querySequence.split(operatorInUse);
                int argumentCursor = 0;
                for (String queryParameter : queryParameters) {
                    MethodExpression currentExpression = this.findMethodExpression(clazz, queryParameter);
                    int requiredArgs = currentExpression.getArgumentsRequired();
                    Object[] currentArguments = new Object[requiredArgs];
                    if (argumentCursor + requiredArgs > arguments.length) {
                        throw new MissingMethodException(methodName, clazz, arguments);
                    }
                    int k = 0;
                    while (k < requiredArgs) {
                        currentArguments[k] = arguments[argumentCursor];
                        ++k;
                        ++argumentCursor;
                    }
                    currentExpression = this.getInitializedExpression(currentExpression, currentArguments);
                    PersistentEntity persistentEntity = this.datastore.getMappingContext().getPersistentEntity(clazz.getName());
                    try {
                        currentExpression.convertArguments(persistentEntity);
                    }
                    catch (ConversionException e) {
                        throw new MissingMethodException(methodName, clazz, arguments);
                    }
                    totalRequiredArguments += currentExpression.argumentsRequired;
                    expressions.add(currentExpression);
                }
                break;
            }
        }
        if (!containsOperator && querySequence != null) {
            MethodExpression solo;
            block21: {
                solo = this.findMethodExpression(clazz, querySequence);
                int requiredArguments = solo.getArgumentsRequired();
                if (requiredArguments > arguments.length) {
                    throw new MissingMethodException(methodName, clazz, arguments);
                }
                totalRequiredArguments += requiredArguments;
                Object[] soloArgs = new Object[requiredArguments];
                System.arraycopy(arguments, 0, soloArgs, 0, requiredArguments);
                solo = this.getInitializedExpression(solo, arguments);
                PersistentEntity persistentEntity = this.datastore.getMappingContext().getPersistentEntity(clazz.getName());
                try {
                    solo.convertArguments(persistentEntity);
                }
                catch (ConversionException e) {
                    if (persistentEntity.getPropertyByName(solo.propertyName) instanceof Basic) break block21;
                    throw new MissingMethodException(methodName, clazz, arguments);
                }
            }
            expressions.add(solo);
        }
        if (totalRequiredArguments > arguments.length) {
            throw new MissingMethodException(methodName, clazz, arguments);
        }
        Object[] remainingArguments = new Object[arguments.length - totalRequiredArguments];
        if (remainingArguments.length > 0) {
            int i = 0;
            int j = totalRequiredArguments;
            while (i < remainingArguments.length) {
                remainingArguments[i] = arguments[j];
                ++i;
                ++j;
            }
        }
        return new DynamicFinderInvocation(clazz, methodName, remainingArguments, expressions, additionalCriteria, operatorInUse);
    }

    private MethodExpression getInitializedExpression(MethodExpression expression, Object[] arguments) {
        if (expression instanceof MethodExpression.Equal && arguments.length == 1 && arguments[0] == null) {
            expression = new MethodExpression.IsNull(expression.targetClass, expression.propertyName);
        } else {
            expression.setArguments(arguments);
        }
        return expression;
    }

    protected MethodExpression findMethodExpression(Class clazz, String expression) {
        MethodExpression me = null;
        Matcher matcher = methodExpressinPattern.matcher(expression);
        if (matcher.find()) {
            Constructor constructor = methodExpressions.get(matcher.group(1));
            try {
                me = (MethodExpression)constructor.newInstance(clazz, DynamicFinder.calcPropertyName(expression, constructor.getDeclaringClass().getSimpleName()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (me == null) {
            me = new MethodExpression.Equal(clazz, DynamicFinder.calcPropertyName(expression, MethodExpression.Equal.class.getSimpleName()));
        }
        return me;
    }

    private static String calcPropertyName(String queryParameter, String clause) {
        String propName;
        int i;
        if (clause != null && !clause.equals(MethodExpression.Equal.class.getSimpleName())) {
            i = queryParameter.indexOf(clause);
            propName = queryParameter.substring(0, i);
        } else {
            propName = queryParameter;
        }
        if (propName.endsWith(NOT)) {
            i = propName.lastIndexOf(NOT);
            propName = propName.substring(0, i);
        }
        if (!StringUtils.hasLength((String)propName)) {
            throw new IllegalArgumentException("No property name specified in clause: " + clause);
        }
        return propName.substring(0, 1).toLowerCase(Locale.ENGLISH) + propName.substring(1);
    }

    protected abstract Object doInvokeInternal(DynamicFinderInvocation var1);

    @Override
    public Object invoke(Class clazz, String methodName, Object[] arguments) {
        return this.invoke(clazz, methodName, (Closure)null, arguments);
    }

    public static void populateArgumentsForCriteria(Class<?> targetClass, Query q, Map argMap) {
        int offset;
        if (argMap == null) {
            return;
        }
        Integer maxParam = null;
        Integer offsetParam = null;
        ConversionService conversionService = q.getSession().getMappingContext().getConversionService();
        if (argMap.containsKey(ARGUMENT_MAX)) {
            maxParam = (Integer)conversionService.convert(argMap.get(ARGUMENT_MAX), Integer.class);
        }
        if (argMap.containsKey(ARGUMENT_OFFSET)) {
            offsetParam = (Integer)conversionService.convert(argMap.get(ARGUMENT_OFFSET), Integer.class);
        }
        String orderParam = (String)argMap.get(ARGUMENT_ORDER);
        Object fetchObj = argMap.get(ARGUMENT_FETCH);
        if (fetchObj instanceof Map) {
            Map fetch = (Map)fetchObj;
            for (Object o : fetch.keySet()) {
                String associationName = (String)o;
                FetchType fetchType = DynamicFinder.getFetchMode(fetch.get(associationName));
                switch (fetchType) {
                    case LAZY: {
                        q.select(associationName);
                        break;
                    }
                    case EAGER: {
                        q.join(associationName);
                    }
                }
            }
        }
        String sort = (String)argMap.get(ARGUMENT_SORT);
        String order = ORDER_DESC.equalsIgnoreCase(orderParam) ? ORDER_DESC : ORDER_ASC;
        int max = maxParam == null ? -1 : maxParam;
        int n = offset = offsetParam == null ? -1 : offsetParam;
        if (max > -1) {
            q.max(max);
        }
        if (offset > -1) {
            q.offset(offset);
        }
        if (sort != null) {
            if (ORDER_DESC.equalsIgnoreCase(order)) {
                q.order(Query.Order.desc((String)sort));
            } else {
                q.order(Query.Order.asc((String)sort));
            }
        }
        if (q instanceof QueryArgumentsAware) {
            ((QueryArgumentsAware)q).setArguments(argMap);
        }
    }

    public static FetchType getFetchMode(Object object) {
        String name;
        String string = name = object != null ? object.toString() : "default";
        if (name.equalsIgnoreCase(FetchType.EAGER.toString()) || name.equalsIgnoreCase("join")) {
            return FetchType.EAGER;
        }
        if (name.equalsIgnoreCase(FetchType.LAZY.toString()) || name.equalsIgnoreCase("select")) {
            return FetchType.LAZY;
        }
        return FetchType.LAZY;
    }

    protected void configureQueryWithArguments(Class clazz, Query query, Object[] arguments) {
        if (arguments.length == 0 || !(arguments[0] instanceof Map)) {
            return;
        }
        Map argMap = (Map)arguments[0];
        DynamicFinder.populateArgumentsForCriteria(clazz, query, argMap);
    }

    public static void applyDetachedCriteria(Query q, DetachedCriteria detachedCriteria) {
        if (detachedCriteria != null) {
            List<Query.Criterion> criteria = detachedCriteria.getCriteria();
            for (Query.Criterion criterion : criteria) {
                q.add(criterion);
            }
            List<Query.Projection> projections = detachedCriteria.getProjections();
            for (Query.Projection projection : projections) {
                q.projections().add(projection);
            }
            List<Query.Order> orders = detachedCriteria.getOrders();
            for (Query.Order order : orders) {
                q.order(order);
            }
            Map<String, FetchType> fetchStrategies = detachedCriteria.getFetchStrategies();
            for (Map.Entry<String, FetchType> entry : fetchStrategies.entrySet()) {
                switch (entry.getValue()) {
                    case EAGER: {
                        q.join(entry.getKey());
                        break;
                    }
                    case LAZY: {
                        q.select(entry.getKey());
                    }
                }
            }
        }
    }

    static {
        EMPTY_OBJECT_ARRAY = new Object[0];
        methodExpressions = new LinkedHashMap<String, Constructor>();
        try {
            Class[] classes = new Class[]{MethodExpression.Equal.class, MethodExpression.NotEqual.class, MethodExpression.InList.class, MethodExpression.InRange.class, MethodExpression.Between.class, MethodExpression.Like.class, MethodExpression.Ilike.class, MethodExpression.Rlike.class, MethodExpression.GreaterThanEquals.class, MethodExpression.LessThanEquals.class, MethodExpression.GreaterThan.class, MethodExpression.LessThan.class, MethodExpression.IsNull.class, MethodExpression.IsNotNull.class, MethodExpression.IsEmpty.class, MethodExpression.IsEmpty.class, MethodExpression.IsNotEmpty.class};
            Class[] constructorParamTypes = new Class[]{Class.class, String.class};
            for (Class c : classes) {
                methodExpressions.put(c.getSimpleName(), c.getConstructor(constructorParamTypes));
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        DynamicFinder.resetMethodExpressionPattern();
    }
}

