/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.support;

import groovy.lang.MetaClass;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.grails.datastore.gorm.support.EventTriggerCaller;

public class BeforeValidateHelper {
    public static final String BEFORE_VALIDATE = "beforeValidate";
    private Map<Class<?>, BeforeValidateEventTriggerCaller> eventTriggerCallerCache = new ConcurrentHashMap();

    public void invokeBeforeValidate(Object target, List<?> validatedFieldsList) {
        Class<?> domainClass = target.getClass();
        BeforeValidateEventTriggerCaller eventTriggerCaller = this.eventTriggerCallerCache.get(domainClass);
        if (eventTriggerCaller == null) {
            eventTriggerCaller = new BeforeValidateEventTriggerCaller(domainClass, null);
            this.eventTriggerCallerCache.put(domainClass, eventTriggerCaller);
        }
        eventTriggerCaller.call(target, validatedFieldsList);
    }

    public static final class BeforeValidateEventTriggerCaller {
        EventTriggerCaller eventTriggerCaller;
        EventTriggerCaller eventTriggerCallerNoArgs;

        public BeforeValidateEventTriggerCaller(Class<?> domainClass, MetaClass metaClass) {
            this.eventTriggerCaller = this.build(domainClass, metaClass, new Class[]{List.class});
            this.eventTriggerCallerNoArgs = this.build(domainClass, metaClass, new Class[0]);
        }

        protected EventTriggerCaller build(Class<?> domainClass, MetaClass metaClass, Class<?>[] argumentTypes) {
            return EventTriggerCaller.buildCaller(BeforeValidateHelper.BEFORE_VALIDATE, domainClass, metaClass, argumentTypes);
        }

        public void call(Object target, List<?> validatedFieldsList) {
            if (validatedFieldsList != null && this.eventTriggerCaller != null) {
                this.eventTriggerCaller.call(target, new Object[]{validatedFieldsList});
            } else if (this.eventTriggerCallerNoArgs != null) {
                this.eventTriggerCallerNoArgs.call(target);
            }
        }
    }
}

