/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints;

import grails.gorm.validation.ConstrainedProperty;
import grails.gorm.validation.Constraint;
import java.beans.Introspector;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public abstract class AbstractConstraint
implements Constraint {
    protected final Class<?> constraintOwningClass;
    protected final String constraintPropertyName;
    protected final Object constraintParameter;
    protected final String classShortName;
    protected final MessageSource messageSource;
    private final String fullQualifiedConstraintErrorCode;
    private final String shortNameConstraintErrorCode;
    private final String fullQualifiedPrefix;
    private final String shortNamePrefix;

    public AbstractConstraint(Class<?> constraintOwningClass, String constraintPropertyName, Object constraintParameter, MessageSource messageSource) {
        this.constraintPropertyName = constraintPropertyName;
        this.constraintOwningClass = constraintOwningClass;
        this.constraintParameter = this.validateParameter(constraintParameter);
        this.messageSource = messageSource;
        this.classShortName = Introspector.decapitalize(constraintOwningClass.getSimpleName());
        this.fullQualifiedPrefix = constraintOwningClass.getName() + "." + constraintPropertyName + ".";
        this.shortNamePrefix = this.classShortName + "." + constraintPropertyName + ".";
        this.fullQualifiedConstraintErrorCode = this.fullQualifiedPrefix + this.getName() + ".error";
        this.shortNameConstraintErrorCode = this.shortNamePrefix + this.getName() + ".error";
    }

    protected abstract Object validateParameter(Object var1);

    @Override
    public String getPropertyName() {
        return this.constraintPropertyName;
    }

    @Override
    public Object getParameter() {
        return this.constraintParameter;
    }

    protected void checkState() {
        Assert.hasLength((String)this.constraintPropertyName, (String)"Property 'propertyName' must be set on the constraint");
        Assert.notNull(this.constraintOwningClass, (String)"Property 'owningClass' must be set on the constraint");
        Assert.notNull((Object)this.constraintParameter, (String)"Property 'constraintParameter' must be set on the constraint");
    }

    @Override
    public void validate(Object target, Object propertyValue, Errors errors) {
        this.checkState();
        if (propertyValue == null && this.skipNullValues()) {
            return;
        }
        if (this.skipBlankValues() && propertyValue instanceof String && StringUtils.isEmpty((Object)propertyValue)) {
            return;
        }
        this.processValidate(target, propertyValue, errors);
    }

    protected boolean skipNullValues() {
        return true;
    }

    protected boolean skipBlankValues() {
        return true;
    }

    public void rejectValue(Object target, Errors errors, String defaultMessageCode, Object[] args) {
        this.rejectValue(target, errors, defaultMessageCode, new String[0], args);
    }

    public void rejectValue(Object target, Errors errors, String defaultMessageCode, String code, Object[] args) {
        this.rejectValue(target, errors, defaultMessageCode, new String[]{code}, args);
    }

    public void rejectValue(Object target, Errors errors, String defaultMessageCode, String[] codes, Object[] args) {
        this.rejectValueWithDefaultMessage(target, errors, this.getDefaultMessage(defaultMessageCode), codes, args);
    }

    public void rejectValueWithDefaultMessage(Object target, Errors errors, String defaultMessage, String[] codes, Object[] args) {
        BindingResult result = (BindingResult)errors;
        LinkedHashSet<String> newCodes = new LinkedHashSet<String>();
        if (args.length > 1 && this.messageSource != null && args[0] instanceof String && args[1] instanceof Class) {
            String propertyName;
            String propertyNameCode;
            String resolvedPropertyName;
            String[] locale = LocaleContextHolder.getLocale();
            Class constrainedClass = (Class)args[1];
            String fullClassName = constrainedClass.getName();
            String classNameCode = fullClassName + ".label";
            String resolvedClassName = this.messageSource.getMessage(classNameCode, null, fullClassName, (Locale)locale);
            String classAsPropertyName = Introspector.decapitalize(constrainedClass.getSimpleName());
            if (resolvedClassName.equals(fullClassName)) {
                classNameCode = classAsPropertyName + ".label";
                resolvedClassName = this.messageSource.getMessage(classNameCode, null, fullClassName, (Locale)locale);
            }
            if (!resolvedClassName.equals(fullClassName)) {
                args[1] = resolvedClassName;
            }
            if ((resolvedPropertyName = this.messageSource.getMessage(propertyNameCode = fullClassName + "." + (propertyName = (String)args[0]) + ".label", null, propertyName, (Locale)locale)).equals(propertyName)) {
                propertyNameCode = classAsPropertyName + "." + propertyName + ".label";
                resolvedPropertyName = this.messageSource.getMessage(propertyNameCode, null, propertyName, (Locale)locale);
            }
            if (!resolvedPropertyName.equals(propertyName)) {
                args[0] = resolvedPropertyName;
            }
        }
        newCodes.addAll(Arrays.asList(result.resolveMessageCodes(this.fullQualifiedConstraintErrorCode, this.constraintPropertyName)));
        newCodes.addAll(Arrays.asList(result.resolveMessageCodes(this.shortNameConstraintErrorCode, this.constraintPropertyName)));
        for (String code : codes) {
            newCodes.addAll(Arrays.asList(result.resolveMessageCodes(this.fullQualifiedPrefix + code, this.constraintPropertyName)));
            newCodes.addAll(Arrays.asList(result.resolveMessageCodes(this.shortNamePrefix + code, this.constraintPropertyName)));
            newCodes.addAll(Arrays.asList(result.resolveMessageCodes(code, this.constraintPropertyName)));
        }
        FieldError error = new FieldError(errors.getObjectName(), errors.getNestedPath() + this.constraintPropertyName, this.getPropertyValue(errors, target), false, newCodes.toArray(new String[newCodes.size()]), args, defaultMessage);
        ((BindingResult)errors).addError((ObjectError)error);
    }

    private Object getPropertyValue(Errors errors, Object target) {
        try {
            return errors.getFieldValue(this.constraintPropertyName);
        }
        catch (Exception nre) {
            int i = this.constraintPropertyName.lastIndexOf(".");
            String propertyName = i > -1 ? this.constraintPropertyName.substring(i, this.constraintPropertyName.length()) : this.constraintPropertyName;
            return new BeanWrapperImpl(target).getPropertyValue(propertyName);
        }
    }

    public void rejectValue(Object target, Errors errors, String code, String defaultMessage) {
        this.rejectValueWithDefaultMessage(target, errors, defaultMessage, new String[]{code}, null);
    }

    public void rejectValue(Object target, Errors errors, String code, Object[] args, String defaultMessage) {
        this.rejectValueWithDefaultMessage(target, errors, defaultMessage, new String[]{code}, args);
    }

    protected String getDefaultMessage(String code) {
        try {
            if (this.messageSource != null) {
                return this.messageSource.getMessage(code, null, LocaleContextHolder.getLocale());
            }
            return ConstrainedProperty.DEFAULT_MESSAGES.get(code);
        }
        catch (Exception e) {
            return ConstrainedProperty.DEFAULT_MESSAGES.get(code);
        }
    }

    protected abstract void processValidate(Object var1, Object var2, Errors var3);

    public String toString() {
        return new ToStringCreator((Object)this).append(this.constraintParameter).toString();
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

