/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints.eval;

import grails.gorm.validation.Constrained;
import grails.gorm.validation.ConstrainedProperty;
import grails.gorm.validation.DefaultConstrainedProperty;
import grails.gorm.validation.exceptions.ValidationConfigurationException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.grails.datastore.gorm.validation.constraints.builder.ConstrainedPropertyBuilder;
import org.grails.datastore.gorm.validation.constraints.eval.ConstraintsEvaluator;
import org.grails.datastore.gorm.validation.constraints.registry.ConstraintRegistry;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Identity;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConstraintEvaluator
implements ConstraintsEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConstraintEvaluator.class);
    protected final ConstraintRegistry constraintRegistry;
    protected final MappingContext mappingContext;
    protected final Map<String, Object> defaultConstraints;

    public DefaultConstraintEvaluator(ConstraintRegistry constraintRegistry, MappingContext mappingContext, Map<String, Object> defaultConstraints) {
        this.constraintRegistry = constraintRegistry;
        this.mappingContext = mappingContext;
        this.defaultConstraints = defaultConstraints;
    }

    @Override
    public Map<String, Object> getDefaultConstraints() {
        return null;
    }

    @Override
    public Map<String, ConstrainedProperty> evaluate(Class cls) {
        return this.evaluate(cls, false);
    }

    @Override
    public Map<String, ConstrainedProperty> evaluate(Class theClass, boolean defaultNullable) {
        ConstrainedPropertyBuilder delegate = new ConstrainedPropertyBuilder(this.mappingContext, this.constraintRegistry, theClass, this.defaultConstraints);
        List constraints = ClassPropertyFetcher.getStaticPropertyValuesFromInheritanceHierarchy((Class)theClass, (String)PROPERTY_NAME, Closure.class);
        for (Closure c : constraints) {
            if (c == null) continue;
            c = (Closure)c.clone();
            c.setResolveStrategy(3);
            c.setDelegate((Object)delegate);
            c.call();
        }
        Map<String, ConstrainedProperty> constrainedProperties = delegate.getConstrainedProperties();
        PersistentEntity entity = this.mappingContext.getPersistentEntity(theClass.getName());
        List properties = null;
        if (entity != null && (properties = entity.getPersistentProperties()) != null) {
            for (PersistentProperty p : properties) {
                Property mappedForm = p.getMapping().getMappedForm();
                if (!this.canPropertyBeConstrained(p)) continue;
                if (mappedForm.isDerived()) {
                    if (constrainedProperties.remove(p.getName()) == null) continue;
                    LOG.warn("Derived properties may not be constrained. Property [" + p.getName() + "] of domain class " + theClass.getName() + " will not be checked during validation.");
                    continue;
                }
                String propertyName = p.getName();
                ConstrainedProperty cp = constrainedProperties.get(propertyName);
                if (cp == null) {
                    DefaultConstrainedProperty constrainedProperty = new DefaultConstrainedProperty(entity.getJavaClass(), propertyName, p.getType(), this.constraintRegistry);
                    cp = constrainedProperty;
                    constrainedProperty.setOrder(constrainedProperties.size() + 1);
                    constrainedProperties.put(propertyName, cp);
                }
                this.applyDefaultConstraints(propertyName, p, cp, this.defaultConstraints);
            }
        }
        if (properties == null || properties.size() == 0) {
            Set<Map.Entry<String, ConstrainedProperty>> entrySet = constrainedProperties.entrySet();
            for (Map.Entry<String, ConstrainedProperty> entry : entrySet) {
                ConstrainedProperty constrainedProperty = entry.getValue();
                if (constrainedProperty.hasAppliedConstraint("nullable")) continue;
                this.applyDefaultNullableConstraint(constrainedProperty, defaultNullable);
            }
        }
        this.applySharedConstraints(delegate, constrainedProperties);
        return constrainedProperties;
    }

    protected void applySharedConstraints(ConstrainedPropertyBuilder constrainedPropertyBuilder, Map<String, ConstrainedProperty> constrainedProperties) {
        for (Map.Entry<String, ConstrainedProperty> entry : constrainedProperties.entrySet()) {
            String propertyName = entry.getKey();
            Constrained constrainedProperty = entry.getValue();
            String sharedConstraintReference = constrainedPropertyBuilder.getSharedConstraint(propertyName);
            if (sharedConstraintReference == null || this.defaultConstraints == null) continue;
            Object o = this.defaultConstraints.get(sharedConstraintReference);
            if (o instanceof Map) {
                Map constraintsWithinSharedConstraint = (Map)o;
                for (Map.Entry e : constraintsWithinSharedConstraint.entrySet()) {
                    constrainedProperty.applyConstraint((String)e.getKey(), e.getValue());
                }
                continue;
            }
            throw new ValidationConfigurationException("Property [" + constrainedProperty.getOwner().getName() + '.' + propertyName + "] references shared constraint [" + sharedConstraintReference + ":" + o + "], which doesn't exist!");
        }
    }

    protected boolean canPropertyBeConstrained(PersistentProperty property) {
        return true;
    }

    public static LinkedList<Class<?>> getSuperClassChain(Class<?> theClass) {
        LinkedList classChain = new LinkedList();
        for (Class<?> clazz = theClass; clazz != Object.class && clazz != null; clazz = clazz.getSuperclass()) {
            classChain.addFirst(clazz);
        }
        return classChain;
    }

    protected void applyDefaultConstraints(String propertyName, PersistentProperty p, ConstrainedProperty cp, Map<String, Object> defaultConstraints) {
        Object o;
        if (defaultConstraints != null && !defaultConstraints.isEmpty() && defaultConstraints.containsKey("*") && (o = defaultConstraints.get("*")) instanceof Map) {
            Map globalConstraints = (Map)o;
            this.applyMapOfConstraints(globalConstraints, propertyName, p, cp);
        }
        if (this.canApplyNullableConstraint(propertyName, p, cp)) {
            this.applyDefaultNullableConstraint(p, cp);
        }
    }

    protected void applyDefaultNullableConstraint(PersistentProperty p, ConstrainedProperty cp) {
        this.applyDefaultNullableConstraint(cp, false);
    }

    protected void applyDefaultNullableConstraint(ConstrainedProperty cp, boolean defaultNullable) {
        boolean isCollection = Collection.class.isAssignableFrom(cp.getPropertyType()) || Map.class.isAssignableFrom(cp.getPropertyType());
        cp.applyConstraint("nullable", isCollection || defaultNullable);
    }

    protected boolean canApplyNullableConstraint(String propertyName, PersistentProperty property, Constrained constrained) {
        if (property == null || property.getType() == null) {
            return false;
        }
        PersistentEntity domainClass = property.getOwner();
        if (!GroovyObject.class.isAssignableFrom(domainClass.getJavaClass())) {
            return false;
        }
        PersistentProperty versionProperty = domainClass.getVersion();
        boolean isVersion = versionProperty != null && versionProperty.equals(property);
        return !constrained.hasAppliedConstraint("nullable") && this.isConstrainableProperty(property, propertyName) && !isVersion;
    }

    protected void applyMapOfConstraints(Map<String, Object> constraints, String propertyName, PersistentProperty p, ConstrainedProperty cp) {
        for (Map.Entry<String, Object> entry : constraints.entrySet()) {
            String constraintName = entry.getKey();
            Object constrainingValue = entry.getValue();
            if (cp.hasAppliedConstraint(constraintName) || !cp.supportsContraint(constraintName)) continue;
            if ("nullable".equals(constraintName)) {
                if (!this.isConstrainableProperty(p, propertyName)) continue;
                cp.applyConstraint(constraintName, constrainingValue);
                continue;
            }
            cp.applyConstraint(constraintName, constrainingValue);
        }
    }

    protected boolean isConstrainableProperty(PersistentProperty p, String propertyName) {
        return !propertyName.equals("version") && !propertyName.equals("dateCreated") && !propertyName.equals("lastUpdated") && !(p instanceof Identity) && !p.getMapping().getMappedForm().isDerived() && (!(p instanceof ToOne) || !((ToOne)p).isBidirectional() || !((ToOne)p).isCircular());
    }
}

