/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints;

import java.util.List;
import org.grails.datastore.gorm.validation.constraints.AbstractConstraint;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;

public class InListConstraint
extends AbstractConstraint {
    protected final List<?> list;

    public InListConstraint(Class<?> constraintOwningClass, String constraintPropertyName, Object constraintParameter, MessageSource messageSource) {
        super(constraintOwningClass, constraintPropertyName, constraintParameter, messageSource);
        this.list = (List)constraintParameter;
    }

    public List<?> getList() {
        return this.list;
    }

    @Override
    public boolean supports(Class type) {
        return type != null;
    }

    @Override
    public String getName() {
        return "inList";
    }

    @Override
    protected Object validateParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof List)) {
            throw new IllegalArgumentException("Parameter for constraint [inList] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must implement the interface [java.util.List]");
        }
        return constraintParameter;
    }

    @Override
    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        if (!this.list.contains(propertyValue)) {
            Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue, this.list};
            this.rejectValue(target, errors, "default.not.inlist.message", "not.inList", args);
        }
    }
}

