/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.engine.codecs;

import com.mongodb.DBRef;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.persistence.FetchType;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.ObjectId;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.bson.codecs.BsonPersistentEntityCodec;
import org.grails.datastore.bson.codecs.PropertyDecoder;
import org.grails.datastore.bson.codecs.PropertyEncoder;
import org.grails.datastore.bson.codecs.decoders.EmbeddedCollectionDecoder;
import org.grails.datastore.bson.codecs.decoders.EmbeddedDecoder;
import org.grails.datastore.bson.codecs.encoders.EmbeddedCollectionEncoder;
import org.grails.datastore.bson.codecs.encoders.EmbeddedEncoder;
import org.grails.datastore.bson.codecs.encoders.IdentityEncoder;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.gorm.schemaless.DynamicAttributes;
import org.grails.datastore.mapping.collection.PersistentList;
import org.grails.datastore.mapping.collection.PersistentSet;
import org.grails.datastore.mapping.collection.PersistentSortedSet;
import org.grails.datastore.mapping.core.AbstractDatastore;
import org.grails.datastore.mapping.core.DatastoreException;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckableCollection;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.engine.internal.MappingUtils;
import org.grails.datastore.mapping.model.EmbeddedPersistentEntity;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.config.GormProperties;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.EmbeddedCollection;
import org.grails.datastore.mapping.model.types.Identity;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.ManyToOne;
import org.grails.datastore.mapping.model.types.OneToMany;
import org.grails.datastore.mapping.model.types.OneToOne;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.mongo.MongoCodecSession;
import org.grails.datastore.mapping.mongo.MongoConstants;
import org.grails.datastore.mapping.mongo.MongoDatastore;
import org.grails.datastore.mapping.mongo.config.MongoAttribute;
import org.grails.datastore.mapping.proxy.ProxyFactory;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.grails.datastore.mapping.reflect.FieldEntityAccess;

public class PersistentEntityCodec
extends BsonPersistentEntityCodec {
    private static final String BLANK_STRING = "";
    public static final String MONGO_SET_OPERATOR = "$set";
    public static final String MONGO_UNSET_OPERATOR = "$unset";
    public static final String DB_REF_ID_FIELD = "$id";
    public static final String SCHEMALESS_ATTRIBUTES = "schemaless.attributes";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PersistentEntityCodec(CodecRegistry codecRegistry, PersistentEntity entity, boolean stateful) {
        super(codecRegistry, entity, stateful);
    }

    @Generated
    public PersistentEntityCodec(CodecRegistry codecRegistry, PersistentEntity entity) {
        this(codecRegistry, entity, true);
    }

    static {
        BsonPersistentEntityCodec.registerEncoder(Identity.class, (PropertyEncoder)((PropertyEncoder)new 1()));
        BsonPersistentEntityCodec.registerEncoder(Embedded.class, (PropertyEncoder)((PropertyEncoder)new 2()));
        BsonPersistentEntityCodec.registerDecoder(Embedded.class, (PropertyDecoder)((PropertyDecoder)new 3()));
        BsonPersistentEntityCodec.registerEncoder(EmbeddedCollection.class, (PropertyEncoder)((PropertyEncoder)new 4()));
        BsonPersistentEntityCodec.registerDecoder(EmbeddedCollection.class, (PropertyDecoder)((PropertyDecoder)new 5()));
        BsonPersistentEntityCodec.registerEncoder(OneToOne.class, (PropertyEncoder)new ToOneEncoder());
        BsonPersistentEntityCodec.registerDecoder(OneToOne.class, (PropertyDecoder)new ToOneDecoder());
        BsonPersistentEntityCodec.registerEncoder(ManyToOne.class, (PropertyEncoder)new ToOneEncoder());
        BsonPersistentEntityCodec.registerDecoder(ManyToOne.class, (PropertyDecoder)new ToOneDecoder());
        BsonPersistentEntityCodec.registerEncoder(OneToMany.class, (PropertyEncoder)new OneToManyEncoder());
        BsonPersistentEntityCodec.registerDecoder(OneToMany.class, (PropertyDecoder)new OneToManyDecoder());
        BsonPersistentEntityCodec.registerEncoder(ManyToMany.class, (PropertyEncoder)new OneToManyEncoder());
        BsonPersistentEntityCodec.registerDecoder(ManyToMany.class, (PropertyDecoder)new OneToManyDecoder());
    }

    protected boolean isIdentifierProperty(String name) {
        return ScriptBytecodeAdapter.compareEqual((Object)MongoConstants.MONGO_ID_FIELD, (Object)name);
    }

    protected void readingComplete(EntityAccess access) {
        Reference access2 = new Reference((Object)access);
        public final class _readingComplete_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference access;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _readingComplete_closure1(Object _outerInstance, Object _thisObject, Reference access) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.access = reference = access;
            }

            public Object doCall(Session session) {
                return InvokerHelper.invokeMethodSafe((Object)((Object)((PersistentEntityCodec)((Object)this.getThisObject()))), (String)"decodeAssociations", (Object)new Object[]{session, this.access.get()});
            }

            public Object call(Session session) {
                return this.doCall(session);
            }

            @Generated
            public EntityAccess getAccess() {
                return (EntityAccess)ScriptBytecodeAdapter.castToType((Object)this.access.get(), EntityAccess.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _readingComplete_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        _readingComplete_closure1 callback = new _readingComplete_closure1((Object)this, (Object)this, access2);
        if (this.getEntity() instanceof EmbeddedPersistentEntity) {
            callback.call(AbstractDatastore.retrieveSession(MongoDatastore.class));
        } else {
            GormEnhancer.findStaticApi((Class)this.getEntity().getJavaClass()).withSession((Closure)callback);
        }
    }

    protected Object retrieveCachedInstance(EntityAccess access) {
        Reference access2 = new Reference((Object)access);
        public final class _retrieveCachedInstance_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference access;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _retrieveCachedInstance_closure2(Object _outerInstance, Object _thisObject, Reference access) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.access = reference = access;
            }

            public Object doCall(Session session) {
                Object cachedInstance = null;
                Session session2 = session;
                Boolean bl = session2 != null ? Boolean.valueOf(session2.contains(((EntityAccess)this.access.get()).getEntity())) : null;
                if (bl == null ? false : bl) {
                    Object object;
                    cachedInstance = object = session.retrieve(((EntityAccess)this.access.get()).getPersistentEntity().getJavaClass(), (Serializable)ScriptBytecodeAdapter.castToType((Object)((EntityAccess)this.access.get()).getIdentifier(), Serializable.class));
                }
                return cachedInstance;
            }

            public Object call(Session session) {
                return this.doCall(session);
            }

            @Generated
            public EntityAccess getAccess() {
                return (EntityAccess)ScriptBytecodeAdapter.castToType((Object)this.access.get(), EntityAccess.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _retrieveCachedInstance_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        _retrieveCachedInstance_closure2 callback = new _retrieveCachedInstance_closure2((Object)this, (Object)this, access2);
        if (this.getEntity() instanceof EmbeddedPersistentEntity) {
            return callback.call(AbstractDatastore.retrieveSession(MongoDatastore.class));
        }
        return GormEnhancer.findStaticApi((Class)this.getEntity().getJavaClass()).withSession((Closure)callback);
    }

    protected void decodeAssociations(Session mongoSession, EntityAccess access) {
        if (mongoSession != null) {
            Object association2 = null;
            for (Object association2 : this.getEntity().getAssociations()) {
                if (association2 instanceof OneToMany) {
                    if (!((Association)association2).isBidirectional()) continue;
                    OneToManyDecoder.initializePersistentCollection(mongoSession, access, (Association)ScriptBytecodeAdapter.castToType(association2, Association.class));
                    continue;
                }
                if (!(association2 instanceof OneToOne) || !((ToOne)ScriptBytecodeAdapter.castToType(association2, ToOne.class)).isForeignKeyInChild()) continue;
                Class associatedClass = ((Association)association2).getAssociatedEntity().getJavaClass();
                Query query = mongoSession.createQuery(associatedClass);
                query.eq(((Association)association2).getInverseSide().getName(), access.getIdentifier()).projections().id();
                Object id = query.singleResult();
                boolean lazy = ScriptBytecodeAdapter.compareEqual((Object)((Association)association2).getMapping().getMappedForm().getFetchStrategy(), (Object)FetchType.LAZY);
                access.setPropertyNoConversion(((Association)association2).getName(), lazy ? mongoSession.proxy(associatedClass, (Serializable)ScriptBytecodeAdapter.castToType((Object)id, Serializable.class)) : mongoSession.retrieve(associatedClass, (Serializable)ScriptBytecodeAdapter.castToType((Object)id, Serializable.class)));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Document encodeUpdate(Object value, EntityAccess access, EncoderContext encoderContext, boolean embedded) {
        void var3_3;
        Reference value2 = new Reference(value);
        Reference encoderContext2 = new Reference((Object)var3_3);
        Document update = new Document();
        PersistentEntity entity = access.getPersistentEntity();
        ProxyFactory proxyFactory = this.getMappingContext().getProxyFactory();
        if (proxyFactory.isProxy(value2.get())) {
            Object object = proxyFactory.unwrap(value2.get());
            value2.set(object);
        }
        if (value2.get() instanceof DirtyCheckable) {
            BsonDocument sets = new BsonDocument();
            Reference unsets = new Reference((Object)new Document());
            Reference writer = new Reference((Object)new BsonDocumentWriter(sets));
            ((BsonDocumentWriter)writer.get()).writeStartDocument();
            DirtyCheckable dirty = (DirtyCheckable)ScriptBytecodeAdapter.castToType((Object)value2.get(), DirtyCheckable.class);
            Set processed = (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
            List dirtyProperties = new ArrayList(dirty.listDirtyPropertyNames());
            boolean isNew = ((ArrayList)ScriptBytecodeAdapter.castToType(dirtyProperties, ArrayList.class)).isEmpty() && dirty.hasChanged();
            boolean isVersioned = entity.isVersioned();
            if (isNew) {
                List list = entity.getPersistentPropertyNames();
                dirtyProperties = list;
                if (!entity.isRoot()) {
                    sets.put(MongoConstants.MONGO_CLASS_FIELD, (BsonValue)new BsonString(entity.getDiscriminator()));
                }
                if (isVersioned) {
                    EntityPersister.incrementEntityVersion((EntityAccess)access);
                }
            } else if (entity.getPropertyByName(GormProperties.LAST_UPDATED) != null) {
                ((ArrayList)ScriptBytecodeAdapter.castToType(dirtyProperties, ArrayList.class)).add(GormProperties.LAST_UPDATED);
            }
            Object propertyName2 = null;
            for (Object propertyName2 : dirtyProperties) {
                PersistentProperty prop = entity.getPropertyByName(ShortTypeHandling.castToString(propertyName2));
                if (!(prop != null)) continue;
                DefaultGroovyMethods.leftShift((Set)processed, propertyName2);
                Object v = access.getProperty(prop.getName());
                if (v != null) {
                    Object v0;
                    if (prop instanceof Embedded) {
                        this.encodeEmbeddedUpdate(sets, (Document)unsets.get(), (Association)ScriptBytecodeAdapter.castToType((Object)prop, Association.class), v);
                        continue;
                    }
                    if (prop instanceof EmbeddedCollection) {
                        this.encodeEmbeddedCollectionUpdate(access, sets, (Document)unsets.get(), (Association)ScriptBytecodeAdapter.castToType((Object)prop, Association.class), v);
                        continue;
                    }
                    Class<?> propKind = prop.getClass().getSuperclass();
                    PropertyEncoder propertyEncoder = this.getPropertyEncoder(propKind);
                    PropertyEncoder propertyEncoder2 = propertyEncoder;
                    if (propertyEncoder2 != null) {
                        propertyEncoder2.encode((BsonWriter)((BsonDocumentWriter)writer.get()), prop, v, access, (EncoderContext)encoderContext2.get(), this.getCodecRegistry());
                        v0 = null;
                        continue;
                    }
                    v0 = null;
                    continue;
                }
                if (!(embedded || !isNew)) continue;
                String string = BLANK_STRING;
                ScriptBytecodeAdapter.invokeMethodN(PersistentEntityCodec.class, (Object)((Document)unsets.get()), (String)"putAt", (Object[])new Object[]{prop.getName(), string});
            }
            if (value2.get() instanceof DynamicAttributes) {
                Map attributes = ((DynamicAttributes)ScriptBytecodeAdapter.castToType((Object)value2.get(), DynamicAttributes.class)).attributes();
                Object attr2 = null;
                for (Object attr2 : attributes.keySet()) {
                    Object v = attributes.get(attr2);
                    if (v == null) {
                        ((Document)unsets.get()).put(ShortTypeHandling.castToString(attr2), (Object)BLANK_STRING);
                        continue;
                    }
                    ((BsonDocumentWriter)writer.get()).writeName(ShortTypeHandling.castToString(attr2));
                    Codec codec = this.getCodecRegistry().get(v.getClass());
                    codec.encode((BsonWriter)((BsonDocumentWriter)writer.get()), v, (EncoderContext)encoderContext2.get());
                }
            } else {
                public final class _encodeUpdate_closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference value;
                    private /* synthetic */ Reference unsets;
                    private /* synthetic */ Reference writer;
                    private /* synthetic */ Reference encoderContext;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _encodeUpdate_closure3(Object _outerInstance, Object _thisObject, Reference value, Reference unsets, Reference writer, Reference encoderContext) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        this.value = reference4 = value;
                        this.unsets = reference3 = unsets;
                        this.writer = reference2 = writer;
                        this.encoderContext = reference = encoderContext;
                    }

                    public Object doCall(Session mongoSession) {
                        if (mongoSession != null) {
                            Document schemaless = (Document)ScriptBytecodeAdapter.castToType((Object)mongoSession.getAttribute(this.value.get(), ShortTypeHandling.castToString((Object)ScriptBytecodeAdapter.getField(_encodeUpdate_closure3.class, PersistentEntityCodec.class, (String)"SCHEMALESS_ATTRIBUTES"))), Document.class);
                            if (schemaless != null) {
                                Object name2 = null;
                                for (Object name2 : schemaless.keySet()) {
                                    Object v = schemaless.get(name2);
                                    if (v == null) {
                                        ((Document)this.unsets.get()).put(ShortTypeHandling.castToString(name2), ScriptBytecodeAdapter.getField(_encodeUpdate_closure3.class, PersistentEntityCodec.class, (String)"BLANK_STRING"));
                                        continue;
                                    }
                                    ((BsonDocumentWriter)this.writer.get()).writeName(ShortTypeHandling.castToString(name2));
                                    Codec codec = ((PersistentEntityCodec)((BsonPersistentEntityCodec)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), BsonPersistentEntityCodec.class))).getCodecRegistry().get(v.getClass());
                                    codec.encode((BsonWriter)ScriptBytecodeAdapter.castToType((Object)this.writer.get(), BsonWriter.class), v, (EncoderContext)ScriptBytecodeAdapter.castToType((Object)this.encoderContext.get(), EncoderContext.class));
                                }
                                return null;
                            }
                            return null;
                        }
                        return null;
                    }

                    public Object call(Session mongoSession) {
                        return this.doCall(mongoSession);
                    }

                    @Generated
                    public Object getValue() {
                        return this.value.get();
                    }

                    @Generated
                    public Object getUnsets() {
                        return this.unsets.get();
                    }

                    @Generated
                    public BsonWriter getWriter() {
                        return (BsonWriter)ScriptBytecodeAdapter.castToType((Object)this.writer.get(), BsonWriter.class);
                    }

                    @Generated
                    public EncoderContext getEncoderContext() {
                        return (EncoderContext)ScriptBytecodeAdapter.castToType((Object)this.encoderContext.get(), EncoderContext.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _encodeUpdate_closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                GormEnhancer.findStaticApi((Class)entity.getJavaClass()).withSession((Closure)new _encodeUpdate_closure3((Object)this, (Object)this, value2, unsets, writer, encoderContext2));
            }
            Object association2 = null;
            for (Object association2 : entity.getAssociations()) {
                if (processed.contains(((Association)association2).getName())) continue;
                if (association2 instanceof OneToMany) {
                    Object v = access.getProperty(((Association)association2).getName());
                    if (!(v != null)) continue;
                }
                if (association2 instanceof ToOne) {
                    Object v = access.getProperty(((Association)association2).getName());
                    if (!(v instanceof DirtyCheckable) || !((DirtyCheckable)ScriptBytecodeAdapter.castToType((Object)v, DirtyCheckable.class)).hasChanged() || !(association2 instanceof Embedded)) continue;
                    this.encodeEmbeddedUpdate(sets, (Document)unsets.get(), (Association)ScriptBytecodeAdapter.castToType(association2, Association.class), v);
                    continue;
                }
                if (!(association2 instanceof EmbeddedCollection)) continue;
                Object v = access.getProperty(((Association)association2).getName());
                if (!(v instanceof DirtyCheckableCollection) || !((DirtyCheckableCollection)ScriptBytecodeAdapter.castToType((Object)v, DirtyCheckableCollection.class)).hasChanged()) continue;
                this.encodeEmbeddedCollectionUpdate(access, sets, (Document)unsets.get(), (Association)ScriptBytecodeAdapter.castToType(association2, Association.class), v);
            }
            boolean hasSets = !sets.isEmpty();
            boolean hasUnsets = !((Document)unsets.get()).isEmpty();
            if (hasSets && isVersioned) {
                Object v1;
                PersistentProperty version = entity.getVersion();
                Class<?> propKind = version.getClass().getSuperclass();
                EntityPersister.incrementEntityVersion((EntityAccess)access);
                Object v = access.getProperty(version.getName());
                PropertyEncoder propertyEncoder = this.getPropertyEncoder(propKind);
                if (propertyEncoder != null) {
                    propertyEncoder.encode((BsonWriter)((BsonDocumentWriter)writer.get()), version, v, access, (EncoderContext)encoderContext2.get(), this.getCodecRegistry());
                    v1 = null;
                } else {
                    v1 = null;
                }
            }
            ((BsonDocumentWriter)writer.get()).writeEndDocument();
            if (hasSets) {
                update.put(MONGO_SET_OPERATOR, (Object)sets);
            }
            if (hasUnsets) {
                update.put(MONGO_UNSET_OPERATOR, (Object)((Document)unsets.get()));
            }
        }
        return update;
    }

    protected String getDiscriminatorAttributeName() {
        return MongoConstants.MONGO_CLASS_FIELD;
    }

    protected void encodeEmbeddedCollectionUpdate(EntityAccess parentAccess, BsonDocument sets, Document unsets, Association association, Object v) {
        if (v instanceof Collection) {
            if (v instanceof DirtyCheckableCollection && !((DirtyCheckableCollection)ScriptBytecodeAdapter.castToType((Object)v, DirtyCheckableCollection.class)).hasChangedSize()) {
                int i = 0;
                Object o = null;
                Iterator iterator = DefaultGroovyMethods.iterator((Object)v);
                while (iterator.hasNext()) {
                    o = iterator.next();
                    Document embeddedUpdate = this.encodeUpdate(o, this.createEntityAccess(o), EncoderContext.builder().build(), true);
                    Object embeddedSets = embeddedUpdate.get((Object)MONGO_SET_OPERATOR);
                    if (embeddedSets != null) {
                        Map map = (Map)ScriptBytecodeAdapter.castToType((Object)embeddedSets, Map.class);
                        Object key2 = null;
                        for (Object key2 : map.keySet()) {
                            sets.put(new GStringImpl(new Object[]{association.getName(), i, key2}, new String[]{BLANK_STRING, ".", ".", BLANK_STRING}).toString(), (BsonValue)ScriptBytecodeAdapter.castToType(map.get(key2), BsonValue.class));
                        }
                    }
                    Object embeddedUnsets = embeddedUpdate.get((Object)MONGO_UNSET_OPERATOR);
                    if (DefaultTypeTransformation.booleanUnbox((Object)embeddedUnsets)) {
                        Map map = (Map)ScriptBytecodeAdapter.castToType((Object)embeddedUnsets, Map.class);
                        Object key3 = null;
                        for (Object key3 : map.keySet()) {
                            unsets.put(new GStringImpl(new Object[]{association.getName(), i, key3}, new String[]{BLANK_STRING, ".", ".", BLANK_STRING}).toString(), (Object)BLANK_STRING);
                        }
                    }
                    int n = i;
                    int cfr_ignored_0 = n + 1;
                }
            } else {
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                Class rootClass = associatedEntity.getJavaClass();
                PersistentEntityCodec entityCodec = (PersistentEntityCodec)((Object)ScriptBytecodeAdapter.castToType((Object)this.getCodecRegistry().get(rootClass), PersistentEntityCodec.class));
                Association inverseProperty = association.getInverseSide();
                List documents = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                Object o = null;
                Iterator iterator = DefaultGroovyMethods.iterator((Object)v);
                while (iterator.hasNext()) {
                    o = iterator.next();
                    if (o == null) {
                        DefaultGroovyMethods.leftShift((List)documents, null);
                        continue;
                    }
                    PersistentEntity entity = associatedEntity;
                    PersistentEntityCodec codec = entityCodec;
                    Class<?> cls = o.getClass();
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)rootClass, cls)) {
                        PersistentEntityCodec persistentEntityCodec;
                        PersistentEntity persistentEntity;
                        entity = persistentEntity = this.getMappingContext().getPersistentEntity(cls.getName());
                        if (entity == null) {
                            throw (Throwable)new DatastoreException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{o, association}, new String[]{"Value [", "] is not a valid type for association [", "]"})));
                        }
                        codec = persistentEntityCodec = (PersistentEntityCodec)((Object)ScriptBytecodeAdapter.castToType((Object)this.getCodecRegistry().get(cls), PersistentEntityCodec.class));
                    }
                    EntityAccess ea = this.createEntityAccess(entity, o);
                    if (inverseProperty != null && inverseProperty instanceof ToOne) {
                        ea.setPropertyNoConversion(inverseProperty.getName(), parentAccess.getEntity());
                    }
                    BsonDocument doc = new BsonDocument();
                    Object id = ea.getIdentifier();
                    codec.encode((BsonWriter)new BsonDocumentWriter(doc), o, BsonPersistentEntityCodec.DEFAULT_ENCODER_CONTEXT, id != null);
                    documents.add(doc);
                }
                BsonArray bsonArray = new BsonArray(documents);
                sets.put(association.getName(), (BsonValue)bsonArray);
            }
        }
    }

    protected void encodeEmbeddedUpdate(BsonDocument sets, Document unsets, Association association, Object v) {
        if (v instanceof DirtyCheckable) {
            ((DirtyCheckable)v).markDirty();
        }
        Document embeddedUpdate = this.encodeUpdate(v);
        Object embeddedSets = embeddedUpdate.get((Object)MONGO_SET_OPERATOR);
        if (embeddedSets != null) {
            Map map = (Map)ScriptBytecodeAdapter.castToType((Object)embeddedSets, Map.class);
            Object key2 = null;
            for (Object key2 : map.keySet()) {
                sets.put(new GStringImpl(new Object[]{association.getName(), key2}, new String[]{BLANK_STRING, ".", BLANK_STRING}).toString(), (BsonValue)ScriptBytecodeAdapter.castToType(map.get(key2), BsonValue.class));
            }
        }
        Object embeddedUnsets = embeddedUpdate.get((Object)MONGO_UNSET_OPERATOR);
        if (DefaultTypeTransformation.booleanUnbox((Object)embeddedUnsets)) {
            Map map = (Map)ScriptBytecodeAdapter.castToType((Object)embeddedUnsets, Map.class);
            Object key3 = null;
            for (Object key3 : map.keySet()) {
                unsets.put(new GStringImpl(new Object[]{association.getName(), key3}, new String[]{BLANK_STRING, ".", BLANK_STRING}).toString(), (Object)BLANK_STRING);
            }
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != PersistentEntityCodec.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(PersistentEntityCodec.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{BLANK_STRING, BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, PersistentEntityCodec.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{BLANK_STRING, BLANK_STRING})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(PersistentEntityCodec.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{BLANK_STRING, BLANK_STRING})));
    }

    public static /* synthetic */ String pfaccess$0(PersistentEntityCodec $that) {
        return ShortTypeHandling.castToString((Object)ScriptBytecodeAdapter.getField(PersistentEntityCodec.class, PersistentEntityCodec.class, (String)"BLANK_STRING"));
    }

    /*
     * WARNING - void declaration
     */
    @Generated
    public Document encodeUpdate(Object value, EntityAccess access, EncoderContext encoderContext) {
        void var3_3;
        Reference value2 = new Reference(value);
        Reference encoderContext2 = new Reference((Object)var3_3);
        return this.encodeUpdate(value2.get(), access, (EncoderContext)encoderContext2.get(), false);
    }

    @Generated
    public Document encodeUpdate(Object value, EntityAccess access) {
        Reference value2 = new Reference(value);
        return this.encodeUpdate(value2.get(), access, BsonPersistentEntityCodec.DEFAULT_ENCODER_CONTEXT, false);
    }

    @Generated
    public Document encodeUpdate(Object value) {
        Reference value2 = new Reference(value);
        return this.encodeUpdate(value2.get(), this.createEntityAccess(value2.get()), BsonPersistentEntityCodec.DEFAULT_ENCODER_CONTEXT, false);
    }

    public class 1
    extends IdentityEncoder {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        /* synthetic */ 1() {
        }

        protected String getIdentifierName(Identity property) {
            return MongoConstants.MONGO_ID_FIELD;
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(1.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(1.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(1.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(1.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != 1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public class 2
    extends EmbeddedEncoder {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        /* synthetic */ 2() {
        }

        protected BsonPersistentEntityCodec createEmbeddedEntityCodec(CodecRegistry codecRegistry, PersistentEntity associatedEntity) {
            return new PersistentEntityCodec(codecRegistry, associatedEntity);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(2.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(2.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(2.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(2.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != 2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public class 3
    extends EmbeddedDecoder {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        /* synthetic */ 3() {
        }

        protected BsonPersistentEntityCodec createEmbeddedEntityCodec(CodecRegistry codecRegistry, PersistentEntity associatedEntity) {
            return new PersistentEntityCodec(codecRegistry, associatedEntity);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(3.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(3.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(3.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(3.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != 3.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public class 4
    extends EmbeddedCollectionEncoder {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        /* synthetic */ 4() {
        }

        protected BsonPersistentEntityCodec createEmbeddedEntityCodec(CodecRegistry codecRegistry, PersistentEntity associatedEntity) {
            return new PersistentEntityCodec(codecRegistry, associatedEntity);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(4.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(4.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(4.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(4.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != 4.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public class 5
    extends EmbeddedCollectionDecoder {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        /* synthetic */ 5() {
        }

        protected BsonPersistentEntityCodec createEmbeddedEntityCodec(CodecRegistry codecRegistry, PersistentEntity associatedEntity) {
            return new PersistentEntityCodec(codecRegistry, associatedEntity);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(5.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(5.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(5.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(5.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != 5.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public static class OneToManyDecoder
    implements PropertyDecoder<Association>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public OneToManyDecoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void decode(BsonReader reader, Association property, EntityAccess entityAccess, DecoderContext decoderContext, CodecRegistry codecRegistry) {
            Session session = AbstractDatastore.retrieveSession(MongoDatastore.class);
            if (property.isBidirectional() && !(property instanceof ManyToMany)) {
                OneToManyDecoder.initializePersistentCollection(session, entityAccess, property);
            } else {
                Class type = property.getType();
                String propertyName = property.getName();
                Codec listCodec = codecRegistry.get(List.class);
                List identifiers = (List)ScriptBytecodeAdapter.castToType((Object)listCodec.decode(reader, decoderContext), List.class);
                MongoAttribute attr = (MongoAttribute)((Object)ScriptBytecodeAdapter.castToType((Object)property.getMapping().getMappedForm(), MongoAttribute.class));
                MongoAttribute mongoAttribute = attr;
                Boolean bl = mongoAttribute != null ? Boolean.valueOf(mongoAttribute.isReference()) : null;
                if (bl == null ? false : bl) {
                    List list;
                    public final class _decode_closure1
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _decode_closure1(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            if (it instanceof DBRef) {
                                return ((DBRef)ScriptBytecodeAdapter.castToType((Object)it, DBRef.class)).getId();
                            }
                            if (it instanceof Map) {
                                return ((Map)ScriptBytecodeAdapter.castToType((Object)it, Map.class)).get(ScriptBytecodeAdapter.getField(_decode_closure1.class, PersistentEntityCodec.class, (String)"DB_REF_ID_FIELD"));
                            }
                            return it;
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _decode_closure1.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    identifiers = list = DefaultGroovyMethods.collect((Iterable)identifiers, (Closure)new _decode_closure1(this, this));
                }
                Class associatedType = property.getAssociatedEntity().getJavaClass();
                if (SortedSet.class.isAssignableFrom(type)) {
                    entityAccess.setPropertyNoConversion(propertyName, (Object)new PersistentSortedSet((Collection)identifiers, associatedType, session));
                } else if (Set.class.isAssignableFrom(type)) {
                    entityAccess.setPropertyNoConversion(propertyName, (Object)new PersistentSet((Collection)identifiers, associatedType, session));
                } else {
                    entityAccess.setPropertyNoConversion(propertyName, (Object)new PersistentList((Collection)identifiers, associatedType, session));
                }
            }
        }

        public static Object initializePersistentCollection(Session session, EntityAccess entityAccess, Association property) {
            Class type = property.getType();
            String propertyName = property.getName();
            Serializable identifier = (Serializable)ScriptBytecodeAdapter.castToType((Object)entityAccess.getIdentifier(), Serializable.class);
            if (SortedSet.class.isAssignableFrom(type)) {
                entityAccess.setPropertyNoConversion(propertyName, (Object)new PersistentSortedSet(property, identifier, session));
                return null;
            }
            if (Set.class.isAssignableFrom(type)) {
                entityAccess.setPropertyNoConversion(propertyName, (Object)new PersistentSet(property, identifier, session));
                return null;
            }
            entityAccess.setPropertyNoConversion(propertyName, (Object)new PersistentList(property, identifier, session));
            return null;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != OneToManyDecoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(OneToManyDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(OneToManyDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(OneToManyDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(OneToManyDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }

    public static class OneToManyEncoder
    implements PropertyEncoder<Association>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public OneToManyEncoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void encode(BsonWriter writer, Association property, Object value, EntityAccess parentAccess, EncoderContext encoderContext, CodecRegistry codecRegistry) {
            boolean shouldEncodeIds = !property.isBidirectional() || property instanceof ManyToMany;
            MongoCodecSession mongoSession = (MongoCodecSession)((Object)ScriptBytecodeAdapter.castToType((Object)AbstractDatastore.retrieveSession(MongoDatastore.class), MongoCodecSession.class));
            if (shouldEncodeIds) {
                PersistentEntity associatedEntity = property.getAssociatedEntity();
                if (value instanceof Collection) {
                    boolean updateCollection = false;
                    if (value instanceof DirtyCheckableCollection) {
                        boolean bl;
                        DirtyCheckableCollection persistentCollection = (DirtyCheckableCollection)ScriptBytecodeAdapter.castToType((Object)value, DirtyCheckableCollection.class);
                        updateCollection = bl = persistentCollection.hasChanged();
                    } else {
                        boolean bl;
                        updateCollection = bl = true;
                    }
                    if (updateCollection) {
                        Collection identifiers = (Collection)ScriptBytecodeAdapter.castToType((Object)mongoSession.getAttribute(parentAccess.getEntity(), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{property}, new String[]{PersistentEntityCodec.BLANK_STRING, ".ids"}))), Collection.class);
                        if (identifiers == null) {
                            Reference entityReflector = new Reference((Object)FieldEntityAccess.getOrIntializeReflector((PersistentEntity)associatedEntity));
                            public final class _encode_closure1
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference entityReflector;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _encode_closure1(Object _outerInstance, Object _thisObject, Reference entityReflector) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    this.entityReflector = reference = entityReflector;
                                }

                                public Object doCall(Object it) {
                                    return ((EntityReflector)this.entityReflector.get()).getIdentifier(it);
                                }

                                @Generated
                                public Object getEntityReflector() {
                                    return this.entityReflector.get();
                                }

                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                public Object call() {
                                    return this.doCall(null);
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _encode_closure1.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            List list = DefaultGroovyMethods.collect((Iterable)((Collection)ScriptBytecodeAdapter.castToType((Object)value, Collection.class)), (Closure)new _encode_closure1(this, this, entityReflector));
                            identifiers = list;
                        }
                        writer.writeName(MappingUtils.getTargetKey((PersistentProperty)((PersistentProperty)property)));
                        Codec listCodec = codecRegistry.get(List.class);
                        List identifierList = DefaultGroovyMethods.toList((Iterable)identifiers);
                        MongoAttribute attr = (MongoAttribute)((Object)ScriptBytecodeAdapter.castToType((Object)property.getMapping().getMappedForm(), MongoAttribute.class));
                        MongoAttribute mongoAttribute = attr;
                        Boolean bl = mongoAttribute != null ? Boolean.valueOf(mongoAttribute.isReference()) : null;
                        if (bl == null ? false : bl) {
                            List list;
                            Reference collectionName = new Reference((Object)mongoSession.getCollectionName(property.getAssociatedEntity()));
                            public final class _encode_closure2
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _encode_closure2(Object _outerInstance, Object _thisObject) {
                                    super(_outerInstance, _thisObject);
                                }

                                public Object doCall(Object it) {
                                    return it != null;
                                }

                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                public Object call() {
                                    return this.doCall(null);
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _encode_closure2.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            public final class _encode_closure3
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference collectionName;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _encode_closure3(Object _outerInstance, Object _thisObject, Reference collectionName) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    this.collectionName = reference = collectionName;
                                }

                                public Object doCall(Object it) {
                                    return new DBRef(ShortTypeHandling.castToString((Object)this.collectionName.get()), it);
                                }

                                @Generated
                                public Object getCollectionName() {
                                    return this.collectionName.get();
                                }

                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                public Object call() {
                                    return this.doCall(null);
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _encode_closure3.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            identifierList = list = DefaultGroovyMethods.collect((Iterable)DefaultGroovyMethods.findAll((List)identifierList, (Closure)new _encode_closure2(this, this)), (Closure)new _encode_closure3(this, this, collectionName));
                        }
                        listCodec.encode(writer, (Object)identifierList, encoderContext);
                    }
                }
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != OneToManyEncoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(OneToManyEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(OneToManyEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(OneToManyEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(OneToManyEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }

    public static class ToOneEncoder
    implements PropertyEncoder<ToOne>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public ToOneEncoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void encode(BsonWriter writer, ToOne property, Object value, EntityAccess parentAccess, EncoderContext encoderContext, CodecRegistry codecRegistry) {
            if (DefaultTypeTransformation.booleanUnbox((Object)value)) {
                PersistentEntity associatedEntity = property.getAssociatedEntity();
                Serializable associationId = null;
                if (!property.isForeignKeyInChild()) {
                    MappingContext mappingContext = parentAccess.getPersistentEntity().getMappingContext();
                    ProxyFactory proxyFactory = mappingContext.getProxyFactory();
                    if (proxyFactory.isProxy(value)) {
                        Serializable serializable;
                        associationId = serializable = proxyFactory.getIdentifier(value);
                    } else {
                        Serializable serializable;
                        EntityReflector associationAccess = mappingContext.getEntityReflector(associatedEntity);
                        associationId = serializable = associationAccess.getIdentifier(value);
                    }
                    if (associationId != null) {
                        writer.writeName(MappingUtils.getTargetKey((PersistentProperty)property));
                        MongoAttribute attr = (MongoAttribute)((Object)ScriptBytecodeAdapter.castToType((Object)property.getMapping().getMappedForm(), MongoAttribute.class));
                        MongoAttribute mongoAttribute = attr;
                        Boolean bl = mongoAttribute != null ? Boolean.valueOf(mongoAttribute.isReference()) : null;
                        if (bl == null ? false : bl) {
                            Codec identityEncoder = codecRegistry.get(DBRef.class);
                            MongoCodecSession mongoSession = (MongoCodecSession)((Object)ScriptBytecodeAdapter.castToType((Object)AbstractDatastore.retrieveSession(MongoDatastore.class), MongoCodecSession.class));
                            DBRef ref = new DBRef(mongoSession.getCollectionName(associatedEntity), (Object)associationId);
                            identityEncoder.encode(writer, (Object)ref, encoderContext);
                        } else {
                            Codec identityEncoder = codecRegistry.get(associationId.getClass());
                            identityEncoder.encode(writer, (Object)associationId, encoderContext);
                        }
                    }
                }
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ToOneEncoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ToOneEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ToOneEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ToOneEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ToOneEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }

    public static class ToOneDecoder
    implements PropertyDecoder<ToOne>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public ToOneDecoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void decode(BsonReader bsonReader, ToOne property, EntityAccess entityAccess, DecoderContext decoderContext, CodecRegistry codecRegistry) {
            MongoCodecSession mongoSession = (MongoCodecSession)((Object)ScriptBytecodeAdapter.castToType((Object)AbstractDatastore.retrieveSession(MongoDatastore.class), MongoCodecSession.class));
            MongoAttribute attr = (MongoAttribute)((Object)ScriptBytecodeAdapter.castToType((Object)property.getMapping().getMappedForm(), MongoAttribute.class));
            boolean isLazy = this.isLazyAssociation(attr);
            PersistentEntity associatedEntity = property.getAssociatedEntity();
            if (associatedEntity == null) {
                bsonReader.skipValue();
                return;
            }
            Object associationId = null;
            if (attr.getReference() && ScriptBytecodeAdapter.compareEqual((Object)bsonReader.getCurrentBsonType(), (Object)BsonType.DOCUMENT)) {
                Codec dbRefCodec = codecRegistry.get(Document.class);
                Document dBRef = (Document)ScriptBytecodeAdapter.castToType((Object)dbRefCodec.decode(bsonReader, decoderContext), Document.class);
                Serializable serializable = (Serializable)ScriptBytecodeAdapter.castToType((Object)dBRef.get(ScriptBytecodeAdapter.getField(ToOneDecoder.class, PersistentEntityCodec.class, (String)"DB_REF_ID_FIELD")), Serializable.class);
                associationId = serializable;
            } else {
                Class clazz = associatedEntity.getIdentity().getType();
                if (ScriptBytecodeAdapter.isCase((Object)clazz, ObjectId.class)) {
                    ObjectId objectId;
                    associationId = objectId = bsonReader.readObjectId();
                } else if (ScriptBytecodeAdapter.isCase((Object)clazz, Long.class)) {
                    Long l = bsonReader.readInt64();
                    associationId = l;
                } else if (ScriptBytecodeAdapter.isCase((Object)clazz, Integer.class)) {
                    Integer n = bsonReader.readInt32();
                    associationId = n;
                } else {
                    String string = bsonReader.readString();
                    associationId = string;
                }
            }
            if (isLazy) {
                entityAccess.setPropertyNoConversion(property.getName(), mongoSession.proxy(associatedEntity.getJavaClass(), (Serializable)associationId));
            } else {
                entityAccess.setPropertyNoConversion(property.getName(), mongoSession.retrieve(associatedEntity.getJavaClass(), (Serializable)associationId));
            }
        }

        private boolean isLazyAssociation(MongoAttribute attribute) {
            if (attribute == null) {
                return true;
            }
            return ScriptBytecodeAdapter.compareEqual((Object)attribute.getFetchStrategy(), (Object)FetchType.LAZY);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ToOneDecoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ToOneDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ToOneDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ToOneDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ToOneDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }
}

