/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.connections;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.mapping.config.ConfigurationBuilder;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.mongo.config.MongoSettings;
import org.grails.datastore.mapping.mongo.connections.AbstractMongoConnectionSourceSettings;
import org.grails.datastore.mapping.mongo.connections.MongoConnectionSourceSettings;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.ReflectionUtils;

public class MongoConnectionSourceSettingsBuilder
extends ConfigurationBuilder<MongoConnectionSourceSettings, MongoConnectionSourceSettings> {
    private MongoClientSettings.Builder clientOptionsBuilder;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public MongoConnectionSourceSettingsBuilder(PropertyResolver propertyResolver, String configurationPrefix, ConnectionSourceSettings fallback) {
        super(propertyResolver, configurationPrefix, (Object)fallback);
    }

    public MongoConnectionSourceSettingsBuilder(PropertyResolver propertyResolver) {
        super(propertyResolver, MongoSettings.PREFIX);
    }

    public MongoConnectionSourceSettingsBuilder(PropertyResolver propertyResolver, MongoConnectionSourceSettings fallback) {
        super(propertyResolver, MongoSettings.PREFIX, (Object)fallback);
    }

    protected MongoConnectionSourceSettings createBuilder() {
        return new MongoConnectionSourceSettings();
    }

    protected MongoConnectionSourceSettings toConfiguration(MongoConnectionSourceSettings builder) {
        return builder;
    }

    protected void newChildBuilder(Object builder, String configurationPath) {
        if (builder instanceof MongoClientSettings.Builder) {
            MongoClientSettings.Builder builder2;
            this.clientOptionsBuilder = builder2 = (MongoClientSettings.Builder)ScriptBytecodeAdapter.castToType((Object)builder, MongoClientSettings.Builder.class);
        }
        this.applyConnectionString(builder);
        this.applyCredentials(builder);
    }

    public Object newChildBuilderForFallback(Object childBuilder, Object fallbackConfig) {
        if (childBuilder instanceof MongoClientSettings.Builder && fallbackConfig instanceof MongoClientSettings.Builder) {
            return MongoClientSettings.builder((MongoClientSettings)((MongoClientSettings.Builder)ScriptBytecodeAdapter.castToType((Object)fallbackConfig, MongoClientSettings.Builder.class)).build());
        }
        return childBuilder;
    }

    protected void startBuild(Object builder, String configurationPath) {
        this.applyCredentials(builder);
        this.applyConnectionString(builder);
    }

    protected void applyCredentials(Object builder) {
        Method credentialListMethod = ReflectionUtils.findMethod(builder.getClass(), (String)"credentialList", (Class[])new Class[]{List.class});
        if (credentialListMethod != null) {
            String username = ((AbstractMongoConnectionSourceSettings)this.rootBuilder).getUsername();
            String password = ((AbstractMongoConnectionSourceSettings)this.rootBuilder).getPassword();
            String databaseName = ((AbstractMongoConnectionSourceSettings)this.rootBuilder).getDatabase();
            if (username != null && password != null) {
                MongoCredential credential = MongoCredential.createCredential((String)username, (String)databaseName, (char[])password.toCharArray());
                credentialListMethod.invoke(builder, Arrays.asList(credential));
            }
        }
    }

    protected void applyConnectionString(Object builder) {
        Method applyConnectionStringMethod = ReflectionUtils.findMethod(builder.getClass(), (String)"applyConnectionString", (Class[])new Class[]{ConnectionString.class});
        if (applyConnectionStringMethod != null) {
            ConnectionString connectionString = ((AbstractMongoConnectionSourceSettings)this.rootBuilder).getUrl();
            if (connectionString == null) {
                ConnectionString connectionString2;
                String username = ((AbstractMongoConnectionSourceSettings)this.rootBuilder).getUsername();
                String password = ((AbstractMongoConnectionSourceSettings)this.rootBuilder).getPassword();
                String host = ((AbstractMongoConnectionSourceSettings)this.rootBuilder).getHost();
                Integer port = ((AbstractMongoConnectionSourceSettings)this.rootBuilder).getPort();
                String databaseName = ((AbstractMongoConnectionSourceSettings)this.rootBuilder).getDatabaseName();
                String uAndP = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)username) && DefaultTypeTransformation.booleanUnbox((Object)password) ? new GStringImpl(new Object[]{username, password}, new String[]{"", ":", "@"}) : ""));
                connectionString = connectionString2 = new ConnectionString(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{uAndP, host, port, databaseName}, new String[]{"mongodb://", "", ":", "/", ""})));
            }
            applyConnectionStringMethod.invoke(builder, connectionString);
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != MongoConnectionSourceSettingsBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public MongoClientSettings.Builder getClientOptionsBuilder() {
        return this.clientOptionsBuilder;
    }

    @Generated
    public void setClientOptionsBuilder(MongoClientSettings.Builder builder) {
        this.clientOptionsBuilder = builder;
    }
}

