/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.mapping.mongo.config.MongoSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.ReflectionUtils;

public class MongoClientOptionsBuilder
implements GroovyObject {
    private final PropertyResolver propertyResolver;
    private final String databaseName;
    private String prefix;
    private ConnectionString connectionString;
    private String host;
    private String username;
    private String password;
    private String uAndP;
    private MongoCredential mongoCredential;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public MongoClientOptionsBuilder(PropertyResolver propertyResolver) {
        this(propertyResolver, propertyResolver.getProperty(MongoSettings.SETTING_DATABASE_NAME, "test"));
    }

    public MongoClientOptionsBuilder(PropertyResolver propertyResolver, String databaseName) {
        String string;
        String string2;
        String string3;
        String string4;
        PropertyResolver propertyResolver2;
        MetaClass metaClass;
        String string5;
        this.prefix = string5 = MongoSettings.SETTING_OPTIONS;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.propertyResolver = propertyResolver2 = propertyResolver;
        this.databaseName = string4 = databaseName;
        this.host = string3 = propertyResolver.getProperty(MongoSettings.SETTING_HOST, "");
        this.username = string2 = propertyResolver.getProperty(MongoSettings.SETTING_USERNAME, "");
        this.password = string = propertyResolver.getProperty(MongoSettings.SETTING_PASSWORD, "");
        String string6 = DefaultTypeTransformation.booleanUnbox((Object)this.username) && DefaultTypeTransformation.booleanUnbox((Object)this.password) ? new GStringImpl(new Object[]{this.username, this.password}, new String[]{"", ":", "@"}) : "";
        this.uAndP = ShortTypeHandling.castToString((Object)string6);
        if (DefaultTypeTransformation.booleanUnbox((Object)this.host)) {
            ConnectionString connectionString;
            String string7;
            String port = propertyResolver.getProperty(MongoSettings.SETTING_PORT, "");
            port = string7 = DefaultTypeTransformation.booleanUnbox((Object)port) ? new GStringImpl(new Object[]{port}, new String[]{":", ""}) : "";
            this.connectionString = connectionString = new ConnectionString(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.uAndP, this.host, port, databaseName}, new String[]{"mongodb://", "", "", "/", ""})));
        } else {
            ConnectionString connectionString;
            this.connectionString = connectionString = new ConnectionString(propertyResolver.getProperty(MongoSettings.SETTING_CONNECTION_STRING, propertyResolver.getProperty(MongoSettings.SETTING_URL, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{databaseName}, new String[]{"mongodb://localhost/", ""})))));
        }
        MongoCredential mongoCredential = DefaultTypeTransformation.booleanUnbox((Object)this.uAndP) ? MongoCredential.createCredential((String)this.username, (String)databaseName, (char[])this.password.toCharArray()) : null;
        this.mongoCredential = (MongoCredential)ScriptBytecodeAdapter.castToType(mongoCredential, MongoCredential.class);
    }

    public MongoClientSettings.Builder build() {
        MongoClientSettings.Builder builder = MongoClientSettings.builder();
        this.buildInternal(builder, this.prefix, true);
        return builder;
    }

    private Object buildInternal(Object builder, String startingPrefix, boolean root) {
        Class<?> builderClass = builder.getClass();
        Method[] methods = builderClass.getDeclaredMethods();
        Method applyConnectionStringMethod = ReflectionUtils.findMethod(builderClass, (String)"applyConnectionString", (Class[])new Class[]{ConnectionString.class});
        if (applyConnectionStringMethod != null) {
            applyConnectionStringMethod.invoke(builder, this.connectionString);
        }
        if (this.mongoCredential != null) {
            Method credentialListMethod = ReflectionUtils.findMethod(builderClass, (String)"credentialList", (Class[])new Class[]{List.class});
            if (credentialListMethod != null) {
                credentialListMethod.invoke(builder, Arrays.asList(this.mongoCredential));
            }
        }
        Object method = null;
        Iterator iterator = DefaultGroovyMethods.iterator((Object)methods);
        while (iterator.hasNext()) {
            method = iterator.next();
            String methodName = ((Method)method).getName();
            if (!Modifier.isPublic(((Method)method).getModifiers()) || methodName.equals("applyConnectionString") || methodName.equals("credentialList")) continue;
            Object[] parameterTypes = ((Method)method).getParameterTypes();
            if (!(parameterTypes.length == 1)) continue;
            Class argType = ShortTypeHandling.castToClass((Object)BytecodeInterface8.objectArrayGet((Object[])parameterTypes, (int)0));
            Method builderMethod = ReflectionUtils.findMethod((Class)argType, (String)"builder");
            String propertyPath = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{startingPrefix, methodName}, new String[]{"", ".", ""}));
            if (builderMethod != null && Modifier.isStatic(builderMethod.getModifiers())) {
                if (!this.propertyResolver.containsProperty(propertyPath)) continue;
                Object newBuilder = builderMethod.invoke((Object)argType, new Object[0]);
                if (DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.respondsTo((Object)newBuilder, (String)"applyConnectionString"))) {
                    this.applyConnectionString(newBuilder, this.connectionString);
                }
                ((Method)method).invoke(builder, this.buildInternal(newBuilder, propertyPath));
                continue;
            }
            if (argType.isEnum()) {
                String value = this.propertyResolver.getProperty(propertyPath, "");
                if (!DefaultTypeTransformation.booleanUnbox((Object)value)) continue;
                try {
                    ((Method)method).invoke(builder, Enum.valueOf(argType, value));
                }
                catch (Throwable e) {
                    Object v0;
                    if (log.isWarnEnabled()) {
                        log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{propertyPath, e.getMessage()}, new String[]{"Error occurred reading setting [", "]: ", ""})), e);
                        v0 = null;
                        continue;
                    }
                    v0 = null;
                }
                continue;
            }
            Method valueOfMethod = ReflectionUtils.findMethod((Class)argType, (String)"valueOf");
            if (valueOfMethod != null && Modifier.isStatic(valueOfMethod.getModifiers())) {
                try {
                    String value = this.propertyResolver.getProperty(propertyPath, "");
                    if (!DefaultTypeTransformation.booleanUnbox((Object)value)) continue;
                    Object converted = valueOfMethod.invoke((Object)argType, value);
                    ((Method)method).invoke(builder, converted);
                }
                catch (Exception e) {
                    Object v1;
                    if (log.isWarnEnabled()) {
                        log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{propertyPath, e.getMessage()}, new String[]{"Error occurred reading setting [", "]: ", ""})), (Throwable)ScriptBytecodeAdapter.castToType((Object)e, Throwable.class));
                        v1 = null;
                        continue;
                    }
                    v1 = null;
                }
                continue;
            }
            if (!(!List.class.isAssignableFrom(argType))) continue;
            try {
                Object value = this.propertyResolver.getProperty(propertyPath, argType, null);
                if (!(value != null)) continue;
                ((Method)method).invoke(builder, value);
            }
            catch (Throwable e) {
                Object v2;
                if (log.isWarnEnabled()) {
                    log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{propertyPath, e.getMessage()}, new String[]{"Error occurred reading setting [", "]: ", ""})), e);
                    v2 = null;
                    continue;
                }
                v2 = null;
            }
        }
        if (!root) {
            return this.doBuild(builder);
        }
        return builder;
    }

    private void applyConnectionString(Object newBuilder, ConnectionString connectionString) {
        CallSite[] callSiteArray = MongoClientOptionsBuilder.$getCallSiteArray();
        callSiteArray[0].call(newBuilder, (Object)connectionString);
    }

    private Object doBuild(Object builder) {
        CallSite[] callSiteArray = MongoClientOptionsBuilder.$getCallSiteArray();
        return callSiteArray[1].call(builder);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MongoClientOptionsBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    private Object buildInternal(Object builder, String startingPrefix) {
        return this.buildInternal(builder, startingPrefix, false);
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"org.grails.datastore.mapping.mongo.config.MongoClientOptionsBuilder");
    }

    @Generated
    public final PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    @Generated
    public final String getDatabaseName() {
        return this.databaseName;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "applyConnectionString";
        stringArray[1] = "build";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[2];
        MongoClientOptionsBuilder.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(MongoClientOptionsBuilder.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = MongoClientOptionsBuilder.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

