/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.engine;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import grails.gorm.DetachedCriteria;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.mapping.cache.TPCacheAdapterRepository;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.core.IdentityGenerationException;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.SessionImplementor;
import org.grails.datastore.mapping.core.impl.PendingDelete;
import org.grails.datastore.mapping.core.impl.PendingInsert;
import org.grails.datastore.mapping.core.impl.PendingOperation;
import org.grails.datastore.mapping.core.impl.PendingUpdate;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckableCollection;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckingCollection;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckingSupport;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.engine.ThirdPartyCacheEntityPersister;
import org.grails.datastore.mapping.engine.internal.MappingUtils;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.OneToMany;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.mongo.MongoCodecSession;
import org.grails.datastore.mapping.mongo.MongoDatastore;
import org.grails.datastore.mapping.mongo.engine.AbstractMongoObectEntityPersister;
import org.grails.datastore.mapping.mongo.query.MongoQuery;
import org.grails.datastore.mapping.proxy.ProxyFactory;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.grails.datastore.mapping.reflect.FieldEntityAccess;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataIntegrityViolationException;

public class MongoCodecEntityPersister
extends ThirdPartyCacheEntityPersister<Object>
implements GroovyObject {
    public static final String INSTANCE_PREFIX = "instance:";
    public static final String MONGO_ID_FIELD = "_id";
    public static final String MONGO_CLASS_FIELD = "_class";
    protected static final String NEXT_ID = "next_id";
    protected static final String NEXT_ID_SUFFIX;
    public static final String INC_OPERATOR = "$inc";
    public static final String ASSIGNED_IDENTIFIER_MAPPING = "assigned";
    protected final MongoCodecSession mongoSession;
    protected final MongoDatastore mongoDatastore;
    protected boolean hasNumericalIdentifier;
    protected boolean hasStringIdentifier;
    protected final EntityReflector fastClassData;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public MongoCodecEntityPersister(MappingContext mappingContext, PersistentEntity entity, MongoCodecSession session, ApplicationEventPublisher publisher, TPCacheAdapterRepository<Object> cacheAdapterRepository) {
        super(mappingContext, entity, (Session)session, publisher, cacheAdapterRepository);
        EntityReflector entityReflector;
        MongoDatastore mongoDatastore;
        MongoCodecSession mongoCodecSession;
        MetaClass metaClass;
        boolean bl;
        boolean bl2;
        this.hasNumericalIdentifier = bl2 = false;
        this.hasStringIdentifier = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.mongoSession = mongoCodecSession = session;
        this.mongoDatastore = mongoDatastore = session.getDatastore();
        this.fastClassData = entityReflector = FieldEntityAccess.getOrIntializeReflector((PersistentEntity)entity);
        PersistentProperty identity = entity.getIdentity();
        if (identity != null) {
            boolean bl3;
            boolean bl4;
            this.hasNumericalIdentifier = bl4 = Long.class.isAssignableFrom(identity.getType());
            this.hasStringIdentifier = bl3 = String.class.isAssignableFrom(identity.getType());
        }
    }

    public MongoCodecSession getSession() {
        return (MongoCodecSession)((Object)ScriptBytecodeAdapter.castToType((Object)super.getSession(), MongoCodecSession.class));
    }

    protected String getIdentifierName(ClassMapping cm) {
        IdentityMapping identifier = cm.getIdentifier();
        if (identifier != null && identifier.getIdentifierName() != null) {
            return ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])identifier.getIdentifierName(), (int)0));
        }
        return ShortTypeHandling.castToString(null);
    }

    protected List<Object> retrieveAllEntities(PersistentEntity pe, Serializable ... keys) {
        return this.retrieveAllEntities(pe, Arrays.asList((Object[])ScriptBytecodeAdapter.castToType((Object)keys, Object[].class)));
    }

    protected List<Object> retrieveAllEntities(PersistentEntity pe, Iterable<Serializable> keys) {
        List idList = DefaultGroovyMethods.toList(keys);
        if (idList.isEmpty()) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        return this.createQuery().in(pe.getIdentity().getName(), idList).list();
    }

    protected List<Serializable> persistEntities(PersistentEntity pe, Iterable objs) {
        Reference pe2 = new Reference((Object)pe);
        public final class _persistEntities_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference pe;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _persistEntities_closure1(Object _outerInstance, Object _thisObject, Reference pe) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.pe = reference = pe;
            }

            public Object doCall(Object it) {
                return InvokerHelper.invokeMethodSafe((Object)((Object)((MongoCodecEntityPersister)((Object)this.getThisObject()))), (String)"persistEntity", (Object)new Object[]{this.pe.get(), it});
            }

            public PersistentEntity getPe() {
                return (PersistentEntity)ScriptBytecodeAdapter.castToType((Object)this.pe.get(), PersistentEntity.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _persistEntities_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.collect((Iterable)objs, (Closure)new _persistEntities_closure1((Object)this, (Object)this, pe2));
    }

    protected Object retrieveEntity(PersistentEntity pe, Serializable key) {
        Object object;
        Object o = this.getFromTPCache(pe, key);
        if (o != null) {
            return o;
        }
        if (this.cancelLoad(pe, null)) {
            return null;
        }
        MongoCollection mongoCollection = this.getMongoCollection(pe);
        Document idQuery = this.createIdQuery(key);
        o = object = mongoCollection.withDocumentClass(this.getPersistentEntity().getJavaClass()).withCodecRegistry(this.mongoDatastore.getCodecRegistry()).find((Bson)idQuery, pe.getJavaClass()).limit(1).first();
        if (o != null && !this.cancelLoad(pe, this.createEntityAccess(pe, o))) {
            this.firePostLoadEvent(pe, this.createEntityAccess(pe, o));
            return o;
        }
        return null;
    }

    protected Document createIdQuery(Object key) {
        return new Document(AbstractMongoObectEntityPersister.MONGO_ID_FIELD, key);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Serializable persistEntity(PersistentEntity entity, Object obj, boolean isInsert) {
        void var2_2;
        Reference entity2 = new Reference((Object)entity);
        Reference obj2 = new Reference((Object)var2_2);
        ProxyFactory proxyFactory = this.getProxyFactory();
        Object object = proxyFactory.unwrap(obj2.get());
        obj2.set(object);
        Reference id = new Reference((Object)this.getObjectIdentifier(obj2.get()));
        SessionImplementor si = (SessionImplementor)this.getSession();
        if (si.isPendingAlready(obj2.get())) {
            return (Serializable)id.get();
        }
        boolean idIsNull = (Serializable)id.get() == null;
        boolean isUpdate = !idIsNull && !isInsert;
        MongoCodecSession mongoCodecSession = this.mongoSession;
        boolean assignedId = this.isAssignedId(this.getPersistentEntity());
        if (this.isNotUpdateForAssignedId(this.getPersistentEntity(), obj2.get(), isUpdate, assignedId, (SessionImplementor<Object>)si)) {
            boolean bl;
            isUpdate = bl = false;
        }
        if (isUpdate && !this.getSession().isDirty(obj2.get())) {
            return (Serializable)id.get();
        }
        Reference entityAccess = new Reference((Object)this.createEntityAccess((PersistentEntity)entity2.get(), obj2.get()));
        boolean isAssigned = this.isAssignedId((PersistentEntity)entity2.get());
        if (!isAssigned && idIsNull) {
            Serializable serializable = this.generateIdentifier((PersistentEntity)entity2.get());
            id.set((Object)serializable);
            if (!((Serializable)id.get() != null)) throw (Throwable)new DataIntegrityViolationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{obj2.get()}, new String[]{"Failed to generate a valid identifier for entity [", "]"})));
            ((EntityAccess)entityAccess.get()).setIdentifier((Object)((Serializable)id.get()));
        } else {
            if (idIsNull) {
                throw (Throwable)new DataIntegrityViolationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{obj2.get()}, new String[]{"Entity [", "] has null identifier when identifier strategy is manual assignment. Assign an appropriate identifier before persisting."})));
            }
            if (isAssigned && !si.isStateless((PersistentEntity)entity2.get())) {
                boolean bl;
                isUpdate = bl = mongoCodecSession.contains(obj2.get());
            }
        }
        si.registerPending(obj2.get());
        this.processAssociations(mongoCodecSession, (PersistentEntity)entity2.get(), (EntityAccess)entityAccess.get(), obj2.get(), proxyFactory, isUpdate);
        if (!isUpdate) {
            Reference self = new Reference((Object)this);
            mongoCodecSession.addPendingInsert((PendingInsert)new GroovyObject(this, entity2, entityAccess, obj2, id, self, (PersistentEntity)entity2.get(), (Serializable)id.get(), obj2.get(), (EntityAccess)entityAccess.get()){
                public /* synthetic */ Reference self;
                public /* synthetic */ Reference id;
                public /* synthetic */ Reference obj;
                public /* synthetic */ Reference entityAccess;
                public /* synthetic */ Reference entity;
                public /* synthetic */ MongoCodecEntityPersister this$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                {
                    MetaClass metaClass;
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    MongoCodecEntityPersister mongoCodecEntityPersister;
                    this.this$0 = mongoCodecEntityPersister = p0;
                    super((PersistentEntity)ScriptBytecodeAdapter.castToType((Object)p7, PersistentEntity.class), p8, p9, (EntityAccess)ScriptBytecodeAdapter.castToType((Object)p10, EntityAccess.class));
                    this.self = reference5 = p5;
                    this.id = reference4 = p4;
                    this.obj = reference3 = p3;
                    this.entityAccess = reference2 = p2;
                    this.entity = reference = p1;
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                public void run() {
                    if (!this.this$0.cancelInsert((PersistentEntity)ScriptBytecodeAdapter.castToType((Object)this.entity.get(), PersistentEntity.class), (EntityAccess)ScriptBytecodeAdapter.castToType((Object)this.entityAccess.get(), EntityAccess.class))) {
                        this.this$0.updateCaches((PersistentEntity)ScriptBytecodeAdapter.castToType((Object)this.entity.get(), PersistentEntity.class), this.obj.get(), (Serializable)ScriptBytecodeAdapter.castToType((Object)this.id.get(), Serializable.class));
                        this.addCascadeOperation((PendingOperation)new GroovyObject(this, this.self, this.entity, this.entityAccess, this.entity.get(), this.id.get(), this.obj.get()){
                            public /* synthetic */ Reference entityAccess;
                            public /* synthetic */ Reference entity;
                            public /* synthetic */ Reference self;
                            public /* synthetic */ 1 this$0;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private transient /* synthetic */ MetaClass metaClass;
                            {
                                MetaClass metaClass;
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                1 var8_8;
                                this.this$0 = var8_8 = p0;
                                super((PersistentEntity)ScriptBytecodeAdapter.castToType((Object)p5, PersistentEntity.class), p6, p7);
                                this.entityAccess = reference3 = p3;
                                this.entity = reference2 = p2;
                                this.self = reference = p1;
                                this.metaClass = metaClass = this.$getStaticMetaClass();
                            }

                            public void run() {
                                ((MongoCodecEntityPersister)((Object)this.self.get())).firePostInsertEvent((PersistentEntity)ScriptBytecodeAdapter.castToType((Object)this.entity.get(), PersistentEntity.class), (EntityAccess)ScriptBytecodeAdapter.castToType((Object)this.entityAccess.get(), EntityAccess.class));
                            }

                            public /* synthetic */ Object methodMissing(String name, Object args) {
                                return this.this$0.this$dist$invoke$3(name, args);
                            }

                            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                                return ScriptBytecodeAdapter.invokeMethodN(2.class, 1.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                            }

                            public /* synthetic */ void propertyMissing(String name, Object val) {
                                this.this$0.this$dist$set$3(name, val);
                            }

                            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                                Object object = val;
                                ScriptBytecodeAdapter.setProperty((Object)object, null, 1.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                            }

                            public /* synthetic */ Object propertyMissing(String name) {
                                return this.this$0.this$dist$get$3(name);
                            }

                            public static /* synthetic */ Object $static_propertyMissing(String name) {
                                return ScriptBytecodeAdapter.getProperty(2.class, 1.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != 2.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            @Generated
                            @Internal
                            public /* synthetic */ MetaClass getMetaClass() {
                                MetaClass metaClass = this.metaClass;
                                if (metaClass != null) {
                                    return metaClass;
                                }
                                this.metaClass = this.$getStaticMetaClass();
                                return this.metaClass;
                            }

                            @Generated
                            @Internal
                            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                                this.metaClass = metaClass;
                            }

                            @Generated
                            @Internal
                            public /* synthetic */ Object invokeMethod(String string, Object object) {
                                return this.getMetaClass().invokeMethod((Object)this, string, object);
                            }

                            @Generated
                            @Internal
                            public /* synthetic */ Object getProperty(String string) {
                                return this.getMetaClass().getProperty((Object)this, string);
                            }

                            @Generated
                            @Internal
                            public /* synthetic */ void setProperty(String string, Object object) {
                                this.getMetaClass().setProperty((Object)this, string, object);
                            }
                        });
                    } else {
                        this.setVetoed(true);
                    }
                }

                public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodOnCurrentN(1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void this$dist$set$3(String name, Object value) {
                    Object object = value;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, 1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object this$dist$get$3(String name) {
                    return ScriptBytecodeAdapter.getGroovyObjectProperty(1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    return this.this$0.this$dist$invoke$4(name, args);
                }

                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, MongoCodecEntityPersister.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object val) {
                    this.this$0.this$dist$set$4(name, val);
                }

                public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                    Object object = val;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, MongoCodecEntityPersister.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return this.this$0.this$dist$get$4(name);
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(1.class, MongoCodecEntityPersister.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != 1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                @Generated
                @Internal
                public /* synthetic */ MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ Object invokeMethod(String string, Object object) {
                    return this.getMetaClass().invokeMethod((Object)this, string, object);
                }

                @Generated
                @Internal
                public /* synthetic */ Object getProperty(String string) {
                    return this.getMetaClass().getProperty((Object)this, string);
                }

                @Generated
                @Internal
                public /* synthetic */ void setProperty(String string, Object object) {
                    this.getMetaClass().setProperty((Object)this, string, object);
                }
            });
            return (Serializable)id.get();
        } else {
            mongoCodecSession.addPendingUpdate((PendingUpdate)new GroovyObject(this, entity2, entityAccess, obj2, id, (PersistentEntity)entity2.get(), (Serializable)id.get(), obj2.get(), (EntityAccess)entityAccess.get()){
                public /* synthetic */ Reference id;
                public /* synthetic */ Reference obj;
                public /* synthetic */ Reference entityAccess;
                public /* synthetic */ Reference entity;
                public /* synthetic */ MongoCodecEntityPersister this$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                {
                    MetaClass metaClass;
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    MongoCodecEntityPersister mongoCodecEntityPersister;
                    this.this$0 = mongoCodecEntityPersister = p0;
                    super((PersistentEntity)ScriptBytecodeAdapter.castToType((Object)p6, PersistentEntity.class), p7, p8, (EntityAccess)ScriptBytecodeAdapter.castToType((Object)p9, EntityAccess.class));
                    this.id = reference4 = p4;
                    this.obj = reference3 = p3;
                    this.entityAccess = reference2 = p2;
                    this.entity = reference = p1;
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                public void run() {
                    if (!this.this$0.cancelUpdate((PersistentEntity)ScriptBytecodeAdapter.castToType((Object)this.entity.get(), PersistentEntity.class), (EntityAccess)ScriptBytecodeAdapter.castToType((Object)this.entityAccess.get(), EntityAccess.class))) {
                        this.this$0.updateCaches((PersistentEntity)ScriptBytecodeAdapter.castToType((Object)this.entity.get(), PersistentEntity.class), this.obj.get(), (Serializable)ScriptBytecodeAdapter.castToType((Object)this.id.get(), Serializable.class));
                        this.addCascadeOperation((PendingOperation)new GroovyObject(this, this.entity, this.entityAccess, this.entity.get(), this.id.get(), this.obj.get()){
                            public /* synthetic */ Reference entityAccess;
                            public /* synthetic */ Reference entity;
                            public /* synthetic */ 3 this$0;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private transient /* synthetic */ MetaClass metaClass;
                            {
                                MetaClass metaClass;
                                Reference reference;
                                Reference reference2;
                                3 var7_7;
                                this.this$0 = var7_7 = p0;
                                super((PersistentEntity)ScriptBytecodeAdapter.castToType((Object)p4, PersistentEntity.class), p5, p6);
                                this.entityAccess = reference2 = p2;
                                this.entity = reference = p1;
                                this.metaClass = metaClass = this.$getStaticMetaClass();
                            }

                            public void run() {
                                this.this$0.this$0.firePostUpdateEvent((PersistentEntity)ScriptBytecodeAdapter.castToType((Object)this.entity.get(), PersistentEntity.class), (EntityAccess)ScriptBytecodeAdapter.castToType((Object)this.entityAccess.get(), EntityAccess.class));
                            }

                            public /* synthetic */ Object methodMissing(String name, Object args) {
                                return this.this$0.this$dist$invoke$3(name, args);
                            }

                            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                                return ScriptBytecodeAdapter.invokeMethodN(4.class, 3.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                            }

                            public /* synthetic */ void propertyMissing(String name, Object val) {
                                this.this$0.this$dist$set$3(name, val);
                            }

                            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                                Object object = val;
                                ScriptBytecodeAdapter.setProperty((Object)object, null, 3.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                            }

                            public /* synthetic */ Object propertyMissing(String name) {
                                return this.this$0.this$dist$get$3(name);
                            }

                            public static /* synthetic */ Object $static_propertyMissing(String name) {
                                return ScriptBytecodeAdapter.getProperty(4.class, 3.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != 4.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            @Generated
                            @Internal
                            public /* synthetic */ MetaClass getMetaClass() {
                                MetaClass metaClass = this.metaClass;
                                if (metaClass != null) {
                                    return metaClass;
                                }
                                this.metaClass = this.$getStaticMetaClass();
                                return this.metaClass;
                            }

                            @Generated
                            @Internal
                            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                                this.metaClass = metaClass;
                            }

                            @Generated
                            @Internal
                            public /* synthetic */ Object invokeMethod(String string, Object object) {
                                return this.getMetaClass().invokeMethod((Object)this, string, object);
                            }

                            @Generated
                            @Internal
                            public /* synthetic */ Object getProperty(String string) {
                                return this.getMetaClass().getProperty((Object)this, string);
                            }

                            @Generated
                            @Internal
                            public /* synthetic */ void setProperty(String string, Object object) {
                                this.getMetaClass().setProperty((Object)this, string, object);
                            }
                        });
                    } else {
                        this.setVetoed(true);
                    }
                }

                public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodOnCurrentN(3.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void this$dist$set$3(String name, Object value) {
                    Object object = value;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, 3.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object this$dist$get$3(String name) {
                    return ScriptBytecodeAdapter.getGroovyObjectProperty(3.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    return this.this$0.this$dist$invoke$4(name, args);
                }

                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodN(3.class, MongoCodecEntityPersister.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object val) {
                    this.this$0.this$dist$set$4(name, val);
                }

                public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                    Object object = val;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, MongoCodecEntityPersister.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return this.this$0.this$dist$get$4(name);
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(3.class, MongoCodecEntityPersister.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != 3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                @Generated
                @Internal
                public /* synthetic */ MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ Object invokeMethod(String string, Object object) {
                    return this.getMetaClass().invokeMethod((Object)this, string, object);
                }

                @Generated
                @Internal
                public /* synthetic */ Object getProperty(String string) {
                    return this.getMetaClass().getProperty((Object)this, string);
                }

                @Generated
                @Internal
                public /* synthetic */ void setProperty(String string, Object object) {
                    this.getMetaClass().setProperty((Object)this, string, object);
                }
            });
        }
        return (Serializable)id.get();
    }

    protected boolean isAssignedId(PersistentEntity persistentEntity) {
        Property mapping = persistentEntity.getIdentity().getMapping().getMappedForm();
        Property property = mapping;
        return ASSIGNED_IDENTIFIER_MAPPING.equals(property != null ? property.getGenerator() : null);
    }

    private boolean isNotUpdateForAssignedId(PersistentEntity persistentEntity, Object obj, boolean update, boolean assignedId, SessionImplementor<Object> si) {
        return assignedId && update && !si.isStateless(persistentEntity) && !this.getSession().contains(obj);
    }

    protected void processAssociations(MongoCodecSession mongoCodecSession, PersistentEntity entity, EntityAccess entityAccess, Object obj, ProxyFactory proxyFactory, boolean isUpdate) {
        Association association = null;
        Iterator iterator = entity.getAssociations().iterator();
        while (iterator.hasNext()) {
            association = (Association)ScriptBytecodeAdapter.castToType(iterator.next(), Association.class);
            PersistentEntity associatedEntity = association.getAssociatedEntity();
            if (association instanceof ToOne) {
                if (association instanceof Embedded) {
                    String propertyName = association.getName();
                    Object value = entityAccess.getProperty(propertyName);
                    if (!proxyFactory.isInitialized(value) || !(value != null)) continue;
                    this.processAssociations(mongoCodecSession, associatedEntity, this.createEntityAccess(associatedEntity, value), value, proxyFactory, isUpdate);
                    continue;
                }
                String propertyName = association.getName();
                Object value = entityAccess.getProperty(propertyName);
                if (!(value != null)) continue;
                if (association.isBidirectional() && !isUpdate) {
                    EntityAccess inverseAccess = this.createEntityAccess(associatedEntity, value);
                    Association inverseSide = association.getInverseSide();
                    String inverseName = inverseSide.getName();
                    if (inverseSide instanceof ToOne) {
                        inverseAccess.setPropertyNoConversion(inverseName, obj);
                    } else if (inverseSide instanceof OneToMany) {
                        if (isUpdate) continue;
                        Object inverseCollection = inverseAccess.getProperty(inverseName);
                        if (inverseCollection == null) {
                            Collection collection = MappingUtils.createConcreteCollection((Class)inverseSide.getType());
                            inverseCollection = collection;
                            inverseAccess.setPropertyNoConversion(inverseName, inverseCollection);
                        }
                        if (inverseCollection instanceof Collection) {
                            Collection coll = (Collection)ScriptBytecodeAdapter.castToType((Object)inverseCollection, Collection.class);
                            if (!coll.contains(obj)) {
                                DefaultGroovyMethods.leftShift((Collection)coll, (Object)obj);
                            }
                        }
                    }
                }
                if (!proxyFactory.isInitialized(value)) continue;
                DirtyCheckable dirtyCheckable = (DirtyCheckable)ScriptBytecodeAdapter.castToType((Object)value, DirtyCheckable.class);
                if (!dirtyCheckable.hasChanged() || !(association.isOwningSide() || association.doesCascade(CascadeType.PERSIST))) continue;
                mongoCodecSession.persist(value);
                continue;
            }
            if (!(association instanceof OneToMany || association instanceof ManyToMany)) continue;
            String propertyName = association.getName();
            Object value = entityAccess.getProperty(propertyName);
            boolean shouldPersist = false;
            if (!(value != null && association.doesCascade(CascadeType.PERSIST))) continue;
            if (!isUpdate) {
                boolean bl;
                shouldPersist = bl = true;
            } else if (value instanceof DirtyCheckableCollection) {
                Collection dirtyCheckingCollection = DirtyCheckingSupport.wrap((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)value, Collection.class)), (DirtyCheckable)((DirtyCheckable)ScriptBytecodeAdapter.castToType((Object)obj, DirtyCheckable.class)), (String)propertyName);
                if (((DirtyCheckingCollection)ScriptBytecodeAdapter.castToType((Object)dirtyCheckingCollection, DirtyCheckingCollection.class)).hasChanged()) {
                    boolean bl;
                    shouldPersist = bl = true;
                }
            } else {
                boolean bl;
                shouldPersist = bl = true;
            }
            if (!shouldPersist) continue;
            Iterable associatedEntities = (Iterable)ScriptBytecodeAdapter.castToType((Object)value, Iterable.class);
            if (association.isBidirectional()) {
                Association inverseSide = association.getInverseSide();
                String inverseName = inverseSide.getName();
                if (inverseSide instanceof ToOne) {
                    Object ae2 = null;
                    for (Object ae2 : associatedEntities) {
                        this.createEntityAccess(associatedEntity, ae2).setPropertyNoConversion(inverseName, obj);
                    }
                }
            }
            List identifiers = mongoCodecSession.persist(associatedEntities);
            mongoCodecSession.setAttribute(obj, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{association}, new String[]{"", ".ids"})), identifiers);
            Collection dirtyCheckingCollection = DirtyCheckingSupport.wrap((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)value, Collection.class)), (DirtyCheckable)((DirtyCheckable)ScriptBytecodeAdapter.castToType((Object)obj, DirtyCheckable.class)), (String)propertyName);
            entityAccess.setPropertyNoConversion(propertyName, (Object)dirtyCheckingCollection);
        }
    }

    protected void updateCaches(PersistentEntity persistentEntity, Object e, Serializable id) {
        this.updateTPCache(persistentEntity, e, id);
    }

    public Serializable generateIdentifier(PersistentEntity persistentEntity) {
        if (this.hasNumericalIdentifier) {
            String collectionName = this.getCollectionName(persistentEntity);
            MongoClient client = this.mongoSession.getNativeInterface();
            MongoCollection dbCollection = client.getDatabase(this.mongoSession.getDatabase(persistentEntity)).getCollection(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{collectionName, NEXT_ID_SUFFIX}, new String[]{"", "", ""})));
            int attempts = 0;
            do {
                FindOneAndUpdateOptions options = new FindOneAndUpdateOptions();
                options.upsert(true).returnDocument(ReturnDocument.AFTER);
                Document result = (Document)ScriptBytecodeAdapter.castToType((Object)dbCollection.findOneAndUpdate((Bson)new Document(MONGO_ID_FIELD, (Object)collectionName), (Bson)new Document(INC_OPERATOR, (Object)new Document(NEXT_ID, (Object)1L)), options), Document.class);
                if (result != null) {
                    return result.getLong((Object)NEXT_ID);
                }
                int n = attempts;
                int cfr_ignored_0 = n + 1;
            } while (!(attempts > 3));
            throw (Throwable)new IdentityGenerationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{persistentEntity.getName()}, new String[]{"Unable to generate identity for [", "] using findAndModify after 3 attempts"})));
        }
        ObjectId objectId = ObjectId.get();
        Class identityType = persistentEntity.getIdentity().getType();
        if (ObjectId.class.isAssignableFrom(identityType)) {
            return objectId;
        }
        return objectId.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected void deleteEntity(PersistentEntity pe, Object obj) {
        void var2_2;
        Reference pe2 = new Reference((Object)pe);
        Reference obj2 = new Reference((Object)var2_2);
        ProxyFactory proxyFactory = this.getProxyFactory();
        Reference id = new Reference(null);
        Serializable cfr_ignored_0 = (Serializable)id.get();
        if (proxyFactory.isProxy(obj2.get())) {
            Serializable serializable = proxyFactory.getIdentifier(obj2.get());
            id.set((Object)serializable);
        } else {
            Serializable serializable = this.getObjectIdentifier(obj2.get());
            id.set((Object)serializable);
        }
        if ((Serializable)id.get() != null) {
            Reference self = new Reference((Object)this);
            this.mongoSession.addPendingDelete((PendingDelete)new GroovyObject(this, self, pe2, obj2, id, (PersistentEntity)pe2.get(), (Serializable)id.get(), obj2.get()){
                public /* synthetic */ Reference id;
                public /* synthetic */ Reference obj;
                public /* synthetic */ Reference pe;
                public /* synthetic */ Reference self;
                public /* synthetic */ MongoCodecEntityPersister this$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                {
                    MetaClass metaClass;
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    MongoCodecEntityPersister mongoCodecEntityPersister;
                    this.this$0 = mongoCodecEntityPersister = p0;
                    super((PersistentEntity)ScriptBytecodeAdapter.castToType((Object)p6, PersistentEntity.class), p7, p8);
                    this.id = reference4 = p4;
                    this.obj = reference3 = p3;
                    this.pe = reference2 = p2;
                    this.self = reference = p1;
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                public void run() {
                    Reference entityAccess = new Reference((Object)((MongoCodecEntityPersister)((Object)this.self.get())).createEntityAccess((PersistentEntity)ScriptBytecodeAdapter.castToType((Object)this.pe.get(), PersistentEntity.class), this.obj.get()));
                    if (!((MongoCodecEntityPersister)((Object)this.self.get())).cancelDelete((PersistentEntity)ScriptBytecodeAdapter.castToType((Object)this.pe.get(), PersistentEntity.class), (EntityAccess)entityAccess.get())) {
                        ((MongoCodecSession)((Object)this.getProperty("mongoSession"))).clear(this.obj.get());
                        this.addCascadeOperation((PendingOperation)new GroovyObject(this, this.self, this.pe, entityAccess, this.pe.get(), this.id.get(), this.obj.get()){
                            public /* synthetic */ Reference entityAccess;
                            public /* synthetic */ Reference pe;
                            public /* synthetic */ Reference self;
                            public /* synthetic */ 5 this$0;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private transient /* synthetic */ MetaClass metaClass;
                            {
                                MetaClass metaClass;
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                5 var8_8;
                                this.this$0 = var8_8 = p0;
                                super((PersistentEntity)ScriptBytecodeAdapter.castToType((Object)p5, PersistentEntity.class), p6, p7);
                                this.entityAccess = reference3 = p3;
                                this.pe = reference2 = p2;
                                this.self = reference = p1;
                                this.metaClass = metaClass = this.$getStaticMetaClass();
                            }

                            public void run() {
                                ((MongoCodecEntityPersister)((Object)this.self.get())).firePostDeleteEvent((PersistentEntity)ScriptBytecodeAdapter.castToType((Object)this.pe.get(), PersistentEntity.class), (EntityAccess)ScriptBytecodeAdapter.castToType((Object)this.entityAccess.get(), EntityAccess.class));
                            }

                            public /* synthetic */ Object methodMissing(String name, Object args) {
                                return this.this$0.this$dist$invoke$3(name, args);
                            }

                            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                                return ScriptBytecodeAdapter.invokeMethodN(6.class, 5.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                            }

                            public /* synthetic */ void propertyMissing(String name, Object val) {
                                this.this$0.this$dist$set$3(name, val);
                            }

                            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                                Object object = val;
                                ScriptBytecodeAdapter.setProperty((Object)object, null, 5.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                            }

                            public /* synthetic */ Object propertyMissing(String name) {
                                return this.this$0.this$dist$get$3(name);
                            }

                            public static /* synthetic */ Object $static_propertyMissing(String name) {
                                return ScriptBytecodeAdapter.getProperty(6.class, 5.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != 6.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            @Generated
                            @Internal
                            public /* synthetic */ MetaClass getMetaClass() {
                                MetaClass metaClass = this.metaClass;
                                if (metaClass != null) {
                                    return metaClass;
                                }
                                this.metaClass = this.$getStaticMetaClass();
                                return this.metaClass;
                            }

                            @Generated
                            @Internal
                            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                                this.metaClass = metaClass;
                            }

                            @Generated
                            @Internal
                            public /* synthetic */ Object invokeMethod(String string, Object object) {
                                return this.getMetaClass().invokeMethod((Object)this, string, object);
                            }

                            @Generated
                            @Internal
                            public /* synthetic */ Object getProperty(String string) {
                                return this.getMetaClass().getProperty((Object)this, string);
                            }

                            @Generated
                            @Internal
                            public /* synthetic */ void setProperty(String string, Object object) {
                                this.getMetaClass().setProperty((Object)this, string, object);
                            }
                        });
                    } else {
                        this.setVetoed(true);
                    }
                }

                public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodOnCurrentN(5.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void this$dist$set$3(String name, Object value) {
                    Object object = value;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, 5.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object this$dist$get$3(String name) {
                    return ScriptBytecodeAdapter.getGroovyObjectProperty(5.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    return this.this$0.this$dist$invoke$4(name, args);
                }

                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodN(5.class, MongoCodecEntityPersister.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object val) {
                    this.this$0.this$dist$set$4(name, val);
                }

                public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                    Object object = val;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, MongoCodecEntityPersister.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return this.this$0.this$dist$get$4(name);
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(5.class, MongoCodecEntityPersister.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != 5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                @Generated
                @Internal
                public /* synthetic */ MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ Object invokeMethod(String string, Object object) {
                    return this.getMetaClass().invokeMethod((Object)this, string, object);
                }

                @Generated
                @Internal
                public /* synthetic */ Object getProperty(String string) {
                    return this.getMetaClass().getProperty((Object)this, string);
                }

                @Generated
                @Internal
                public /* synthetic */ void setProperty(String string, Object object) {
                    this.getMetaClass().setProperty((Object)this, string, object);
                }
            });
            EntityAccess access = this.createEntityAccess((PersistentEntity)pe2.get(), obj2.get());
            Association association = null;
            Iterator iterator = ((PersistentEntity)pe2.get()).getAssociations().iterator();
            while (iterator.hasNext()) {
                association = (Association)ScriptBytecodeAdapter.castToType(iterator.next(), Association.class);
                if (!(association.isOwningSide() && association.doesCascade(CascadeType.REMOVE)) || !(!association.isEmbedded() && !(association instanceof Basic))) continue;
                Object v = access.getProperty(association.getName());
                if (association instanceof ToOne) {
                    if (association.isBidirectional() && association.isCircular() || !(v != null)) continue;
                    this.mongoSession.delete(v);
                    continue;
                }
                if (!(v != null)) continue;
                this.mongoSession.delete((Iterable)ScriptBytecodeAdapter.castToType((Object)v, Iterable.class));
            }
        }
    }

    protected void deleteEntities(PersistentEntity pe, Iterable objects) {
        DetachedCriteria criteria = new DetachedCriteria(pe.getJavaClass());
        public final class _deleteEntities_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _deleteEntities_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((MongoCodecEntityPersister)((EntityPersister)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), EntityPersister.class))).getObjectIdentifier(it);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteEntities_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _deleteEntities_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _deleteEntities_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return it != null;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteEntities_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        criteria.in(pe.getIdentity().getName(), (Collection)DefaultGroovyMethods.findAll((List)DefaultGroovyMethods.collect((Iterable)objects, (Closure)new _deleteEntities_closure2((Object)this, (Object)this)), (Closure)new _deleteEntities_closure3((Object)this, (Object)this)));
        this.mongoSession.deleteAll((QueryableCriteria)criteria);
    }

    public Query createQuery() {
        return new MongoQuery(this.mongoSession, this.getPersistentEntity());
    }

    public Serializable refresh(Object o) {
        throw (Throwable)new UnsupportedOperationException("Refresh not supported by codec entity persistence engine");
    }

    public Object lock(Serializable id) throws CannotAcquireLockException {
        throw (Throwable)new UnsupportedOperationException("Pessimistic locks not supported by MongoDB");
    }

    public Object lock(Serializable id, int timeout) throws CannotAcquireLockException {
        throw (Throwable)new UnsupportedOperationException("Pessimistic locks not supported by MongoDB");
    }

    public boolean isLocked(Object o) {
        throw (Throwable)new UnsupportedOperationException("Pessimistic locks not supported by MongoDB");
    }

    public void unlock(Object o) {
        throw (Throwable)new UnsupportedOperationException("Pessimistic locks not supported by MongoDB");
    }

    protected EntityAccess createEntityAccess(PersistentEntity pe, Object obj) {
        return this.mongoSession.createEntityAccess(pe, obj);
    }

    protected Serializable persistEntity(PersistentEntity pe, Object obj) {
        return this.persistEntity(pe, obj, false);
    }

    protected MongoCollection getMongoCollection(PersistentEntity pe) {
        String database = this.mongoSession.getDatabase(pe);
        String collection = this.getCollectionName(pe);
        MongoClient client = this.mongoSession.getNativeInterface();
        MongoCollection mongoCollection = client.getDatabase(database).getCollection(collection).withDocumentClass(pe.getJavaClass());
        return mongoCollection;
    }

    protected String getCollectionName(PersistentEntity pe) {
        return this.mongoSession.getCollectionName(pe);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != MongoCodecEntityPersister.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(MongoCodecEntityPersister.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, MongoCodecEntityPersister.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(MongoCodecEntityPersister.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        GStringImpl gStringImpl = new GStringImpl(new Object[]{NEXT_ID}, new String[]{".", ""});
        NEXT_ID_SUFFIX = ShortTypeHandling.castToString((Object)gStringImpl);
    }
}

