/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo;

import com.mongodb.MongoClient;
import com.mongodb.WriteConcern;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.Document;
import org.grails.datastore.mapping.config.Entity;
import org.grails.datastore.mapping.core.AbstractSession;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.impl.PendingOperation;
import org.grails.datastore.mapping.document.config.DocumentMappingContext;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.mongo.MongoDatastore;
import org.grails.datastore.mapping.mongo.config.MongoCollection;
import org.grails.datastore.mapping.mongo.config.MongoMappingContext;
import org.springframework.context.ApplicationEventPublisher;

public abstract class AbstractMongoSession
extends AbstractSession<MongoClient> {
    public static final String MONGO_SET_OPERATOR = "$set";
    public static final String MONGO_UNSET_OPERATOR = "$unset";
    protected static final Map<PersistentEntity, WriteConcern> declaredWriteConcerns = new ConcurrentHashMap<PersistentEntity, WriteConcern>();
    protected final String defaultDatabase;
    protected MongoDatastore mongoDatastore;
    protected WriteConcern writeConcern = null;
    protected boolean errorOccured = false;
    protected Map<PersistentEntity, String> mongoCollections = new ConcurrentHashMap<PersistentEntity, String>();
    protected Map<PersistentEntity, String> mongoDatabases = new ConcurrentHashMap<PersistentEntity, String>();

    public AbstractMongoSession(MongoDatastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher) {
        this(datastore, mappingContext, publisher, false);
    }

    public AbstractMongoSession(MongoDatastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher, boolean stateless) {
        super((Datastore)datastore, mappingContext, publisher, stateless);
        this.mongoDatastore = datastore;
        this.defaultDatabase = this.getDocumentMappingContext().getDefaultDatabaseName();
    }

    public boolean hasTransaction() {
        return true;
    }

    public MongoDatastore getDatastore() {
        return (MongoDatastore)super.getDatastore();
    }

    public void flush() {
        this.flush(this.getWriteConcern());
    }

    public abstract void flush(WriteConcern var1);

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public String getDatabase(PersistentEntity entity) {
        String name = this.mongoDatabases.get(entity);
        if (name != null) {
            return name;
        }
        return this.getDatastore().getDatabaseName(entity);
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public WriteConcern getDeclaredWriteConcern(PersistentEntity entity) {
        return this.getDeclaredWriteConcern(this.writeConcern, entity);
    }

    private WriteConcern getDeclaredWriteConcern(WriteConcern defaultConcern, PersistentEntity entity) {
        WriteConcern writeConcern = declaredWriteConcerns.get(entity);
        if (writeConcern == null) {
            MongoCollection mc;
            Entity mappedForm = entity.getMapping().getMappedForm();
            if (mappedForm instanceof MongoCollection && (writeConcern = (mc = (MongoCollection)mappedForm).getWriteConcern()) == null) {
                writeConcern = defaultConcern;
            }
            if (writeConcern != null) {
                declaredWriteConcerns.put(entity, writeConcern);
            }
        }
        return writeConcern;
    }

    public MongoClient getNativeInterface() {
        return this.getDatastore().getMongoClient();
    }

    public DocumentMappingContext getDocumentMappingContext() {
        return this.getMappingContext();
    }

    public String getCollectionName(PersistentEntity entity) {
        entity = entity.isRoot() ? entity : entity.getRootEntity();
        return this.mongoCollections.containsKey(entity) ? this.mongoCollections.get(entity) : this.mongoDatastore.getCollectionName(entity);
    }

    public String useCollection(PersistentEntity entity, String collectionName) {
        entity = entity.isRoot() ? entity : entity.getRootEntity();
        String current = this.mongoCollections.containsKey(entity) ? this.mongoCollections.get(entity) : this.mongoDatastore.getCollectionName(entity);
        this.mongoCollections.put(entity, collectionName);
        return current;
    }

    public String useDatabase(PersistentEntity entity, String databaseName) {
        if (databaseName == null) {
            return this.mongoDatabases.put(entity, this.getDefaultDatabase());
        }
        return this.mongoDatabases.put(entity, databaseName);
    }

    public com.mongodb.client.MongoCollection<Document> getCollection(PersistentEntity entity) {
        if (entity.isRoot()) {
            String database = this.getDatabase(entity);
            String collectionName = this.getCollectionName(entity);
            return this.getNativeInterface().getDatabase(database).getCollection(collectionName).withCodecRegistry(this.getDatastore().getCodecRegistry());
        }
        PersistentEntity root = entity.getRootEntity();
        return this.getCollection(root);
    }

    public MongoMappingContext getMappingContext() {
        return (MongoMappingContext)super.getMappingContext();
    }

    public abstract <T> T decode(Class<T> var1, Object var2);

    protected void addPostFlushOperations(List<PendingOperation> cascadeOperations) {
        for (PendingOperation cascadeOperation : cascadeOperations) {
            this.addPostFlushOperation((Runnable)cascadeOperation);
        }
    }
}

