/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.config;

import com.mongodb.MongoClientURI;
import groovy.lang.Closure;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;
import org.grails.datastore.bson.codecs.BigDecimalCodec;
import org.grails.datastore.bson.codecs.CodecCustomTypeMarshaller;
import org.grails.datastore.bson.codecs.CodecExtensions;
import org.grails.datastore.bson.codecs.InstantCodec;
import org.grails.datastore.bson.codecs.LocalDateCodec;
import org.grails.datastore.bson.codecs.LocalDateTimeCodec;
import org.grails.datastore.bson.codecs.LocalTimeCodec;
import org.grails.datastore.bson.codecs.OffsetDateTimeCodec;
import org.grails.datastore.bson.codecs.OffsetTimeCodec;
import org.grails.datastore.bson.codecs.PeriodCodec;
import org.grails.datastore.bson.codecs.ZonedDateTimeCodec;
import org.grails.datastore.bson.codecs.encoders.SimpleEncoder;
import org.grails.datastore.gorm.mongo.geo.BoxType;
import org.grails.datastore.gorm.mongo.geo.CircleType;
import org.grails.datastore.gorm.mongo.geo.GeometryCollectionType;
import org.grails.datastore.gorm.mongo.geo.LineStringType;
import org.grails.datastore.gorm.mongo.geo.MultiLineStringType;
import org.grails.datastore.gorm.mongo.geo.MultiPointType;
import org.grails.datastore.gorm.mongo.geo.MultiPolygonType;
import org.grails.datastore.gorm.mongo.geo.PointType;
import org.grails.datastore.gorm.mongo.geo.PolygonType;
import org.grails.datastore.gorm.mongo.geo.ShapeType;
import org.grails.datastore.gorm.mongo.simple.EnumType;
import org.grails.datastore.mapping.config.AbstractGormMappingFactory;
import org.grails.datastore.mapping.config.ConfigurationUtils;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.document.config.Collection;
import org.grails.datastore.mapping.document.config.DocumentMappingContext;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.AbstractClassMapping;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.EmbeddedPersistentEntity;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.model.types.Custom;
import org.grails.datastore.mapping.model.types.Identity;
import org.grails.datastore.mapping.mongo.config.MongoAttribute;
import org.grails.datastore.mapping.mongo.config.MongoCollection;
import org.grails.datastore.mapping.mongo.connections.AbstractMongoConnectionSourceSettings;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.env.PropertyResolver;

public class MongoMappingContext
extends DocumentMappingContext {
    private static final String DECIMAL_TYPE_CLASS_NAME = "org.bson.types.Decimal128";
    private static final Set<String> MONGO_NATIVE_TYPES = new HashSet<String>(Arrays.asList(Double.class.getName(), String.class.getName(), Document.class.getName(), "com.mongodb.DBObject", Binary.class.getName(), ObjectId.class.getName(), "com.mongodb.DBRef", Boolean.class.getName(), Date.class.getName(), Pattern.class.getName(), Symbol.class.getName(), Integer.class.getName(), Code.class.getName(), "org.bson.types.BSONTimestamp", "org.bson.types.Decimal128", "org.bson.types.CodeWScope", "org.bson.types.Code", "org.bson.types.Binary", Long.class.getName(), UUID.class.getName(), byte[].class.getName(), Byte.class.getName()));
    private CodecRegistry codecRegistry;
    private Map<Class, Boolean> hasCodecCache = new HashMap<Class, Boolean>();

    public MongoMappingContext(String defaultDatabaseName) {
        this(defaultDatabaseName, null);
    }

    public MongoMappingContext(String defaultDatabaseName, Closure defaultMapping) {
        this(defaultDatabaseName, defaultMapping, new Class[0]);
    }

    public MongoMappingContext(String defaultDatabaseName, Closure defaultMapping, Class ... classes) {
        super(defaultDatabaseName, defaultMapping);
        this.initialize(classes);
    }

    @Deprecated
    public MongoMappingContext(PropertyResolver configuration, Class ... classes) {
        this(MongoMappingContext.getDefaultDatabaseName(configuration), (Closure)configuration.getProperty("grails.mongodb.default.mapping", Closure.class, null), classes);
    }

    public MongoMappingContext(AbstractMongoConnectionSourceSettings settings, Class ... classes) {
        super(settings.getDatabase(), (ConnectionSourceSettings)settings);
        this.initialize(classes);
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    protected void initialize(ConnectionSourceSettings settings) {
        super.initialize(settings);
        AbstractMongoConnectionSourceSettings mongoConnectionSourceSettings = (AbstractMongoConnectionSourceSettings)settings;
        List<Class<? extends Codec>> codecClasses = mongoConnectionSourceSettings.getCodecs();
        if (mongoConnectionSourceSettings.isDecimalType() && ClassUtils.isPresent((String)DECIMAL_TYPE_CLASS_NAME)) {
            MONGO_NATIVE_TYPES.add(BigDecimal.class.getName());
            MONGO_NATIVE_TYPES.add(BigInteger.class.getName());
            SimpleEncoder.enableBigDecimalEncoding();
            codecClasses.add(BigDecimalCodec.class);
        }
        Iterable codecList = ConfigurationUtils.findServices(codecClasses, Codec.class);
        ArrayList<Object> codecs = new ArrayList<Object>();
        for (Codec codec : codecList) {
            codecs.add(codec);
        }
        codecs.add(new InstantCodec());
        codecs.add(new LocalDateCodec());
        codecs.add(new LocalDateTimeCodec());
        codecs.add(new LocalTimeCodec());
        codecs.add(new OffsetDateTimeCodec());
        codecs.add(new OffsetTimeCodec());
        codecs.add(new PeriodCodec());
        codecs.add(new ZonedDateTimeCodec());
        this.codecRegistry = mongoConnectionSourceSettings.getCodecRegistry() != null ? CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{mongoConnectionSourceSettings.getCodecRegistry(), CodecRegistries.fromCodecs(codecs)}) : CodecRegistries.fromCodecs(codecs);
    }

    private void initialize(Class[] classes) {
        this.registerMongoTypes();
        ConverterRegistry converterRegistry = this.getConverterRegistry();
        converterRegistry.addConverter((Converter)new Converter<String, ObjectId>(){

            public ObjectId convert(String source) {
                if (ObjectId.isValid((String)source)) {
                    return new ObjectId(source);
                }
                return null;
            }
        });
        converterRegistry.addConverter((Converter)new Converter<ObjectId, String>(){

            public String convert(ObjectId source) {
                return source.toString();
            }
        });
        converterRegistry.addConverter((Converter)new Converter<byte[], Binary>(){

            public Binary convert(byte[] source) {
                return new Binary(source);
            }
        });
        converterRegistry.addConverter((Converter)new Converter<Binary, byte[]>(){

            public byte[] convert(Binary source) {
                return source.getData();
            }
        });
        converterRegistry.addConverter((Converter)new Converter<Decimal128, BigDecimal>(){

            public BigDecimal convert(Decimal128 source) {
                return source.bigDecimalValue();
            }
        });
        converterRegistry.addConverter((Converter)new Converter<BigDecimal, Decimal128>(){

            public Decimal128 convert(BigDecimal source) {
                return new Decimal128(source);
            }
        });
        converterRegistry.addConverter((Converter)new Converter<Decimal128, BigInteger>(){

            public BigInteger convert(Decimal128 source) {
                return source.bigDecimalValue().toBigInteger();
            }
        });
        converterRegistry.addConverter((Converter)new Converter<BigInteger, Decimal128>(){

            public Decimal128 convert(BigInteger source) {
                return new Decimal128(new BigDecimal(source.toString()));
            }
        });
        for (Converter converter : CodecExtensions.getBsonConverters()) {
            converterRegistry.addConverter(converter);
        }
        this.addPersistentEntities(classes);
        this.hasCodecCache.clear();
    }

    public static boolean isMongoNativeType(Class clazz) {
        return MONGO_NATIVE_TYPES.contains(clazz.getName()) || Bson.class.isAssignableFrom(clazz.getClass());
    }

    public static String getDefaultDatabaseName(PropertyResolver configuration) {
        MongoClientURI mongoClientURI;
        String database;
        String connectionString = (String)configuration.getProperty("grails.mongodb.connectionString", String.class, null);
        if (connectionString != null && (database = (mongoClientURI = new MongoClientURI(connectionString)).getDatabase()) != null) {
            return database;
        }
        return configuration.getProperty("grails.mongodb.databaseName", "test");
    }

    private boolean hasCodecForType(Class propType) {
        Boolean hasCodec;
        if (this.hasCodecCache.containsKey(propType)) {
            return this.hasCodecCache.get(propType);
        }
        try {
            hasCodec = this.codecRegistry.get(propType) != null;
        }
        catch (CodecConfigurationException e) {
            hasCodec = false;
        }
        this.hasCodecCache.put(propType, hasCodec);
        return hasCodec;
    }

    protected void registerMongoTypes() {
        MappingFactory mappingFactory = this.getMappingFactory();
        mappingFactory.registerCustomType((CustomTypeMarshaller)new GeometryCollectionType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new PointType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new PolygonType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new LineStringType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new MultiLineStringType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new MultiPointType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new MultiPolygonType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new ShapeType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new BoxType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new CircleType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new EnumType());
    }

    protected MappingFactory createDocumentMappingFactory(Closure defaultMapping) {
        MongoDocumentMappingFactory mongoDocumentMappingFactory = new MongoDocumentMappingFactory();
        mongoDocumentMappingFactory.setDefaultMapping(defaultMapping);
        return mongoDocumentMappingFactory;
    }

    public PersistentEntity createEmbeddedEntity(Class type) {
        return new DocumentEmbeddedPersistentEntity(type, (MappingContext)this);
    }

    class DocumentEmbeddedPersistentEntity
    extends EmbeddedPersistentEntity {
        private DocumentCollectionMapping classMapping;

        public DocumentEmbeddedPersistentEntity(Class type, MappingContext ctx) {
            super(type, ctx);
            this.classMapping = new DocumentCollectionMapping((PersistentEntity)this, ctx);
        }

        public ClassMapping getMapping() {
            return this.classMapping;
        }

        public class DocumentCollectionMapping
        extends AbstractClassMapping<Collection> {
            private Collection mappedForm;

            public DocumentCollectionMapping(PersistentEntity entity, MappingContext context) {
                super(entity, context);
                this.mappedForm = (Collection)context.getMappingFactory().createMappedForm((PersistentEntity)DocumentEmbeddedPersistentEntity.this);
            }

            public Collection getMappedForm() {
                return this.mappedForm;
            }
        }
    }

    private final class MongoDocumentMappingFactory
    extends AbstractGormMappingFactory<MongoCollection, MongoAttribute> {
        private MongoDocumentMappingFactory() {
        }

        protected Class<MongoAttribute> getPropertyMappedFormType() {
            return MongoAttribute.class;
        }

        protected Class<MongoCollection> getEntityMappedFormType() {
            return MongoCollection.class;
        }

        public Identity<MongoAttribute> createIdentity(PersistentEntity owner, MappingContext context, PropertyDescriptor pd) {
            Identity identity = super.createIdentity(owner, context, pd);
            ((MongoAttribute)identity.getMapping().getMappedForm()).setTargetName("_id");
            return identity;
        }

        public boolean isCustomType(Class<?> propertyType) {
            return super.isCustomType(propertyType) || MongoMappingContext.this.hasCodecForType(propertyType);
        }

        public Custom<MongoAttribute> createCustom(PersistentEntity owner, MappingContext context, PropertyDescriptor pd) {
            if (MongoMappingContext.this.hasCodecForType(pd.getPropertyType())) {
                CodecCustomTypeMarshaller customTypeMarshaller = new CodecCustomTypeMarshaller(MongoMappingContext.this.codecRegistry.get(pd.getPropertyType()), (MappingContext)MongoMappingContext.this);
                return new Custom<MongoAttribute>(owner, context, pd, (CustomTypeMarshaller)customTypeMarshaller){
                    PropertyMapping<MongoAttribute> propertyMapping;
                    {
                        this.propertyMapping = MongoDocumentMappingFactory.this.createPropertyMapping((PersistentProperty)this, this.owner);
                    }

                    public PropertyMapping<MongoAttribute> getMapping() {
                        return this.propertyMapping;
                    }
                };
            }
            return super.createCustom(owner, context, pd);
        }

        public boolean isSimpleType(Class propType) {
            if (propType == null) {
                return false;
            }
            if (propType.isArray()) {
                return this.isSimpleType(propType.getComponentType()) || super.isSimpleType(propType);
            }
            return MongoMappingContext.isMongoNativeType(propType) || super.isSimpleType(propType);
        }
    }
}

