/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.query;

import com.mongodb.ReadConcern;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import grails.mongodb.geo.Box;
import grails.mongodb.geo.Circle;
import grails.mongodb.geo.Distance;
import grails.mongodb.geo.GeoJSON;
import grails.mongodb.geo.Point;
import grails.mongodb.geo.Polygon;
import grails.mongodb.geo.Shape;
import grails.mongodb.geo.Sphere;
import groovy.lang.Closure;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.datastore.bson.codecs.CodecCustomTypeMarshaller;
import org.grails.datastore.bson.query.BsonQuery;
import org.grails.datastore.bson.query.EmbeddedQueryEncoder;
import org.grails.datastore.gorm.mongo.geo.GeoJSONType;
import org.grails.datastore.gorm.query.AbstractResultList;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.SessionImplementor;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.EmbeddedPersistentEntity;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.Custom;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.EmbeddedCollection;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.mongo.AbstractMongoSession;
import org.grails.datastore.mapping.mongo.MongoCodecSession;
import org.grails.datastore.mapping.mongo.MongoDatastore;
import org.grails.datastore.mapping.mongo.config.MongoCollection;
import org.grails.datastore.mapping.mongo.engine.MongoCodecEntityPersister;
import org.grails.datastore.mapping.mongo.engine.MongoEntityPersister;
import org.grails.datastore.mapping.mongo.engine.codecs.PersistentEntityCodec;
import org.grails.datastore.mapping.query.AssociationQuery;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.QueryArgumentsAware;
import org.grails.datastore.mapping.query.projections.ManualProjections;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class MongoQuery
extends BsonQuery
implements QueryArgumentsAware {
    public static final String MONGO_IN_OPERATOR = "$in";
    public static final String MONGO_OR_OPERATOR = "$or";
    public static final String MONGO_AND_OPERATOR = "$and";
    public static final String MONGO_GTE_OPERATOR = "$gte";
    public static final String MONGO_LTE_OPERATOR = "$lte";
    public static final String MONGO_GT_OPERATOR = "$gt";
    public static final String MONGO_LT_OPERATOR = "$lt";
    public static final String MONGO_NE_OPERATOR = "$ne";
    public static final String MONGO_NIN_OPERATOR = "$nin";
    public static final String MONGO_REGEX_OPERATOR = "$regex";
    public static final String MONGO_WHERE_OPERATOR = "$where";
    public static final String HINT_ARGUMENT = "hint";
    public static final String READ_CONCERN_ARGUMENT = "readConcern";
    private Map queryArguments = Collections.emptyMap();
    public static final String NEAR_OPERATOR = "$near";
    public static final String BOX_OPERATOR = "$box";
    public static final String POLYGON_OPERATOR = "$polygon";
    public static final String WITHIN_OPERATOR = "$within";
    public static final String CENTER_OPERATOR = "$center";
    public static final String GEO_WITHIN_OPERATOR = "$geoWithin";
    public static final String GEOMETRY_OPERATOR = "$geometry";
    public static final String CENTER_SPHERE_OPERATOR = "$centerSphere";
    public static final String GEO_INTERSECTS_OPERATOR = "$geoIntersects";
    public static final String MAX_DISTANCE_OPERATOR = "$maxDistance";
    public static final String NEAR_SPHERE_OPERATOR = "$nearSphere";
    private final AbstractMongoSession mongoSession;
    private final EntityPersister mongoEntityPersister;
    private final ManualProjections manualProjections;
    private boolean isCodecPersister = false;

    private static Document getIdObjectForGroupBy(Document groupBy) {
        Document id;
        Object value = groupBy.get((Object)"_id");
        if (value instanceof Document) {
            id = (Document)value;
        } else {
            id = new Document();
            groupBy.put("_id", (Object)id);
        }
        return id;
    }

    private static String addProjectionToGroupBy(Document projectObject, Document groupBy, Query.PropertyProjection projection, String operator, String prefix) {
        projectObject.put(projection.getPropertyName(), (Object)1);
        String property = projection.getPropertyName();
        String projectionValueKey = prefix + property.replace('.', '_');
        Document averageProjection = new Document(operator, (Object)("$" + property));
        groupBy.put(projectionValueKey, (Object)averageProjection);
        return projectionValueKey;
    }

    public MongoQuery(AbstractMongoSession session, PersistentEntity entity) {
        super((Session)session, entity);
        this.mongoSession = session;
        this.manualProjections = new ManualProjections(entity);
        if (session != null) {
            this.mongoEntityPersister = (EntityPersister)session.getPersister(entity);
            if (this.mongoEntityPersister instanceof MongoCodecEntityPersister) {
                this.isCodecPersister = true;
            }
        } else {
            this.mongoEntityPersister = null;
        }
    }

    protected void flushBeforeQuery() {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            super.flushBeforeQuery();
        }
    }

    public Document getMongoQuery() {
        Document query = this.createQueryObject(this.entity);
        MongoQuery.populateMongoQuery((AbstractMongoSession)this.getSession(), query, this.criteria, this.entity);
        return query;
    }

    protected List executeQuery(PersistentEntity entity, Query.Junction criteria) {
        AbstractMongoSession mongoSession = this.mongoSession;
        com.mongodb.client.MongoCollection collection = mongoSession.getCollection(entity);
        List projectionList = this.projections().getProjectionList();
        if (this.uniqueResult && projectionList.isEmpty()) {
            Object dbObject;
            if (this.isCodecPersister) {
                collection = collection.withDocumentClass(entity.getJavaClass());
            }
            if ((dbObject = criteria.isEmpty() ? collection.find((Bson)this.createQueryObject(entity)).limit(1).first() : collection.find((Bson)this.getMongoQuery()).limit(1).first()) == null) {
                return this.wrapObjectResultInList(dbObject);
            }
            if (this.isCodecPersister) {
                if (!mongoSession.contains(dbObject)) {
                    EntityAccess entityAccess = mongoSession.createEntityAccess(entity, dbObject);
                    this.mongoEntityPersister.firePostLoadEvent(entity, entityAccess);
                    mongoSession.cacheInstance(dbObject.getClass(), (Serializable)entityAccess.getIdentifier(), dbObject);
                }
                return this.wrapObjectResultInList(dbObject);
            }
            return this.wrapObjectResultInList(this.createObjectFromDBObject((Document)dbObject));
        }
        Document query = this.createQueryObject(entity);
        if (projectionList.isEmpty()) {
            if (this.isCodecPersister) {
                collection = collection.withDocumentClass(entity.getJavaClass()).withCodecRegistry(mongoSession.getDatastore().getCodecRegistry());
            }
            MongoCursor<Document> cursor = this.executeQuery(entity, criteria, (com.mongodb.client.MongoCollection<Document>)collection, query);
            return new MongoResultList(cursor, this.offset, this.mongoEntityPersister);
        }
        MongoQuery.populateMongoQuery((AbstractMongoSession)this.session, query, criteria, entity);
        AggregatePipeline aggregatePipeline = this.buildAggregatePipeline(entity, query, projectionList);
        List<Document> aggregationPipeline = aggregatePipeline.getAggregationPipeline();
        boolean singleResult = aggregatePipeline.isSingleResult();
        List<ProjectedProperty> projectedKeys = aggregatePipeline.getProjectedKeys();
        ArrayList<Object> projectedResults = new ArrayList<Object>();
        AggregateIterable aggregatedResults = collection.aggregate(aggregationPipeline);
        MongoCursor aggregateCursor = aggregatedResults.iterator();
        if (singleResult && aggregateCursor.hasNext()) {
            Document dbo = (Document)aggregateCursor.next();
            for (ProjectedProperty projectedProperty : projectedKeys) {
                Object value = dbo.get((Object)projectedProperty.projectionKey);
                PersistentProperty property = projectedProperty.property;
                if (value != null) {
                    if (property instanceof ToOne) {
                        projectedResults.add(this.session.retrieve(property.getType(), (Serializable)value));
                        continue;
                    }
                    projectedResults.add(value);
                    continue;
                }
                if (!(projectedProperty.projection instanceof Query.CountProjection)) continue;
                projectedResults.add(0);
            }
        } else {
            return new AggregatedResultList((AbstractMongoSession)this.getSession(), (MongoCursor<Document>)aggregateCursor, projectedKeys);
        }
        return projectedResults;
    }

    protected AggregatePipeline buildAggregatePipeline(PersistentEntity entity, Document query, List<Query.Projection> projectionList) {
        return new AggregatePipeline(this, entity, query, projectionList).build();
    }

    protected MongoCursor<Document> executeQuery(PersistentEntity entity, Query.Junction criteria, com.mongodb.client.MongoCollection<Document> collection, Document query) {
        FindIterable cursor;
        if (criteria.isEmpty()) {
            cursor = this.executeQueryAndApplyPagination(collection, query);
        } else {
            MongoQuery.populateMongoQuery((AbstractMongoSession)this.session, query, criteria, entity);
            cursor = this.executeQueryAndApplyPagination(collection, query);
        }
        if (this.queryArguments != null && this.queryArguments.containsKey(HINT_ARGUMENT)) {
            Object hint = this.queryArguments.get(HINT_ARGUMENT);
            cursor = cursor.modifiers((Bson)new Document("$hint", hint));
        }
        return cursor.iterator();
    }

    protected FindIterable<Document> executeQueryAndApplyPagination(com.mongodb.client.MongoCollection<Document> collection, Document query) {
        Object readConcernObject = this.queryArguments.get(READ_CONCERN_ARGUMENT);
        if (readConcernObject instanceof ReadConcern) {
            collection = collection.withReadConcern((ReadConcern)readConcernObject);
        }
        FindIterable iterable = collection.find((Bson)query);
        if (this.offset > 0) {
            iterable.skip(this.offset);
        }
        if (this.max > -1) {
            iterable.limit(this.max);
        }
        if (this.uniqueResult) {
            iterable.limit(1);
        }
        if (!this.orderBy.isEmpty()) {
            Document orderObject = new Document();
            for (Query.Order order : this.orderBy) {
                String property = order.getProperty();
                property = MongoQuery.getPropertyName((PersistentEntity)this.entity, (String)property);
                orderObject.put(property, (Object)(order.getDirection() == Query.Order.Direction.DESC ? -1 : 1));
            }
            iterable.sort((Bson)orderObject);
        } else {
            MongoCollection coll = (MongoCollection)this.entity.getMapping().getMappedForm();
            if (coll != null && coll.getSort() != null) {
                Document orderObject = new Document();
                Query.Order order = coll.getSort();
                String property = order.getProperty();
                property = MongoQuery.getPropertyName((PersistentEntity)this.entity, (String)property);
                orderObject.put(property, (Object)(order.getDirection() == Query.Order.Direction.DESC ? -1 : 1));
                iterable.sort((Bson)orderObject);
            }
        }
        return iterable;
    }

    private Document getClassFieldDocument(PersistentEntity entity) {
        Object classFieldValue;
        Collection childEntities = entity.getMappingContext().getChildEntities(entity);
        if (childEntities.size() > 0) {
            HashMap classValue = new HashMap();
            ArrayList<String> classes = new ArrayList<String>();
            classes.add(entity.getDiscriminator());
            for (PersistentEntity childEntity : childEntities) {
                classes.add(childEntity.getDiscriminator());
            }
            classValue.put(MONGO_IN_OPERATOR, classes);
            classFieldValue = classValue;
        } else {
            classFieldValue = entity.getDiscriminator();
        }
        return new Document("_class", classFieldValue);
    }

    protected Document createQueryObject(PersistentEntity persistentEntity) {
        Document query = persistentEntity.isRoot() ? new Document() : this.getClassFieldDocument(persistentEntity);
        return query;
    }

    public static void populateMongoQuery(final AbstractMongoSession session, Document query, Query.Junction criteria, final PersistentEntity entity) {
        Object queryEncoder;
        if (session instanceof MongoCodecSession) {
            MongoDatastore datastore = session.getDatastore();
            final CodecRegistry codecRegistry = datastore.getCodecRegistry();
            queryEncoder = new EmbeddedQueryEncoder(){

                public Object encode(Embedded embedded, Object instance) {
                    PersistentEntityCodec codec = (PersistentEntityCodec)codecRegistry.get(embedded.getType());
                    BsonDocument doc = new BsonDocument();
                    codec.encode((BsonWriter)new BsonDocumentWriter(doc), instance, BsonQuery.ENCODER_CONTEXT, false);
                    return doc;
                }
            };
        } else {
            queryEncoder = new EmbeddedQueryEncoder(){

                public Object encode(Embedded embedded, Object instance) {
                    MongoEntityPersister persister = (MongoEntityPersister)session.getPersister(entity.getJavaClass());
                    return persister.createNativeObjectForEmbedded((Association)embedded, instance);
                }
            };
        }
        MongoQuery.populateMongoQuery(queryEncoder, query, criteria, entity);
    }

    public static void populateMongoQuery(EmbeddedQueryEncoder queryEncoder, Document query, Query.Junction criteria, PersistentEntity entity) {
        ArrayList<Document> subList = null;
        if (criteria.getCriteria().size() > 1) {
            if (criteria instanceof Query.Disjunction) {
                subList = new ArrayList<Document>();
                query.put(MONGO_OR_OPERATOR, subList);
            } else if (criteria instanceof Query.Conjunction) {
                subList = new ArrayList();
                query.put(MONGO_AND_OPERATOR, subList);
            }
        }
        for (Query.Criterion criterion : criteria.getCriteria()) {
            BsonQuery.QueryHandler queryHandler = (BsonQuery.QueryHandler)queryHandlers.get(criterion.getClass());
            if (queryHandler != null) {
                CustomTypeMarshaller customTypeMarshaller;
                Query.PropertyCriterion pc;
                PersistentProperty property;
                Document dbo = query;
                if (subList != null) {
                    dbo = new Document();
                    subList.add(dbo);
                }
                if (criterion instanceof Query.PropertyCriterion && !(criterion instanceof GeoCriterion) && (property = entity.getPropertyByName((pc = (Query.PropertyCriterion)criterion).getProperty())) instanceof Custom && !((customTypeMarshaller = ((Custom)property).getCustomTypeMarshaller()) instanceof CodecCustomTypeMarshaller)) {
                    customTypeMarshaller.query(property, pc, (Object)query);
                    continue;
                }
                queryHandler.handle(queryEncoder, (Object)criterion, dbo, entity);
                continue;
            }
            throw new InvalidDataAccessResourceUsageException("Queries of type " + criterion.getClass().getSimpleName() + " are not supported by this implementation");
        }
    }

    private Object createObjectFromDBObject(Document dbObject) {
        Object id = dbObject.get((Object)"_id");
        Class type = this.mongoEntityPersister.getPersistentEntity().getJavaClass();
        Object instance = this.mongoSession.getCachedInstance(type, (Serializable)id);
        if (instance == null) {
            instance = ((MongoEntityPersister)this.mongoEntityPersister).createObjectFromNativeEntry(this.mongoEntityPersister.getPersistentEntity(), (Serializable)id, dbObject);
            this.mongoSession.cacheInstance(type, (Serializable)id, instance);
        }
        return instance;
    }

    private List wrapObjectResultInList(Object object) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(object);
        return result;
    }

    public Query near(String property, List value) {
        this.add((Query.Criterion)new Near(property, value));
        return this;
    }

    public Query near(String property, Point value) {
        this.add((Query.Criterion)new Near(property, value));
        return this;
    }

    public Query near(String property, List value, Distance maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query near(String property, Point value, Distance maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query near(String property, List value, Number maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query near(String property, Point value, Number maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, List value) {
        this.add((Query.Criterion)new NearSphere(property, value));
        return this;
    }

    public Query nearSphere(String property, Point value) {
        this.add((Query.Criterion)new NearSphere(property, value));
        return this;
    }

    public Query nearSphere(String property, List value, Distance maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, Point value, Distance maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, List value, Number maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, Point value, Number maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query withinBox(String property, List value) {
        this.add((Query.Criterion)new WithinBox(property, value));
        return this;
    }

    public Query geoWithin(String property, Shape shape) {
        this.add((Query.Criterion)new GeoWithin(property, shape));
        return this;
    }

    public Query geoIntersects(String property, GeoJSON shape) {
        this.add((Query.Criterion)new GeoIntersects(property, shape));
        return this;
    }

    public Query withinPolygon(String property, List value) {
        this.add((Query.Criterion)new WithinPolygon(property, value));
        return this;
    }

    public Query withinCircle(String property, List value) {
        this.add((Query.Criterion)new WithinBox(property, value));
        return this;
    }

    public void setArguments(Map arguments) {
        this.queryArguments = arguments;
    }

    static {
        queryHandlers.put(Query.IdEquals.class, new BsonQuery.QueryHandler<Query.IdEquals>(){

            public void handle(EmbeddedQueryEncoder queryEncoder, Query.IdEquals criterion, Document query, PersistentEntity entity) {
                Object value = criterion.getValue();
                MappingContext mappingContext = entity.getMappingContext();
                PersistentProperty identity = entity.getIdentity();
                Object converted = mappingContext.getConversionService().convert(value, identity.getType());
                query.put("_id", converted);
            }
        });
        queryHandlers.put(AssociationQuery.class, new BsonQuery.QueryHandler<AssociationQuery>(){

            public void handle(EmbeddedQueryEncoder queryEncoder, AssociationQuery criterion, Document query, PersistentEntity entity) {
                Association association = criterion.getAssociation();
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                if (association instanceof EmbeddedCollection) {
                    Document associationCollectionQuery = new Document();
                    MongoQuery.populateMongoQuery(queryEncoder, associationCollectionQuery, criterion.getCriteria(), associatedEntity);
                    Document collectionQuery = new Document("$elemMatch", (Object)associationCollectionQuery);
                    String propertyKey = MongoQuery.getPropertyName((PersistentEntity)entity, (String)association.getName());
                    query.put(propertyKey, (Object)collectionQuery);
                } else if (associatedEntity instanceof EmbeddedPersistentEntity || association instanceof Embedded) {
                    Document associatedEntityQuery = new Document();
                    MongoQuery.populateMongoQuery(queryEncoder, associatedEntityQuery, criterion.getCriteria(), associatedEntity);
                    for (String property : associatedEntityQuery.keySet()) {
                        String propertyKey = MongoQuery.getPropertyName((PersistentEntity)entity, (String)association.getName());
                        query.put(propertyKey + '.' + property, associatedEntityQuery.get((Object)property));
                    }
                } else {
                    throw new UnsupportedOperationException("Join queries are not supported by MongoDB");
                }
            }
        });
        queryHandlers.put(WithinBox.class, new BsonQuery.QueryHandler<WithinBox>(){

            public void handle(EmbeddedQueryEncoder queryEncoder, WithinBox withinBox, Document query, PersistentEntity entity) {
                Document nearQuery = new Document();
                Document box = new Document();
                MongoEntityPersister.setDBObjectValue(box, MongoQuery.BOX_OPERATOR, withinBox.getValues(), entity.getMappingContext());
                nearQuery.put(MongoQuery.WITHIN_OPERATOR, (Object)box);
                String propertyName = MongoQuery.getPropertyName((PersistentEntity)entity, (Query.PropertyNameCriterion)((Query.PropertyNameCriterion)withinBox));
                query.put(propertyName, (Object)nearQuery);
            }
        });
        queryHandlers.put(WithinPolygon.class, new BsonQuery.QueryHandler<WithinPolygon>(){

            public void handle(EmbeddedQueryEncoder queryEncoder, WithinPolygon withinPolygon, Document query, PersistentEntity entity) {
                Document nearQuery = new Document();
                Document box = new Document();
                MongoEntityPersister.setDBObjectValue(box, MongoQuery.POLYGON_OPERATOR, withinPolygon.getValues(), entity.getMappingContext());
                nearQuery.put(MongoQuery.WITHIN_OPERATOR, (Object)box);
                String propertyName = MongoQuery.getPropertyName((PersistentEntity)entity, (Query.PropertyNameCriterion)((Query.PropertyNameCriterion)withinPolygon));
                query.put(propertyName, (Object)nearQuery);
            }
        });
        queryHandlers.put(WithinCircle.class, new BsonQuery.QueryHandler<WithinCircle>(){

            public void handle(EmbeddedQueryEncoder queryEncoder, WithinCircle withinCentre, Document query, PersistentEntity entity) {
                Document nearQuery = new Document();
                Document center = new Document();
                MongoEntityPersister.setDBObjectValue(center, MongoQuery.CENTER_OPERATOR, withinCentre.getValues(), entity.getMappingContext());
                nearQuery.put(MongoQuery.WITHIN_OPERATOR, (Object)center);
                String propertyName = MongoQuery.getPropertyName((PersistentEntity)entity, (Query.PropertyNameCriterion)((Query.PropertyNameCriterion)withinCentre));
                query.put(propertyName, (Object)nearQuery);
            }
        });
        BsonQuery.QueryHandler<Near> nearHandler = new BsonQuery.QueryHandler<Near>(){

            public void handle(EmbeddedQueryEncoder queryEncoder, Near near, Document query, PersistentEntity entity) {
                String nearOperator;
                Document nearQuery = new Document();
                Object value = near.getValue();
                String string = nearOperator = near instanceof NearSphere ? MongoQuery.NEAR_SPHERE_OPERATOR : MongoQuery.NEAR_OPERATOR;
                if (value instanceof List || value instanceof Map) {
                    MongoEntityPersister.setDBObjectValue(nearQuery, nearOperator, value, entity.getMappingContext());
                } else if (value instanceof Point) {
                    Document geoJson = GeoJSONType.convertToGeoDocument((Point)value);
                    Document geometry = new Document();
                    geometry.put(MongoQuery.GEOMETRY_OPERATOR, (Object)geoJson);
                    if (near.maxDistance != null) {
                        geometry.put(MongoQuery.MAX_DISTANCE_OPERATOR, (Object)near.maxDistance.getValue());
                    }
                    nearQuery.put(nearOperator, (Object)geometry);
                }
                String propertyName = MongoQuery.getPropertyName((PersistentEntity)entity, (Query.PropertyNameCriterion)((Query.PropertyNameCriterion)near));
                query.put(propertyName, (Object)nearQuery);
            }
        };
        queryHandlers.put(Near.class, nearHandler);
        queryHandlers.put(NearSphere.class, nearHandler);
        queryHandlers.put(GeoWithin.class, new BsonQuery.QueryHandler<GeoWithin>(){

            public void handle(EmbeddedQueryEncoder queryEncoder, GeoWithin geoWithin, Document query, PersistentEntity entity) {
                Document queryRoot = new Document();
                Document queryGeoWithin = new Document();
                queryRoot.put(MongoQuery.GEO_WITHIN_OPERATOR, (Object)queryGeoWithin);
                String targetProperty = MongoQuery.getPropertyName((PersistentEntity)entity, (Query.PropertyNameCriterion)((Query.PropertyNameCriterion)geoWithin));
                Object value = geoWithin.getValue();
                if (value instanceof Shape) {
                    Shape shape = (Shape)value;
                    if (shape instanceof Polygon) {
                        Polygon p = (Polygon)shape;
                        Document geoJson = GeoJSONType.convertToGeoDocument(p);
                        queryGeoWithin.put(MongoQuery.GEOMETRY_OPERATOR, (Object)geoJson);
                    } else if (shape instanceof Box) {
                        queryGeoWithin.put(MongoQuery.BOX_OPERATOR, shape.asList());
                    } else if (shape instanceof Circle) {
                        queryGeoWithin.put(MongoQuery.CENTER_OPERATOR, shape.asList());
                    } else if (shape instanceof Sphere) {
                        queryGeoWithin.put(MongoQuery.CENTER_SPHERE_OPERATOR, shape.asList());
                    }
                } else if (value instanceof Map) {
                    queryGeoWithin.putAll((Map)value);
                }
                query.put(targetProperty, (Object)queryRoot);
            }
        });
        queryHandlers.put(GeoIntersects.class, new BsonQuery.QueryHandler<GeoIntersects>(){

            public void handle(EmbeddedQueryEncoder queryEncoder, GeoIntersects geoIntersects, Document query, PersistentEntity entity) {
                Document queryRoot = new Document();
                Document queryGeoWithin = new Document();
                queryRoot.put(MongoQuery.GEO_INTERSECTS_OPERATOR, (Object)queryGeoWithin);
                String targetProperty = MongoQuery.getPropertyName((PersistentEntity)entity, (Query.PropertyNameCriterion)((Query.PropertyNameCriterion)geoIntersects));
                Object value = geoIntersects.getValue();
                if (value instanceof GeoJSON) {
                    Shape shape = (Shape)value;
                    Document geoJson = GeoJSONType.convertToGeoDocument(shape);
                    queryGeoWithin.put(MongoQuery.GEOMETRY_OPERATOR, (Object)geoJson);
                } else if (value instanceof Map) {
                    queryGeoWithin.putAll((Map)value);
                }
                query.put(targetProperty, (Object)queryRoot);
            }
        });
        queryHandlers.put(Query.Conjunction.class, new BsonQuery.QueryHandler<Query.Conjunction>(){

            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Conjunction criterion, Document query, PersistentEntity entity) {
                MongoQuery.populateMongoQuery(queryEncoder, query, (Query.Junction)criterion, entity);
            }
        });
        queryHandlers.put(Query.Disjunction.class, new BsonQuery.QueryHandler<Query.Disjunction>(){

            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Disjunction criterion, Document query, PersistentEntity entity) {
                MongoQuery.populateMongoQuery(queryEncoder, query, (Query.Junction)criterion, entity);
            }
        });
        groupByProjectionHandlers.put(Query.AvgProjection.class, new BsonQuery.ProjectionHandler<Query.AvgProjection>(){

            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.AvgProjection projection) {
                return MongoQuery.addProjectionToGroupBy(projectObject, groupBy, (Query.PropertyProjection)projection, "$avg", "avg_");
            }
        });
        groupByProjectionHandlers.put(Query.CountProjection.class, new BsonQuery.ProjectionHandler<Query.CountProjection>(){

            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.CountProjection projection) {
                projectObject.put("_id", (Object)1);
                String projectionKey = "count";
                groupBy.put(projectionKey, (Object)new Document("$sum", (Object)1));
                return projectionKey;
            }
        });
        groupByProjectionHandlers.put(Query.CountDistinctProjection.class, new BsonQuery.ProjectionHandler<Query.CountDistinctProjection>(){

            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.CountDistinctProjection projection) {
                projectObject.put(projection.getPropertyName(), (Object)1);
                String property = projection.getPropertyName();
                String projectionValueKey = "countDistinct_" + property;
                Document id = MongoQuery.getIdObjectForGroupBy(groupBy);
                id.put(projectionValueKey, (Object)("$" + property));
                return projectionValueKey;
            }
        });
        groupByProjectionHandlers.put(Query.MinProjection.class, new BsonQuery.ProjectionHandler<Query.MinProjection>(){

            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.MinProjection projection) {
                return MongoQuery.addProjectionToGroupBy(projectObject, groupBy, (Query.PropertyProjection)projection, "$min", "min_");
            }
        });
        groupByProjectionHandlers.put(Query.MaxProjection.class, new BsonQuery.ProjectionHandler<Query.MaxProjection>(){

            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.MaxProjection projection) {
                return MongoQuery.addProjectionToGroupBy(projectObject, groupBy, (Query.PropertyProjection)projection, "$max", "max_");
            }
        });
        groupByProjectionHandlers.put(Query.SumProjection.class, new BsonQuery.ProjectionHandler<Query.SumProjection>(){

            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.SumProjection projection) {
                return MongoQuery.addProjectionToGroupBy(projectObject, groupBy, (Query.PropertyProjection)projection, "$sum", "sum_");
            }
        });
        projectProjectionHandlers.put(Query.DistinctPropertyProjection.class, new BsonQuery.ProjectionHandler<Query.DistinctPropertyProjection>(){

            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.DistinctPropertyProjection projection) {
                String property = projection.getPropertyName();
                projectObject.put(property, (Object)1);
                Document id = MongoQuery.getIdObjectForGroupBy(groupBy);
                String projectedValueKey = property.replace('.', '_');
                id.put(projectedValueKey, (Object)("$" + property));
                return projectedValueKey;
            }
        });
        projectProjectionHandlers.put(Query.PropertyProjection.class, new BsonQuery.ProjectionHandler<Query.PropertyProjection>(){

            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.PropertyProjection projection) {
                String property = projection.getPropertyName();
                projectObject.put(property, (Object)1);
                Document id = MongoQuery.getIdObjectForGroupBy(groupBy);
                String projectedValueKey = property.replace('.', '_');
                id.put(projectedValueKey, (Object)("$" + property));
                id.put("_id", (Object)"$_id");
                return projectedValueKey;
            }
        });
        projectProjectionHandlers.put(Query.IdProjection.class, new BsonQuery.ProjectionHandler<Query.IdProjection>(){

            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.IdProjection projection) {
                projectObject.put("_id", (Object)1);
                Document id = MongoQuery.getIdObjectForGroupBy(groupBy);
                id.put("_id", (Object)"$_id");
                return "_id";
            }
        });
    }

    protected static class AggregatePipeline {
        private PersistentEntity entity;
        private Document query;
        private List<Query.Projection> projectionList;
        private List<Document> aggregationPipeline;
        private List<ProjectedProperty> projectedKeys;
        private boolean singleResult;
        private final MongoQuery mongoQuery;

        public AggregatePipeline(MongoQuery mongoQuery, PersistentEntity entity, Document queryObject, List<Query.Projection> projectionList) {
            this.mongoQuery = mongoQuery;
            this.entity = entity;
            this.query = queryObject;
            this.projectionList = projectionList;
        }

        public List<Document> getAggregationPipeline() {
            return this.aggregationPipeline;
        }

        public List<ProjectedProperty> getProjectedKeys() {
            return this.projectedKeys;
        }

        public boolean isSingleResult() {
            return this.singleResult;
        }

        public AggregatePipeline build() {
            int offset;
            int max;
            List orderBy;
            this.aggregationPipeline = new ArrayList<Document>();
            if (!this.query.keySet().isEmpty()) {
                this.aggregationPipeline.add(new Document("$match", (Object)this.query));
            }
            if (!(orderBy = this.mongoQuery.getOrderBy()).isEmpty()) {
                Document sortBy = new Document();
                Document sort = new Document("$sort", (Object)sortBy);
                for (Query.Order order : orderBy) {
                    sortBy.put(order.getProperty(), (Object)(order.getDirection() == Query.Order.Direction.ASC ? 1 : -1));
                }
                this.aggregationPipeline.add(sort);
            }
            if ((max = this.mongoQuery.max) > 0) {
                this.aggregationPipeline.add(new Document("$limit", (Object)max));
            }
            if ((offset = this.mongoQuery.offset) > 0) {
                this.aggregationPipeline.add(new Document("$skip", (Object)offset));
            }
            this.projectedKeys = new ArrayList<ProjectedProperty>();
            this.singleResult = true;
            Document projectObject = new Document();
            Document groupByObject = new Document();
            groupByObject.put("_id", (Object)0);
            Document additionalGroupBy = null;
            for (Query.Projection projection : this.projectionList) {
                BsonQuery.ProjectionHandler projectionHandler = (BsonQuery.ProjectionHandler)projectProjectionHandlers.get(projection.getClass());
                ProjectedProperty projectedProperty = new ProjectedProperty();
                projectedProperty.projection = projection;
                if (projection instanceof Query.PropertyProjection) {
                    Query.PropertyProjection propertyProjection = (Query.PropertyProjection)projection;
                    String propertyName = propertyProjection.getPropertyName();
                    PersistentProperty property = this.entity.getPropertyByName(propertyName);
                    if (property != null) {
                        projectedProperty.property = property;
                    } else if (!propertyName.contains(".")) {
                        throw new InvalidDataAccessResourceUsageException("Attempt to project on a non-existent project [" + propertyName + "]");
                    }
                }
                if (projectionHandler != null) {
                    this.singleResult = false;
                    String aggregationKey = projectionHandler.handle(this.entity, projectObject, groupByObject, projection);
                    projectedProperty.projectionKey = aggregationKey = "id." + aggregationKey;
                    this.projectedKeys.add(projectedProperty);
                    continue;
                }
                projectionHandler = (BsonQuery.ProjectionHandler)groupByProjectionHandlers.get(projection.getClass());
                if (projectionHandler == null) continue;
                projectedProperty.projectionKey = projectionHandler.handle(this.entity, projectObject, groupByObject, projection);
                this.projectedKeys.add(projectedProperty);
                if (!(projection instanceof Query.CountDistinctProjection)) continue;
                Document finalCount = new Document("_id", (Object)1);
                finalCount.put(projectedProperty.projectionKey, (Object)new Document("$sum", (Object)1));
                additionalGroupBy = new Document("$group", (Object)finalCount);
            }
            if (!projectObject.isEmpty()) {
                this.aggregationPipeline.add(new Document("$project", (Object)projectObject));
            }
            this.aggregationPipeline.add(new Document("$group", (Object)groupByObject));
            if (additionalGroupBy != null) {
                this.aggregationPipeline.add(additionalGroupBy);
            }
            return this;
        }
    }

    public static class ProjectedProperty {
        public Query.Projection projection;
        public String projectionKey;
        public PersistentProperty property;
    }

    public static class MongoResultList
    extends AbstractResultList {
        private EntityPersister mongoEntityPersister;
        private MongoCursor cursor;
        private boolean isCodecPersister;

        public MongoResultList(MongoCursor cursor, int offset, EntityPersister mongoEntityPersister) {
            super(offset, (Iterator)cursor);
            this.cursor = cursor;
            this.mongoEntityPersister = mongoEntityPersister;
            this.isCodecPersister = mongoEntityPersister instanceof MongoCodecEntityPersister;
        }

        public void close() throws IOException {
            this.cursor.close();
        }

        public String toString() {
            this.initializeFully();
            return this.initializedObjects.toString();
        }

        public MongoCursor getCursor() {
            return this.cursor;
        }

        protected Object nextDecoded() {
            AbstractMongoSession session;
            Object o = this.cursor.next();
            if (this.isCodecPersister && !(session = (AbstractMongoSession)this.mongoEntityPersister.getSession()).contains(o)) {
                PersistentEntity entity = this.mongoEntityPersister.getPersistentEntity();
                EntityAccess entityAccess = session.createEntityAccess(entity, o);
                Object id = entityAccess.getIdentifier();
                if (id != null) {
                    session.cacheInstance(entity.getJavaClass(), (Serializable)id, o);
                }
                this.mongoEntityPersister.firePostLoadEvent(entity, entityAccess);
            }
            return o;
        }

        protected Object convertObject(Object object) {
            return this.isCodecPersister ? object : this.convertDBObject(object);
        }

        protected Object convertDBObject(Object object) {
            Class type;
            if (this.mongoEntityPersister instanceof MongoCodecEntityPersister) {
                return object;
            }
            Document dbObject = (Document)object;
            Object id = dbObject.get((Object)"_id");
            SessionImplementor session = (SessionImplementor)this.mongoEntityPersister.getSession();
            Object instance = session.getCachedInstance(type = this.mongoEntityPersister.getPersistentEntity().getJavaClass(), (Serializable)id);
            if (instance == null) {
                MongoEntityPersister mep = (MongoEntityPersister)this.mongoEntityPersister;
                instance = mep.createObjectFromNativeEntry(this.mongoEntityPersister.getPersistentEntity(), (Serializable)id, dbObject);
                session.cacheInstance(type, (Serializable)id, instance);
            }
            return instance;
        }
    }

    public static class AggregatedResultList
    extends AbstractList
    implements Closeable {
        private MongoCursor cursor;
        private List<ProjectedProperty> projectedProperties;
        private List initializedObjects = new ArrayList();
        private int internalIndex = 0;
        private boolean initialized = false;
        private boolean containsAssociations = false;
        private AbstractMongoSession session;

        public AggregatedResultList(AbstractMongoSession session, MongoCursor<Document> cursor, List<ProjectedProperty> projectedProperties) {
            this.cursor = cursor;
            this.projectedProperties = projectedProperties;
            this.session = session;
            for (ProjectedProperty projectedProperty : projectedProperties) {
                if (!(projectedProperty.property instanceof Association)) continue;
                this.containsAssociations = true;
                break;
            }
        }

        @Override
        public String toString() {
            return this.initializedObjects.toString();
        }

        @Override
        public Object get(int index) {
            if (this.containsAssociations) {
                this.initializeFully();
            }
            if (this.initializedObjects.size() > index) {
                return this.initializedObjects.get(index);
            }
            if (!this.initialized) {
                boolean hasResults = false;
                while (this.cursor.hasNext()) {
                    hasResults = true;
                    Document dbo = (Document)this.cursor.next();
                    Object projected = this.addInitializedObject(dbo);
                    if (index != this.internalIndex) continue;
                    return projected;
                }
                if (!hasResults) {
                    this.handleNoResults();
                }
                this.initialized = true;
            }
            throw new ArrayIndexOutOfBoundsException("Index value " + index + " exceeds size of aggregate list");
        }

        @Override
        public Object set(int index, Object element) {
            this.initializeFully();
            return this.initializedObjects.set(index, element);
        }

        @Override
        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator listIterator(int index) {
            this.initializeFully();
            return this.initializedObjects.listIterator(index);
        }

        protected void initializeFully() {
            if (this.initialized) {
                return;
            }
            if (this.containsAssociations) {
                if (this.projectedProperties.size() == 1) {
                    ProjectedProperty projectedProperty = this.projectedProperties.get(0);
                    PersistentProperty property = projectedProperty.property;
                    ArrayList<Serializable> identifiers = new ArrayList<Serializable>();
                    boolean hasResults = false;
                    while (this.cursor.hasNext()) {
                        hasResults = true;
                        Document dbo = (Document)this.cursor.next();
                        Object id = this.getProjectedValue(dbo, projectedProperty.projectionKey);
                        identifiers.add((Serializable)id);
                    }
                    if (!hasResults) {
                        this.handleNoResults();
                    } else if (property instanceof Embedded) {
                        Embedded embedded = (Embedded)property;
                        ArrayList<Object> embeddedList = new ArrayList<Object>();
                        CodecRegistry codecRegistry = this.session.getDatastore().getCodecRegistry();
                        PersistentEntityCodec codec = new PersistentEntityCodec(codecRegistry, embedded.getAssociatedEntity());
                        for (Serializable embeddedDoc : identifiers) {
                            if (!(embeddedDoc instanceof Document)) continue;
                            Document documentObject = (Document)embeddedDoc;
                            Object decoded = codec.decode((BsonReader)new BsonDocumentReader(documentObject.toBsonDocument(Document.class, codecRegistry)));
                            embeddedList.add(decoded);
                        }
                        this.initializedObjects = embeddedList;
                    } else {
                        this.initializedObjects = this.session.retrieveAll(property.getType(), identifiers);
                    }
                } else {
                    Map<Integer, Map<Class, List<Serializable>>> associationMap = this.createAssociationMap();
                    boolean hasResults = false;
                    while (this.cursor.hasNext()) {
                        hasResults = true;
                        Document dbo = (Document)this.cursor.next();
                        ArrayList<Object> projectedResult = new ArrayList<Object>();
                        int index = 0;
                        for (ProjectedProperty projectedProperty : this.projectedProperties) {
                            PersistentProperty property = projectedProperty.property;
                            Object value = this.getProjectedValue(dbo, projectedProperty.projectionKey);
                            if (property instanceof Association && !(property instanceof Embedded) && !(property instanceof EmbeddedCollection) && !(property instanceof Basic)) {
                                Map<Class, List<Serializable>> identifierMap = associationMap.get(index);
                                Class type = ((Association)property).getAssociatedEntity().getJavaClass();
                                identifierMap.get(type).add((Serializable)value);
                            }
                            projectedResult.add(value);
                            ++index;
                        }
                        this.initializedObjects.add(projectedResult);
                    }
                    if (!hasResults) {
                        this.handleNoResults();
                        return;
                    }
                    HashMap<Integer, List> finalResults = new HashMap<Integer, List>();
                    for (Integer index : associationMap.keySet()) {
                        Map<Class, List<Serializable>> associatedEntityIdentifiers = associationMap.get(index);
                        for (Class associationClass : associatedEntityIdentifiers.keySet()) {
                            List<Serializable> identifiers = associatedEntityIdentifiers.get(associationClass);
                            finalResults.put(index, this.session.retrieveAll(associationClass, identifiers));
                        }
                    }
                    for (Integer initializedObject : this.initializedObjects) {
                        List projected = (List)((Object)initializedObject);
                        for (Integer index : finalResults.keySet()) {
                            List resultsByIndex = (List)finalResults.get(index);
                            if (index < resultsByIndex.size()) {
                                projected.set(index, resultsByIndex.get(index));
                                continue;
                            }
                            projected.set(index, null);
                        }
                    }
                }
            } else {
                boolean hasResults = false;
                while (this.cursor.hasNext()) {
                    hasResults = true;
                    Document dbo = (Document)this.cursor.next();
                    this.addInitializedObject(dbo);
                }
                if (!hasResults) {
                    this.handleNoResults();
                }
            }
            this.initialized = true;
        }

        protected void handleNoResults() {
            ProjectedProperty projectedProperty = this.projectedProperties.get(0);
            if (projectedProperty.projection instanceof Query.CountProjection) {
                this.initializedObjects.add(0);
            }
        }

        private Map<Integer, Map<Class, List<Serializable>>> createAssociationMap() {
            HashMap<Integer, Map<Class, List<Serializable>>> associationMap = new HashMap();
            associationMap = DefaultGroovyMethods.withDefault(associationMap, (Closure)new Closure(this){

                public Object doCall(Object o) {
                    Map subMap = new HashMap();
                    subMap = DefaultGroovyMethods.withDefault(subMap, (Closure)new Closure((Object)this){

                        public Object doCall(Object o) {
                            return new ArrayList();
                        }
                    });
                    return subMap;
                }
            });
            return associationMap;
        }

        @Override
        public Iterator iterator() {
            if (this.initialized || this.containsAssociations || this.internalIndex > 0) {
                this.initializeFully();
                return this.initializedObjects.iterator();
            }
            if (!this.cursor.hasNext()) {
                this.handleNoResults();
                return this.initializedObjects.iterator();
            }
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    boolean hasMore = cursor.hasNext();
                    if (!hasMore) {
                        initialized = true;
                    }
                    return hasMore;
                }

                public Object next() {
                    Document dbo = (Document)cursor.next();
                    return this.addInitializedObject(dbo);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Aggregate result list cannot be mutated.");
                }
            };
        }

        private Object addInitializedObject(Document dbo) {
            if (this.projectedProperties.size() > 1) {
                ArrayList<Object> projected = new ArrayList<Object>();
                for (ProjectedProperty projectedProperty : this.projectedProperties) {
                    Object value = this.getProjectedValue(dbo, projectedProperty.projectionKey);
                    projected.add(value);
                }
                this.initializedObjects.add(this.internalIndex, projected);
                ++this.internalIndex;
                return projected;
            }
            ProjectedProperty projectedProperty = this.projectedProperties.get(0);
            Object projected = this.getProjectedValue(dbo, projectedProperty.projectionKey);
            this.initializedObjects.add(this.internalIndex, projected);
            ++this.internalIndex;
            return projected;
        }

        private Object getProjectedValue(Document dbo, String projectionKey) {
            Object value;
            if (projectionKey.startsWith("id.")) {
                projectionKey = projectionKey.substring(3);
                Document id = (Document)dbo.get((Object)"_id");
                value = id.get((Object)projectionKey);
            } else {
                value = dbo.get((Object)projectionKey);
            }
            return value;
        }

        @Override
        public int size() {
            this.initializeFully();
            return this.initializedObjects.size();
        }

        @Override
        public void close() throws IOException {
            this.cursor.close();
        }
    }

    public static class GeoIntersects
    extends GeoCriterion {
        public GeoIntersects(String name, Object value) {
            super(name, value);
        }
    }

    public static class GeoWithin
    extends GeoCriterion {
        public GeoWithin(String name, Object value) {
            super(name, value);
        }
    }

    public static class GeoCriterion
    extends Query.PropertyCriterion {
        public GeoCriterion(String name, Object value) {
            super(name, value);
        }
    }

    public static class WithinCircle
    extends Query.PropertyCriterion {
        public WithinCircle(String name, List value) {
            super(name, (Object)value);
        }

        public List getValues() {
            return (List)this.getValue();
        }

        public void setValue(List matrix) {
            this.value = matrix;
        }
    }

    public static class WithinPolygon
    extends Query.PropertyCriterion {
        public WithinPolygon(String name, List value) {
            super(name, (Object)value);
        }

        public List getValues() {
            return (List)this.getValue();
        }

        public void setValue(List value) {
            this.value = value;
        }
    }

    public static class WithinBox
    extends Query.PropertyCriterion {
        public WithinBox(String name, List value) {
            super(name, (Object)value);
        }

        public List getValues() {
            return (List)this.getValue();
        }

        public void setValue(List matrix) {
            this.value = matrix;
        }
    }

    public static class NearSphere
    extends Near {
        public NearSphere(String name, Object value) {
            super(name, value);
        }

        public NearSphere(String name, Object value, Distance maxDistance) {
            super(name, value, maxDistance);
        }

        public NearSphere(String name, Object value, Number maxDistance) {
            super(name, value, maxDistance);
        }
    }

    public static class Near
    extends GeoCriterion {
        Distance maxDistance = null;

        public Near(String name, Object value) {
            super(name, value);
        }

        public Near(String name, Object value, Distance maxDistance) {
            super(name, value);
            this.maxDistance = maxDistance;
        }

        public Near(String name, Object value, Number maxDistance) {
            super(name, value);
            this.maxDistance = Distance.valueOf(maxDistance.doubleValue());
        }

        public void setMaxDistance(Distance maxDistance) {
            this.maxDistance = maxDistance;
        }
    }
}

