/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.IndexOptions;
import grails.gorm.multitenancy.Tenants;
import groovy.lang.Closure;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.persistence.FlushModeType;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.grails.datastore.bson.codecs.CodecExtensions;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.gorm.GormInstanceApi;
import org.grails.datastore.gorm.GormValidationApi;
import org.grails.datastore.gorm.events.AutoTimestampEventListener;
import org.grails.datastore.gorm.events.ConfigurableApplicationEventPublisher;
import org.grails.datastore.gorm.events.DefaultApplicationEventPublisher;
import org.grails.datastore.gorm.events.DomainEventListener;
import org.grails.datastore.gorm.mongo.MongoGormEnhancer;
import org.grails.datastore.gorm.mongo.api.MongoStaticApi;
import org.grails.datastore.gorm.multitenancy.MultiTenantEventListener;
import org.grails.datastore.gorm.utils.ClasspathEntityScanner;
import org.grails.datastore.gorm.validation.constraints.MappingContextAwareConstraintFactory;
import org.grails.datastore.gorm.validation.constraints.builtin.UniqueConstraint;
import org.grails.datastore.gorm.validation.constraints.factory.ConstraintFactory;
import org.grails.datastore.gorm.validation.constraints.registry.ConstraintRegistry;
import org.grails.datastore.gorm.validation.listener.ValidationEventListener;
import org.grails.datastore.gorm.validation.registry.support.ValidatorRegistries;
import org.grails.datastore.mapping.core.AbstractDatastore;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.DatastoreUtils;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.StatelessDatastore;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSourceFactory;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.core.connections.ConnectionSources;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesInitializer;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesListener;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesSupport;
import org.grails.datastore.mapping.core.connections.DefaultConnectionSource;
import org.grails.datastore.mapping.core.connections.InMemoryConnectionSources;
import org.grails.datastore.mapping.core.connections.MultipleConnectionSourceCapableDatastore;
import org.grails.datastore.mapping.core.connections.SingletonConnectionSources;
import org.grails.datastore.mapping.core.exceptions.ConfigurationException;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.EmbeddedPersistentEntity;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.mongo.MongoCodecSession;
import org.grails.datastore.mapping.mongo.MongoConstants;
import org.grails.datastore.mapping.mongo.MongoSession;
import org.grails.datastore.mapping.mongo.config.MongoAttribute;
import org.grails.datastore.mapping.mongo.config.MongoCollection;
import org.grails.datastore.mapping.mongo.config.MongoMappingContext;
import org.grails.datastore.mapping.mongo.connections.AbstractMongoConnectionSourceSettings;
import org.grails.datastore.mapping.mongo.connections.MongoConnectionSourceFactory;
import org.grails.datastore.mapping.mongo.connections.MongoConnectionSourceSettings;
import org.grails.datastore.mapping.mongo.connections.MongoConnectionSourceSettingsBuilder;
import org.grails.datastore.mapping.mongo.engine.codecs.PersistentEntityCodec;
import org.grails.datastore.mapping.multitenancy.AllTenantsResolver;
import org.grails.datastore.mapping.multitenancy.MultiTenancySettings;
import org.grails.datastore.mapping.multitenancy.MultiTenantCapableDatastore;
import org.grails.datastore.mapping.multitenancy.TenantResolver;
import org.grails.datastore.mapping.multitenancy.exceptions.TenantNotFoundException;
import org.grails.datastore.mapping.transactions.DatastoreTransactionManager;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.grails.datastore.mapping.validation.ValidatorRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.MessageSource;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.transaction.PlatformTransactionManager;

public class MongoDatastore
extends AbstractDatastore
implements MappingContext.Listener,
Closeable,
StatelessDatastore,
MultipleConnectionSourceCapableDatastore,
MultiTenantCapableDatastore<MongoClient, MongoConnectionSourceSettings>,
TransactionCapableDatastore {
    public static final String SETTING_DATABASE_NAME = "grails.mongodb.databaseName";
    public static final String SETTING_CONNECTION_STRING = "grails.mongodb.connectionString";
    public static final String SETTING_URL = "grails.mongodb.url";
    public static final String SETTING_DEFAULT_MAPPING = "grails.mongodb.default.mapping";
    public static final String SETTING_OPTIONS = "grails.mongodb.options";
    public static final String SETTING_HOST = "grails.mongodb.host";
    public static final String SETTING_PORT = "grails.mongodb.port";
    public static final String SETTING_USERNAME = "grails.mongodb.username";
    public static final String SETTING_PASSWORD = "grails.mongodb.password";
    public static final String SETTING_STATELESS = "grails.mongodb.stateless";
    public static final String SETTING_ENGINE = "grails.mongodb.engine";
    public static final String INDEX_ATTRIBUTES = "indexAttributes";
    public static final String CODEC_ENGINE = "codec";
    protected final MongoClient mongo;
    protected final String defaultDatabase;
    protected final Map<PersistentEntity, String> mongoCollections = new ConcurrentHashMap<PersistentEntity, String>();
    protected final Map<PersistentEntity, String> mongoDatabases = new ConcurrentHashMap<PersistentEntity, String>();
    protected final boolean stateless;
    protected final boolean codecEngine;
    protected CodecRegistry codecRegistry;
    protected final ConfigurableApplicationEventPublisher eventPublisher;
    protected final PlatformTransactionManager transactionManager;
    protected final GormEnhancer gormEnhancer;
    protected final ConnectionSources<MongoClient, MongoConnectionSourceSettings> connectionSources;
    protected final FlushModeType defaultFlushMode;
    protected final Map<String, MongoDatastore> datastoresByConnectionSource = new LinkedHashMap<String, MongoDatastore>();
    protected final MultiTenancySettings.MultiTenancyMode multiTenancyMode;
    protected final TenantResolver tenantResolver;

    public MongoDatastore(final ConnectionSources<MongoClient, MongoConnectionSourceSettings> connectionSources, final MongoMappingContext mappingContext, final ConfigurableApplicationEventPublisher eventPublisher) {
        super((MappingContext)mappingContext, connectionSources != null ? connectionSources.getBaseConfiguration() : null, null);
        if (connectionSources == null) {
            throw new IllegalArgumentException("Argument [connectionSources] cannot be null");
        }
        if (mappingContext == null) {
            throw new IllegalArgumentException("Argument [mappingContext] cannot be null");
        }
        this.connectionSources = connectionSources;
        final ConnectionSource defaultConnectionSource = connectionSources.getDefaultConnectionSource();
        MongoConnectionSourceSettings settings = (MongoConnectionSourceSettings)defaultConnectionSource.getSettings();
        MultiTenancySettings multiTenancySettings = settings.getMultiTenancy();
        this.mongo = (MongoClient)defaultConnectionSource.getSource();
        this.multiTenancyMode = multiTenancySettings.getMode();
        if (this.multiTenancyMode == MultiTenancySettings.MultiTenancyMode.SCHEMA) {
            final TenantResolver baseResolver = multiTenancySettings.getTenantResolver();
            this.tenantResolver = new AllTenantsResolver(){

                public Iterable<Serializable> resolveTenantIds() {
                    ArrayList<Serializable> ids = new ArrayList<Serializable>();
                    MongoIterable databaseNames = ((MongoClient)defaultConnectionSource.getSource()).listDatabaseNames();
                    for (String databaseName : databaseNames) {
                        ids.add((Serializable)((Object)databaseName));
                    }
                    return ids;
                }

                public Serializable resolveTenantIdentifier() throws TenantNotFoundException {
                    return baseResolver.resolveTenantIdentifier();
                }
            };
        } else {
            this.tenantResolver = multiTenancySettings.getTenantResolver();
        }
        this.eventPublisher = eventPublisher;
        this.defaultDatabase = settings.getDatabase();
        this.defaultFlushMode = settings.getFlushMode();
        this.stateless = settings.isStateless();
        this.codecEngine = settings.getEngine().equals(CODEC_ENGINE);
        this.codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClient.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new CodecExtensions(), new PersistentEntityCodeRegistry()}), mappingContext.getCodecRegistry()});
        DatastoreTransactionManager datastoreTransactionManager = new DatastoreTransactionManager();
        datastoreTransactionManager.setDatastore((Datastore)this);
        this.transactionManager = datastoreTransactionManager;
        for (PersistentEntity entity : mappingContext.getPersistentEntities()) {
            this.registerEntity(entity);
        }
        if (!(connectionSources instanceof SingletonConnectionSources)) {
            Iterable allConnectionSources = connectionSources.getAllConnectionSources();
            for (final ConnectionSource connectionSource : allConnectionSources) {
                SingletonConnectionSources singletonConnectionSources = new SingletonConnectionSources(connectionSource, connectionSources.getBaseConfiguration());
                MongoDatastore childDatastore = "DEFAULT".equals(connectionSource.getName()) ? this : new MongoDatastore((ConnectionSources)singletonConnectionSources, mappingContext, eventPublisher){

                    @Override
                    protected MongoGormEnhancer initialize(MongoConnectionSourceSettings settings) {
                        super.buildIndex();
                        return null;
                    }

                    public String toString() {
                        return "MongoDatastore: " + connectionSource.getName();
                    }
                };
                this.datastoresByConnectionSource.put(connectionSource.getName(), childDatastore);
            }
            connectionSources.addListener((ConnectionSourcesListener)new ConnectionSourcesListener<MongoClient, MongoConnectionSourceSettings>(){

                public void newConnectionSource(final ConnectionSource<MongoClient, MongoConnectionSourceSettings> connectionSource) {
                    SingletonConnectionSources singletonConnectionSources = new SingletonConnectionSources(connectionSource, connectionSources.getBaseConfiguration());
                    MongoDatastore childDatastore = new MongoDatastore((ConnectionSources)singletonConnectionSources, mappingContext, eventPublisher){

                        @Override
                        protected MongoGormEnhancer initialize(MongoConnectionSourceSettings settings) {
                            super.buildIndex();
                            return null;
                        }

                        public String toString() {
                            return "MongoDatastore: " + connectionSource.getName();
                        }
                    };
                    MongoDatastore.this.datastoresByConnectionSource.put(connectionSource.getName(), childDatastore);
                    for (PersistentEntity persistentEntity : mappingContext.getPersistentEntities()) {
                        MongoDatastore.this.gormEnhancer.registerEntity(persistentEntity);
                    }
                }
            });
        }
        this.registerEventListeners(this.eventPublisher);
        this.gormEnhancer = this.initialize(settings);
    }

    public MongoDatastore(ConnectionSources<MongoClient, MongoConnectionSourceSettings> connectionSources, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this(connectionSources, MongoDatastore.createMappingContext(connectionSources, classes), eventPublisher);
    }

    public MongoDatastore(MongoClient mongoClient, PropertyResolver configuration, MongoMappingContext mappingContext, ConfigurableApplicationEventPublisher eventPublisher) {
        this(MongoDatastore.createDefaultConnectionSources(mongoClient, configuration, mappingContext), mappingContext, eventPublisher);
    }

    public MongoDatastore(MongoClient mongoClient, PropertyResolver configuration, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this(mongoClient, configuration, MongoDatastore.createMappingContext(configuration, classes), eventPublisher);
    }

    public MongoDatastore(MongoClient mongoClient, PropertyResolver configuration, ConfigurableApplicationEventPublisher eventPublisher, Package ... packages) {
        this(mongoClient, configuration, MongoDatastore.createMappingContext(configuration, new ClasspathEntityScanner().scan(packages)), eventPublisher);
    }

    public MongoDatastore(MongoClient mongoClient, PropertyResolver configuration, Class ... classes) {
        this(mongoClient, configuration, MongoDatastore.createMappingContext(configuration, classes), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher());
    }

    public MongoDatastore(MongoClient mongoClient, PropertyResolver configuration, Package ... packages) {
        this(mongoClient, configuration, MongoDatastore.createMappingContext(configuration, new ClasspathEntityScanner().scan(packages)), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher());
    }

    public MongoDatastore(MongoClient mongoClient, Class ... classes) {
        this(mongoClient, MongoDatastore.mapToPropertyResolver(null), MongoDatastore.createMappingContext(MongoDatastore.mapToPropertyResolver(null), classes), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher());
    }

    public MongoDatastore(MongoClientOptions.Builder clientOptions, PropertyResolver configuration, MongoMappingContext mappingContext, ConfigurableApplicationEventPublisher eventPublisher) {
        this(MongoDatastore.createMongoClient(configuration, clientOptions, mappingContext), configuration, mappingContext, eventPublisher);
    }

    public MongoDatastore(MongoClientOptions.Builder clientOptions, PropertyResolver configuration, MongoMappingContext mappingContext) {
        this(MongoDatastore.createMongoClient(configuration, clientOptions, mappingContext), configuration, mappingContext, (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher());
    }

    public MongoDatastore(PropertyResolver configuration, MongoMappingContext mappingContext, ConfigurableApplicationEventPublisher eventPublisher) {
        this((ConnectionSources<MongoClient, MongoConnectionSourceSettings>)ConnectionSourcesInitializer.create((ConnectionSourceFactory)new MongoConnectionSourceFactory(), (PropertyResolver)configuration), mappingContext, eventPublisher);
    }

    public MongoDatastore(PropertyResolver configuration, MongoConnectionSourceFactory connectionSourceFactory, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this((ConnectionSources<MongoClient, MongoConnectionSourceSettings>)ConnectionSourcesInitializer.create((ConnectionSourceFactory)connectionSourceFactory, (PropertyResolver)configuration), eventPublisher, classes);
    }

    public MongoDatastore(PropertyResolver configuration, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this(configuration, new MongoConnectionSourceFactory(), eventPublisher, classes);
    }

    public MongoDatastore(PropertyResolver configuration, MongoMappingContext mappingContext) {
        this(configuration, mappingContext, (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher());
    }

    public MongoDatastore(PropertyResolver configuration, Class ... classes) {
        this(configuration, (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher(), classes);
    }

    public MongoDatastore(Map<String, Object> configuration, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this(MongoDatastore.mapToPropertyResolver(configuration), eventPublisher, classes);
    }

    public MongoDatastore(Map<String, Object> configuration, Class ... classes) {
        this(MongoDatastore.mapToPropertyResolver(configuration), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher(), classes);
    }

    public MongoDatastore(Map<String, Object> configuration) {
        this(configuration, new Class[0]);
    }

    public MongoDatastore(Map<String, Object> configuration, MongoMappingContext mappingContext) {
        this(MongoDatastore.mapToPropertyResolver(configuration), mappingContext, (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher());
    }

    public MongoDatastore(MongoMappingContext mappingContext) {
        this(MongoDatastore.mapToPropertyResolver(null), mappingContext, (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher());
    }

    public MongoDatastore(Class ... classes) {
        this(MongoDatastore.mapToPropertyResolver(null), classes);
    }

    public MongoDatastore(Package ... packagesToScan) {
        this(new ClasspathEntityScanner().scan(packagesToScan));
    }

    public MongoDatastore(Package packageToScan) {
        this(new ClasspathEntityScanner().scan(new Package[]{packageToScan}));
    }

    public MongoDatastore(PropertyResolver configuration, Package ... packagesToScan) {
        this(configuration, new ClasspathEntityScanner().scan(packagesToScan));
    }

    public MongoDatastore(Map<String, Object> configuration, Package ... packagesToScan) {
        this(DatastoreUtils.createPropertyResolver(configuration), packagesToScan);
    }

    public MongoDatastore(PropertyResolver configuration, ConfigurableApplicationEventPublisher eventPublisher, Package ... packagesToScan) {
        this(configuration, eventPublisher, new ClasspathEntityScanner().scan(packagesToScan));
    }

    public ConnectionSources<MongoClient, MongoConnectionSourceSettings> getConnectionSources() {
        return this.connectionSources;
    }

    public void buildIndex() {
        for (PersistentEntity entity : this.mappingContext.getPersistentEntities()) {
            if (entity.isExternal() || entity.isMultiTenant() && this.multiTenancyMode == MultiTenancySettings.MultiTenancyMode.SCHEMA) continue;
            this.initializeIndices(entity);
        }
    }

    public FlushModeType getDefaultFlushMode() {
        return this.defaultFlushMode;
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    @Autowired(required=false)
    public void setCodecRegistries(List<CodecRegistry> codecRegistries) {
        this.codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{this.codecRegistry, CodecRegistries.fromRegistries(codecRegistries)});
    }

    @Autowired(required=false)
    public void setCodecProviders(List<CodecProvider> codecProviders) {
        this.codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{this.codecRegistry, CodecRegistries.fromProviders(codecProviders)});
    }

    @Autowired(required=false)
    public void setCodecs(List<Codec<?>> codecs) {
        this.codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{this.codecRegistry, CodecRegistries.fromCodecs(codecs)});
    }

    @Autowired(required=false)
    public void setMessageSource(MessageSource messageSource) {
        if (messageSource != null) {
            MongoDatastore.configureValidatorRegistry((MongoConnectionSourceSettings)this.connectionSources.getDefaultConnectionSource().getSettings(), (MongoMappingContext)this.mappingContext, messageSource);
        }
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public PersistentEntityCodec getPersistentEntityCodec(PersistentEntity entity) {
        if (entity instanceof EmbeddedPersistentEntity) {
            return new PersistentEntityCodec(this.codecRegistry, entity);
        }
        return this.getPersistentEntityCodec(entity.getJavaClass());
    }

    public PersistentEntityCodec getPersistentEntityCodec(Class entityClass) {
        if (entityClass == null) {
            throw new IllegalArgumentException("Argument [entityClass] cannot be null");
        }
        PersistentEntity entity = this.getMappingContext().getPersistentEntity(entityClass.getName());
        if (entity == null) {
            throw new IllegalArgumentException("Argument [" + entityClass + "] is not an entity");
        }
        return (PersistentEntityCodec)this.getCodecRegistry().get(entity.getJavaClass());
    }

    public ConfigurableApplicationEventPublisher getApplicationEventPublisher() {
        return this.eventPublisher;
    }

    public MongoClient getMongoClient() {
        return this.mongo;
    }

    public String getDatabaseName(PersistentEntity entity) {
        if (entity.isMultiTenant() && this.multiTenancyMode == MultiTenancySettings.MultiTenancyMode.SCHEMA) {
            return Tenants.currentId(this.getClass()).toString();
        }
        String databaseName = this.mongoDatabases.get(entity);
        if (databaseName == null) {
            this.mongoDatabases.put(entity, this.defaultDatabase);
            return this.defaultDatabase;
        }
        return databaseName;
    }

    public String getCollectionName(PersistentEntity entity) {
        String collectionName = this.mongoCollections.get(entity);
        if (collectionName == null) {
            String decapitalizedName = entity.isRoot() ? entity.getDecapitalizedName() : entity.getRootEntity().getDecapitalizedName();
            this.mongoCollections.put(entity, decapitalizedName);
            return decapitalizedName;
        }
        return collectionName;
    }

    public com.mongodb.client.MongoCollection<Document> getCollection(PersistentEntity entity) {
        return this.getMongoClient().getDatabase(this.getDatabaseName(entity)).getCollection(this.getCollectionName(entity)).withCodecRegistry(this.codecRegistry);
    }

    public MongoMappingContext getMappingContext() {
        return (MongoMappingContext)super.getMappingContext();
    }

    public boolean isSchemaless() {
        return true;
    }

    protected Session createSession(PropertyResolver connDetails) {
        if (this.stateless) {
            return this.createStatelessSession(connDetails);
        }
        if (this.codecEngine) {
            return new MongoCodecSession(this, (MappingContext)this.getMappingContext(), (ApplicationEventPublisher)this.getApplicationEventPublisher(), false);
        }
        return new MongoSession(this, (MappingContext)this.getMappingContext(), (ApplicationEventPublisher)this.getApplicationEventPublisher(), false);
    }

    protected MongoGormEnhancer initialize(final MongoConnectionSourceSettings settings) {
        this.getMappingContext().addMappingContextListener(this);
        this.initializeConverters(this.mappingContext);
        this.mappingContext.addMappingContextListener(new MappingContext.Listener(){

            public void persistentEntityAdded(PersistentEntity entity) {
                MongoDatastore.this.gormEnhancer.registerEntity(entity);
                MongoDatastore.this.registerEntity(entity);
            }
        });
        this.buildIndex();
        return new MongoGormEnhancer(this, this.transactionManager, settings){

            protected <D> MongoStaticApi<D> getStaticApi(Class<D> cls, String qualifier) {
                MongoDatastore mongoDatastore = this.getDatastoreForQualifier(cls, qualifier);
                return new MongoStaticApi<D>(cls, (Datastore)mongoDatastore, this.createDynamicFinders((Datastore)mongoDatastore), MongoDatastore.this.transactionManager);
            }

            protected <D> GormInstanceApi<D> getInstanceApi(Class<D> cls, String qualifier) {
                MongoDatastore mongoDatastore = this.getDatastoreForQualifier(cls, qualifier);
                GormInstanceApi instanceApi = new GormInstanceApi(cls, (Datastore)mongoDatastore);
                instanceApi.setFailOnError(settings.isFailOnError());
                return instanceApi;
            }

            protected <D> GormValidationApi<D> getValidationApi(Class<D> cls, String qualifier) {
                MongoDatastore mongoDatastore = this.getDatastoreForQualifier(cls, qualifier);
                return new GormValidationApi(cls, (Datastore)mongoDatastore);
            }

            private <D> MongoDatastore getDatastoreForQualifier(Class<D> cls, String qualifier) {
                ConnectionSource connectionSource;
                boolean isDefaultQualifier;
                String defaultConnectionSourceName = ConnectionSourcesSupport.getDefaultConnectionSourceName((PersistentEntity)MongoDatastore.this.getMappingContext().getPersistentEntity(cls.getName()));
                if (defaultConnectionSourceName.equals("ALL")) {
                    defaultConnectionSourceName = "DEFAULT";
                }
                if ((isDefaultQualifier = qualifier.equals("DEFAULT")) && defaultConnectionSourceName.equals("DEFAULT")) {
                    return MongoDatastore.this;
                }
                if (isDefaultQualifier) {
                    qualifier = defaultConnectionSourceName;
                }
                if ((connectionSource = MongoDatastore.this.connectionSources.getConnectionSource(qualifier)) == null) {
                    throw new ConfigurationException("Invalid connection [" + defaultConnectionSourceName + "] configured for class [" + cls + "]");
                }
                return MongoDatastore.this.datastoresByConnectionSource.get(qualifier);
            }
        };
    }

    protected Session createStatelessSession(PropertyResolver connectionDetails) {
        if (this.codecEngine) {
            return new MongoCodecSession(this, (MappingContext)this.getMappingContext(), (ApplicationEventPublisher)this.getApplicationEventPublisher(), true);
        }
        return new MongoSession(this, (MappingContext)this.getMappingContext(), (ApplicationEventPublisher)this.getApplicationEventPublisher(), true);
    }

    protected void registerEventListeners(ConfigurableApplicationEventPublisher eventPublisher) {
        eventPublisher.addApplicationListener((ApplicationListener)new DomainEventListener((Datastore)this));
        eventPublisher.addApplicationListener((ApplicationListener)new AutoTimestampEventListener((Datastore)this));
        eventPublisher.addApplicationListener((ApplicationListener)new ValidationEventListener((Datastore)this));
        if (this.multiTenancyMode == MultiTenancySettings.MultiTenancyMode.DISCRIMINATOR) {
            eventPublisher.addApplicationListener((ApplicationListener)new MultiTenantEventListener((Datastore)this));
        }
    }

    protected void initializeIndices(PersistentEntity entity) {
        MongoCollection mappedForm;
        com.mongodb.client.MongoCollection<Document> collection = this.getCollection(entity);
        ClassMapping classMapping = entity.getMapping();
        if (classMapping != null && (mappedForm = (MongoCollection)classMapping.getMappedForm()) != null) {
            List<MongoCollection.Index> indices = mappedForm.getIndices();
            for (MongoCollection.Index index : indices) {
                Map<String, Object> options = index.getOptions();
                IndexOptions indexOptions = MongoConstants.mapToObject(IndexOptions.class, options);
                collection.createIndex((Bson)new Document(index.getDefinition()), indexOptions);
            }
            for (Map compoundIndex : mappedForm.getCompoundIndices()) {
                Object o;
                Map indexAttributes = null;
                if (compoundIndex.containsKey(INDEX_ATTRIBUTES) && (o = compoundIndex.remove(INDEX_ATTRIBUTES)) instanceof Map) {
                    indexAttributes = (Map)o;
                }
                Document indexDef = new Document(compoundIndex);
                if (indexAttributes != null) {
                    IndexOptions indexOptions = MongoConstants.mapToObject(IndexOptions.class, indexAttributes);
                    collection.createIndex((Bson)indexDef, indexOptions);
                    continue;
                }
                collection.createIndex((Bson)indexDef);
            }
        }
        for (PersistentProperty property : entity.getPersistentProperties()) {
            HashMap attributes;
            boolean indexed = this.isIndexed(property);
            if (!indexed) continue;
            MongoAttribute mongoAttributeMapping = (MongoAttribute)property.getMapping().getMappedForm();
            Document dbObject = new Document();
            String fieldName = this.getMongoFieldNameForProperty((PersistentProperty<MongoAttribute>)property);
            dbObject.put(fieldName, (Object)1);
            Document options = new Document();
            if (mongoAttributeMapping != null && (attributes = mongoAttributeMapping.getIndexAttributes()) != null) {
                if ((attributes = new HashMap(attributes)).containsKey("type")) {
                    dbObject.put(fieldName, attributes.remove("type"));
                }
                options.putAll(attributes);
            }
            if (options.isEmpty()) {
                collection.createIndex((Bson)dbObject);
                continue;
            }
            IndexOptions indexOptions = MongoConstants.mapToObject(IndexOptions.class, (Map<String, Object>)options);
            collection.createIndex((Bson)dbObject, indexOptions);
        }
    }

    String getMongoFieldNameForProperty(PersistentProperty<MongoAttribute> property) {
        PropertyMapping pm = property.getMapping();
        String propKey = null;
        if (pm.getMappedForm() != null) {
            propKey = ((MongoAttribute)pm.getMappedForm()).getField();
        }
        if (propKey == null) {
            propKey = property.getName();
        }
        return propKey;
    }

    public void persistentEntityAdded(PersistentEntity entity) {
        this.initializeIndices(entity);
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        try {
            super.destroy();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.connectionSources != null) {
                this.connectionSources.close();
            }
        }
        finally {
            if (this.gormEnhancer != null) {
                try {
                    this.gormEnhancer.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected static ConnectionSources<MongoClient, MongoConnectionSourceSettings> createDefaultConnectionSources(MongoClient mongoClient, PropertyResolver configuration, MongoMappingContext mappingContext) {
        MongoConnectionSourceSettings settings = new MongoConnectionSourceSettings();
        settings.setOptions(MongoClientOptions.builder((MongoClientOptions)mongoClient.getMongoClientOptions()));
        settings.setDatabaseName(mappingContext.getDefaultDatabaseName());
        DefaultConnectionSource defaultConnectionSource = new DefaultConnectionSource("DEFAULT", (Object)mongoClient, (ConnectionSourceSettings)settings);
        return new InMemoryConnectionSources((ConnectionSource)defaultConnectionSource, (ConnectionSourceFactory)new MongoConnectionSourceFactory(), configuration);
    }

    protected static MongoClient createMongoClient(PropertyResolver configuration, MongoClientOptions.Builder mongoOptions, MongoMappingContext mappingContext) {
        MongoConnectionSourceFactory mongoConnectionSourceFactory = new MongoConnectionSourceFactory();
        mongoConnectionSourceFactory.setClientOptionsBuilder(mongoOptions);
        return (MongoClient)mongoConnectionSourceFactory.create("DEFAULT", configuration).getSource();
    }

    protected static MongoMappingContext createMappingContext(ConnectionSources<MongoClient, MongoConnectionSourceSettings> connectionSources, Class ... classes) {
        ConnectionSource defaultConnectionSource = connectionSources.getDefaultConnectionSource();
        MongoMappingContext mongoMappingContext = new MongoMappingContext((AbstractMongoConnectionSourceSettings)defaultConnectionSource.getSettings(), classes);
        MongoDatastore.configureValidationRegistry((MongoConnectionSourceSettings)connectionSources.getDefaultConnectionSource().getSettings(), mongoMappingContext);
        return mongoMappingContext;
    }

    protected static MongoMappingContext createMappingContext(PropertyResolver configuration, Class ... classes) {
        MongoConnectionSourceSettingsBuilder builder = new MongoConnectionSourceSettingsBuilder(configuration);
        MongoConnectionSourceSettings mongoConnectionSourceSettings = (MongoConnectionSourceSettings)builder.build();
        MongoMappingContext mongoMappingContext = new MongoMappingContext(mongoConnectionSourceSettings, classes);
        MongoDatastore.configureValidationRegistry(mongoConnectionSourceSettings, mongoMappingContext);
        return mongoMappingContext;
    }

    protected void registerEntity(PersistentEntity entity) {
        String collectionName = entity.isRoot() ? entity.getDecapitalizedName() : entity.getRootEntity().getDecapitalizedName();
        String databaseName = this.defaultDatabase;
        MongoCollection collectionMapping = (MongoCollection)entity.getMapping().getMappedForm();
        if (collectionMapping.getCollection() != null) {
            collectionName = collectionMapping.getCollection();
        }
        if (collectionMapping.getDatabase() != null) {
            databaseName = collectionMapping.getDatabase();
        }
        this.mongoCollections.put(entity, collectionName);
        this.mongoDatabases.put(entity, databaseName);
    }

    private static void configureValidationRegistry(MongoConnectionSourceSettings settings, MongoMappingContext mongoMappingContext) {
        StaticMessageSource messageSource = new StaticMessageSource();
        MongoDatastore.configureValidatorRegistry(settings, mongoMappingContext, (MessageSource)messageSource);
    }

    private static void configureValidatorRegistry(MongoConnectionSourceSettings settings, MongoMappingContext mongoMappingContext, MessageSource messageSource) {
        ValidatorRegistry validatorRegistry = ValidatorRegistries.createValidatorRegistry((MappingContext)mongoMappingContext, (ConnectionSourceSettings)settings, (MessageSource)messageSource);
        if (validatorRegistry instanceof ConstraintRegistry) {
            ((ConstraintRegistry)validatorRegistry).addConstraintFactory((ConstraintFactory)new MappingContextAwareConstraintFactory(UniqueConstraint.class, messageSource, (MappingContext)mongoMappingContext));
        }
        mongoMappingContext.setValidatorRegistry(validatorRegistry);
    }

    public MultiTenancySettings.MultiTenancyMode getMultiTenancyMode() {
        return this.multiTenancyMode;
    }

    public TenantResolver getTenantResolver() {
        return this.tenantResolver;
    }

    public MongoDatastore getDatastoreForTenantId(Serializable tenantId) {
        if (this.getMultiTenancyMode() == MultiTenancySettings.MultiTenancyMode.DATABASE) {
            return this.datastoresByConnectionSource.get(tenantId.toString());
        }
        return this;
    }

    public Datastore getDatastoreForConnection(String connectionName) {
        return this.getDatastoreForConnection(connectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T1> T1 withNewSession(Serializable tenantId, Closure<T1> callable) {
        MongoDatastore mongoDatastore = this.getDatastoreForTenantId(tenantId);
        Session session = mongoDatastore.connect();
        try {
            DatastoreUtils.bindNewSession((Session)session);
            Object object = callable.call((Object)session);
            return (T1)object;
        }
        finally {
            DatastoreUtils.unbindSession((Session)session);
        }
    }

    class PersistentEntityCodeRegistry
    implements CodecProvider {
        Map<String, PersistentEntityCodec> codecs = new HashMap<String, PersistentEntityCodec>();

        PersistentEntityCodeRegistry() {
        }

        public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
            PersistentEntity entity;
            String entityName = clazz.getName();
            PersistentEntityCodec codec = this.codecs.get(entityName);
            if (codec == null && (entity = MongoDatastore.this.getMappingContext().getPersistentEntity(entityName)) != null) {
                codec = new PersistentEntityCodec(MongoDatastore.this.codecRegistry, entity);
                this.codecs.put(entityName, codec);
            }
            return codec;
        }
    }
}

