/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.engine;

import com.mongodb.DBRef;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.SessionImplementor;
import org.grails.datastore.mapping.engine.AssociationIndexer;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.NativeEntryEntityPersister;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.engine.PropertyValueIndexer;
import org.grails.datastore.mapping.model.EmbeddedPersistentEntity;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Identity;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.mongo.MongoSession;
import org.grails.datastore.mapping.mongo.config.MongoAttribute;
import org.grails.datastore.mapping.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.ConversionService;

public abstract class AbstractMongoObectEntityPersister<T>
extends NativeEntryEntityPersister<T, Object> {
    public static final String INSTANCE_PREFIX = "instance:";
    public static final String MONGO_ID_FIELD = "_id";
    public static final String MONGO_CLASS_FIELD = "_class";
    protected static final String NEXT_ID_SUFFIX = ".next_id";
    static Logger log = LoggerFactory.getLogger(AbstractMongoObectEntityPersister.class);
    protected boolean hasNumericalIdentifier = false;
    protected boolean hasStringIdentifier = false;

    public AbstractMongoObectEntityPersister(MappingContext mappingContext, PersistentEntity entity, Session session, ApplicationEventPublisher publisher) {
        super(mappingContext, entity, session, publisher);
        PersistentProperty identity;
        if (!(entity instanceof EmbeddedPersistentEntity) && (identity = entity.getIdentity()) != null) {
            this.hasNumericalIdentifier = Long.class.isAssignableFrom(identity.getType());
            this.hasStringIdentifier = String.class.isAssignableFrom(identity.getType());
        }
    }

    public static String createInstanceCacheEntryKey(Object instance) {
        return INSTANCE_PREFIX + System.identityHashCode(instance);
    }

    public String getEntityFamily() {
        return this.getMongoSession().getCollectionName(this.getPersistentEntity());
    }

    public MongoSession getMongoSession() {
        return (MongoSession)this.getSession();
    }

    public String getCollectionName(PersistentEntity persistentEntity) {
        return this.getCollectionName(persistentEntity, null);
    }

    public AssociationIndexer getAssociationIndexer(T nativeEntry, Association association) {
        return new MongoAssociationIndexer(nativeEntry, association, (MongoSession)this.session);
    }

    public PropertyValueIndexer getPropertyIndexer(PersistentProperty property) {
        return null;
    }

    public boolean isDirty(Object instance, Object entry) {
        if (super.isDirty(instance, entry)) {
            return true;
        }
        Object dbo = entry;
        PersistentEntity entity = this.getPersistentEntity();
        EntityAccess entityAccess = this.createEntityAccess(entity, instance, dbo);
        Object cached = ((SessionImplementor)this.getSession()).getCachedEntry(entity, (Serializable)entityAccess.getIdentifier(), true);
        return !dbo.equals(cached);
    }

    protected T getEmbedded(T nativeEntry, String key) {
        Object embeddedDocument = this.getValueRetrievalStrategy().getValue(nativeEntry, key);
        if (this.isEmbeddedEntry(embeddedDocument)) {
            return (T)embeddedDocument;
        }
        return null;
    }

    protected boolean doesRequirePropertyIndexing() {
        return false;
    }

    protected void setEmbedded(T nativeEntry, String key, T embeddedEntry) {
        this.getValueRetrievalStrategy().setValue(nativeEntry, key, embeddedEntry);
    }

    protected void cascadeDeleteCollection(EntityAccess entityAccess, Association association) {
        Object propValue = entityAccess.getProperty(association.getName());
        if (!(propValue instanceof Collection)) {
            return;
        }
        Collection collection = (Collection)propValue;
        Persister persister = null;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object child = iter.next();
            if (child == null) {
                log.warn("Encountered a null associated reference while cascade-deleting '{}' as part of {} (ID {})", new Object[]{association.getReferencedPropertyName(), entityAccess.getEntity().getClass().getName(), entityAccess.getIdentifier()});
                continue;
            }
            if (persister == null) {
                persister = this.session.getPersister(child);
            }
            persister.delete(child);
            iter.remove();
        }
    }

    protected void setEmbeddedCollection(T nativeEntry, String key, Collection<?> instances, List<T> embeddedEntries) {
        ValueRetrievalStrategy<T> valueRetrievalStrategy = this.getValueRetrievalStrategy();
        if (instances == null || instances.isEmpty()) {
            valueRetrievalStrategy.setValue(nativeEntry, key, null);
            return;
        }
        valueRetrievalStrategy.setValue(nativeEntry, key, embeddedEntries);
    }

    protected void setEmbeddedMap(T nativeEntry, String key, Map instances, Map<Object, T> embeddedEntries) {
        ValueRetrievalStrategy<T> valueRetrievalStrategy = this.getValueRetrievalStrategy();
        if (instances == null || instances.isEmpty()) {
            valueRetrievalStrategy.setValue(nativeEntry, key, null);
            return;
        }
        valueRetrievalStrategy.setValue(nativeEntry, key, embeddedEntries);
    }

    protected void setEmbeddedCollectionKeys(Association association, EntityAccess embeddedEntityAccess, T embeddedEntry, List<Serializable> keys) {
        ArrayList<Object> dbRefs = new ArrayList<Object>();
        boolean reference = this.isReference(association);
        for (Serializable foreignKey : keys) {
            if (reference) {
                dbRefs.add(new DBRef(this.getCollectionName(association.getAssociatedEntity()), (Object)foreignKey));
                continue;
            }
            dbRefs.add(foreignKey);
        }
        this.getValueRetrievalStrategy().setValue(embeddedEntry, association.getName(), dbRefs);
    }

    protected List loadEmbeddedCollectionKeys(Association association, EntityAccess ea, T nativeEntry) {
        if (nativeEntry == null) {
            return super.loadEmbeddedCollectionKeys(association, ea, nativeEntry);
        }
        ValueRetrievalStrategy<T> valueRetrievalStrategy = this.getValueRetrievalStrategy();
        Object entry = valueRetrievalStrategy.getValue(nativeEntry, this.getPropertyKey((PersistentProperty)association));
        ArrayList<Object> keys = new ArrayList<Object>();
        if (entry instanceof List) {
            List entries = (List)entry;
            for (Object o : entries) {
                if (o instanceof DBRef) {
                    DBRef dbref = (DBRef)o;
                    keys.add(dbref.getId());
                    continue;
                }
                if (o != null) {
                    keys.add(o);
                    continue;
                }
                keys.add(null);
            }
        }
        return keys;
    }

    protected List<Object> retrieveAllEntities(PersistentEntity persistentEntity, Iterable<Serializable> keys) {
        Query query = this.session.createQuery(persistentEntity.getJavaClass());
        PersistentProperty identity = persistentEntity.getIdentity();
        if (keys instanceof List) {
            ArrayList<Object> actualKeys = new ArrayList<Object>();
            for (Serializable key : keys) {
                Object id = this.getIdentifierForKey(key);
                actualKeys.add(id);
            }
            query.in(identity.getName(), actualKeys);
        } else {
            ArrayList<Serializable> keyList = new ArrayList<Serializable>();
            for (Serializable key : keys) {
                keyList.add(key);
            }
            query.in(identity.getName(), keyList);
        }
        ArrayList<Object> entityResults = new ArrayList<Object>();
        Iterator<Serializable> keyIterator = keys.iterator();
        HashMap resultMap = new HashMap();
        for (Object o : query.list()) {
            if (this.isEmbeddedEntry(o)) {
                ValueRetrievalStrategy valueRetrievalStrategy = this.getValueRetrievalStrategy();
                Object id = valueRetrievalStrategy.getValue(o, MONGO_ID_FIELD);
                o = this.createObjectFromNativeEntry(this.getPersistentEntity(), (Serializable)id, o);
            }
            resultMap.put(this.getObjectIdentifier(o), o);
        }
        while (keyIterator.hasNext()) {
            Object key = this.getIdentifierForKey(keyIterator.next());
            ConversionService conversionService = this.getMappingContext().getConversionService();
            key = conversionService.convert(key, identity.getType());
            Object o = resultMap.get(key);
            entityResults.add(o);
        }
        return entityResults;
    }

    protected Object getIdentifierForKey(Object key) {
        Object id = key;
        if (key instanceof DBRef) {
            DBRef ref = (DBRef)key;
            id = ref.getId();
        }
        return id;
    }

    protected List<Object> retrieveAllEntities(PersistentEntity persistentEntity, Serializable[] keys) {
        return this.retrieveAllEntities(persistentEntity, Arrays.asList(keys));
    }

    protected void refreshObjectStateFromNativeEntry(PersistentEntity persistentEntity, Object obj, Serializable nativeKey, T nativeEntry, boolean isEmbedded) {
        if (isEmbedded) {
            Object id = this.getValueRetrievalStrategy().getValue(nativeEntry, MONGO_ID_FIELD);
            super.refreshObjectStateFromNativeEntry(persistentEntity, obj, (Serializable)id, nativeEntry, isEmbedded);
        } else {
            super.refreshObjectStateFromNativeEntry(persistentEntity, obj, nativeKey, nativeEntry, isEmbedded);
        }
    }

    protected Object getEntryValue(T nativeEntry, String property) {
        Object value = this.getValueRetrievalStrategy().getValue(nativeEntry, property);
        if (value instanceof DBRef) {
            return this.getIdentifierForKey(value);
        }
        return value;
    }

    protected Object formulateDatabaseReference(PersistentEntity persistentEntity, Association association, Serializable associationId) {
        boolean isReference = this.isReference(association);
        if (isReference) {
            return new DBRef(this.getCollectionName(association.getAssociatedEntity()), (Object)associationId);
        }
        return associationId;
    }

    protected String getPropertyKey(PersistentProperty prop) {
        if (prop instanceof Identity) {
            return MONGO_ID_FIELD;
        }
        return super.getPropertyKey(prop);
    }

    protected PersistentEntity discriminatePersistentEntity(PersistentEntity persistentEntity, T nativeEntry) {
        Object o = this.getValueRetrievalStrategy().getValue(nativeEntry, MONGO_CLASS_FIELD);
        if (o != null) {
            String className = o.toString();
            PersistentEntity childEntity = this.getMappingContext().getChildEntityByDiscriminator(persistentEntity.getRootEntity(), className);
            if (childEntity != null) {
                return childEntity;
            }
        }
        return super.discriminatePersistentEntity(persistentEntity, nativeEntry);
    }

    protected abstract String getCollectionName(PersistentEntity var1, T var2);

    protected boolean isReference(Association association) {
        MongoAttribute attribute;
        PropertyMapping mapping = association.getMapping();
        if (mapping != null && (attribute = (MongoAttribute)mapping.getMappedForm()) != null) {
            return attribute.isReference();
        }
        return true;
    }

    protected Collection getManyToManyKeys(PersistentEntity persistentEntity, Object object, Serializable nativeKey, T nativeEntry, ManyToMany manyToMany) {
        return (Collection)this.getValueRetrievalStrategy().getValue(nativeEntry, manyToMany.getName() + "_$$manyToManyIds");
    }

    protected void setManyToMany(PersistentEntity persistentEntity, Object obj, T nativeEntry, ManyToMany manyToMany, Collection associatedObjects, Map<Association, List<Serializable>> toManyKeys) {
        ArrayList<Object> ids = new ArrayList<Object>();
        if (associatedObjects != null) {
            for (Object o : associatedObjects) {
                if (o == null) {
                    ids.add(null);
                    continue;
                }
                PersistentEntity childPersistentEntity = this.getMappingContext().getPersistentEntity(o.getClass().getName());
                EntityAccess entityAccess = this.createEntityAccess(childPersistentEntity, o);
                ids.add(entityAccess.getIdentifier());
            }
        }
        this.getValueRetrievalStrategy().setValue(nativeEntry, manyToMany.getName() + "_$$manyToManyIds", ids);
    }

    abstract ValueRetrievalStrategy<T> getValueRetrievalStrategy();

    protected class MongoAssociationIndexer
    implements AssociationIndexer {
        private T nativeEntry;
        private Association association;
        private MongoSession session;
        private boolean isReference = true;

        public MongoAssociationIndexer(T nativeEntry, Association association, MongoSession session) {
            this.nativeEntry = nativeEntry;
            this.association = association;
            this.session = session;
            this.isReference = AbstractMongoObectEntityPersister.this.isReference(association);
        }

        public boolean doesReturnKeys() {
            return true;
        }

        public void preIndex(Object primaryKey, List foreignKeys) {
            if (!this.association.isBidirectional()) {
                ArrayList<Object> dbRefs = new ArrayList<Object>();
                for (Object foreignKey : foreignKeys) {
                    if (this.isReference) {
                        dbRefs.add(new DBRef(AbstractMongoObectEntityPersister.this.getCollectionName(this.association.getAssociatedEntity()), foreignKey));
                        continue;
                    }
                    dbRefs.add(foreignKey);
                }
                AbstractMongoObectEntityPersister.this.getValueRetrievalStrategy().setValue(this.nativeEntry, this.association.getName(), dbRefs);
            }
        }

        public void index(Object primaryKey, List foreignKeys) {
        }

        public List query(Object primaryKey) {
            if (!this.association.isBidirectional()) {
                Object indexed = AbstractMongoObectEntityPersister.this.getValueRetrievalStrategy().getValue(this.nativeEntry, this.association.getName());
                if (!(indexed instanceof Collection)) {
                    return Collections.emptyList();
                }
                List indexedList = this.getIndexedAssociationsAsList(indexed);
                if (this.associationsAreDbRefs(indexedList)) {
                    return this.extractIdsFromDbRefs(indexedList);
                }
                return indexedList;
            }
            Association inverseSide = this.association.getInverseSide();
            Query query = this.session.createQuery(this.association.getAssociatedEntity().getJavaClass());
            query.eq(inverseSide.getName(), primaryKey);
            query.projections().id();
            return query.list();
        }

        public PersistentEntity getIndexedEntity() {
            return this.association.getAssociatedEntity();
        }

        public void index(Object primaryKey, Object foreignKey) {
        }

        private List getIndexedAssociationsAsList(Object indexed) {
            return indexed instanceof List ? (List)indexed : new ArrayList((Collection)indexed);
        }

        private boolean associationsAreDbRefs(List indexedList) {
            return !indexedList.isEmpty() && indexedList.get(0) instanceof DBRef;
        }

        private List extractIdsFromDbRefs(List indexedList) {
            ArrayList<Object> resolvedDbRefs = new ArrayList<Object>();
            for (Object indexedAssociation : indexedList) {
                resolvedDbRefs.add(((DBRef)indexedAssociation).getId());
            }
            return resolvedDbRefs;
        }
    }

    static interface ValueRetrievalStrategy<T> {
        public Object getValue(T var1, String var2);

        public void setValue(T var1, String var2, Object var3);
    }
}

