/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.mongo.extensions;

import com.mongodb.AggregationOptions;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBEncoder;
import com.mongodb.DBObject;
import com.mongodb.InsertOptions;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.mongo.AbstractMongoSession;
import org.grails.datastore.mapping.mongo.engine.AbstractMongoObectEntityPersister;
import org.grails.datastore.mapping.mongo.engine.MongoEntityPersister;
import org.grails.datastore.mapping.mongo.query.MongoQuery;

public class MongoExtensions
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public MongoExtensions() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static <T> T asType(Document document, Class<T> cls) {
        Datastore datastore = GormEnhancer.findDatastore(cls);
        AbstractMongoSession session = (AbstractMongoSession)((Object)ScriptBytecodeAdapter.castToType((Object)datastore.getCurrentSession(), AbstractMongoSession.class));
        if (session != null) {
            return session.decode(cls, document);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)cls.getName(), (Object)"grails.converters.JSON")) {
            return (T)DefaultGroovyMethods.newInstance(cls, (Object[])new Object[]{document});
        }
        throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{document, cls}, new String[]{"Cannot convert DBOject [", "] to target type ", ". Type is not a persistent entity"})));
    }

    public static <T> T asType(FindIterable iterable, Class<T> cls) {
        Datastore datastore = GormEnhancer.findDatastore(cls);
        AbstractMongoSession session = (AbstractMongoSession)((Object)ScriptBytecodeAdapter.castToType((Object)datastore.getCurrentSession(), AbstractMongoSession.class));
        if (session != null) {
            return session.decode(cls, iterable);
        }
        throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{iterable, cls}, new String[]{"Cannot convert DBOject [", "] to target type ", ". Type is not a persistent entity"})));
    }

    public static <T> List<T> toList(FindIterable iterable, Class<T> cls) {
        Datastore datastore = GormEnhancer.findDatastore(cls);
        AbstractMongoSession session = (AbstractMongoSession)((Object)ScriptBytecodeAdapter.castToType((Object)datastore.getCurrentSession(), AbstractMongoSession.class));
        MongoEntityPersister p = (MongoEntityPersister)((Object)ScriptBytecodeAdapter.castToType((Object)session.getPersister(cls), MongoEntityPersister.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)((Object)p))) {
            return new MongoQuery.MongoResultList(iterable.iterator(), 0, (EntityPersister)p);
        }
        throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{iterable, cls}, new String[]{"Cannot convert DBCursor [", "] to target type ", ". Type is not a persistent entity"})));
    }

    public static DBObject toDBObject(Document document) {
        BasicDBObject object = new BasicDBObject();
        String key = null;
        Iterator iterator = document.keySet().iterator();
        while (iterator.hasNext()) {
            key = ShortTypeHandling.castToString(iterator.next());
            Object value = document.get((Object)key);
            if (value instanceof Document) {
                DBObject dBObject = MongoExtensions.toDBObject((Document)ScriptBytecodeAdapter.castToType((Object)value, Document.class));
                value = dBObject;
            } else if (value instanceof Collection) {
                Collection col = (Collection)ScriptBytecodeAdapter.castToType((Object)value, Collection.class);
                List newCol = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                Object i2 = null;
                for (Object i2 : col) {
                    if (i2 instanceof Document) {
                        DefaultGroovyMethods.leftShift((List)newCol, (Object)MongoExtensions.toDBObject((Document)ScriptBytecodeAdapter.castToType(i2, Document.class)));
                        continue;
                    }
                    DefaultGroovyMethods.leftShift((List)newCol, i2);
                }
                List list = newCol;
                value = list;
            }
            object.put(key, value);
        }
        return object;
    }

    public static DistinctIterable<Document> filter(DistinctIterable<Document> iterable, Map<String, Object> filter) {
        return iterable.filter((Bson)new Document(filter));
    }

    public static FindIterable<Document> filter(FindIterable<Document> iterable, Map<String, Object> filter) {
        return iterable.filter((Bson)new Document(filter));
    }

    public static FindIterable<Document> modifiers(FindIterable<Document> iterable, Map<String, Object> modifiers) {
        return iterable.modifiers((Bson)new Document(modifiers));
    }

    public static FindIterable<Document> projection(FindIterable<Document> iterable, Map<String, Object> projection) {
        return iterable.projection((Bson)new Document(projection));
    }

    public static FindIterable<Document> sort(FindIterable<Document> iterable, Map<String, Object> sort) {
        return iterable.sort((Bson)new Document(sort));
    }

    public static DBCursor sort(DBCursor cursor, Map<String, Object> sort) {
        return cursor.sort((DBObject)new BasicDBObject(sort));
    }

    public static DBCursor hint(DBCursor cursor, Map<String, Object> sort) {
        return cursor.hint((DBObject)new BasicDBObject(sort));
    }

    public static Object getProperty(DB db, String name) {
        return db.getCollection(name);
    }

    public static Object getProperty(MongoDatabase db, String name) {
        return db.getCollection(name);
    }

    public static Object getAt(DB db, String name) {
        return db.getCollection(name);
    }

    public static Object getAt(MongoDatabase db, String name) {
        return db.getCollection(name);
    }

    public static MongoIterable<String> getCollectionNames(MongoDatabase db) {
        return db.listCollectionNames();
    }

    public static DBCollection createCollection(DB db, String collectionName, Map options) {
        return db.createCollection(collectionName, (DBObject)new BasicDBObject(options));
    }

    public static void createCollection(MongoDatabase db, String collectionName, Map<String, Object> options) {
        db.createCollection(collectionName, (CreateCollectionOptions)ScriptBytecodeAdapter.castToType((Object)MongoExtensions.mapToObject(CreateCollectionOptions.class, options), CreateCollectionOptions.class));
    }

    public static <T> T mapToObject(Class<T> targetType, Map<String, Object> values) {
        CallSite[] callSiteArray = MongoExtensions.$getCallSiteArray();
        Object t = callSiteArray[0].call(targetType);
        String name = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(callSiteArray[2].call(values)), Iterator.class);
        while (iterator.hasNext()) {
            name = ShortTypeHandling.castToString(iterator.next());
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(t, (Object)name))) continue;
            ScriptBytecodeAdapter.invokeMethodN(MongoExtensions.class, (Object)t, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[4].call(values, (Object)name)});
        }
        return (T)t;
    }

    public static DBObject findOne(DBCollection collection, Map query) {
        return collection.findOne((DBObject)new BasicDBObject(query));
    }

    public static String getName(MongoCollection<Document> collection) {
        return collection.getNamespace().getCollectionName();
    }

    public static Document findOne(MongoCollection<Document> collection, Map<String, Object> query) {
        return (Document)ScriptBytecodeAdapter.castToType((Object)collection.find((Bson)new Document(query)).limit(1).first(), Document.class);
    }

    public static Document findOne(MongoCollection<Document> collection, ObjectId id) {
        Document query = new Document();
        query.put(AbstractMongoObectEntityPersister.MONGO_ID_FIELD, (Object)id);
        return (Document)ScriptBytecodeAdapter.castToType((Object)collection.find((Bson)query).limit(1).first(), Document.class);
    }

    public static Document findOne(MongoCollection<Document> collection, CharSequence id) {
        Document query = new Document();
        query.put(AbstractMongoObectEntityPersister.MONGO_ID_FIELD, (Object)id);
        return (Document)ScriptBytecodeAdapter.castToType((Object)collection.find((Bson)query).limit(1).first(), Document.class);
    }

    public static <T> T findOne(MongoCollection<Document> collection, Serializable id, Class<T> type) {
        Document query = new Document();
        query.put(AbstractMongoObectEntityPersister.MONGO_ID_FIELD, (Object)id);
        return (T)collection.find((Bson)query, type).limit(1).first();
    }

    public static DBObject findOne(DBCollection collection, Map query, Map projection) {
        return collection.findOne((DBObject)new BasicDBObject(query), (DBObject)new BasicDBObject(projection));
    }

    public static Document findOne(MongoCollection<Document> collection, Map<String, Object> query, Map projection) {
        return (Document)ScriptBytecodeAdapter.castToType((Object)collection.find((Bson)new Document(query)).projection((Bson)new Document(projection)).limit(1).first(), Document.class);
    }

    public static DBObject findOne(DBCollection collection, Map query, Map projection, Map sort) {
        return collection.findOne((DBObject)new BasicDBObject(query), (DBObject)new BasicDBObject(projection), (DBObject)new BasicDBObject(sort));
    }

    public static Document findOne(MongoCollection<Document> collection, Map query, Map projection, Map sort) {
        return (Document)ScriptBytecodeAdapter.castToType((Object)collection.find((Bson)new Document(query)).projection((Bson)new Document(projection)).sort((Bson)new Document(sort)).limit(1).first(), Document.class);
    }

    public static Document findOne(MongoCollection<Document> collection) {
        return (Document)ScriptBytecodeAdapter.castToType((Object)collection.find().first(), Document.class);
    }

    public static DBObject findOne(DBCollection collection, Map query, Map projection, ReadPreference readPreference) {
        return collection.findOne((DBObject)new BasicDBObject(query), (DBObject)new BasicDBObject(projection), readPreference);
    }

    public static Document findOne(MongoCollection<Document> collection, Map query, Map projection, ReadPreference readPreference) {
        return (Document)ScriptBytecodeAdapter.castToType((Object)collection.withReadPreference(readPreference).find((Bson)new Document(query)).projection((Bson)new Document(projection)).limit(1).first(), Document.class);
    }

    public static DBObject findOne(DBCollection collection, Map query, Map projection, Map sort, ReadPreference readPreference) {
        return collection.findOne((DBObject)new BasicDBObject(query), (DBObject)new BasicDBObject(projection), (DBObject)new BasicDBObject(sort), readPreference);
    }

    public static Document findOne(MongoCollection<Document> collection, Map query, Map projection, Map sort, ReadPreference readPreference) {
        return (Document)ScriptBytecodeAdapter.castToType((Object)collection.withReadPreference(readPreference).find((Bson)new Document(query)).projection((Bson)new Document(projection)).sort((Bson)new Document(sort)).limit(1).first(), Document.class);
    }

    public static DBCursor find(DBCollection collection, Map query) {
        return collection.find((DBObject)new BasicDBObject(query));
    }

    public static FindIterable<Document> find(MongoCollection<Document> collection, Map<String, Object> query) {
        return collection.find((Bson)new Document(query));
    }

    public static <T> FindIterable<T> find(MongoCollection<T> collection, Map<String, Object> query, Class<T> type) {
        return collection.find((Bson)new Document(query), type);
    }

    public static DBCursor find(DBCollection collection, Map<String, Object> query, Map<String, Object> projection) {
        return collection.find((DBObject)new BasicDBObject(query), (DBObject)new BasicDBObject(projection));
    }

    public static FindIterable<Document> find(MongoCollection<Document> collection, Map<String, Object> query, Map<String, Object> projection) {
        return collection.find((Bson)new Document(query)).projection((Bson)new Document(projection));
    }

    public static long count(DBCollection collection, Map query) {
        return MongoExtensions.getCount(collection, query, null);
    }

    public static long count(MongoCollection<Document> collection, Map<String, Object> query) {
        return MongoExtensions.getCount(collection, query);
    }

    public static long count(MongoCollection<Document> collection, Map<String, Object> query, ReadPreference readPreference) {
        return MongoExtensions.getCount(collection, query, readPreference);
    }

    public static long count(MongoCollection<Document> collection, Map query, Map<String, Object> options) {
        return MongoExtensions.getCount(collection, (Map<String, Object>)query, options);
    }

    public static long count(DBCollection collection, Map query, ReadPreference readPreference) {
        return MongoExtensions.getCount(collection, query, null, readPreference);
    }

    public static long getCount(DBCollection collection, Map query) {
        return MongoExtensions.getCount(collection, query, null);
    }

    public static long getCount(MongoCollection<Document> collection, Map<String, Object> query) {
        return collection.count((Bson)new Document(query));
    }

    public static long getCount(MongoCollection<Document> collection, Map<String, Object> query, ReadPreference readPreference) {
        return collection.withReadPreference(readPreference).count((Bson)new Document(query));
    }

    public static long getCount(MongoCollection<Document> collection, Map<String, Object> query, Map<String, Object> options) {
        return collection.count((Bson)new Document(query), (CountOptions)ScriptBytecodeAdapter.castToType((Object)MongoExtensions.mapToObject(CountOptions.class, options), CountOptions.class));
    }

    public static long getCount(DBCollection collection, Map query, Map projection) {
        return MongoExtensions.getCount(collection, query, projection, 0, 0);
    }

    public static long getCount(DBCollection collection, Map query, Map projection, ReadPreference readPreference) {
        return MongoExtensions.getCount(collection, query, projection, 0, 0, readPreference);
    }

    public static long getCount(DBCollection collection, Map query, Map projection, long limit, long skip) {
        return collection.getCount((DBObject)new BasicDBObject(query), (DBObject)new BasicDBObject(projection), limit, skip);
    }

    public static long getCount(DBCollection collection, Map query, Map projection, long limit, long skip, ReadPreference readPreference) {
        return collection.getCount((DBObject)new BasicDBObject(query), (DBObject)new BasicDBObject(projection), limit, skip, readPreference);
    }

    public static void createIndex(DBCollection collection, Map keys, String name) {
        MongoExtensions.createIndex(collection, keys, name, false);
    }

    public static void createIndex(DBCollection collection, Map keys, String name, boolean unique) {
        collection.createIndex((DBObject)new BasicDBObject(keys), name, unique);
    }

    public static void createIndex(DBCollection collection, Map keys) {
        collection.createIndex((DBObject)new BasicDBObject(keys));
    }

    public static void createIndex(DBCollection collection, Map keys, Map options) {
        collection.createIndex((DBObject)new BasicDBObject(keys), (DBObject)new BasicDBObject(options));
    }

    public static void createIndex(MongoCollection<Document> collection, Map keys, String name) {
        MongoExtensions.createIndex(collection, keys, name, false);
    }

    public static void createIndex(MongoCollection<Document> collection, Map keys, String name, boolean unique) {
        collection.createIndex((Bson)new Document(keys), new IndexOptions().name(name).unique(unique));
    }

    public static void createIndex(MongoCollection<Document> collection, Map<String, Object> keys) {
        collection.createIndex((Bson)new Document(keys));
    }

    public static void createIndex(MongoCollection<Document> collection, Map<String, Object> keys, IndexOptions options) {
        collection.createIndex((Bson)new Document(keys), options);
    }

    public static void createIndex(MongoCollection<Document> collection, Map<String, Object> keys, Map<String, Object> options) {
        collection.createIndex((Bson)new Document(keys), (IndexOptions)ScriptBytecodeAdapter.castToType((Object)MongoExtensions.mapToObject(IndexOptions.class, options), IndexOptions.class));
    }

    public static void dropIndex(DBCollection collection, Map index) {
        collection.dropIndex((DBObject)new BasicDBObject(index));
    }

    public static void dropIndex(MongoCollection<Document> collection, Map<String, Object> index) {
        collection.dropIndex((Bson)new Document(index));
    }

    public static WriteResult insert(DBCollection collection, Map document) {
        return MongoExtensions.insert(collection, Arrays.asList(document));
    }

    public static void insert(MongoCollection<Document> collection, Map<String, Object> document) {
        MongoExtensions.insert(collection, Arrays.asList(document));
    }

    public static WriteResult leftShift(DBCollection collection, Map document) {
        return MongoExtensions.insert(collection, document);
    }

    public static WriteResult insert(DBCollection collection, Map document, WriteConcern writeConcern) {
        return MongoExtensions.insert(collection, Arrays.asList(document), writeConcern);
    }

    public static MongoCollection<Document> insert(MongoCollection<Document> collection, Map<String, Object> document, WriteConcern writeConcern) {
        return MongoExtensions.insert(collection, Arrays.asList(document), writeConcern);
    }

    public static WriteResult insert(DBCollection collection, Map ... documents) {
        class _insert_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _insert_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map m) {
                return new BasicDBObject(m);
            }

            public Object call(Map m) {
                return this.doCall(m);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _insert_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return collection.insert(DefaultGroovyMethods.collect((Object)documents, (Closure)new _insert_closure1(MongoExtensions.class, MongoExtensions.class)));
    }

    public static void insert(MongoCollection<Document> collection, Map<String, Object> ... documents) {
        class _insert_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _insert_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map m) {
                return new Document(m);
            }

            public Object call(Map m) {
                return this.doCall(m);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _insert_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        collection.insertMany(DefaultGroovyMethods.collect(documents, (Closure)new _insert_closure2(MongoExtensions.class, MongoExtensions.class)));
    }

    public static WriteResult leftShift(DBCollection collection, Map ... documents) {
        return MongoExtensions.insert(collection, documents);
    }

    public static MongoCollection<Document> leftShift(MongoCollection<Document> collection, Map<String, Object> ... documents) {
        MongoExtensions.insert(collection, documents);
        return collection;
    }

    public static WriteResult insert(DBCollection collection, WriteConcern writeConcern, Map ... documents) {
        return MongoExtensions.insert(collection, documents, writeConcern);
    }

    public static MongoCollection<Document> insert(MongoCollection<Document> collection, WriteConcern writeConcern, Map<String, Object> ... documents) {
        return MongoExtensions.insert(collection, (Map[])documents, writeConcern);
    }

    public static WriteResult insert(DBCollection collection, Map[] documents, WriteConcern writeConcern) {
        return MongoExtensions.insert(collection, Arrays.asList((Object[])ScriptBytecodeAdapter.castToType((Object)documents, Object[].class)), writeConcern);
    }

    public static MongoCollection<Document> insert(MongoCollection<Document> collection, Map[] documents, WriteConcern writeConcern) {
        return MongoExtensions.insert(collection, Arrays.asList((Object[])ScriptBytecodeAdapter.castToType((Object)documents, Object[].class)), writeConcern);
    }

    public static WriteResult insert(DBCollection collection, List<? extends Map> documents) {
        class _insert_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _insert_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map m) {
                return new BasicDBObject(m);
            }

            public Object call(Map m) {
                return this.doCall(m);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _insert_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return collection.insert(DefaultGroovyMethods.collect(documents, (Closure)new _insert_closure3(MongoExtensions.class, MongoExtensions.class)));
    }

    public static MongoCollection<Document> insert(MongoCollection<Document> collection, List<? extends Map<String, Object>> documents) {
        class _insert_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _insert_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map m) {
                return new Document(m);
            }

            public Object call(Map m) {
                return this.doCall(m);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _insert_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        collection.insertMany(DefaultGroovyMethods.collect(documents, (Closure)new _insert_closure4(MongoExtensions.class, MongoExtensions.class)));
        return collection;
    }

    public static WriteResult leftShift(DBCollection collection, List<? extends Map> documents) {
        return MongoExtensions.insert(collection, documents);
    }

    public static WriteResult insert(DBCollection collection, List<? extends Map> documents, WriteConcern aWriteConcern) {
        return MongoExtensions.insert(collection, documents, aWriteConcern, null);
    }

    public static MongoCollection<Document> insert(MongoCollection<Document> collection, List<? extends Map<String, Object>> documents, WriteConcern aWriteConcern) {
        return MongoExtensions.insert(collection, documents, aWriteConcern, null);
    }

    public static WriteResult insert(DBCollection collection, Map[] documents, WriteConcern aWriteConcern, DBEncoder encoder) {
        return MongoExtensions.insert(collection, Arrays.asList((Object[])ScriptBytecodeAdapter.castToType((Object)documents, Object[].class)), aWriteConcern, encoder);
    }

    public static WriteResult insert(DBCollection collection, List<? extends Map> documents, WriteConcern aWriteConcern, DBEncoder dbEncoder) {
        class _insert_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _insert_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map m) {
                return new BasicDBObject(m);
            }

            public Object call(Map m) {
                return this.doCall(m);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _insert_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return collection.insert(DefaultGroovyMethods.collect(documents, (Closure)new _insert_closure5(MongoExtensions.class, MongoExtensions.class)), aWriteConcern, dbEncoder);
    }

    public static WriteResult insert(DBCollection collection, List<? extends Map> documents, InsertOptions insertOptions) {
        class _insert_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _insert_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map m) {
                return new BasicDBObject(m);
            }

            public Object call(Map m) {
                return this.doCall(m);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _insert_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return collection.insert(DefaultGroovyMethods.collect(documents, (Closure)new _insert_closure6(MongoExtensions.class, MongoExtensions.class)), insertOptions);
    }

    public static MongoCollection<Document> insert(MongoCollection<Document> collection, List<? extends Map<String, Object>> documents, WriteConcern writeConcern, InsertManyOptions insertOptions) {
        class _insert_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _insert_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map m) {
                return new Document(m);
            }

            public Object call(Map m) {
                return this.doCall(m);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _insert_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        collection.withWriteConcern(writeConcern).insertMany(DefaultGroovyMethods.collect(documents, (Closure)new _insert_closure7(MongoExtensions.class, MongoExtensions.class)), insertOptions);
        return collection;
    }

    public static MongoCollection<Document> insert(MongoCollection<Document> collection, List<? extends Map> documents, InsertManyOptions insertOptions) {
        class _insert_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _insert_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map m) {
                return new Document(m);
            }

            public Object call(Map m) {
                return this.doCall(m);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _insert_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        collection.insertMany(DefaultGroovyMethods.collect(documents, (Closure)new _insert_closure8(MongoExtensions.class, MongoExtensions.class)), insertOptions);
        return collection;
    }

    public static WriteResult save(DBCollection collection, Map document) {
        return collection.save((DBObject)new BasicDBObject(document));
    }

    public static WriteResult save(DBCollection collection, Map document, WriteConcern writeConcern) {
        return collection.save((DBObject)new BasicDBObject(document), writeConcern);
    }

    public static MongoCollection save(MongoCollection<Document> collection, Map<String, Object> document) {
        MongoExtensions.insert(collection, document);
        return (MongoCollection)ScriptBytecodeAdapter.castToType(null, MongoCollection.class);
    }

    public static MongoCollection save(MongoCollection<Document> collection, Map<String, Object> document, WriteConcern writeConcern) {
        return MongoExtensions.insert(collection, document, writeConcern);
    }

    public static UpdateResult updateOne(MongoCollection<Document> collection, Map<String, Object> filter, Map<String, Object> update) {
        return collection.updateOne((Bson)new Document(filter), (Bson)new Document(update));
    }

    public static UpdateResult update(MongoCollection<Document> collection, Map<String, Object> filter, Map<String, Object> update) {
        return collection.updateOne((Bson)new Document(filter), (Bson)new Document(update));
    }

    public static UpdateResult updateOne(MongoCollection<Document> collection, Map<String, Object> filter, Map<String, Object> update, Map<String, Object> options) {
        return collection.updateOne((Bson)new Document(filter), (Bson)new Document(update), (UpdateOptions)ScriptBytecodeAdapter.castToType((Object)MongoExtensions.mapToObject(UpdateOptions.class, options), UpdateOptions.class));
    }

    public static UpdateResult update(MongoCollection<Document> collection, Map<String, Object> filter, Map<String, Object> update, Map<String, Object> options) {
        return collection.updateOne((Bson)new Document(filter), (Bson)new Document(update), (UpdateOptions)ScriptBytecodeAdapter.castToType((Object)MongoExtensions.mapToObject(UpdateOptions.class, options), UpdateOptions.class));
    }

    public static WriteResult update(DBCollection collection, Map query, Map update, boolean upsert, boolean multi, WriteConcern aWriteConcern) {
        return collection.update((DBObject)new BasicDBObject(query), (DBObject)new BasicDBObject(update), upsert, multi, aWriteConcern);
    }

    public static WriteResult update(DBCollection collection, Map query, Map update, boolean upsert, boolean multi, WriteConcern aWriteConcern, DBEncoder encoder) {
        return collection.update((DBObject)new BasicDBObject(query), (DBObject)new BasicDBObject(update), upsert, multi, aWriteConcern, encoder);
    }

    public static WriteResult update(DBCollection collection, Map query, Map update, boolean upsert, boolean multi) {
        return collection.update((DBObject)new BasicDBObject(query), (DBObject)new BasicDBObject(update), upsert, multi);
    }

    public static WriteResult update(DBCollection collection, Map query, Map update) {
        return collection.update((DBObject)new BasicDBObject(query), (DBObject)new BasicDBObject(update));
    }

    public static UpdateResult updateMany(MongoCollection<Document> collection, Map<String, Object> filter, Map<String, Object> update) {
        return collection.updateMany((Bson)new Document(filter), (Bson)new Document(update));
    }

    public static UpdateResult updateMany(MongoCollection<Document> collection, Map<String, Object> filter, Map<String, Object> update, Map<String, Object> options) {
        return collection.updateMany((Bson)new Document(filter), (Bson)new Document(update), (UpdateOptions)ScriptBytecodeAdapter.castToType((Object)MongoExtensions.mapToObject(UpdateOptions.class, options), UpdateOptions.class));
    }

    public static WriteResult updateMulti(DBCollection collection, Map query, Map update) {
        return collection.updateMulti((DBObject)new BasicDBObject(query), (DBObject)new BasicDBObject(update));
    }

    public static WriteResult remove(DBCollection collection, Map query) {
        return collection.remove((DBObject)new BasicDBObject(query));
    }

    public static WriteResult rightShift(DBCollection collection, Map query) {
        return MongoExtensions.remove(collection, query);
    }

    public static WriteResult remove(DBCollection collection, Map query, WriteConcern writeConcern) {
        return collection.remove((DBObject)new BasicDBObject(query), writeConcern);
    }

    public static WriteResult remove(DBCollection collection, Map query, WriteConcern writeConcern, DBEncoder encoder) {
        return collection.remove((DBObject)new BasicDBObject(query), writeConcern, encoder);
    }

    public static DeleteResult deleteMany(MongoCollection<Document> collection, Map<String, Object> query) {
        return collection.deleteMany((Bson)new Document(query));
    }

    public static DeleteResult remove(MongoCollection<Document> collection, Map<String, Object> query) {
        return MongoExtensions.deleteMany(collection, query);
    }

    public static MongoCollection<Document> rightShift(MongoCollection<Document> collection, Map<String, Object> query) {
        MongoExtensions.deleteMany(collection, query);
        return collection;
    }

    public static DeleteResult deleteMany(MongoCollection<Document> collection, Map<String, Object> query, WriteConcern writeConcern) {
        return collection.withWriteConcern(writeConcern).deleteMany((Bson)new Document(query));
    }

    public static DeleteResult deleteOne(MongoCollection<Document> collection, Map<String, Object> query) {
        return collection.deleteOne((Bson)new Document(query));
    }

    public static DeleteResult deleteOne(MongoCollection<Document> collection, Map<String, Object> query, WriteConcern writeConcern) {
        return collection.withWriteConcern(writeConcern).deleteOne((Bson)new Document(query));
    }

    public static void setHintFields(DBCollection collection, List<? extends Map> indexes) {
        class _setHintFields_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _setHintFields_closure9(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map m) {
                return new BasicDBObject(m);
            }

            public Object call(Map m) {
                return this.doCall(m);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setHintFields_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List list = DefaultGroovyMethods.collect(indexes, (Closure)new _setHintFields_closure9(MongoExtensions.class, MongoExtensions.class));
        collection.setHintFields(list);
    }

    public static DBObject findAndModify(DBCollection collection, Map query, Map sort, Map update) {
        return MongoExtensions.findAndModify(collection, query, null, sort, false, update, false, false);
    }

    public static DBObject findAndModify(DBCollection collection, Map query, Map update) {
        return MongoExtensions.findAndModify(collection, query, null, null, false, update, false, false);
    }

    public static DBObject findAndRemove(DBCollection collection, Map query) {
        return MongoExtensions.findAndModify(collection, query, null, null, true, null, false, false);
    }

    public static DBObject findAndModify(DBCollection collection, Map query, Map fields, Map sort, boolean remove, Map update, boolean returnNew, boolean upsert) {
        return MongoExtensions.findAndModify(collection, query, fields, sort, remove, update, returnNew, upsert, 0L, TimeUnit.MILLISECONDS);
    }

    public static DBObject findAndModify(DBCollection collection, Map query, Map fields, Map sort, boolean remove, Map update, boolean returnNew, boolean upsert, long maxTime, TimeUnit maxTimeUnit) {
        return collection.findAndModify((DBObject)new BasicDBObject(query), (DBObject)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)fields) ? new BasicDBObject(fields) : null), DBObject.class), (DBObject)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)sort) ? new BasicDBObject(sort) : null), DBObject.class), remove, (DBObject)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)update) ? new BasicDBObject(update) : null), DBObject.class), returnNew, upsert, maxTime, maxTimeUnit);
    }

    public static List distinct(DBCollection collection, String fieldName, Map query) {
        return collection.distinct(fieldName, (DBObject)new BasicDBObject(query));
    }

    public static List distinct(DBCollection collection, String fieldName, Map query, ReadPreference readPreference) {
        return collection.distinct(fieldName, (DBObject)new BasicDBObject(query), readPreference);
    }

    public static DistinctIterable<Document> distinct(MongoCollection<Document> collection, String fieldName) {
        return collection.distinct(fieldName, Document.class);
    }

    public static DistinctIterable<Document> distinct(MongoCollection<Document> collection, String fieldName, ReadPreference readPreference) {
        return collection.withReadPreference(readPreference).distinct(fieldName, Document.class);
    }

    public static DistinctIterable<Document> distinct(MongoCollection<Document> collection, String fieldName, Map<String, Object> query) {
        return collection.distinct(fieldName, Document.class).filter((Bson)new Document(query));
    }

    public static DistinctIterable<Document> distinct(MongoCollection<Document> collection, String fieldName, Map<String, Object> query, ReadPreference readPreference) {
        return collection.withReadPreference(readPreference).distinct(fieldName, Document.class).filter((Bson)new Document(query));
    }

    public static AggregationOutput aggregate(DBCollection collection, List<? extends Map> pipeline) {
        class _aggregate_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _aggregate_closure10(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map m) {
                return new BasicDBObject(m);
            }

            public Object call(Map m) {
                return this.doCall(m);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _aggregate_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return collection.aggregate(DefaultGroovyMethods.collect(pipeline, (Closure)new _aggregate_closure10(MongoExtensions.class, MongoExtensions.class)));
    }

    public static AggregationOutput aggregate(DBCollection collection, List<? extends Map> pipeline, ReadPreference readPreference) {
        class _aggregate_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _aggregate_closure11(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map m) {
                return new BasicDBObject(m);
            }

            public Object call(Map m) {
                return this.doCall(m);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _aggregate_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return collection.aggregate(DefaultGroovyMethods.collect(pipeline, (Closure)new _aggregate_closure11(MongoExtensions.class, MongoExtensions.class)), readPreference);
    }

    public static Cursor aggregate(DBCollection collection, List<? extends Map> pipeline, AggregationOptions options) {
        class _aggregate_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _aggregate_closure12(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map m) {
                return new BasicDBObject(m);
            }

            public Object call(Map m) {
                return this.doCall(m);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _aggregate_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return collection.aggregate(DefaultGroovyMethods.collect(pipeline, (Closure)new _aggregate_closure12(MongoExtensions.class, MongoExtensions.class)), options);
    }

    public static DBObject group(DBCollection collection, Map key, Map cond, Map initial, String reduce) {
        return MongoExtensions.group(collection, key, cond, initial, reduce, null);
    }

    public static DBObject group(DBCollection collection, Map key, Map cond, Map initial, String reduce, String finalize) {
        return collection.group((DBObject)new BasicDBObject(key), (DBObject)new BasicDBObject(cond), (DBObject)new BasicDBObject(initial), reduce, finalize);
    }

    public static DBObject group(DBCollection collection, Map key, Map cond, Map initial, String reduce, String finalize, ReadPreference readPreference) {
        return collection.group((DBObject)new BasicDBObject(key), (DBObject)new BasicDBObject(cond), (DBObject)new BasicDBObject(initial), reduce, finalize, readPreference);
    }

    public static MapReduceOutput mapReduce(DBCollection collection, String map, String reduce, String outputTarget, Map query) {
        return collection.mapReduce(map, reduce, outputTarget, (DBObject)new BasicDBObject(query));
    }

    public static MapReduceOutput mapReduce(DBCollection collection, String map, String reduce, String outputTarget, MapReduceCommand.OutputType outputType, Map query) {
        return collection.mapReduce(map, reduce, outputTarget, outputType, (DBObject)new BasicDBObject(query));
    }

    public static MapReduceOutput mapReduce(DBCollection collection, String map, String reduce, String outputTarget, MapReduceCommand.OutputType outputType, Map query, ReadPreference readPreference) {
        return collection.mapReduce(map, reduce, outputTarget, outputType, (DBObject)new BasicDBObject(query), readPreference);
    }

    public static UpdateResult replaceOne(MongoCollection<Document> collection, Map<String, Object> filter, Document replacement) {
        return collection.replaceOne((Bson)new Document(filter), (Object)replacement);
    }

    public static UpdateResult replaceOne(MongoCollection<Document> collection, Map<String, Object> filter, Document replacement, Map<String, Object> options) {
        return collection.replaceOne((Bson)new Document(filter), (Object)replacement, (UpdateOptions)ScriptBytecodeAdapter.castToType((Object)MongoExtensions.mapToObject(UpdateOptions.class, options), UpdateOptions.class));
    }

    public static Document findOneAndDelete(MongoCollection<Document> collection, Map<String, Object> filter) {
        return (Document)ScriptBytecodeAdapter.castToType((Object)collection.findOneAndDelete((Bson)new Document(filter)), Document.class);
    }

    public static Document findOneAndDelete(MongoCollection<Document> collection, Map<String, Object> filter, Map<String, Object> options) {
        return (Document)ScriptBytecodeAdapter.castToType((Object)collection.findOneAndDelete((Bson)new Document(filter), (FindOneAndDeleteOptions)ScriptBytecodeAdapter.castToType((Object)MongoExtensions.mapToObject(FindOneAndDeleteOptions.class, options), FindOneAndDeleteOptions.class)), Document.class);
    }

    public static Document findOneAndReplace(MongoCollection<Document> collection, Map<String, Object> filter, Map<String, Object> replacement) {
        return (Document)ScriptBytecodeAdapter.castToType((Object)collection.findOneAndReplace((Bson)new Document(filter), (Object)new Document(replacement)), Document.class);
    }

    public static Document findOneAndReplace(MongoCollection<Document> collection, Map<String, Object> filter, Map<String, Object> replacement, Map<String, Object> options) {
        return (Document)ScriptBytecodeAdapter.castToType((Object)collection.findOneAndReplace((Bson)new Document(filter), (Object)new Document(replacement), (FindOneAndReplaceOptions)ScriptBytecodeAdapter.castToType((Object)MongoExtensions.mapToObject(FindOneAndReplaceOptions.class, options), FindOneAndReplaceOptions.class)), Document.class);
    }

    public static Document findOneAndUpdate(MongoCollection<Document> collection, Map<String, Object> filter, Map<String, Object> update) {
        return (Document)ScriptBytecodeAdapter.castToType((Object)collection.findOneAndUpdate((Bson)new Document(filter), (Bson)new Document(update)), Document.class);
    }

    public static Document findOneAndUpdate(MongoCollection<Document> collection, Map<String, Object> filter, Map<String, Object> update, Map<String, Object> options) {
        return (Document)ScriptBytecodeAdapter.castToType((Object)collection.findOneAndUpdate((Bson)new Document(filter), (Bson)new Document(update), (FindOneAndUpdateOptions)ScriptBytecodeAdapter.castToType((Object)MongoExtensions.mapToObject(FindOneAndUpdateOptions.class, options), FindOneAndUpdateOptions.class)), Document.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MongoExtensions.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "newInstance";
        stringArray[1] = "iterator";
        stringArray[2] = "keySet";
        stringArray[3] = "respondsTo";
        stringArray[4] = "get";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[5];
        MongoExtensions.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(MongoExtensions.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = MongoExtensions.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

