/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.engine.codecs;

import com.mongodb.DBRef;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.mapping.collection.PersistentList;
import org.grails.datastore.mapping.collection.PersistentSet;
import org.grails.datastore.mapping.collection.PersistentSortedSet;
import org.grails.datastore.mapping.core.DatastoreException;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckableCollection;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckingMap;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckingSupport;
import org.grails.datastore.mapping.document.config.DocumentMappingContext;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.engine.internal.MappingUtils;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.Custom;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.EmbeddedCollection;
import org.grails.datastore.mapping.model.types.Identity;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.ManyToOne;
import org.grails.datastore.mapping.model.types.OneToMany;
import org.grails.datastore.mapping.model.types.OneToOne;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.mongo.AbstractMongoSession;
import org.grails.datastore.mapping.mongo.MongoDatastore;
import org.grails.datastore.mapping.mongo.config.MongoAttribute;
import org.grails.datastore.mapping.mongo.engine.MongoCodecEntityPersister;
import org.grails.datastore.mapping.mongo.engine.codecs.AdditionalCodecs;
import org.grails.datastore.mapping.proxy.ProxyFactory;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.grails.datastore.mapping.reflect.FieldEntityAccess;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;

public class PersistentEntityCodec
implements Codec,
GroovyObject {
    private static final Map<Class, PropertyEncoder> ENCODERS;
    private static final Map<Class, PropertyDecoder> DECODERS;
    private static final String BLANK_STRING = "";
    public static final String MONGO_SET_OPERATOR = "$set";
    public static final String MONGO_UNSET_OPERATOR = "$unset";
    public static final EncoderContext DEFAULT_ENCODER_CONTEXT;
    public static final String DB_REF_ID_FIELD = "$id";
    public static final String SCHEMALESS_ATTRIBUTES = "schemaless.attributes";
    private final MongoDatastore datastore;
    private final MappingContext mappingContext;
    private final PersistentEntity entity;
    private final CodecRegistry codecRegistry;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    /*
     * WARNING - void declaration
     */
    public PersistentEntityCodec(MongoDatastore mongoDatastore, PersistentEntity persistentEntity) {
        void entity;
        CodecRegistry codecRegistry;
        void datastore;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var4_4 = datastore;
        this.datastore = var4_4;
        DocumentMappingContext documentMappingContext = datastore.getMappingContext();
        this.mappingContext = documentMappingContext;
        this.codecRegistry = codecRegistry = datastore.getCodecRegistry();
        void var7_7 = entity;
        this.entity = var7_7;
    }

    static {
        EncoderContext encoderContext;
        Map map;
        Map map2;
        ENCODERS = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        DECODERS = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        DEFAULT_ENCODER_CONTEXT = encoderContext = EncoderContext.builder().build();
        IdentityEncoder identityEncoder = new IdentityEncoder();
        DefaultGroovyMethods.putAt(ENCODERS, Identity.class, (Object)identityEncoder);
        IdentityDecoder identityDecoder = new IdentityDecoder();
        DefaultGroovyMethods.putAt(DECODERS, Identity.class, (Object)identityDecoder);
        SimpleEncoder simpleEncoder = new SimpleEncoder();
        DefaultGroovyMethods.putAt(ENCODERS, Simple.class, (Object)simpleEncoder);
        SimpleDecoder simpleDecoder = new SimpleDecoder();
        DefaultGroovyMethods.putAt(DECODERS, Simple.class, (Object)simpleDecoder);
        EmbeddedEncoder embeddedEncoder = new EmbeddedEncoder();
        DefaultGroovyMethods.putAt(ENCODERS, Embedded.class, (Object)embeddedEncoder);
        EmbeddedDecoder embeddedDecoder = new EmbeddedDecoder();
        DefaultGroovyMethods.putAt(DECODERS, Embedded.class, (Object)embeddedDecoder);
        EmbeddedCollectionEncoder embeddedCollectionEncoder = new EmbeddedCollectionEncoder();
        DefaultGroovyMethods.putAt(ENCODERS, EmbeddedCollection.class, (Object)embeddedCollectionEncoder);
        EmbeddedCollectionDecoder embeddedCollectionDecoder = new EmbeddedCollectionDecoder();
        DefaultGroovyMethods.putAt(DECODERS, EmbeddedCollection.class, (Object)embeddedCollectionDecoder);
        ToOneEncoder toOneEncoder = new ToOneEncoder();
        DefaultGroovyMethods.putAt(ENCODERS, OneToOne.class, (Object)toOneEncoder);
        ToOneDecoder toOneDecoder = new ToOneDecoder();
        DefaultGroovyMethods.putAt(DECODERS, OneToOne.class, (Object)toOneDecoder);
        ToOneEncoder toOneEncoder2 = new ToOneEncoder();
        DefaultGroovyMethods.putAt(ENCODERS, ManyToOne.class, (Object)toOneEncoder2);
        ToOneDecoder toOneDecoder2 = new ToOneDecoder();
        DefaultGroovyMethods.putAt(DECODERS, ManyToOne.class, (Object)toOneDecoder2);
        OneToManyEncoder oneToManyEncoder = new OneToManyEncoder();
        DefaultGroovyMethods.putAt(ENCODERS, OneToMany.class, (Object)oneToManyEncoder);
        OneToManyDecoder oneToManyDecoder = new OneToManyDecoder();
        DefaultGroovyMethods.putAt(DECODERS, OneToMany.class, (Object)oneToManyDecoder);
        OneToManyEncoder oneToManyEncoder2 = new OneToManyEncoder();
        DefaultGroovyMethods.putAt(ENCODERS, ManyToMany.class, (Object)oneToManyEncoder2);
        OneToManyDecoder oneToManyDecoder2 = new OneToManyDecoder();
        DefaultGroovyMethods.putAt(DECODERS, ManyToMany.class, (Object)oneToManyDecoder2);
        CustomTypeEncoder customTypeEncoder = new CustomTypeEncoder();
        DefaultGroovyMethods.putAt(ENCODERS, Custom.class, (Object)customTypeEncoder);
        CustomTypeDecoder customTypeDecoder = new CustomTypeDecoder();
        DefaultGroovyMethods.putAt(DECODERS, Custom.class, (Object)customTypeDecoder);
        BasicCollectionTypeEncoder basicCollectionTypeEncoder = new BasicCollectionTypeEncoder();
        DefaultGroovyMethods.putAt(ENCODERS, Basic.class, (Object)basicCollectionTypeEncoder);
        BasicCollectionTypeDecoder basicCollectionTypeDecoder = new BasicCollectionTypeDecoder();
        DefaultGroovyMethods.putAt(DECODERS, Basic.class, (Object)basicCollectionTypeDecoder);
    }

    public Object decode(BsonReader bsonReader, DecoderContext decoderContext) {
        bsonReader.readStartDocument();
        PersistentEntity persistentEntity = this.entity;
        Object instance = DefaultGroovyMethods.newInstance((Class)persistentEntity.getJavaClass());
        AbstractMongoSession mongoSession = (AbstractMongoSession)((Object)ScriptBytecodeAdapter.castToType((Object)this.datastore.getCurrentSession(), AbstractMongoSession.class));
        EntityAccess access = this.createEntityAccess(mongoSession, persistentEntity, instance);
        Document schemalessAttributes = null;
        BsonType bsonType = bsonReader.readBsonType();
        boolean abortReading = false;
        while (ScriptBytecodeAdapter.compareNotEqual((Object)bsonType, (Object)BsonType.END_OF_DOCUMENT)) {
            BsonType bsonType2;
            String name = bsonReader.readName();
            if (!abortReading) {
                if (ScriptBytecodeAdapter.compareEqual((Object)MongoCodecEntityPersister.MONGO_CLASS_FIELD, (Object)name)) {
                    BsonType bsonType3;
                    PersistentEntity childEntity = this.mappingContext.getChildEntityByDiscriminator(persistentEntity.getRootEntity(), bsonReader.readString());
                    if (childEntity != null) {
                        EntityAccess entityAccess;
                        Object object;
                        PersistentEntity persistentEntity2;
                        persistentEntity = persistentEntity2 = childEntity;
                        instance = object = childEntity.newInstance();
                        EntityAccess newAccess = this.createEntityAccess(childEntity, instance);
                        newAccess.setIdentifierNoConversion(access.getIdentifier());
                        access = entityAccess = newAccess;
                    }
                    bsonType = bsonType3 = bsonReader.readBsonType();
                    continue;
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)MongoCodecEntityPersister.MONGO_ID_FIELD, (Object)name)) {
                    ((PropertyDecoder)DefaultGroovyMethods.getAt(DECODERS, Identity.class)).decode(bsonReader, persistentEntity.getIdentity(), access, decoderContext, this.datastore);
                    if (mongoSession.contains(instance)) {
                        boolean bl;
                        Object object;
                        instance = object = mongoSession.retrieve(persistentEntity.getJavaClass(), (Serializable)ScriptBytecodeAdapter.castToType((Object)access.getIdentifier(), Serializable.class));
                        abortReading = bl = true;
                    }
                } else {
                    PersistentProperty property = persistentEntity.getPropertyByName(name);
                    if (DefaultTypeTransformation.booleanUnbox((Object)property) && ScriptBytecodeAdapter.compareNotEqual((Object)bsonType, (Object)BsonType.NULL)) {
                        Class<?> propKind = property.getClass().getSuperclass();
                        Class clazz = property.getType();
                        if (ScriptBytecodeAdapter.isCase((Object)clazz, CharSequence.class)) {
                            access.setPropertyNoConversion(property.getName(), (Object)bsonReader.readString());
                        } else {
                            Object v0;
                            Object object = DefaultGroovyMethods.getAt(DECODERS, propKind);
                            if (object != null) {
                                ((PropertyDecoder)object).decode(bsonReader, property, access, decoderContext, this.datastore);
                                v0 = null;
                            } else {
                                v0 = null;
                            }
                        }
                    } else if (!abortReading) {
                        if (schemalessAttributes == null) {
                            Document document;
                            schemalessAttributes = document = new Document();
                        }
                        this.readSchemaless(bsonReader, schemalessAttributes, name, decoderContext);
                    } else {
                        bsonReader.skipValue();
                    }
                }
            } else if (!abortReading) {
                if (schemalessAttributes == null) {
                    Document document;
                    schemalessAttributes = document = new Document();
                }
                this.readSchemaless(bsonReader, schemalessAttributes, name, decoderContext);
            } else {
                bsonReader.skipValue();
            }
            bsonType = bsonType2 = bsonReader.readBsonType();
        }
        bsonReader.readEndDocument();
        AbstractMongoSession session = mongoSession;
        Association association = null;
        Iterator iterator = this.entity.getAssociations().iterator();
        while (iterator.hasNext()) {
            association = (Association)ScriptBytecodeAdapter.castToType(iterator.next(), Association.class);
            if (association instanceof OneToMany) {
                if (!association.isBidirectional()) continue;
                OneToManyDecoder.initializePersistentCollection((Session)session, access, association);
                continue;
            }
            if (!(association instanceof OneToOne) || !((ToOne)ScriptBytecodeAdapter.castToType((Object)association, ToOne.class)).isForeignKeyInChild()) continue;
            Class associatedClass = association.getAssociatedEntity().getJavaClass();
            Query query = session.createQuery(associatedClass);
            query.eq(association.getInverseSide().getName(), access.getIdentifier()).projections().id();
            Object id = query.singleResult();
            boolean lazy = ScriptBytecodeAdapter.compareEqual((Object)association.getMapping().getMappedForm().getFetchStrategy(), (Object)FetchType.LAZY);
            access.setPropertyNoConversion(association.getName(), lazy ? session.proxy(associatedClass, (Serializable)ScriptBytecodeAdapter.castToType((Object)id, Serializable.class)) : session.retrieve(associatedClass, (Serializable)ScriptBytecodeAdapter.castToType((Object)id, Serializable.class)));
        }
        if (schemalessAttributes != null) {
            mongoSession.setAttribute(instance, SCHEMALESS_ATTRIBUTES, schemalessAttributes);
        }
        return instance;
    }

    protected void readSchemaless(BsonReader bsonReader, Document schemalessAttributes, String name, DecoderContext decoderContext) {
        BsonType currentBsonType = bsonReader.getCurrentBsonType();
        Class targetClass = BsonValueCodecProvider.getClassForBsonType((BsonType)currentBsonType);
        Codec codec = this.codecRegistry.get(targetClass);
        BsonValue bsonValue = (BsonValue)codec.decode(bsonReader, decoderContext);
        if (bsonValue != null) {
            Converter converter = AdditionalCodecs.getBsonConverter(bsonValue.getClass());
            schemalessAttributes.put(name, converter != null ? converter.convert((Object)bsonValue) : bsonValue);
        }
    }

    protected EntityAccess createEntityAccess(Object instance) {
        PersistentEntity entity = this.mappingContext.getPersistentEntity(instance.getClass().getName());
        return this.createEntityAccess(entity, instance);
    }

    protected EntityAccess createEntityAccess(PersistentEntity entity, Object instance) {
        AbstractMongoSession session = (AbstractMongoSession)((Object)ScriptBytecodeAdapter.castToType((Object)this.getDatastore().getCurrentSession(), AbstractMongoSession.class));
        return this.createEntityAccess(session, entity, instance);
    }

    protected EntityAccess createEntityAccess(AbstractMongoSession session, PersistentEntity entity, Object instance) {
        return session.createEntityAccess(entity, instance);
    }

    public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
        boolean includeIdentifier = true;
        this.encode(writer, value, encoderContext, includeIdentifier);
    }

    public Document encodeUpdate(Object value, EntityAccess access, EncoderContext encoderContext) {
        Document update;
        block20: {
            update = new Document();
            PersistentEntity entity = access.getPersistentEntity();
            ProxyFactory proxyFactory = this.mappingContext.getProxyFactory();
            if (proxyFactory.isProxy(value)) {
                Object object;
                value = object = proxyFactory.unwrap(value);
            }
            if (!(value instanceof DirtyCheckable)) break block20;
            BsonDocument sets = new BsonDocument();
            Document unsets = new Document();
            BsonDocumentWriter writer = new BsonDocumentWriter(sets);
            writer.writeStartDocument();
            DirtyCheckable dirty = (DirtyCheckable)ScriptBytecodeAdapter.castToType((Object)value, DirtyCheckable.class);
            Set processed = (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
            List dirtyProperties = dirty.listDirtyPropertyNames();
            boolean isNew = dirtyProperties.isEmpty() && dirty.hasChanged();
            boolean isVersioned = entity.isVersioned();
            if (isNew) {
                List list;
                dirtyProperties = list = entity.getPersistentPropertyNames();
                if (!entity.isRoot()) {
                    sets.put(MongoCodecEntityPersister.MONGO_CLASS_FIELD, (BsonValue)new BsonString(entity.getDiscriminator()));
                }
                if (isVersioned) {
                    EntityPersister.incrementEntityVersion((EntityAccess)access);
                }
            }
            MongoDatastore mongoDatastore = this.datastore;
            String propertyName = null;
            Iterator iterator = dirtyProperties.iterator();
            while (iterator.hasNext()) {
                propertyName = ShortTypeHandling.castToString(iterator.next());
                PersistentProperty prop = entity.getPropertyByName(propertyName);
                if (!(prop != null)) continue;
                DefaultGroovyMethods.leftShift((Set)processed, (Object)propertyName);
                Object v = access.getProperty(prop.getName());
                if (v != null) {
                    Object v0;
                    if (prop instanceof Embedded) {
                        this.encodeEmbeddedUpdate(sets, (Association)ScriptBytecodeAdapter.castToType((Object)prop, Association.class), v);
                        continue;
                    }
                    if (prop instanceof EmbeddedCollection) {
                        this.encodeEmbeddedCollectionUpdate(access, sets, (Association)ScriptBytecodeAdapter.castToType((Object)prop, Association.class), v);
                        continue;
                    }
                    Class<?> propKind = prop.getClass().getSuperclass();
                    PropertyEncoder propertyEncoder = ENCODERS.get(propKind);
                    if (propertyEncoder != null) {
                        propertyEncoder.encode((BsonWriter)writer, prop, v, access, encoderContext, mongoDatastore);
                        v0 = null;
                        continue;
                    }
                    v0 = null;
                    continue;
                }
                if (!(!isNew)) continue;
                String string = BLANK_STRING;
                DefaultGroovyMethods.putAt((Map)unsets, (Object)prop.getName(), (Object)string);
            }
            Document schemaless = (Document)ScriptBytecodeAdapter.castToType((Object)this.datastore.getCurrentSession().getAttribute(value, SCHEMALESS_ATTRIBUTES), Document.class);
            if (schemaless != null) {
                String name = null;
                Iterator iterator2 = schemaless.keySet().iterator();
                while (iterator2.hasNext()) {
                    name = ShortTypeHandling.castToString(iterator2.next());
                    Object v = schemaless.get((Object)name);
                    if (v == null) {
                        unsets.put(name, (Object)BLANK_STRING);
                        continue;
                    }
                    writer.writeName(name);
                    Codec codec = this.codecRegistry.get(v.getClass());
                    codec.encode((BsonWriter)writer, v, encoderContext);
                }
            }
            Association association = null;
            Iterator iterator3 = entity.getAssociations().iterator();
            while (iterator3.hasNext()) {
                association = (Association)ScriptBytecodeAdapter.castToType(iterator3.next(), Association.class);
                if (processed.contains(association.getName())) continue;
                if (association instanceof OneToMany) {
                    Object v = access.getProperty(association.getName());
                    if (!(v != null)) continue;
                }
                if (association instanceof ToOne) {
                    Object v = access.getProperty(association.getName());
                    if (!(v instanceof DirtyCheckable) || !((DirtyCheckable)ScriptBytecodeAdapter.castToType((Object)v, DirtyCheckable.class)).hasChanged() || !(association instanceof Embedded)) continue;
                    this.encodeEmbeddedUpdate(sets, association, v);
                    continue;
                }
                if (!(association instanceof EmbeddedCollection)) continue;
                Object v = access.getProperty(association.getName());
                if (!(v instanceof DirtyCheckableCollection) || !((DirtyCheckableCollection)ScriptBytecodeAdapter.castToType((Object)v, DirtyCheckableCollection.class)).hasChanged()) continue;
                this.encodeEmbeddedCollectionUpdate(access, sets, association, v);
            }
            boolean hasSets = !sets.isEmpty();
            boolean hasUnsets = !unsets.isEmpty();
            if (hasSets && isVersioned) {
                Object v1;
                PersistentProperty version = entity.getVersion();
                Class<?> propKind = version.getClass().getSuperclass();
                EntityPersister.incrementEntityVersion((EntityAccess)access);
                Object v = access.getProperty(version.getName());
                PropertyEncoder propertyEncoder = ENCODERS.get(propKind);
                if (propertyEncoder != null) {
                    propertyEncoder.encode((BsonWriter)writer, version, v, access, encoderContext, mongoDatastore);
                    v1 = null;
                } else {
                    v1 = null;
                }
            }
            writer.writeEndDocument();
            if (hasSets) {
                update.put(MONGO_SET_OPERATOR, (Object)sets);
            }
            if (hasUnsets) {
                update.put(MONGO_UNSET_OPERATOR, (Object)unsets);
            }
        }
        return update;
    }

    protected void encodeEmbeddedCollectionUpdate(EntityAccess parentAccess, BsonDocument sets, Association association, Object v) {
        block10: {
            if (!(v instanceof Collection)) break block10;
            if (v instanceof DirtyCheckableCollection && !((DirtyCheckableCollection)ScriptBytecodeAdapter.castToType((Object)v, DirtyCheckableCollection.class)).hasChangedSize()) {
                int i = 0;
                Object o = null;
                Iterator iterator = DefaultGroovyMethods.iterator((Object)v);
                while (iterator.hasNext()) {
                    o = iterator.next();
                    Document embeddedUpdate = this.encodeUpdate(o);
                    Object embeddedSets = embeddedUpdate.get((Object)MONGO_SET_OPERATOR);
                    if (DefaultTypeTransformation.booleanUnbox((Object)embeddedSets)) {
                        Map map = (Map)ScriptBytecodeAdapter.castToType((Object)embeddedSets, Map.class);
                        Object key2 = null;
                        for (Object key2 : map.keySet()) {
                            sets.put(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{association.getName(), i, key2}, new String[]{BLANK_STRING, ".", ".", BLANK_STRING})), (BsonValue)ScriptBytecodeAdapter.castToType(map.get(key2), BsonValue.class));
                        }
                    }
                    int n = i;
                    int cfr_ignored_0 = n + 1;
                }
            } else {
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                Class rootClass = associatedEntity.getJavaClass();
                MongoDatastore mongoDatastore = this.datastore;
                PersistentEntityCodec entityCodec = mongoDatastore.getPersistentEntityCodec(rootClass);
                Association inverseProperty = association.getInverseSide();
                List documents = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                Object o = null;
                Iterator iterator = DefaultGroovyMethods.iterator((Object)v);
                while (iterator.hasNext()) {
                    o = iterator.next();
                    if (o == null) {
                        DefaultGroovyMethods.leftShift((List)documents, null);
                        continue;
                    }
                    PersistentEntity entity = associatedEntity;
                    PersistentEntityCodec codec = entityCodec;
                    Class<?> cls = o.getClass();
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)rootClass, cls)) {
                        PersistentEntityCodec persistentEntityCodec;
                        PersistentEntity persistentEntity;
                        entity = persistentEntity = mongoDatastore.getMappingContext().getPersistentEntity(cls.getName());
                        if (entity == null) {
                            throw (Throwable)new DatastoreException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{o, association}, new String[]{"Value [", "] is not a valid type for association [", "]"})));
                        }
                        codec = persistentEntityCodec = mongoDatastore.getPersistentEntityCodec(cls);
                    }
                    EntityAccess ea = this.createEntityAccess(entity, o);
                    if (inverseProperty != null && inverseProperty instanceof ToOne) {
                        ea.setPropertyNoConversion(inverseProperty.getName(), parentAccess.getEntity());
                    }
                    BsonDocument doc = new BsonDocument();
                    Object id = ea.getIdentifier();
                    codec.encode((BsonWriter)new BsonDocumentWriter(doc), o, DEFAULT_ENCODER_CONTEXT, id != null);
                    documents.add(doc);
                }
                BsonArray bsonArray = new BsonArray(documents);
                sets.put(association.getName(), (BsonValue)bsonArray);
            }
        }
    }

    protected void encodeEmbeddedUpdate(BsonDocument sets, Association association, Object v) {
        Document embeddedUpdate = this.encodeUpdate(v);
        Object embeddedSets = embeddedUpdate.get((Object)MONGO_SET_OPERATOR);
        if (DefaultTypeTransformation.booleanUnbox((Object)embeddedSets)) {
            Map map = (Map)ScriptBytecodeAdapter.castToType((Object)embeddedSets, Map.class);
            Object key2 = null;
            for (Object key2 : map.keySet()) {
                sets.put(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{association.getName(), key2}, new String[]{BLANK_STRING, ".", BLANK_STRING})), (BsonValue)ScriptBytecodeAdapter.castToType(map.get(key2), BsonValue.class));
            }
        }
    }

    public void encode(BsonWriter writer, Object value, EncoderContext encoderContext, boolean includeIdentifier) {
        writer.writeStartDocument();
        EntityAccess access = this.createEntityAccess(value);
        PersistentEntity entity = access.getPersistentEntity();
        if (!entity.isRoot()) {
            String discriminator = entity.getDiscriminator();
            writer.writeName(MongoCodecEntityPersister.MONGO_CLASS_FIELD);
            writer.writeString(discriminator);
        }
        MongoDatastore mongoDatastore = this.datastore;
        if (includeIdentifier) {
            Object id = access.getIdentifier();
            ENCODERS.get(Identity.class).encode(writer, entity.getIdentity(), id, access, encoderContext, mongoDatastore);
        }
        PersistentProperty prop = null;
        Iterator iterator = entity.getPersistentProperties().iterator();
        while (iterator.hasNext()) {
            Object v0;
            prop = (PersistentProperty)ScriptBytecodeAdapter.castToType(iterator.next(), PersistentProperty.class);
            Class<?> propKind = prop.getClass().getSuperclass();
            Object v = access.getProperty(prop.getName());
            if (!(v != null)) continue;
            PropertyEncoder propertyEncoder = ENCODERS.get(propKind);
            if (propertyEncoder != null) {
                propertyEncoder.encode(writer, prop, v, access, encoderContext, mongoDatastore);
                v0 = null;
                continue;
            }
            v0 = null;
        }
        AbstractMongoSession mongoSession = (AbstractMongoSession)((Object)ScriptBytecodeAdapter.castToType((Object)this.datastore.getCurrentSession(), AbstractMongoSession.class));
        Document schemaless = (Document)ScriptBytecodeAdapter.castToType((Object)mongoSession.getAttribute(access.getEntity(), SCHEMALESS_ATTRIBUTES), Document.class);
        if (schemaless != null) {
            String name = null;
            Iterator iterator2 = schemaless.keySet().iterator();
            while (iterator2.hasNext()) {
                name = ShortTypeHandling.castToString(iterator2.next());
                writer.writeName(name);
                Object v = schemaless.get((Object)name);
                Codec codec = this.codecRegistry.get(v.getClass());
                codec.encode(writer, v, encoderContext);
            }
        }
        writer.writeEndDocument();
        writer.flush();
    }

    public Class getEncoderClass() {
        return this.entity.getJavaClass();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PersistentEntityCodec.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(PersistentEntityCodec.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{BLANK_STRING, BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, PersistentEntityCodec.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{BLANK_STRING, BLANK_STRING})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(PersistentEntityCodec.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{BLANK_STRING, BLANK_STRING})));
    }

    public Document encodeUpdate(Object value, EntityAccess access) {
        return this.encodeUpdate(value, access, DEFAULT_ENCODER_CONTEXT);
    }

    public Document encodeUpdate(Object value) {
        return this.encodeUpdate(value, this.createEntityAccess(value), DEFAULT_ENCODER_CONTEXT);
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public final MongoDatastore getDatastore() {
        return this.datastore;
    }

    public final MappingContext getMappingContext() {
        return this.mappingContext;
    }

    public final PersistentEntity getEntity() {
        return this.entity;
    }

    public final CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public static interface PropertyEncoder<T extends PersistentProperty> {
        public void encode(BsonWriter var1, T var2, Object var3, EntityAccess var4, EncoderContext var5, MongoDatastore var6);
    }

    public static interface PropertyDecoder<T extends PersistentProperty> {
        public void decode(BsonReader var1, T var2, EntityAccess var3, DecoderContext var4, MongoDatastore var5);
    }

    public static class IdentityDecoder
    implements PropertyDecoder<Identity>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public IdentityDecoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public void decode(BsonReader bsonReader, Identity property, EntityAccess access, DecoderContext decoderContext, MongoDatastore datastore) {
            Class clazz = property.getType();
            if (ScriptBytecodeAdapter.isCase((Object)clazz, ObjectId.class)) {
                access.setIdentifierNoConversion((Object)bsonReader.readObjectId());
            } else if (ScriptBytecodeAdapter.isCase((Object)clazz, Long.class)) {
                access.setIdentifierNoConversion((Object)bsonReader.readInt64());
            } else if (ScriptBytecodeAdapter.isCase((Object)clazz, Integer.class)) {
                access.setIdentifierNoConversion((Object)bsonReader.readInt32());
            } else {
                access.setIdentifierNoConversion((Object)bsonReader.readString());
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != IdentityDecoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(IdentityDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(IdentityDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static class IdentityEncoder
    implements PropertyEncoder<Identity>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public IdentityEncoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public void encode(BsonWriter writer, Identity property, Object id, EntityAccess parentAccess, EncoderContext encoderContext, MongoDatastore datastore) {
            writer.writeName(MongoCodecEntityPersister.MONGO_ID_FIELD);
            if (id instanceof ObjectId) {
                writer.writeObjectId((ObjectId)ScriptBytecodeAdapter.castToType((Object)id, ObjectId.class));
            } else if (id instanceof Number) {
                writer.writeInt64(DefaultGroovyMethods.toLong((Number)((Number)ScriptBytecodeAdapter.castToType((Object)id, Number.class))).longValue());
            } else {
                writer.writeString(DefaultGroovyMethods.toString((Object)id));
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != IdentityEncoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(IdentityEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(IdentityEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static class SimpleDecoder
    implements PropertyDecoder<Simple>,
    GroovyObject {
        public static final Map<Class, TypeDecoder> SIMPLE_TYPE_DECODERS;
        public static final TypeDecoder DEFAULT_DECODER;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public SimpleDecoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        static {
            Map map;
            1 var0 = new 1(SimpleDecoder.class);
            DEFAULT_DECODER = var0;
            class __clinit__closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public __clinit__closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object Class2) {
                    return DEFAULT_DECODER;
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __clinit__closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            SIMPLE_TYPE_DECODERS = map = DefaultGroovyMethods.withDefault(new HashMap(), (Closure)new __clinit__closure1(SimpleDecoder.class, PersistentEntityCodec.class));
            2 convertingIntReader = new 2(SimpleDecoder.class);
            2 var3_3 = convertingIntReader;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, Short.class, (Object)var3_3);
            2 var4_4 = convertingIntReader;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, Short.TYPE, (Object)var4_4);
            2 var5_5 = convertingIntReader;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, Byte.class, (Object)var5_5);
            2 var6_6 = convertingIntReader;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, Byte.TYPE, (Object)var6_6);
            3 intDecoder = new 3(SimpleDecoder.class);
            3 var8_8 = intDecoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, Integer.class, (Object)var8_8);
            3 var9_9 = intDecoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, Integer.TYPE, (Object)var9_9);
            4 longDecoder = new 4(SimpleDecoder.class);
            4 var11_11 = longDecoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, Long.class, (Object)var11_11);
            4 var12_12 = longDecoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, Long.TYPE, (Object)var12_12);
            5 doubleDecoder = new 5(SimpleDecoder.class);
            5 var14_14 = doubleDecoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, Double.class, (Object)var14_14);
            5 var15_15 = doubleDecoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, Double.TYPE, (Object)var15_15);
            6 booleanDecoder = new 6(SimpleDecoder.class);
            6 var17_17 = booleanDecoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, Boolean.class, (Object)var17_17);
            6 var18_18 = booleanDecoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, Boolean.TYPE, (Object)var18_18);
            7 var19_19 = new 7(SimpleDecoder.class);
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, new byte[0].getClass(), (Object)var19_19);
            8 var20_20 = new 8(SimpleDecoder.class);
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, Date.class, (Object)var20_20);
            9 var21_21 = new 9(SimpleDecoder.class);
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, Calendar.class, (Object)var21_21);
            10 var22_22 = new 10(SimpleDecoder.class);
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_DECODERS, Binary.class, (Object)var22_22);
        }

        @Override
        public void decode(BsonReader reader, Simple property, EntityAccess entityAccess, DecoderContext decoderContext, MongoDatastore datastore) {
            Class type = property.getType();
            TypeDecoder decoder = (TypeDecoder)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(SIMPLE_TYPE_DECODERS, (Object)type), TypeDecoder.class);
            if (type.isArray()) {
                if (!(decoder == DEFAULT_DECODER)) {
                    decoder.decode(reader, property, entityAccess);
                } else {
                    Codec arrayDecoder = datastore.getCodecRegistry().get(List.class);
                    List bsonArray = (List)ScriptBytecodeAdapter.castToType((Object)arrayDecoder.decode(reader, decoderContext), List.class);
                    entityAccess.setProperty(property.getName(), (Object)bsonArray);
                }
            } else {
                decoder.decode(reader, property, entityAccess);
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != SimpleDecoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(SimpleDecoder.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, SimpleDecoder.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectProperty(SimpleDecoder.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(SimpleDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(SimpleDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public class 1
        implements TypeDecoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 1(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void decode(BsonReader reader, Simple property, EntityAccess entityAccess) {
                entityAccess.setProperty(property.getName(), (Object)reader.readString());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public static interface TypeDecoder {
            public void decode(BsonReader var1, Simple var2, EntityAccess var3);
        }

        public class 2
        implements TypeDecoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 2(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void decode(BsonReader reader, Simple property, EntityAccess entityAccess) {
                entityAccess.setProperty(property.getName(), (Object)reader.readInt32());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(2.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(2.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 3
        implements TypeDecoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 3(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void decode(BsonReader reader, Simple property, EntityAccess entityAccess) {
                entityAccess.setPropertyNoConversion(property.getName(), (Object)reader.readInt32());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(3.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(3.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 4
        implements TypeDecoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 4(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void decode(BsonReader reader, Simple property, EntityAccess entityAccess) {
                entityAccess.setPropertyNoConversion(property.getName(), (Object)reader.readInt64());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(4.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(4.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 5
        implements TypeDecoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 5(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void decode(BsonReader reader, Simple property, EntityAccess entityAccess) {
                entityAccess.setPropertyNoConversion(property.getName(), (Object)reader.readDouble());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(5.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(5.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 6
        implements TypeDecoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 6(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void decode(BsonReader reader, Simple property, EntityAccess entityAccess) {
                entityAccess.setPropertyNoConversion(property.getName(), (Object)reader.readBoolean());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(6.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(6.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 7
        implements TypeDecoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 7(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void decode(BsonReader reader, Simple property, EntityAccess entityAccess) {
                BsonBinary binary = reader.readBinaryData();
                entityAccess.setPropertyNoConversion(property.getName(), (Object)binary.getData());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(7.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(7.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 8
        implements TypeDecoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 8(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void decode(BsonReader reader, Simple property, EntityAccess entityAccess) {
                long time = reader.readDateTime();
                entityAccess.setPropertyNoConversion(property.getName(), (Object)new Date(time));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(8.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(8.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 9
        implements TypeDecoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 9(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void decode(BsonReader reader, Simple property, EntityAccess entityAccess) {
                long time = reader.readDateTime();
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTimeInMillis(time);
                entityAccess.setPropertyNoConversion(property.getName(), (Object)calendar);
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(9.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(9.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 10
        implements TypeDecoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 10(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void decode(BsonReader reader, Simple property, EntityAccess entityAccess) {
                entityAccess.setPropertyNoConversion(property.getName(), (Object)new Binary(reader.readBinaryData().getData()));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(10.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(10.class, SimpleDecoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }
    }

    public static class SimpleEncoder
    implements PropertyEncoder<Simple>,
    GroovyObject {
        public static final Map<Class, TypeEncoder> SIMPLE_TYPE_ENCODERS;
        public static final TypeEncoder DEFAULT_ENCODER;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public SimpleEncoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        static {
            Map map;
            1 var0 = new 1(SimpleEncoder.class);
            DEFAULT_ENCODER = var0;
            class __clinit__closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public __clinit__closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Class c) {
                    return DEFAULT_ENCODER;
                }

                public Object call(Class c) {
                    return this.doCall(c);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __clinit__closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            SIMPLE_TYPE_ENCODERS = map = DefaultGroovyMethods.withDefault(new HashMap(), (Closure)new __clinit__closure1(SimpleEncoder.class, PersistentEntityCodec.class));
            2 smallNumberEncoder = new 2(SimpleEncoder.class);
            TypeEncoder typeEncoder = DEFAULT_ENCODER;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, CharSequence.class, (Object)typeEncoder);
            TypeEncoder typeEncoder2 = DEFAULT_ENCODER;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, String.class, (Object)typeEncoder2);
            TypeEncoder typeEncoder3 = DEFAULT_ENCODER;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, StringBuffer.class, (Object)typeEncoder3);
            TypeEncoder typeEncoder4 = DEFAULT_ENCODER;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, StringBuilder.class, (Object)typeEncoder4);
            TypeEncoder typeEncoder5 = DEFAULT_ENCODER;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, BigInteger.class, (Object)typeEncoder5);
            TypeEncoder typeEncoder6 = DEFAULT_ENCODER;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, BigDecimal.class, (Object)typeEncoder6);
            2 var9_9 = smallNumberEncoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, Byte.class, (Object)var9_9);
            2 var10_10 = smallNumberEncoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, Byte.TYPE, (Object)var10_10);
            2 var11_11 = smallNumberEncoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, Integer.class, (Object)var11_11);
            2 var12_12 = smallNumberEncoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, Integer.TYPE, (Object)var12_12);
            2 var13_13 = smallNumberEncoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, Short.class, (Object)var13_13);
            2 var14_14 = smallNumberEncoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, Short.TYPE, (Object)var14_14);
            3 doubleEncoder = new 3(SimpleEncoder.class);
            3 var16_16 = doubleEncoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, Double.class, (Object)var16_16);
            3 var17_17 = doubleEncoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, Double.TYPE, (Object)var17_17);
            4 longEncoder = new 4(SimpleEncoder.class);
            4 var19_19 = longEncoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, Long.class, (Object)var19_19);
            4 var20_20 = longEncoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, Long.TYPE, (Object)var20_20);
            5 booleanEncoder = new 5(SimpleEncoder.class);
            5 var22_22 = booleanEncoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, Boolean.class, (Object)var22_22);
            5 var23_23 = booleanEncoder;
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, Boolean.TYPE, (Object)var23_23);
            6 var24_24 = new 6(SimpleEncoder.class);
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, Calendar.class, (Object)var24_24);
            7 var25_25 = new 7(SimpleEncoder.class);
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, Date.class, (Object)var25_25);
            8 var26_26 = new 8(SimpleEncoder.class);
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, TimeZone.class, (Object)var26_26);
            9 var27_27 = new 9(SimpleEncoder.class);
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, new byte[0].getClass(), (Object)var27_27);
            10 var28_28 = new 10(SimpleEncoder.class);
            DefaultGroovyMethods.putAt(SIMPLE_TYPE_ENCODERS, Binary.class, (Object)var28_28);
        }

        @Override
        public void encode(BsonWriter writer, Simple property, Object value, EntityAccess parentAccess, EncoderContext encoderContext, MongoDatastore datastore) {
            Class type = property.getType();
            TypeEncoder encoder = (TypeEncoder)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(SIMPLE_TYPE_ENCODERS, (Object)type), TypeEncoder.class);
            writer.writeName(MappingUtils.getTargetKey((PersistentProperty)property));
            if (type.isArray()) {
                if (!(encoder == DEFAULT_ENCODER)) {
                    encoder.encode(writer, property, value);
                } else {
                    writer.writeStartArray();
                    Object o = null;
                    Iterator iterator = DefaultGroovyMethods.iterator((Object)value);
                    while (iterator.hasNext()) {
                        o = iterator.next();
                        Object object = DefaultGroovyMethods.getAt(SIMPLE_TYPE_ENCODERS, type.getComponentType());
                        encoder = (TypeEncoder)ScriptBytecodeAdapter.castToType((Object)object, TypeEncoder.class);
                        encoder.encode(writer, property, o);
                    }
                    writer.writeEndArray();
                }
            } else {
                encoder.encode(writer, property, value);
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != SimpleEncoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(SimpleEncoder.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, SimpleEncoder.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectProperty(SimpleEncoder.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(SimpleEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(SimpleEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static interface TypeEncoder {
            public void encode(BsonWriter var1, Simple var2, Object var3);
        }

        public class 1
        implements TypeEncoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 1(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void encode(BsonWriter writer, Simple property, Object value) {
                writer.writeString(DefaultGroovyMethods.toString((Object)value));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 2
        implements TypeEncoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 2(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void encode(BsonWriter writer, Simple property, Object value) {
                writer.writeInt32(((Number)ScriptBytecodeAdapter.castToType((Object)value, Number.class)).intValue());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(2.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(2.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 3
        implements TypeEncoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 3(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void encode(BsonWriter writer, Simple property, Object value) {
                writer.writeDouble(((Double)ScriptBytecodeAdapter.castToType((Object)value, Double.class)).doubleValue());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(3.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(3.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 4
        implements TypeEncoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 4(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void encode(BsonWriter writer, Simple property, Object value) {
                writer.writeInt64(((Long)ScriptBytecodeAdapter.castToType((Object)value, Long.class)).longValue());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(4.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(4.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 5
        implements TypeEncoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 5(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void encode(BsonWriter writer, Simple property, Object value) {
                writer.writeBoolean(DefaultTypeTransformation.booleanUnbox((Object)((Boolean)ScriptBytecodeAdapter.castToType((Object)value, Boolean.class))));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(5.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(5.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 6
        implements TypeEncoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 6(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void encode(BsonWriter writer, Simple property, Object value) {
                writer.writeDateTime(((Calendar)ScriptBytecodeAdapter.castToType((Object)value, Calendar.class)).getTimeInMillis());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(6.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(6.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 7
        implements TypeEncoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 7(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void encode(BsonWriter writer, Simple property, Object value) {
                writer.writeDateTime(((Date)ScriptBytecodeAdapter.castToType((Object)value, Date.class)).getTime());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(7.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(7.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 8
        implements TypeEncoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 8(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void encode(BsonWriter writer, Simple property, Object value) {
                writer.writeString(((TimeZone)ScriptBytecodeAdapter.castToType((Object)value, TimeZone.class)).getID());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(8.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(8.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 9
        implements TypeEncoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 9(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void encode(BsonWriter writer, Simple property, Object value) {
                writer.writeBinaryData(new BsonBinary((byte[])ScriptBytecodeAdapter.castToType((Object)value, byte[].class)));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(9.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(9.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }

        public class 10
        implements TypeEncoder,
        GroovyObject {
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 10(Class p0) {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void encode(BsonWriter writer, Simple property, Object value) {
                writer.writeBinaryData(new BsonBinary(((Binary)ScriptBytecodeAdapter.castToType((Object)value, Binary.class)).getData()));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(10.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(10.class, SimpleEncoder.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }
    }

    public static class CustomTypeDecoder
    implements PropertyDecoder<Custom>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public CustomTypeDecoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public void decode(BsonReader reader, Custom property, EntityAccess entityAccess, DecoderContext decoderContext, MongoDatastore datastore) {
            CustomTypeMarshaller marshaller = property.getCustomTypeMarshaller();
            CustomTypeDecoder.decode(datastore, reader, decoderContext, marshaller, (PersistentProperty)property, entityAccess);
        }

        protected static void decode(MongoDatastore datastore, BsonReader reader, DecoderContext decoderContext, CustomTypeMarshaller marshaller, PersistentProperty property, EntityAccess entityAccess) {
            BsonType bsonType = reader.getCurrentBsonType();
            Codec codec = AdditionalCodecs.getCodecForBsonType(bsonType, datastore.getCodecRegistry());
            if (codec != null) {
                Object decoded = codec.decode(reader, decoderContext);
                Object value = marshaller.read(property, (Object)new Document(MappingUtils.getTargetKey((PersistentProperty)property), decoded));
                if (value != null) {
                    entityAccess.setPropertyNoConversion(property.getName(), value);
                }
            } else {
                reader.skipValue();
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CustomTypeDecoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(CustomTypeDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(CustomTypeDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static class CustomTypeEncoder
    implements PropertyEncoder<Custom>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public CustomTypeEncoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public void encode(BsonWriter writer, Custom property, Object value, EntityAccess parentAccess, EncoderContext encoderContext, MongoDatastore datastore) {
            CustomTypeMarshaller marshaller = property.getCustomTypeMarshaller();
            CustomTypeEncoder.encode(datastore, encoderContext, writer, (PersistentProperty)property, marshaller, value);
        }

        protected static void encode(MongoDatastore datastore, EncoderContext encoderContext, BsonWriter writer, PersistentProperty property, CustomTypeMarshaller marshaller, Object value) {
            String targetName = MappingUtils.getTargetKey((PersistentProperty)property);
            Document document = new Document();
            marshaller.write(property, value, (Object)document);
            Object converted = document.get((Object)targetName);
            if (converted != null) {
                Codec codec = datastore.getCodecRegistry().get(converted.getClass());
                if (DefaultTypeTransformation.booleanUnbox((Object)codec)) {
                    writer.writeName(targetName);
                    codec.encode(writer, converted, encoderContext);
                }
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CustomTypeEncoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(CustomTypeEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(CustomTypeEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static class OneToManyDecoder
    implements PropertyDecoder<Association>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public OneToManyDecoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public void decode(BsonReader reader, Association property, EntityAccess entityAccess, DecoderContext decoderContext, MongoDatastore datastore) {
            AbstractMongoSession session = (AbstractMongoSession)((Object)ScriptBytecodeAdapter.castToType((Object)datastore.getCurrentSession(), AbstractMongoSession.class));
            if (property.isBidirectional() && !(property instanceof ManyToMany)) {
                OneToManyDecoder.initializePersistentCollection((Session)session, entityAccess, property);
            } else {
                Class type = property.getType();
                String propertyName = property.getName();
                CodecRegistry codecRegistry = datastore.getCodecRegistry();
                Codec listCodec = codecRegistry.get(List.class);
                List identifiers = (List)ScriptBytecodeAdapter.castToType((Object)listCodec.decode(reader, decoderContext), List.class);
                MongoAttribute attr = (MongoAttribute)((Object)ScriptBytecodeAdapter.castToType((Object)property.getMapping().getMappedForm(), MongoAttribute.class));
                MongoAttribute mongoAttribute = attr;
                Boolean bl = mongoAttribute != null ? Boolean.valueOf(mongoAttribute.isReference()) : null;
                if (bl == null ? false : bl) {
                    List list;
                    class _decode_closure1
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _decode_closure1(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            if (it instanceof DBRef) {
                                return ((DBRef)ScriptBytecodeAdapter.castToType((Object)it, DBRef.class)).getId();
                            }
                            if (it instanceof Map) {
                                return ((Map)ScriptBytecodeAdapter.castToType((Object)it, Map.class)).get(this.getProperty("DB_REF_ID_FIELD"));
                            }
                            return it;
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        public Object call() {
                            return this.doCall(null);
                        }

                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _decode_closure1.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    identifiers = list = DefaultGroovyMethods.collect((Collection)identifiers, (Closure)new _decode_closure1(this, this));
                }
                Class associatedType = property.getAssociatedEntity().getJavaClass();
                if (SortedSet.class.isAssignableFrom(type)) {
                    entityAccess.setPropertyNoConversion(propertyName, (Object)new PersistentSortedSet((Collection)identifiers, associatedType, (Session)session));
                } else if (Set.class.isAssignableFrom(type)) {
                    entityAccess.setPropertyNoConversion(propertyName, (Object)new PersistentSet((Collection)identifiers, associatedType, (Session)session));
                } else {
                    entityAccess.setPropertyNoConversion(propertyName, (Object)new PersistentList((Collection)identifiers, associatedType, (Session)session));
                }
            }
        }

        public static Object initializePersistentCollection(Session session, EntityAccess entityAccess, Association property) {
            Class type = property.getType();
            String propertyName = property.getName();
            Serializable identifier = (Serializable)ScriptBytecodeAdapter.castToType((Object)entityAccess.getIdentifier(), Serializable.class);
            if (SortedSet.class.isAssignableFrom(type)) {
                entityAccess.setPropertyNoConversion(propertyName, (Object)new PersistentSortedSet(property, identifier, session));
                return null;
            }
            if (Set.class.isAssignableFrom(type)) {
                entityAccess.setPropertyNoConversion(propertyName, (Object)new PersistentSet(property, identifier, session));
                return null;
            }
            entityAccess.setPropertyNoConversion(propertyName, (Object)new PersistentList(property, identifier, session));
            return null;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != OneToManyDecoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(OneToManyDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(OneToManyDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static class OneToManyEncoder
    implements PropertyEncoder<Association>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public OneToManyEncoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public void encode(BsonWriter writer, Association property, Object value, EntityAccess parentAccess, EncoderContext encoderContext, MongoDatastore datastore) {
            boolean shouldEncodeIds = !property.isBidirectional() || property instanceof ManyToMany;
            if (shouldEncodeIds) {
                PersistentEntity associatedEntity = property.getAssociatedEntity();
                AbstractMongoSession mongoSession = (AbstractMongoSession)((Object)ScriptBytecodeAdapter.castToType((Object)datastore.getCurrentSession(), AbstractMongoSession.class));
                if (value instanceof Collection) {
                    boolean updateCollection = false;
                    if (value instanceof DirtyCheckableCollection) {
                        boolean bl;
                        DirtyCheckableCollection persistentCollection = (DirtyCheckableCollection)ScriptBytecodeAdapter.castToType((Object)value, DirtyCheckableCollection.class);
                        updateCollection = bl = persistentCollection.hasChanged();
                    } else {
                        boolean bl;
                        updateCollection = bl = true;
                    }
                    if (updateCollection) {
                        Collection identifiers = (Collection)ScriptBytecodeAdapter.castToType((Object)mongoSession.getAttribute(parentAccess.getEntity(), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{property}, new String[]{PersistentEntityCodec.BLANK_STRING, ".ids"}))), Collection.class);
                        if (identifiers == null) {
                            Reference fastClassData = new Reference((Object)FieldEntityAccess.getOrIntializeReflector((PersistentEntity)associatedEntity));
                            class _encode_closure1
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference fastClassData;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _encode_closure1(Object _outerInstance, Object _thisObject, Reference fastClassData) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    this.fastClassData = reference = fastClassData;
                                }

                                public Object doCall(Object it) {
                                    return ((EntityReflector)this.fastClassData.get()).getIdentifier(it);
                                }

                                public Object getFastClassData() {
                                    return this.fastClassData.get();
                                }

                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                public Object call() {
                                    return this.doCall(null);
                                }

                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _encode_closure1.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            List list = DefaultGroovyMethods.collect((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)value, Collection.class)), (Closure)new _encode_closure1(this, this, fastClassData));
                            identifiers = list;
                        }
                        writer.writeName(MappingUtils.getTargetKey((PersistentProperty)((PersistentProperty)property)));
                        Codec listCodec = datastore.getCodecRegistry().get(List.class);
                        List identifierList = DefaultGroovyMethods.toList((Iterable)identifiers);
                        MongoAttribute attr = (MongoAttribute)((Object)ScriptBytecodeAdapter.castToType((Object)property.getMapping().getMappedForm(), MongoAttribute.class));
                        MongoAttribute mongoAttribute = attr;
                        Boolean bl = mongoAttribute != null ? Boolean.valueOf(mongoAttribute.isReference()) : null;
                        if (bl == null ? false : bl) {
                            List list;
                            Reference collectionName = new Reference((Object)mongoSession.getCollectionName(property.getAssociatedEntity()));
                            class _encode_closure2
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _encode_closure2(Object _outerInstance, Object _thisObject) {
                                    super(_outerInstance, _thisObject);
                                }

                                public Object doCall(Object it) {
                                    return it != null;
                                }

                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                public Object call() {
                                    return this.doCall(null);
                                }

                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _encode_closure2.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            class _encode_closure3
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference collectionName;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _encode_closure3(Object _outerInstance, Object _thisObject, Reference collectionName) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    this.collectionName = reference = collectionName;
                                }

                                public Object doCall(Object it) {
                                    return new DBRef(ShortTypeHandling.castToString((Object)this.collectionName.get()), it);
                                }

                                public Object getCollectionName() {
                                    return this.collectionName.get();
                                }

                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                public Object call() {
                                    return this.doCall(null);
                                }

                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _encode_closure3.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            identifierList = list = DefaultGroovyMethods.collect((Collection)DefaultGroovyMethods.findAll((List)identifierList, (Closure)new _encode_closure2(this, this)), (Closure)new _encode_closure3(this, this, collectionName));
                        }
                        listCodec.encode(writer, (Object)identifierList, encoderContext);
                    }
                }
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != OneToManyEncoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(OneToManyEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(OneToManyEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static class ToOneEncoder
    implements PropertyEncoder<ToOne>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public ToOneEncoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public void encode(BsonWriter writer, ToOne property, Object value, EntityAccess parentAccess, EncoderContext encoderContext, MongoDatastore datastore) {
            if (DefaultTypeTransformation.booleanUnbox((Object)value)) {
                PersistentEntity associatedEntity = property.getAssociatedEntity();
                Serializable associationId = null;
                if (property.doesCascade(CascadeType.PERSIST) && associatedEntity != null && !property.isForeignKeyInChild()) {
                    ProxyFactory proxyFactory = datastore.getMappingContext().getProxyFactory();
                    CodecRegistry codecRegistry = datastore.getCodecRegistry();
                    if (proxyFactory.isProxy(value)) {
                        Serializable serializable;
                        associationId = serializable = proxyFactory.getIdentifier(value);
                    } else {
                        Serializable serializable;
                        EntityReflector associationAccess = datastore.getMappingContext().getEntityReflector(associatedEntity);
                        associationId = serializable = associationAccess.getIdentifier(value);
                    }
                    if (associationId != null) {
                        writer.writeName(MappingUtils.getTargetKey((PersistentProperty)property));
                        MongoAttribute attr = (MongoAttribute)((Object)ScriptBytecodeAdapter.castToType((Object)property.getMapping().getMappedForm(), MongoAttribute.class));
                        MongoAttribute mongoAttribute = attr;
                        Boolean bl = mongoAttribute != null ? Boolean.valueOf(mongoAttribute.isReference()) : null;
                        if (bl == null ? false : bl) {
                            AbstractMongoSession mongoSession = (AbstractMongoSession)((Object)ScriptBytecodeAdapter.castToType((Object)datastore.getCurrentSession(), AbstractMongoSession.class));
                            Codec identityEncoder = codecRegistry.get(DBRef.class);
                            DBRef ref = new DBRef(mongoSession.getCollectionName(associatedEntity), (Object)associationId);
                            identityEncoder.encode(writer, (Object)ref, encoderContext);
                        } else {
                            Codec identityEncoder = codecRegistry.get(associationId.getClass());
                            identityEncoder.encode(writer, (Object)associationId, encoderContext);
                        }
                    }
                }
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ToOneEncoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ToOneEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ToOneEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static class ToOneDecoder
    implements PropertyDecoder<ToOne>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public ToOneDecoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public void decode(BsonReader bsonReader, ToOne property, EntityAccess entityAccess, DecoderContext decoderContext, MongoDatastore datastore) {
            Session mongoSession = datastore.getCurrentSession();
            MongoAttribute attr = (MongoAttribute)((Object)ScriptBytecodeAdapter.castToType((Object)property.getMapping().getMappedForm(), MongoAttribute.class));
            boolean isLazy = this.isLazyAssociation(attr);
            PersistentEntity associatedEntity = property.getAssociatedEntity();
            if (associatedEntity == null) {
                bsonReader.skipValue();
                return;
            }
            Object associationId = null;
            if (attr.isReference() && ScriptBytecodeAdapter.compareEqual((Object)bsonReader.getCurrentBsonType(), (Object)BsonType.DOCUMENT)) {
                Codec dbRefCodec = datastore.getCodecRegistry().get(Document.class);
                Document dBRef = (Document)ScriptBytecodeAdapter.castToType((Object)dbRefCodec.decode(bsonReader, decoderContext), Document.class);
                Serializable serializable = (Serializable)ScriptBytecodeAdapter.castToType((Object)dBRef.get((Object)DB_REF_ID_FIELD), Serializable.class);
                associationId = serializable;
            } else {
                Class clazz = associatedEntity.getIdentity().getType();
                if (ScriptBytecodeAdapter.isCase((Object)clazz, ObjectId.class)) {
                    ObjectId objectId;
                    associationId = objectId = bsonReader.readObjectId();
                } else if (ScriptBytecodeAdapter.isCase((Object)clazz, Long.class)) {
                    Long l = bsonReader.readInt64();
                    associationId = l;
                } else if (ScriptBytecodeAdapter.isCase((Object)clazz, Integer.class)) {
                    Integer n = bsonReader.readInt32();
                    associationId = n;
                } else {
                    String string = bsonReader.readString();
                    associationId = string;
                }
            }
            if (isLazy) {
                entityAccess.setPropertyNoConversion(property.getName(), mongoSession.proxy(associatedEntity.getJavaClass(), (Serializable)associationId));
            } else {
                entityAccess.setPropertyNoConversion(property.getName(), mongoSession.retrieve(associatedEntity.getJavaClass(), (Serializable)associationId));
            }
        }

        private boolean isLazyAssociation(MongoAttribute attribute) {
            if (attribute == null) {
                return true;
            }
            return ScriptBytecodeAdapter.compareEqual((Object)attribute.getFetchStrategy(), (Object)FetchType.LAZY);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ToOneDecoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ToOneDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ToOneDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static class EmbeddedEncoder
    implements PropertyEncoder<Embedded>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public EmbeddedEncoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public void encode(BsonWriter writer, Embedded property, Object value, EntityAccess parentAccess, EncoderContext encoderContext, MongoDatastore datastore) {
            if (value != null) {
                PersistentEntity associatedEntity = datastore.getMappingContext().getPersistentEntity(value.getClass().getName());
                if (associatedEntity == null) {
                    PersistentEntity persistentEntity;
                    associatedEntity = persistentEntity = property.getAssociatedEntity();
                }
                writer.writeName(MappingUtils.getTargetKey((PersistentProperty)property));
                EntityReflector reflector = datastore.getMappingContext().getEntityReflector(associatedEntity);
                PersistentEntityCodec codec = datastore.getPersistentEntityCodec(associatedEntity);
                Serializable identifier = reflector.getIdentifier(value);
                boolean hasIdentifier = identifier != null;
                codec.encode(writer, value, encoderContext, hasIdentifier);
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != EmbeddedEncoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(EmbeddedEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(EmbeddedEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static class EmbeddedDecoder
    implements PropertyDecoder<Embedded>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public EmbeddedDecoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public void decode(BsonReader reader, Embedded property, EntityAccess entityAccess, DecoderContext decoderContext, MongoDatastore datastore) {
            PersistentEntity associatedEntity = property.getAssociatedEntity();
            PersistentEntityCodec codec = datastore.getPersistentEntityCodec(associatedEntity);
            Object decoded = codec.decode(reader, decoderContext);
            if (decoded instanceof DirtyCheckable) {
                ((DirtyCheckable)decoded).trackChanges();
            }
            entityAccess.setPropertyNoConversion(property.getName(), decoded);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != EmbeddedDecoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(EmbeddedDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(EmbeddedDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static class EmbeddedCollectionEncoder
    implements PropertyEncoder<EmbeddedCollection>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public EmbeddedCollectionEncoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public void encode(BsonWriter writer, EmbeddedCollection property, Object value, EntityAccess parentAccess, EncoderContext encoderContext, MongoDatastore datastore) {
            writer.writeName(MappingUtils.getTargetKey((PersistentProperty)property));
            PersistentEntity associatedEntity = property.getAssociatedEntity();
            PersistentEntityCodec associatedCodec = datastore.getPersistentEntityCodec(associatedEntity);
            boolean isBidirectional = property.isBidirectional();
            Association inverseSide = (Association)ScriptBytecodeAdapter.castToType((Object)(isBidirectional ? property.getInverseSide() : null), Association.class);
            String inverseProperty = ShortTypeHandling.castToString(isBidirectional ? inverseSide.getName() : null);
            boolean isToOne = inverseSide instanceof ToOne;
            DocumentMappingContext mappingContext = datastore.getMappingContext();
            if (Collection.class.isInstance(value)) {
                writer.writeStartArray();
                Object v = null;
                Iterator iterator = DefaultGroovyMethods.iterator((Object)value);
                while (iterator.hasNext()) {
                    v = iterator.next();
                    if (!(v != null)) continue;
                    PersistentEntityCodec codec = associatedCodec;
                    PersistentEntity entity = associatedEntity;
                    Class<?> cls = v.getClass();
                    if (ScriptBytecodeAdapter.compareNotEqual(cls, (Object)associatedEntity.getJavaClass())) {
                        PersistentEntityCodec persistentEntityCodec;
                        PersistentEntity persistentEntity;
                        PersistentEntity childEntity = mappingContext.getPersistentEntity(cls.getName());
                        if (!(childEntity != null)) continue;
                        entity = persistentEntity = childEntity;
                        codec = persistentEntityCodec = datastore.getPersistentEntityCodec(cls);
                    }
                    EntityReflector ea = datastore.getMappingContext().getEntityReflector(entity);
                    Serializable id = ea.getIdentifier(v);
                    if (isBidirectional && isToOne) {
                        ea.setProperty(v, inverseProperty, parentAccess.getEntity());
                    }
                    codec.encode(writer, v, encoderContext, id != null);
                }
                writer.writeEndArray();
            } else if (Map.class.isInstance(value)) {
                writer.writeStartDocument();
                Object e = null;
                Iterator iterator = DefaultGroovyMethods.iterator((Object)value);
                while (iterator.hasNext()) {
                    e = iterator.next();
                    Map.Entry entry = (Map.Entry)ScriptBytecodeAdapter.castToType(e, Map.Entry.class);
                    writer.writeName(ShortTypeHandling.castToString(entry.getKey()));
                    Object v = entry.getValue();
                    EntityReflector ea = datastore.getMappingContext().getEntityReflector(associatedEntity);
                    Serializable id = ea.getIdentifier(v);
                    associatedCodec.encode(writer, v, encoderContext, id != null);
                }
                writer.writeEndDocument();
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != EmbeddedCollectionEncoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(EmbeddedCollectionEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(EmbeddedCollectionEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static class EmbeddedCollectionDecoder
    implements PropertyDecoder<EmbeddedCollection>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public EmbeddedCollectionDecoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public void decode(BsonReader reader, EmbeddedCollection property, EntityAccess entityAccess, DecoderContext decoderContext, MongoDatastore datastore) {
            PersistentEntity associatedEntity = property.getAssociatedEntity();
            PersistentEntityCodec associationCodec = datastore.getPersistentEntityCodec(associatedEntity);
            if (Collection.class.isAssignableFrom(property.getType())) {
                reader.readStartArray();
                BsonType bsonType = reader.readBsonType();
                Collection collection = MappingUtils.createConcreteCollection((Class)property.getType());
                while (ScriptBytecodeAdapter.compareNotEqual((Object)bsonType, (Object)BsonType.END_OF_DOCUMENT)) {
                    BsonType bsonType2;
                    DefaultGroovyMethods.leftShift((Collection)collection, (Object)associationCodec.decode(reader, decoderContext));
                    bsonType = bsonType2 = reader.readBsonType();
                }
                reader.readEndArray();
                entityAccess.setPropertyNoConversion(property.getName(), (Object)DirtyCheckingSupport.wrap((Collection)collection, (DirtyCheckable)((DirtyCheckable)ScriptBytecodeAdapter.castToType((Object)entityAccess.getEntity(), DirtyCheckable.class)), (String)property.getName()));
            } else if (Map.class.isAssignableFrom(property.getType())) {
                reader.readStartDocument();
                BsonType bsonType = reader.readBsonType();
                LinkedHashMap map = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                while (ScriptBytecodeAdapter.compareNotEqual((Object)bsonType, (Object)BsonType.END_OF_DOCUMENT)) {
                    BsonType bsonType3;
                    String key = reader.readName();
                    Object object = associationCodec.decode(reader, decoderContext);
                    DefaultGroovyMethods.putAt((Map)map, (Object)key, (Object)object);
                    bsonType = bsonType3 = reader.readBsonType();
                }
                reader.readEndDocument();
                entityAccess.setPropertyNoConversion(property.getName(), (Object)new DirtyCheckingMap((Map)map, (DirtyCheckable)ScriptBytecodeAdapter.castToType((Object)entityAccess.getEntity(), DirtyCheckable.class), property.getName()));
            } else {
                reader.skipValue();
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != EmbeddedCollectionDecoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(EmbeddedCollectionDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(EmbeddedCollectionDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static class BasicCollectionTypeDecoder
    implements PropertyDecoder<Basic>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public BasicCollectionTypeDecoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public void decode(BsonReader reader, Basic property, EntityAccess entityAccess, DecoderContext decoderContext, MongoDatastore datastore) {
            CustomTypeMarshaller marshaller = property.getCustomTypeMarshaller();
            if (DefaultTypeTransformation.booleanUnbox((Object)marshaller)) {
                CustomTypeDecoder.decode(datastore, reader, decoderContext, marshaller, (PersistentProperty)property, entityAccess);
            } else {
                Reference conversionService = new Reference((Object)datastore.getMappingContext().getConversionService());
                Reference componentType = new Reference((Object)property.getComponentType());
                Codec codec = datastore.getCodecRegistry().get(property.getType());
                Object value = codec.decode(reader, decoderContext);
                Object entity = entityAccess.getEntity();
                if (value instanceof Collection) {
                    class _decode_closure1
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference conversionService;
                        private /* synthetic */ Reference componentType;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _decode_closure1(Object _outerInstance, Object _thisObject, Reference conversionService, Reference componentType) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            this.conversionService = reference2 = conversionService;
                            this.componentType = reference = componentType;
                        }

                        public Object doCall(Object it) {
                            return ((ConversionService)this.conversionService.get()).convert(it, ShortTypeHandling.castToClass((Object)this.componentType.get()));
                        }

                        public Object getConversionService() {
                            return this.conversionService.get();
                        }

                        public Object getComponentType() {
                            return this.componentType.get();
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        public Object call() {
                            return this.doCall(null);
                        }

                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _decode_closure1.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    Collection converted = DefaultGroovyMethods.collect((Object)value, (Closure)new _decode_closure1(this, this, conversionService, componentType));
                    if (entity instanceof DirtyCheckable) {
                        Collection collection = DirtyCheckingSupport.wrap((Collection)converted, (DirtyCheckable)((DirtyCheckable)ScriptBytecodeAdapter.castToType((Object)entity, DirtyCheckable.class)), (String)property.getName());
                        converted = collection;
                    }
                    entityAccess.setProperty(property.getName(), (Object)converted);
                } else if (value instanceof Map) {
                    class _decode_closure2
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference conversionService;
                        private /* synthetic */ Reference componentType;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _decode_closure2(Object _outerInstance, Object _thisObject, Reference conversionService, Reference componentType) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            this.conversionService = reference2 = conversionService;
                            this.componentType = reference = componentType;
                        }

                        public Object doCall(Map.Entry entry) {
                            Object v = entry.getValue();
                            Object object = ((ConversionService)this.conversionService.get()).convert(v, ShortTypeHandling.castToClass((Object)this.componentType.get()));
                            entry.setValue(object);
                            return entry;
                        }

                        public Object call(Map.Entry entry) {
                            return this.doCall(entry);
                        }

                        public Object getConversionService() {
                            return this.conversionService.get();
                        }

                        public Object getComponentType() {
                            return this.componentType.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _decode_closure2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    Map converted = DefaultGroovyMethods.collectEntries((Map)((Map)ScriptBytecodeAdapter.castToType((Object)value, Map.class)), (Closure)new _decode_closure2(this, this, conversionService, componentType));
                    if (entity instanceof DirtyCheckable) {
                        DirtyCheckingMap dirtyCheckingMap = new DirtyCheckingMap(converted, (DirtyCheckable)ScriptBytecodeAdapter.castToType((Object)entity, DirtyCheckable.class), property.getName());
                        converted = dirtyCheckingMap;
                    }
                    entityAccess.setProperty(property.getName(), (Object)converted);
                }
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != BasicCollectionTypeDecoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(BasicCollectionTypeDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(BasicCollectionTypeDecoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public static class BasicCollectionTypeEncoder
    implements PropertyEncoder<Basic>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public BasicCollectionTypeEncoder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public void encode(BsonWriter writer, Basic property, Object value, EntityAccess parentAccess, EncoderContext encoderContext, MongoDatastore datastore) {
            CustomTypeMarshaller marshaller = property.getCustomTypeMarshaller();
            if (DefaultTypeTransformation.booleanUnbox((Object)marshaller)) {
                CustomTypeEncoder.encode(datastore, encoderContext, writer, (PersistentProperty)property, marshaller, value);
            } else {
                writer.writeName(MappingUtils.getTargetKey((PersistentProperty)property));
                Codec codec = datastore.getCodecRegistry().get(property.getType());
                codec.encode(writer, value, encoderContext);
                Object parent = parentAccess.getEntity();
                if (parent instanceof DirtyCheckable) {
                    if (value instanceof Collection) {
                        String propertyName = property.getName();
                        parentAccess.setPropertyNoConversion(propertyName, (Object)DirtyCheckingSupport.wrap((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)value, Collection.class)), (DirtyCheckable)((DirtyCheckable)ScriptBytecodeAdapter.castToType((Object)parent, DirtyCheckable.class)), (String)propertyName));
                    } else if (value instanceof Map && !(value instanceof Bson)) {
                        String propertyName = property.getName();
                        parentAccess.setPropertyNoConversion(propertyName, (Object)new DirtyCheckingMap((Map)ScriptBytecodeAdapter.castToType((Object)value, Map.class), (DirtyCheckable)ScriptBytecodeAdapter.castToType((Object)parent, DirtyCheckable.class), propertyName));
                    }
                }
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != BasicCollectionTypeEncoder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(BasicCollectionTypeEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(BasicCollectionTypeEncoder.class, PersistentEntityCodec.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{PersistentEntityCodec.BLANK_STRING, PersistentEntityCodec.BLANK_STRING})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

