/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.config;

import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.grails.datastore.mapping.document.config.Collection;
import org.grails.datastore.mapping.query.Query;

public class MongoCollection
extends Collection {
    private String database;
    private WriteConcern writeConcern;
    private List<Map> compoundIndices = new ArrayList<Map>();
    private Query.Order sort;
    private List<Index> indices = new ArrayList<Index>();

    public void index(Map<String, Object> definition) {
        this.index(definition, Collections.emptyMap());
    }

    public void index(Map<String, Object> definition, Map<String, Object> options) {
        if (definition != null && !definition.isEmpty()) {
            this.indices.add(new Index(definition, options));
        }
    }

    public List<Index> getIndices() {
        return this.indices;
    }

    public Query.Order getSort() {
        return this.sort;
    }

    public void setSort(Object s) {
        if (s instanceof Query.Order) {
            this.sort = (Query.Order)s;
        }
        if (s instanceof Map) {
            Map m = (Map)s;
            if (!m.isEmpty()) {
                Map.Entry entry = m.entrySet().iterator().next();
                Object key = entry.getKey();
                this.sort = "desc".equalsIgnoreCase(entry.getValue().toString()) ? Query.Order.desc((String)key.toString()) : Query.Order.asc((String)key.toString());
            }
        } else {
            this.sort = Query.Order.asc((String)s.toString());
        }
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setCompoundIndex(Map compoundIndex) {
        if (compoundIndex != null) {
            this.compoundIndices.add(compoundIndex);
        }
    }

    public List<Map> getCompoundIndices() {
        return this.compoundIndices;
    }

    public static class Index {
        Map<String, Object> definition = new HashMap<String, Object>();
        Map<String, Object> options = new HashMap<String, Object>();

        public Index(Map<String, Object> definition) {
            this.definition = definition;
        }

        public Index(Map<String, Object> definition, Map<String, Object> options) {
            this.definition = definition;
            this.options = options;
        }

        public Map<String, Object> getDefinition() {
            return this.definition;
        }

        public Map<String, Object> getOptions() {
            return this.options;
        }
    }
}

