/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.grails.datastore.mapping.config.Entity;
import org.grails.datastore.mapping.core.AbstractSession;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.impl.PendingInsert;
import org.grails.datastore.mapping.core.impl.PendingOperation;
import org.grails.datastore.mapping.document.config.DocumentMappingContext;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.mongo.MongoDatastore;
import org.grails.datastore.mapping.mongo.config.MongoCollection;
import org.grails.datastore.mapping.mongo.engine.MongoEntityPersister;
import org.grails.datastore.mapping.mongo.query.MongoQuery;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.transactions.SessionOnlyTransaction;
import org.grails.datastore.mapping.transactions.Transaction;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongoSession
extends AbstractSession<DB> {
    private static final Map<PersistentEntity, WriteConcern> declaredWriteConcerns = new ConcurrentHashMap<PersistentEntity, WriteConcern>();
    MongoDatastore mongoDatastore;
    private WriteConcern writeConcern = null;
    private boolean errorOccured = false;
    protected Map<PersistentEntity, MongoTemplate> mongoTemplates = new ConcurrentHashMap<PersistentEntity, MongoTemplate>();
    protected Map<PersistentEntity, String> mongoCollections = new ConcurrentHashMap<PersistentEntity, String>();

    public MongoSession(MongoDatastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher) {
        this(datastore, mappingContext, publisher, false);
    }

    public MongoSession(MongoDatastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher, boolean stateless) {
        super((Datastore)datastore, mappingContext, publisher, stateless);
        this.mongoDatastore = datastore;
    }

    public MongoQuery createQuery(Class type) {
        return (MongoQuery)super.createQuery(type);
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(WriteConcern writeConcern) {
        WriteConcern current = this.writeConcern;
        this.writeConcern = writeConcern;
        try {
            if (!this.errorOccured) {
                super.flush();
            }
        }
        finally {
            this.writeConcern = current;
        }
    }

    public void flush() {
        if (!this.errorOccured) {
            super.flush();
        }
    }

    public void disconnect() {
        super.disconnect();
    }

    protected void flushPendingInserts(final Map<PersistentEntity, Collection<PendingInsert>> inserts) {
        for (final PersistentEntity entity : inserts.keySet()) {
            MongoTemplate template = this.getMongoTemplate(entity.isRoot() ? entity : entity.getRootEntity());
            final String collectionNameToUse = this.getCollectionName(entity.isRoot() ? entity : entity.getRootEntity());
            template.execute((DbCallback)new DbCallback<Object>(){

                public Object doInDB(DB db) throws MongoException, DataAccessException {
                    WriteResult writeResult;
                    WriteConcern writeConcernToUse = MongoSession.this.getDeclaredWriteConcern(entity);
                    DBCollection collection = db.getCollection(collectionNameToUse);
                    Collection pendingInserts = (Collection)inserts.get(entity);
                    LinkedList<DBObject> dbObjects = new LinkedList<DBObject>();
                    LinkedList postOperations = new LinkedList();
                    for (PendingInsert pendingInsert : pendingInserts) {
                        List preOperations = pendingInsert.getPreOperations();
                        for (PendingOperation preOperation : preOperations) {
                            preOperation.run();
                        }
                        pendingInsert.run();
                        if (pendingInsert.isVetoed()) continue;
                        dbObjects.add((DBObject)pendingInsert.getNativeEntry());
                        postOperations.addAll(pendingInsert.getCascadeOperations());
                    }
                    WriteResult writeResult2 = writeResult = writeConcernToUse != null ? collection.insert(dbObjects.toArray(new DBObject[dbObjects.size()]), writeConcernToUse) : collection.insert(dbObjects.toArray(new DBObject[dbObjects.size()]));
                    if (writeResult.getError() != null) {
                        MongoSession.this.errorOccured = true;
                        throw new DataIntegrityViolationException(writeResult.getError());
                    }
                    for (PendingOperation pendingOperation : postOperations) {
                        pendingOperation.run();
                    }
                    return null;
                }
            });
        }
    }

    public WriteConcern getDeclaredWriteConcern(PersistentEntity entity) {
        return this.getDeclaredWriteConcern(this.writeConcern, entity);
    }

    private WriteConcern getDeclaredWriteConcern(WriteConcern defaultConcern, PersistentEntity entity) {
        WriteConcern writeConcern = declaredWriteConcerns.get(entity);
        if (writeConcern == null) {
            MongoCollection mc;
            Entity mappedForm = entity.getMapping().getMappedForm();
            if (mappedForm instanceof MongoCollection && (writeConcern = (mc = (MongoCollection)mappedForm).getWriteConcern()) == null) {
                writeConcern = defaultConcern;
            }
            if (writeConcern != null) {
                declaredWriteConcerns.put(entity, writeConcern);
            }
        }
        return writeConcern;
    }

    public DB getNativeInterface() {
        return ((MongoDatastore)this.getDatastore()).getMongo().getDB(this.getDocumentMappingContext().getDefaultDatabaseName());
    }

    public DocumentMappingContext getDocumentMappingContext() {
        return (DocumentMappingContext)this.getMappingContext();
    }

    protected Persister createPersister(Class cls, MappingContext mappingContext) {
        PersistentEntity entity = mappingContext.getPersistentEntity(cls.getName());
        return entity == null ? null : new MongoEntityPersister(mappingContext, entity, this, this.publisher);
    }

    protected Transaction<DB> beginTransactionInternal() {
        return new SessionOnlyTransaction((Object)this.getNativeInterface(), (Session)this);
    }

    public MongoTemplate getMongoTemplate(PersistentEntity entity) {
        MongoTemplate mongoTemplate = this.mongoTemplates.get(entity);
        return mongoTemplate != null ? mongoTemplate : this.mongoDatastore.getMongoTemplate(entity);
    }

    public String getCollectionName(PersistentEntity entity) {
        return this.mongoCollections.containsKey(entity) ? this.mongoCollections.get(entity) : this.mongoDatastore.getCollectionName(entity);
    }

    public String useCollection(PersistentEntity entity, String collectionName) {
        String current = this.mongoCollections.containsKey(entity) ? this.mongoCollections.get(entity) : this.mongoDatastore.getCollectionName(entity);
        this.mongoCollections.put(entity, collectionName);
        return current;
    }

    public String useDatabase(PersistentEntity entity, String databaseName) {
        MongoTemplate currentTemplate = this.mongoTemplates.containsKey(entity) ? this.mongoTemplates.get(entity) : this.mongoDatastore.getMongoTemplate(entity);
        String currentDatabase = currentTemplate.getDb().getName();
        this.mongoTemplates.put(entity, new MongoTemplate(this.mongoDatastore.getMongo(), databaseName, this.mongoDatastore.getUserCrentials()));
        return currentDatabase;
    }

    public int deleteAll(QueryableCriteria criteria) {
        final PersistentEntity entity = criteria.getPersistentEntity();
        final DBObject nativeQuery = this.buildNativeQueryFromCriteria(criteria, entity);
        this.pendingDeletes.add(new Runnable(){

            @Override
            public void run() {
                String collectionName = MongoSession.this.getCollectionName(entity);
                WriteConcern writeConcern = MongoSession.this.getDeclaredWriteConcern(entity);
                if (writeConcern != null) {
                    MongoSession.this.getNativeInterface().getCollection(collectionName).remove(nativeQuery, writeConcern);
                } else {
                    MongoSession.this.getNativeInterface().getCollection(collectionName).remove(nativeQuery);
                }
            }
        });
        return -1;
    }

    public void delete(Iterable objects) {
        HashMap toDelete = new HashMap();
        for (Object object : objects) {
            Serializable id;
            PersistentEntity p;
            if (object == null || (p = this.getMappingContext().getPersistentEntity(object.getClass().getName())) == null) continue;
            ArrayList<Serializable> listForPersister = (ArrayList<Serializable>)toDelete.get(p);
            if (listForPersister == null) {
                listForPersister = new ArrayList<Serializable>();
                toDelete.put(p, listForPersister);
            }
            if ((id = this.getObjectIdentifier(object)) == null) continue;
            listForPersister.add(id);
        }
        Set persistentEntities = toDelete.keySet();
        for (final PersistentEntity persistentEntity : persistentEntities) {
            final List identifiers = (List)toDelete.get(persistentEntity);
            if (identifiers == null || identifiers.isEmpty()) continue;
            this.pendingDeletes.add(new Runnable(){

                @Override
                public void run() {
                    String collectionName = MongoSession.this.getCollectionName(persistentEntity);
                    BasicDBObject nativeQuery = new BasicDBObject();
                    nativeQuery.put("_id", (Object)new BasicDBObject("$in", (Object)identifiers));
                    WriteConcern writeConcern = MongoSession.this.getDeclaredWriteConcern(persistentEntity);
                    if (writeConcern != null) {
                        MongoSession.this.getNativeInterface().getCollection(collectionName).remove((DBObject)nativeQuery, writeConcern);
                    } else {
                        MongoSession.this.getNativeInterface().getCollection(collectionName).remove((DBObject)nativeQuery);
                    }
                }
            });
        }
    }

    public int updateAll(QueryableCriteria criteria, final Map<String, Object> properties) {
        final PersistentEntity entity = criteria.getPersistentEntity();
        final DBObject nativeQuery = this.buildNativeQueryFromCriteria(criteria, entity);
        this.postFlushOperations.add(new Runnable(){

            @Override
            public void run() {
                String collectionName = MongoSession.this.getCollectionName(entity);
                WriteConcern writeConcern = MongoSession.this.getDeclaredWriteConcern(entity);
                if (writeConcern != null) {
                    MongoSession.this.getNativeInterface().getCollection(collectionName).update(nativeQuery, (DBObject)new BasicDBObject("$set", (Object)properties), false, true, writeConcern);
                } else {
                    MongoSession.this.getNativeInterface().getCollection(collectionName).update(nativeQuery, (DBObject)new BasicDBObject("$set", (Object)properties), false, true);
                }
            }
        });
        return -1;
    }

    protected void cacheEntry(Serializable key, Object entry, Map<Serializable, Object> entryCache, boolean forDirtyCheck) {
        if (forDirtyCheck) {
            entryCache.put(key, new BasicDBObject(((DBObject)entry).toMap()));
        } else {
            entryCache.put(key, entry);
        }
    }

    private DBObject buildNativeQueryFromCriteria(QueryableCriteria criteria, PersistentEntity entity) {
        MongoQuery mongoQuery = new MongoQuery(this, entity);
        List criteriaList = criteria.getCriteria();
        for (Query.Criterion c : criteriaList) {
            mongoQuery.add(c);
        }
        return mongoQuery.getMongoQuery();
    }
}

