/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.mongo.bean.factory;

import com.gmongo.GMongo;
import com.gmongo.GMongoClient;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.datastore.mapping.model.DatastoreConfigurationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class GMongoFactoryBean
implements FactoryBean<GMongoClient>,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private MongoClient mongo;
    private MongoClientOptions mongoOptions;
    private String host;
    private Integer port;
    private String username;
    private String password;
    private String database;
    private List<ServerAddress> replicaSetSeeds;
    private List<ServerAddress> replicaPair;
    private String connectionString;
    private MongoClientURI clientURI;

    public void setReplicaPair(List<ServerAddress> replicaPair) {
        this.replicaPair = replicaPair;
    }

    public void setReplicaSetSeeds(List<ServerAddress> replicaSetSeeds) {
        this.replicaSetSeeds = replicaSetSeeds;
    }

    public void setMongoOptions(MongoClientOptions mongoOptions) {
        this.mongoOptions = mongoOptions;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String databaseName) {
        this.database = databaseName;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public void setClientURI(MongoClientURI clientURI) {
        this.clientURI = clientURI;
    }

    public GMongoClient getObject() throws Exception {
        Assert.notNull((Object)this.mongo, (String)"Mongo must not be null");
        GMongoClient mongoClient = new GMongoClient();
        mongoClient.setMongoClient(this.mongo);
        return mongoClient;
    }

    public Class<? extends GMongo> getObjectType() {
        return GMongo.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() throws UnknownHostException {
        if (this.mongo != null) {
            return;
        }
        ServerAddress defaultOptions = new ServerAddress();
        ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
        if (this.mongoOptions == null) {
            MongoClientOptions.Builder builder = MongoClientOptions.builder();
            this.mongoOptions = builder.build();
        }
        if (this.username != null && this.password != null) {
            credentials.add(MongoCredential.createCredential((String)this.username, (String)this.database, (char[])this.password.toCharArray()));
        }
        if (this.replicaPair != null) {
            if (this.replicaPair.size() < 2) {
                throw new DatastoreConfigurationException("A replica pair must have two server entries");
            }
            this.mongo = new MongoClient(this.replicaPair, credentials, this.mongoOptions);
        } else if (this.replicaSetSeeds != null) {
            this.mongo = new MongoClient(this.replicaSetSeeds, credentials, this.mongoOptions);
        } else if (this.clientURI != null) {
            this.mongo = new MongoClient(this.clientURI);
        } else if (this.connectionString != null) {
            this.mongo = new MongoClient(new MongoClientURI(this.connectionString));
        } else {
            String mongoHost = this.host != null ? this.host : defaultOptions.getHost();
            this.mongo = this.port != null ? new MongoClient(new ServerAddress(mongoHost, this.port.intValue()), credentials, this.mongoOptions) : new MongoClient(new ServerAddress(this.host), credentials, this.mongoOptions);
        }
    }

    public void destroy() {
        if (this.mongo == null) {
            return;
        }
        this.mongo.close();
        this.mongo = null;
    }
}

