/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.query;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import grails.mongodb.geo.Box;
import grails.mongodb.geo.Circle;
import grails.mongodb.geo.Distance;
import grails.mongodb.geo.GeoJSON;
import grails.mongodb.geo.Point;
import grails.mongodb.geo.Polygon;
import grails.mongodb.geo.Shape;
import grails.mongodb.geo.Sphere;
import groovy.lang.Closure;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.BasicBSONObject;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.datastore.gorm.mongo.geo.GeoJSONType;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.SessionImplementor;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.internal.MappingUtils;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.EmbeddedPersistentEntity;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Custom;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.EmbeddedCollection;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.mongo.MongoSession;
import org.grails.datastore.mapping.mongo.config.MongoAttribute;
import org.grails.datastore.mapping.mongo.config.MongoCollection;
import org.grails.datastore.mapping.mongo.engine.MongoEntityPersister;
import org.grails.datastore.mapping.query.AssociationQuery;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.Restrictions;
import org.grails.datastore.mapping.query.api.QueryArgumentsAware;
import org.grails.datastore.mapping.query.projections.ManualProjections;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.StringUtils;

public class MongoQuery
extends Query
implements QueryArgumentsAware {
    public static final String PROJECT_OPERATOR = "$project";
    public static final String SORT_OPERATOR = "$sort";
    private static Map<Class, QueryHandler> queryHandlers = new HashMap<Class, QueryHandler>();
    private static Map<Class, QueryHandler> negatedHandlers = new HashMap<Class, QueryHandler>();
    private static Map<Class, ProjectionHandler> groupByProjectionHandlers = new HashMap<Class, ProjectionHandler>();
    private static Map<Class, ProjectionHandler> projectProjectionHandlers = new HashMap<Class, ProjectionHandler>();
    public static final String MONGO_IN_OPERATOR = "$in";
    public static final String MONGO_OR_OPERATOR = "$or";
    public static final String MONGO_AND_OPERATOR = "$and";
    public static final String MONGO_GTE_OPERATOR = "$gte";
    public static final String MONGO_LTE_OPERATOR = "$lte";
    public static final String MONGO_GT_OPERATOR = "$gt";
    public static final String MONGO_LT_OPERATOR = "$lt";
    public static final String MONGO_NE_OPERATOR = "$ne";
    public static final String MONGO_NIN_OPERATOR = "$nin";
    public static final String MONGO_ID_REFERENCE_SUFFIX = ".$id";
    public static final String MONGO_WHERE_OPERATOR = "$where";
    private static final String MONGO_THIS_PREFIX = "this.";
    public static final String HINT_ARGUMENT = "hint";
    private Map queryArguments = Collections.emptyMap();
    public static final String NEAR_OPERATOR = "$near";
    public static final String BOX_OPERATOR = "$box";
    public static final String POLYGON_OPERATOR = "$polygon";
    public static final String WITHIN_OPERATOR = "$within";
    public static final String CENTER_OPERATOR = "$center";
    public static final String GEO_WITHIN_OPERATOR = "$geoWithin";
    public static final String GEOMETRY_OPERATOR = "$geometry";
    public static final String CENTER_SPHERE_OPERATOR = "$centerSphere";
    public static final String GEO_INTERSECTS_OPERATOR = "$geoIntersects";
    public static final String MAX_DISTANCE_OPERATOR = "$maxDistance";
    public static final String NEAR_SPHERE_OPERATOR = "$nearSphere";
    public static final String MONGO_REGEX_OPERATOR = "$regex";
    public static final String MATCH_OPERATOR = "$match";
    public static final String AVERAGE_OPERATOR = "$avg";
    public static final String GROUP_OPERATOR = "$group";
    public static final String SUM_OPERATOR = "$sum";
    public static final String MIN_OPERATOR = "$min";
    public static final String MAX_OPERATOR = "$max";
    public static final String SIZE_OPERATOR = "$size";
    public static final String NOT_OPERATOR = "$not";
    public static final String EXISTS_OPERATOR = "$exists";
    private MongoSession mongoSession;
    private MongoEntityPersister mongoEntityPersister;
    private ManualProjections manualProjections;

    private static Integer getNumber(Query.PropertyCriterion criterion) {
        Object value = criterion.getValue();
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new IllegalArgumentException("Argument to size constraint must be a number");
    }

    private static DBObject getIdObjectForGroupBy(DBObject groupBy) {
        DBObject id;
        Object value = groupBy.get("_id");
        if (value instanceof DBObject) {
            id = (DBObject)value;
        } else {
            id = new BasicDBObject();
            groupBy.put("_id", (Object)id);
        }
        return id;
    }

    private static String addProjectionToGroupBy(DBObject projectObject, DBObject groupBy, Query.PropertyProjection projection, String operator, String prefix) {
        projectObject.put(projection.getPropertyName(), (Object)1);
        String property = projection.getPropertyName();
        String projectionValueKey = prefix + property;
        BasicDBObject averageProjection = new BasicDBObject(operator, (Object)("$" + property));
        groupBy.put(projectionValueKey, (Object)averageProjection);
        return projectionValueKey;
    }

    private static DBObject getOrCreatePropertyQuery(DBObject query, String propertyName) {
        DBObject queryObject;
        Object existing = query.get(propertyName);
        DBObject dBObject = queryObject = existing instanceof DBObject ? (DBObject)existing : null;
        if (queryObject == null) {
            queryObject = new BasicDBObject();
        }
        return queryObject;
    }

    private static void addWherePropertyComparison(DBObject query, String propertyName, String otherPropertyName, String operator) {
        query.put(MONGO_WHERE_OPERATOR, (Object)(MONGO_THIS_PREFIX + propertyName + operator + MONGO_THIS_PREFIX + otherPropertyName));
    }

    private static List<Object> getInListQueryValues(PersistentEntity entity, Query.In in) {
        ArrayList<Object> values = new ArrayList<Object>(in.getValues().size());
        for (Object value : in.getValues()) {
            if (entity.getMappingContext().isPersistentEntity(value)) {
                PersistentEntity pe = entity.getMappingContext().getPersistentEntity(value.getClass().getName());
                values.add(new EntityAccess(pe, value).getIdentifier());
                continue;
            }
            value = MongoEntityPersister.getSimpleNativePropertyValue(value, entity.getMappingContext());
            values.add(value);
        }
        return values;
    }

    private static void handleLike(PersistentEntity entity, Query.Like like, DBObject query, boolean caseSensitive) {
        Object value = like.getValue();
        if (value == null) {
            value = "null";
        }
        Object[] array = value.toString().split("%", -1);
        for (int i = 0; i < array.length; ++i) {
            array[i] = Pattern.quote((String)array[i]);
        }
        String expr = StringUtils.arrayToDelimitedString((Object[])array, (String)".*");
        if (!expr.startsWith(".*")) {
            expr = '^' + expr;
        }
        if (!expr.endsWith(".*")) {
            expr = expr + '$';
        }
        Pattern regex = caseSensitive ? Pattern.compile(expr) : Pattern.compile(expr, 2);
        String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)like);
        query.put(propertyName, (Object)regex);
    }

    public MongoQuery(MongoSession session, PersistentEntity entity) {
        super((Session)session, entity);
        this.mongoSession = session;
        this.manualProjections = new ManualProjections(entity);
        this.mongoEntityPersister = (MongoEntityPersister)session.getPersister(entity);
    }

    protected void flushBeforeQuery() {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            super.flushBeforeQuery();
        }
    }

    public DBObject getMongoQuery() {
        DBObject query = this.createQueryObject(this.entity);
        MongoQuery.populateMongoQuery((MongoSession)this.getSession(), query, this.criteria, this.entity);
        return query;
    }

    protected List executeQuery(final PersistentEntity entity, final Query.Junction criteria) {
        MongoTemplate template = this.mongoSession.getMongoTemplate(entity);
        return (List)template.execute((DbCallback)new DbCallback<List>(){

            public List doInDB(DB db) throws MongoException, DataAccessException {
                PersistentProperty property;
                List orderBy;
                DBCollection collection = db.getCollection(MongoQuery.this.mongoEntityPersister.getCollectionName(entity));
                if (MongoQuery.this.uniqueResult) {
                    DBObject dbObject = criteria.isEmpty() ? (entity.isRoot() ? collection.findOne() : collection.findOne((DBObject)new BasicDBObject("_class", (Object)entity.getDiscriminator()))) : collection.findOne(MongoQuery.this.getMongoQuery());
                    return MongoQuery.this.wrapObjectResultInList(MongoQuery.this.createObjectFromDBObject(dbObject));
                }
                DBObject query = MongoQuery.this.createQueryObject(entity);
                List projectionList = MongoQuery.this.projections().getProjectionList();
                if (projectionList.isEmpty()) {
                    DBCursor cursor = this.executeQuery(entity, criteria, collection, query);
                    return (List)new MongoResultList((Cursor)cursor, MongoQuery.this.offset, MongoQuery.this.mongoEntityPersister).clone();
                }
                MongoQuery.populateMongoQuery((MongoSession)MongoQuery.this.session, query, criteria, entity);
                ArrayList<Object> projectedResults = new ArrayList<Object>();
                ArrayList<BasicDBObject> aggregationPipeline = new ArrayList<BasicDBObject>();
                if (!query.keySet().isEmpty()) {
                    aggregationPipeline.add(new BasicDBObject(MongoQuery.MATCH_OPERATOR, (Object)query));
                }
                if (!(orderBy = MongoQuery.this.getOrderBy()).isEmpty()) {
                    BasicDBObject sortBy = new BasicDBObject();
                    BasicDBObject sort = new BasicDBObject(MongoQuery.SORT_OPERATOR, (Object)sortBy);
                    for (Query.Order order : orderBy) {
                        sortBy.put(order.getProperty(), (Object)(order.getDirection() == Query.Order.Direction.ASC ? 1 : -1));
                    }
                    aggregationPipeline.add(sort);
                }
                if (MongoQuery.this.max > 0) {
                    aggregationPipeline.add(new BasicDBObject("$limit", (Object)MongoQuery.this.max));
                }
                if (MongoQuery.this.offset > 0) {
                    aggregationPipeline.add(new BasicDBObject("$skip", (Object)MongoQuery.this.offset));
                }
                ArrayList<ProjectedProperty> projectedKeys = new ArrayList<ProjectedProperty>();
                boolean singleResult = true;
                BasicDBObject projectObject = new BasicDBObject();
                BasicDBObject groupByObject = new BasicDBObject();
                groupByObject.put("_id", (Object)0);
                BasicDBObject additionalGroupBy = null;
                for (Query.Projection projection : projectionList) {
                    ProjectionHandler projectionHandler = (ProjectionHandler)projectProjectionHandlers.get(projection.getClass());
                    ProjectedProperty projectedProperty = new ProjectedProperty();
                    projectedProperty.projection = projection;
                    if (projection instanceof Query.PropertyProjection) {
                        Query.PropertyProjection propertyProjection = (Query.PropertyProjection)projection;
                        property = entity.getPropertyByName(propertyProjection.getPropertyName());
                        if (property != null) {
                            projectedProperty.property = property;
                        } else {
                            throw new InvalidDataAccessResourceUsageException("Attempt to project on a non-existent project [" + propertyProjection.getPropertyName() + "]");
                        }
                    }
                    if (projectionHandler != null) {
                        singleResult = false;
                        String aggregationKey = projectionHandler.handle(entity, (DBObject)projectObject, (DBObject)groupByObject, projection);
                        projectedProperty.projectionKey = aggregationKey = "id." + aggregationKey;
                        projectedKeys.add(projectedProperty);
                        continue;
                    }
                    projectionHandler = (ProjectionHandler)groupByProjectionHandlers.get(projection.getClass());
                    if (projectionHandler == null) continue;
                    projectedProperty.projectionKey = projectionHandler.handle(entity, (DBObject)projectObject, (DBObject)groupByObject, projection);
                    projectedKeys.add(projectedProperty);
                    if (!(projection instanceof Query.CountDistinctProjection)) continue;
                    BasicDBObject finalCount = new BasicDBObject("_id", (Object)1);
                    finalCount.put(projectedProperty.projectionKey, (Object)new BasicDBObject(MongoQuery.SUM_OPERATOR, (Object)1));
                    additionalGroupBy = new BasicDBObject(MongoQuery.GROUP_OPERATOR, (Object)finalCount);
                }
                if (!projectObject.isEmpty()) {
                    aggregationPipeline.add(new BasicDBObject(MongoQuery.PROJECT_OPERATOR, (Object)projectObject));
                }
                aggregationPipeline.add(new BasicDBObject(MongoQuery.GROUP_OPERATOR, (Object)groupByObject));
                if (additionalGroupBy != null) {
                    aggregationPipeline.add(additionalGroupBy);
                }
                Cursor aggregatedResults = collection.aggregate(aggregationPipeline, AggregationOptions.builder().build());
                if (singleResult && aggregatedResults.hasNext()) {
                    DBObject dbo = (DBObject)aggregatedResults.next();
                    for (ProjectedProperty projectedProperty : projectedKeys) {
                        Object value = dbo.get(projectedProperty.projectionKey);
                        property = projectedProperty.property;
                        if (value != null) {
                            if (property instanceof ToOne) {
                                projectedResults.add(MongoQuery.this.session.retrieve(property.getType(), (Serializable)value));
                                continue;
                            }
                            projectedResults.add(value);
                            continue;
                        }
                        if (!(projectedProperty.projection instanceof Query.CountProjection)) continue;
                        projectedResults.add(0);
                    }
                } else {
                    return new AggregatedResultList(MongoQuery.this.session, aggregatedResults, projectedKeys);
                }
                return projectedResults;
            }

            protected DBCursor executeQuery(PersistentEntity entity2, Query.Junction criteria2, DBCollection collection, DBObject query) {
                DBCursor cursor;
                if (criteria2.isEmpty()) {
                    cursor = this.executeQueryAndApplyPagination(collection, query);
                } else {
                    MongoQuery.populateMongoQuery((MongoSession)MongoQuery.this.session, query, criteria2, entity2);
                    cursor = this.executeQueryAndApplyPagination(collection, query);
                }
                if (MongoQuery.this.queryArguments != null && MongoQuery.this.queryArguments.containsKey(MongoQuery.HINT_ARGUMENT)) {
                    Object hint = MongoQuery.this.queryArguments.get(MongoQuery.HINT_ARGUMENT);
                    if (hint instanceof Map) {
                        cursor.hint((DBObject)new BasicDBObject((Map)hint));
                    } else if (hint != null) {
                        cursor.hint(hint.toString());
                    }
                }
                return cursor;
            }

            protected DBCursor executeQueryAndApplyPagination(DBCollection collection, DBObject query) {
                DBCursor cursor = collection.find(query);
                if (MongoQuery.this.offset > 0) {
                    cursor.skip(MongoQuery.this.offset);
                }
                if (MongoQuery.this.max > -1) {
                    cursor.limit(MongoQuery.this.max);
                }
                if (!MongoQuery.this.orderBy.isEmpty()) {
                    BasicDBObject orderObject = new BasicDBObject();
                    for (Query.Order order : MongoQuery.this.orderBy) {
                        String property = order.getProperty();
                        property = MongoQuery.getPropertyName(entity, property);
                        orderObject.put(property, (Object)(order.getDirection() == Query.Order.Direction.DESC ? -1 : 1));
                    }
                    cursor.sort((DBObject)orderObject);
                } else {
                    MongoCollection coll = (MongoCollection)entity.getMapping().getMappedForm();
                    if (coll != null && coll.getSort() != null) {
                        BasicDBObject orderObject = new BasicDBObject();
                        Query.Order order = coll.getSort();
                        String property = order.getProperty();
                        property = MongoQuery.getPropertyName(entity, property);
                        orderObject.put(property, (Object)(order.getDirection() == Query.Order.Direction.DESC ? -1 : 1));
                        cursor.sort((DBObject)orderObject);
                    }
                }
                return cursor;
            }
        });
    }

    private DBObject createQueryObject(PersistentEntity persistentEntity) {
        BasicDBObject query = persistentEntity.isRoot() ? new BasicDBObject() : new BasicDBObject("_class", (Object)persistentEntity.getDiscriminator());
        return query;
    }

    public static void populateMongoQuery(MongoSession session, DBObject query, Query.Junction criteria, PersistentEntity entity) {
        ArrayList<DBObject> subList = null;
        if (criteria.getCriteria().size() > 1) {
            if (criteria instanceof Query.Disjunction) {
                subList = new ArrayList<DBObject>();
                query.put(MONGO_OR_OPERATOR, subList);
            } else if (criteria instanceof Query.Conjunction) {
                subList = new ArrayList();
                query.put(MONGO_AND_OPERATOR, subList);
            }
        }
        for (Query.Criterion criterion : criteria.getCriteria()) {
            QueryHandler queryHandler = queryHandlers.get(criterion.getClass());
            if (queryHandler != null) {
                Query.PropertyCriterion pc;
                PersistentProperty property;
                DBObject dbo = query;
                if (subList != null) {
                    dbo = new BasicDBObject();
                    subList.add(dbo);
                }
                if (criterion instanceof Query.PropertyCriterion && !(criterion instanceof GeoCriterion) && (property = entity.getPropertyByName((pc = (Query.PropertyCriterion)criterion).getProperty())) instanceof Custom) {
                    CustomTypeMarshaller customTypeMarshaller = ((Custom)property).getCustomTypeMarshaller();
                    customTypeMarshaller.query(property, pc, (Object)query);
                    continue;
                }
                queryHandler.handle((Session)session, criterion, dbo, entity);
                continue;
            }
            throw new InvalidDataAccessResourceUsageException("Queries of type " + criterion.getClass().getSimpleName() + " are not supported by this implementation");
        }
    }

    protected static String getPropertyName(PersistentEntity entity, Query.PropertyNameCriterion criterion) {
        String propertyName = criterion.getProperty();
        return MongoQuery.getPropertyName(entity, propertyName);
    }

    private static String getPropertyName(PersistentEntity entity, String propertyName) {
        if (entity.isIdentityName(propertyName)) {
            propertyName = "_id";
        } else {
            PersistentProperty property = entity.getPropertyByName(propertyName);
            if (property != null) {
                propertyName = MappingUtils.getTargetKey((PersistentProperty)property);
                if (property instanceof ToOne && !(property instanceof Embedded)) {
                    boolean isReference;
                    ToOne association = (ToOne)property;
                    MongoAttribute attr = (MongoAttribute)association.getMapping().getMappedForm();
                    boolean bl = isReference = attr == null || attr.isReference();
                    if (isReference) {
                        propertyName = propertyName + MONGO_ID_REFERENCE_SUFFIX;
                    }
                }
            }
        }
        return propertyName;
    }

    private Object createObjectFromDBObject(DBObject dbObject) {
        Object id = dbObject.get("_id");
        Class type = this.mongoEntityPersister.getPersistentEntity().getJavaClass();
        Object instance = this.mongoSession.getCachedInstance(type, (Serializable)id);
        if (instance == null) {
            instance = this.mongoEntityPersister.createObjectFromNativeEntry(this.mongoEntityPersister.getPersistentEntity(), (Serializable)id, dbObject);
            this.mongoSession.cacheInstance(type, (Serializable)id, instance);
        }
        return instance;
    }

    private List wrapObjectResultInList(Object object) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(object);
        return result;
    }

    public Query near(String property, List value) {
        this.add((Query.Criterion)new Near(property, value));
        return this;
    }

    public Query near(String property, Point value) {
        this.add((Query.Criterion)new Near(property, value));
        return this;
    }

    public Query near(String property, List value, Distance maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query near(String property, Point value, Distance maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query near(String property, List value, Number maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query near(String property, Point value, Number maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, List value) {
        this.add((Query.Criterion)new NearSphere(property, value));
        return this;
    }

    public Query nearSphere(String property, Point value) {
        this.add((Query.Criterion)new NearSphere(property, value));
        return this;
    }

    public Query nearSphere(String property, List value, Distance maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, Point value, Distance maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, List value, Number maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, Point value, Number maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query withinBox(String property, List value) {
        this.add((Query.Criterion)new WithinBox(property, value));
        return this;
    }

    public Query geoWithin(String property, Shape shape) {
        this.add((Query.Criterion)new GeoWithin(property, shape));
        return this;
    }

    public Query geoIntersects(String property, GeoJSON shape) {
        this.add((Query.Criterion)new GeoIntersects(property, shape));
        return this;
    }

    public Query withinPolygon(String property, List value) {
        this.add((Query.Criterion)new WithinPolygon(property, value));
        return this;
    }

    public Query withinCircle(String property, List value) {
        this.add((Query.Criterion)new WithinBox(property, value));
        return this;
    }

    public void setArguments(Map arguments) {
        this.queryArguments = arguments;
    }

    static {
        queryHandlers.put(Query.IdEquals.class, new QueryHandler<Query.IdEquals>(){

            @Override
            public void handle(Session session, Query.IdEquals criterion, DBObject query, PersistentEntity entity) {
                query.put("_id", criterion.getValue());
            }
        });
        queryHandlers.put(AssociationQuery.class, new QueryHandler<AssociationQuery>(){

            @Override
            public void handle(Session session, AssociationQuery criterion, DBObject query, PersistentEntity entity) {
                Association association = criterion.getAssociation();
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                if (association instanceof EmbeddedCollection) {
                    BasicDBObject associationCollectionQuery = new BasicDBObject();
                    MongoQuery.populateMongoQuery((MongoSession)session, (DBObject)associationCollectionQuery, criterion.getCriteria(), associatedEntity);
                    BasicDBObject collectionQuery = new BasicDBObject("$elemMatch", (Object)associationCollectionQuery);
                    String propertyKey = MongoQuery.getPropertyName(entity, association.getName());
                    query.put(propertyKey, (Object)collectionQuery);
                } else if (associatedEntity instanceof EmbeddedPersistentEntity || association instanceof Embedded) {
                    BasicDBObject associatedEntityQuery = new BasicDBObject();
                    MongoQuery.populateMongoQuery((MongoSession)session, (DBObject)associatedEntityQuery, criterion.getCriteria(), associatedEntity);
                    for (String property : associatedEntityQuery.keySet()) {
                        String propertyKey = MongoQuery.getPropertyName(entity, association.getName());
                        query.put(propertyKey + '.' + property, associatedEntityQuery.get(property));
                    }
                } else {
                    throw new UnsupportedOperationException("Join queries are not supported by MongoDB");
                }
            }
        });
        queryHandlers.put(Query.Equals.class, new QueryHandler<Query.Equals>(){

            @Override
            public void handle(Session session, Query.Equals criterion, DBObject query, PersistentEntity entity) {
                Object value;
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                PersistentProperty persistentProperty = entity.getPropertyByName(criterion.getProperty());
                if (persistentProperty instanceof Embedded && criterion.getValue() != null) {
                    MongoEntityPersister persister = (MongoEntityPersister)session.getPersister((Object)entity.getJavaClass());
                    value = persister.createNativeObjectForEmbedded((Association)persistentProperty, criterion.getValue());
                } else {
                    value = criterion.getValue();
                }
                if (value instanceof Pattern) {
                    Pattern pattern = (Pattern)value;
                    query.put(propertyName, (Object)new BasicDBObject(MongoQuery.MONGO_REGEX_OPERATOR, (Object)pattern.toString()));
                } else {
                    MongoEntityPersister.setDBObjectValue(query, propertyName, value, entity.getMappingContext());
                }
            }
        });
        queryHandlers.put(Query.IsNull.class, new QueryHandler<Query.IsNull>(){

            @Override
            public void handle(Session session, Query.IsNull criterion, DBObject query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.Equals.class)).handle(session, new Query.Equals(criterion.getProperty(), null), query, entity);
            }
        });
        queryHandlers.put(Query.IsNotNull.class, new QueryHandler<Query.IsNotNull>(){

            @Override
            public void handle(Session session, Query.IsNotNull criterion, DBObject query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.NotEquals.class)).handle(session, new Query.NotEquals(criterion.getProperty(), null), query, entity);
            }
        });
        queryHandlers.put(Query.EqualsProperty.class, new QueryHandler<Query.EqualsProperty>(){

            @Override
            public void handle(Session session, Query.EqualsProperty criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "==");
            }
        });
        queryHandlers.put(Query.NotEqualsProperty.class, new QueryHandler<Query.NotEqualsProperty>(){

            @Override
            public void handle(Session session, Query.NotEqualsProperty criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "!=");
            }
        });
        queryHandlers.put(Query.GreaterThanProperty.class, new QueryHandler<Query.GreaterThanProperty>(){

            @Override
            public void handle(Session session, Query.GreaterThanProperty criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, ">");
            }
        });
        queryHandlers.put(Query.LessThanProperty.class, new QueryHandler<Query.LessThanProperty>(){

            @Override
            public void handle(Session session, Query.LessThanProperty criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "<");
            }
        });
        queryHandlers.put(Query.GreaterThanEqualsProperty.class, new QueryHandler<Query.GreaterThanEqualsProperty>(){

            @Override
            public void handle(Session session, Query.GreaterThanEqualsProperty criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, ">=");
            }
        });
        queryHandlers.put(Query.LessThanEqualsProperty.class, new QueryHandler<Query.LessThanEqualsProperty>(){

            @Override
            public void handle(Session session, Query.LessThanEqualsProperty criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "<=");
            }
        });
        queryHandlers.put(Query.NotEquals.class, new QueryHandler<Query.NotEquals>(){

            @Override
            public void handle(Session session, Query.NotEquals criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                DBObject notEqualQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(notEqualQuery, MongoQuery.MONGO_NE_OPERATOR, criterion.getValue(), entity.getMappingContext());
                query.put(propertyName, (Object)notEqualQuery);
            }
        });
        queryHandlers.put(Query.Like.class, new QueryHandler<Query.Like>(){

            @Override
            public void handle(Session session, Query.Like like, DBObject query, PersistentEntity entity) {
                MongoQuery.handleLike(entity, like, query, true);
            }
        });
        queryHandlers.put(Query.ILike.class, new QueryHandler<Query.ILike>(){

            @Override
            public void handle(Session session, Query.ILike like, DBObject query, PersistentEntity entity) {
                MongoQuery.handleLike(entity, (Query.Like)like, query, false);
            }
        });
        queryHandlers.put(Query.RLike.class, new QueryHandler<Query.RLike>(){

            @Override
            public void handle(Session session, Query.RLike like, DBObject query, PersistentEntity entity) {
                Object value = like.getValue();
                if (value == null) {
                    value = "null";
                }
                String expr = value.toString();
                Pattern regex = Pattern.compile(expr);
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)like);
                query.put(propertyName, (Object)regex);
            }
        });
        queryHandlers.put(Query.In.class, new QueryHandler<Query.In>(){

            @Override
            public void handle(Session session, Query.In in, DBObject query, PersistentEntity entity) {
                BasicDBObject inQuery = new BasicDBObject();
                List values = MongoQuery.getInListQueryValues(entity, in);
                inQuery.put(MongoQuery.MONGO_IN_OPERATOR, (Object)values);
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)in);
                query.put(propertyName, (Object)inQuery);
            }
        });
        queryHandlers.put(WithinBox.class, new QueryHandler<WithinBox>(){

            @Override
            public void handle(Session session, WithinBox withinBox, DBObject query, PersistentEntity entity) {
                BasicDBObject nearQuery = new BasicDBObject();
                BasicDBObject box = new BasicDBObject();
                MongoEntityPersister.setDBObjectValue((DBObject)box, MongoQuery.BOX_OPERATOR, withinBox.getValues(), entity.getMappingContext());
                nearQuery.put(MongoQuery.WITHIN_OPERATOR, (Object)box);
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)withinBox);
                query.put(propertyName, (Object)nearQuery);
            }
        });
        queryHandlers.put(WithinPolygon.class, new QueryHandler<WithinPolygon>(){

            @Override
            public void handle(Session session, WithinPolygon withinPolygon, DBObject query, PersistentEntity entity) {
                BasicDBObject nearQuery = new BasicDBObject();
                BasicDBObject box = new BasicDBObject();
                MongoEntityPersister.setDBObjectValue((DBObject)box, MongoQuery.POLYGON_OPERATOR, withinPolygon.getValues(), entity.getMappingContext());
                nearQuery.put(MongoQuery.WITHIN_OPERATOR, (Object)box);
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)withinPolygon);
                query.put(propertyName, (Object)nearQuery);
            }
        });
        queryHandlers.put(WithinCircle.class, new QueryHandler<WithinCircle>(){

            @Override
            public void handle(Session session, WithinCircle withinCentre, DBObject query, PersistentEntity entity) {
                BasicDBObject nearQuery = new BasicDBObject();
                BasicDBObject center = new BasicDBObject();
                MongoEntityPersister.setDBObjectValue((DBObject)center, MongoQuery.CENTER_OPERATOR, withinCentre.getValues(), entity.getMappingContext());
                nearQuery.put(MongoQuery.WITHIN_OPERATOR, (Object)center);
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)withinCentre);
                query.put(propertyName, (Object)nearQuery);
            }
        });
        QueryHandler<Near> nearHandler = new QueryHandler<Near>(){

            @Override
            public void handle(Session session, Near near, DBObject query, PersistentEntity entity) {
                String nearOperator;
                BasicDBObject nearQuery = new BasicDBObject();
                Object value = near.getValue();
                String string = nearOperator = near instanceof NearSphere ? MongoQuery.NEAR_SPHERE_OPERATOR : MongoQuery.NEAR_OPERATOR;
                if (value instanceof List || value instanceof Map) {
                    MongoEntityPersister.setDBObjectValue((DBObject)nearQuery, nearOperator, value, entity.getMappingContext());
                } else if (value instanceof Point) {
                    BasicBSONObject geoJson = GeoJSONType.convertToGeoJSON((Point)value);
                    BasicDBObject geometry = new BasicDBObject();
                    geometry.put(MongoQuery.GEOMETRY_OPERATOR, (Object)geoJson);
                    if (near.maxDistance != null) {
                        geometry.put(MongoQuery.MAX_DISTANCE_OPERATOR, (Object)near.maxDistance.getValue());
                    }
                    nearQuery.put(nearOperator, (Object)geometry);
                }
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)near);
                query.put(propertyName, (Object)nearQuery);
            }
        };
        queryHandlers.put(Near.class, nearHandler);
        queryHandlers.put(NearSphere.class, nearHandler);
        queryHandlers.put(GeoWithin.class, new QueryHandler<GeoWithin>(){

            @Override
            public void handle(Session session, GeoWithin geoWithin, DBObject query, PersistentEntity entity) {
                BasicDBObject queryRoot = new BasicDBObject();
                BasicDBObject queryGeoWithin = new BasicDBObject();
                queryRoot.put(MongoQuery.GEO_WITHIN_OPERATOR, (Object)queryGeoWithin);
                String targetProperty = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)geoWithin);
                Object value = geoWithin.getValue();
                if (value instanceof Shape) {
                    Shape shape = (Shape)value;
                    if (shape instanceof Polygon) {
                        Polygon p = (Polygon)shape;
                        BasicBSONObject geoJson = GeoJSONType.convertToGeoJSON(p);
                        queryGeoWithin.put(MongoQuery.GEOMETRY_OPERATOR, (Object)geoJson);
                    } else if (shape instanceof Box) {
                        queryGeoWithin.put(MongoQuery.BOX_OPERATOR, shape.asList());
                    } else if (shape instanceof Circle) {
                        queryGeoWithin.put(MongoQuery.CENTER_OPERATOR, shape.asList());
                    } else if (shape instanceof Sphere) {
                        queryGeoWithin.put(MongoQuery.CENTER_SPHERE_OPERATOR, shape.asList());
                    }
                } else if (value instanceof Map) {
                    queryGeoWithin.putAll((Map)value);
                }
                query.put(targetProperty, (Object)queryRoot);
            }
        });
        queryHandlers.put(GeoIntersects.class, new QueryHandler<GeoIntersects>(){

            @Override
            public void handle(Session session, GeoIntersects geoIntersects, DBObject query, PersistentEntity entity) {
                BasicDBObject queryRoot = new BasicDBObject();
                BasicDBObject queryGeoWithin = new BasicDBObject();
                queryRoot.put(MongoQuery.GEO_INTERSECTS_OPERATOR, (Object)queryGeoWithin);
                String targetProperty = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)geoIntersects);
                Object value = geoIntersects.getValue();
                if (value instanceof GeoJSON) {
                    Shape shape = (Shape)value;
                    BasicBSONObject geoJson = GeoJSONType.convertToGeoJSON(shape);
                    queryGeoWithin.put(MongoQuery.GEOMETRY_OPERATOR, (Object)geoJson);
                } else if (value instanceof Map) {
                    queryGeoWithin.putAll((Map)value);
                }
                query.put(targetProperty, (Object)queryRoot);
            }
        });
        queryHandlers.put(Query.Between.class, new QueryHandler<Query.Between>(){

            @Override
            public void handle(Session session, Query.Between between, DBObject query, PersistentEntity entity) {
                BasicDBObject betweenQuery = new BasicDBObject();
                MongoEntityPersister.setDBObjectValue((DBObject)betweenQuery, MongoQuery.MONGO_GTE_OPERATOR, between.getFrom(), entity.getMappingContext());
                MongoEntityPersister.setDBObjectValue((DBObject)betweenQuery, MongoQuery.MONGO_LTE_OPERATOR, between.getTo(), entity.getMappingContext());
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)between);
                query.put(propertyName, (Object)betweenQuery);
            }
        });
        queryHandlers.put(Query.GreaterThan.class, new QueryHandler<Query.GreaterThan>(){

            @Override
            public void handle(Session session, Query.GreaterThan criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                DBObject greaterThanQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(greaterThanQuery, MongoQuery.MONGO_GT_OPERATOR, criterion.getValue(), entity.getMappingContext());
                query.put(propertyName, (Object)greaterThanQuery);
            }
        });
        queryHandlers.put(Query.GreaterThanEquals.class, new QueryHandler<Query.GreaterThanEquals>(){

            @Override
            public void handle(Session session, Query.GreaterThanEquals criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                DBObject greaterThanQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(greaterThanQuery, MongoQuery.MONGO_GTE_OPERATOR, criterion.getValue(), entity.getMappingContext());
                query.put(propertyName, (Object)greaterThanQuery);
            }
        });
        queryHandlers.put(Query.LessThan.class, new QueryHandler<Query.LessThan>(){

            @Override
            public void handle(Session session, Query.LessThan criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                DBObject lessThanQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(lessThanQuery, MongoQuery.MONGO_LT_OPERATOR, criterion.getValue(), entity.getMappingContext());
                query.put(propertyName, (Object)lessThanQuery);
            }
        });
        queryHandlers.put(Query.LessThanEquals.class, new QueryHandler<Query.LessThanEquals>(){

            @Override
            public void handle(Session session, Query.LessThanEquals criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                DBObject lessThanQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(lessThanQuery, MongoQuery.MONGO_LTE_OPERATOR, criterion.getValue(), entity.getMappingContext());
                query.put(propertyName, (Object)lessThanQuery);
            }
        });
        queryHandlers.put(Query.Conjunction.class, new QueryHandler<Query.Conjunction>(){

            @Override
            public void handle(Session session, Query.Conjunction criterion, DBObject query, PersistentEntity entity) {
                MongoQuery.populateMongoQuery((MongoSession)session, query, (Query.Junction)criterion, entity);
            }
        });
        queryHandlers.put(Query.Negation.class, new QueryHandler<Query.Negation>(){

            @Override
            public void handle(Session session, Query.Negation criteria, DBObject query, PersistentEntity entity) {
                for (Query.Criterion criterion : criteria.getCriteria()) {
                    QueryHandler queryHandler = (QueryHandler)negatedHandlers.get(criterion.getClass());
                    if (queryHandler != null) {
                        queryHandler.handle(session, criterion, query, entity);
                        continue;
                    }
                    throw new UnsupportedOperationException("Query of type " + criterion.getClass().getSimpleName() + " cannot be negated");
                }
            }
        });
        queryHandlers.put(Query.Disjunction.class, new QueryHandler<Query.Disjunction>(){

            @Override
            public void handle(Session session, Query.Disjunction criterion, DBObject query, PersistentEntity entity) {
                MongoQuery.populateMongoQuery((MongoSession)session, query, (Query.Junction)criterion, entity);
            }
        });
        queryHandlers.put(Query.SizeEquals.class, new QueryHandler<Query.SizeEquals>(){

            @Override
            public void handle(Session session, Query.SizeEquals criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                DBObject sizeEqualsQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(sizeEqualsQuery, MongoQuery.SIZE_OPERATOR, MongoQuery.getNumber((Query.PropertyCriterion)criterion), entity.getMappingContext());
                query.put(propertyName, (Object)sizeEqualsQuery);
            }
        });
        queryHandlers.put(Query.SizeNotEquals.class, new QueryHandler<Query.SizeNotEquals>(){

            @Override
            public void handle(Session session, Query.SizeNotEquals criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                DBObject sizeNotEqualsQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                sizeNotEqualsQuery.put(MongoQuery.NOT_OPERATOR, (Object)new BasicDBObject(MongoQuery.SIZE_OPERATOR, (Object)MongoQuery.getNumber((Query.PropertyCriterion)criterion)));
                query.put(propertyName, (Object)sizeNotEqualsQuery);
            }
        });
        queryHandlers.put(Query.SizeGreaterThan.class, new QueryHandler<Query.SizeGreaterThan>(){

            @Override
            public void handle(Session session, Query.SizeGreaterThan criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Integer greaterThanValue = MongoQuery.getNumber((Query.PropertyCriterion)criterion);
                query.put(propertyName + '.' + greaterThanValue, (Object)new BasicDBObject(MongoQuery.EXISTS_OPERATOR, (Object)true));
            }
        });
        queryHandlers.put(Query.SizeLessThan.class, new QueryHandler<Query.SizeLessThan>(){

            @Override
            public void handle(Session session, Query.SizeLessThan criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Integer lessThanValue = MongoQuery.getNumber((Query.PropertyCriterion)criterion);
                query.put(propertyName + '.' + (lessThanValue - 1), (Object)new BasicDBObject(MongoQuery.EXISTS_OPERATOR, (Object)0));
            }
        });
        queryHandlers.put(Query.SizeLessThanEquals.class, new QueryHandler<Query.SizeLessThanEquals>(){

            @Override
            public void handle(Session session, Query.SizeLessThanEquals criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Integer lessThanValue = MongoQuery.getNumber((Query.PropertyCriterion)criterion);
                query.put(propertyName + '.' + lessThanValue, (Object)new BasicDBObject(MongoQuery.EXISTS_OPERATOR, (Object)0));
            }
        });
        queryHandlers.put(Query.SizeGreaterThanEquals.class, new QueryHandler<Query.SizeGreaterThanEquals>(){

            @Override
            public void handle(Session session, Query.SizeGreaterThanEquals criterion, DBObject query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Integer greaterThanValue = MongoQuery.getNumber((Query.PropertyCriterion)criterion);
                query.put(propertyName + '.' + (greaterThanValue - 1), (Object)new BasicDBObject(MongoQuery.EXISTS_OPERATOR, (Object)true));
            }
        });
        negatedHandlers.put(Query.SizeEquals.class, new QueryHandler<Query.SizeEquals>(){

            @Override
            public void handle(Session session, Query.SizeEquals criterion, DBObject query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.SizeNotEquals.class)).handle(session, Restrictions.sizeNe((String)criterion.getProperty(), (int)MongoQuery.getNumber((Query.PropertyCriterion)criterion)), query, entity);
            }
        });
        negatedHandlers.put(Query.SizeNotEquals.class, new QueryHandler<Query.SizeNotEquals>(){

            @Override
            public void handle(Session session, Query.SizeNotEquals criterion, DBObject query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.SizeEquals.class)).handle(session, Restrictions.sizeEq((String)criterion.getProperty(), (int)MongoQuery.getNumber((Query.PropertyCriterion)criterion)), query, entity);
            }
        });
        negatedHandlers.put(Query.SizeGreaterThan.class, new QueryHandler<Query.SizeGreaterThan>(){

            @Override
            public void handle(Session session, Query.SizeGreaterThan criterion, DBObject query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.SizeLessThan.class)).handle(session, Restrictions.sizeLt((String)criterion.getProperty(), (int)MongoQuery.getNumber((Query.PropertyCriterion)criterion)), query, entity);
            }
        });
        negatedHandlers.put(Query.SizeLessThan.class, new QueryHandler<Query.SizeLessThan>(){

            @Override
            public void handle(Session session, Query.SizeLessThan criterion, DBObject query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.SizeGreaterThan.class)).handle(session, Restrictions.sizeGt((String)criterion.getProperty(), (int)MongoQuery.getNumber((Query.PropertyCriterion)criterion)), query, entity);
            }
        });
        negatedHandlers.put(Query.Equals.class, new QueryHandler<Query.Equals>(){

            @Override
            public void handle(Session session, Query.Equals criterion, DBObject query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.NotEquals.class)).handle(session, Restrictions.ne((String)criterion.getProperty(), (Object)criterion.getValue()), query, entity);
            }
        });
        negatedHandlers.put(Query.NotEquals.class, new QueryHandler<Query.NotEquals>(){

            @Override
            public void handle(Session session, Query.NotEquals criterion, DBObject query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.Equals.class)).handle(session, Restrictions.eq((String)criterion.getProperty(), (Object)criterion.getValue()), query, entity);
            }
        });
        negatedHandlers.put(Query.In.class, new QueryHandler<Query.In>(){

            @Override
            public void handle(Session session, Query.In in, DBObject query, PersistentEntity entity) {
                List nativePropertyValue = MongoQuery.getInListQueryValues(entity, in);
                String property = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)in);
                DBObject inQuery = MongoQuery.getOrCreatePropertyQuery(query, property);
                inQuery.put(MongoQuery.MONGO_NIN_OPERATOR, (Object)nativePropertyValue);
                query.put(property, (Object)inQuery);
            }
        });
        negatedHandlers.put(Query.Between.class, new QueryHandler<Query.Between>(){

            @Override
            public void handle(Session session, Query.Between between, DBObject query, PersistentEntity entity) {
                String property = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)between);
                DBObject betweenQuery = MongoQuery.getOrCreatePropertyQuery(query, property);
                betweenQuery.put(MongoQuery.MONGO_LTE_OPERATOR, between.getFrom());
                betweenQuery.put(MongoQuery.MONGO_GTE_OPERATOR, between.getTo());
                query.put(property, (Object)betweenQuery);
            }
        });
        negatedHandlers.put(Query.GreaterThan.class, new QueryHandler<Query.GreaterThan>(){

            @Override
            public void handle(Session session, Query.GreaterThan criterion, DBObject query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.LessThan.class)).handle(session, Restrictions.lt((String)criterion.getProperty(), (Object)criterion.getValue()), query, entity);
            }
        });
        negatedHandlers.put(Query.GreaterThanEquals.class, new QueryHandler<Query.GreaterThanEquals>(){

            @Override
            public void handle(Session session, Query.GreaterThanEquals criterion, DBObject query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.LessThanEquals.class)).handle(session, Restrictions.lte((String)criterion.getProperty(), (Object)criterion.getValue()), query, entity);
            }
        });
        negatedHandlers.put(Query.LessThan.class, new QueryHandler<Query.LessThan>(){

            @Override
            public void handle(Session session, Query.LessThan criterion, DBObject query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.GreaterThan.class)).handle(session, Restrictions.gt((String)criterion.getProperty(), (Object)criterion.getValue()), query, entity);
            }
        });
        negatedHandlers.put(Query.LessThanEquals.class, new QueryHandler<Query.LessThanEquals>(){

            @Override
            public void handle(Session session, Query.LessThanEquals criterion, DBObject query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.GreaterThanEquals.class)).handle(session, Restrictions.gte((String)criterion.getProperty(), (Object)criterion.getValue()), query, entity);
            }
        });
        groupByProjectionHandlers.put(Query.AvgProjection.class, new ProjectionHandler<Query.AvgProjection>(){

            @Override
            public String handle(PersistentEntity entity, DBObject projectObject, DBObject groupBy, Query.AvgProjection projection) {
                return MongoQuery.addProjectionToGroupBy(projectObject, groupBy, (Query.PropertyProjection)projection, MongoQuery.AVERAGE_OPERATOR, "avg_");
            }
        });
        groupByProjectionHandlers.put(Query.CountProjection.class, new ProjectionHandler<Query.CountProjection>(){

            @Override
            public String handle(PersistentEntity entity, DBObject projectObject, DBObject groupBy, Query.CountProjection projection) {
                projectObject.put("_id", (Object)1);
                String projectionKey = "count";
                groupBy.put(projectionKey, (Object)new BasicDBObject(MongoQuery.SUM_OPERATOR, (Object)1));
                return projectionKey;
            }
        });
        groupByProjectionHandlers.put(Query.CountDistinctProjection.class, new ProjectionHandler<Query.CountDistinctProjection>(){

            @Override
            public String handle(PersistentEntity entity, DBObject projectObject, DBObject groupBy, Query.CountDistinctProjection projection) {
                projectObject.put(projection.getPropertyName(), (Object)1);
                String property = projection.getPropertyName();
                String projectionValueKey = "countDistinct_" + property;
                DBObject id = MongoQuery.getIdObjectForGroupBy(groupBy);
                id.put(property, (Object)("$" + property));
                return projectionValueKey;
            }
        });
        groupByProjectionHandlers.put(Query.MinProjection.class, new ProjectionHandler<Query.MinProjection>(){

            @Override
            public String handle(PersistentEntity entity, DBObject projectObject, DBObject groupBy, Query.MinProjection projection) {
                return MongoQuery.addProjectionToGroupBy(projectObject, groupBy, (Query.PropertyProjection)projection, MongoQuery.MIN_OPERATOR, "min_");
            }
        });
        groupByProjectionHandlers.put(Query.MaxProjection.class, new ProjectionHandler<Query.MaxProjection>(){

            @Override
            public String handle(PersistentEntity entity, DBObject projectObject, DBObject groupBy, Query.MaxProjection projection) {
                return MongoQuery.addProjectionToGroupBy(projectObject, groupBy, (Query.PropertyProjection)projection, MongoQuery.MAX_OPERATOR, "max_");
            }
        });
        groupByProjectionHandlers.put(Query.SumProjection.class, new ProjectionHandler<Query.SumProjection>(){

            @Override
            public String handle(PersistentEntity entity, DBObject projectObject, DBObject groupBy, Query.SumProjection projection) {
                return MongoQuery.addProjectionToGroupBy(projectObject, groupBy, (Query.PropertyProjection)projection, MongoQuery.SUM_OPERATOR, "sum_");
            }
        });
        projectProjectionHandlers.put(Query.DistinctPropertyProjection.class, new ProjectionHandler<Query.DistinctPropertyProjection>(){

            @Override
            public String handle(PersistentEntity entity, DBObject projectObject, DBObject groupBy, Query.DistinctPropertyProjection projection) {
                String property = projection.getPropertyName();
                projectObject.put(property, (Object)1);
                DBObject id = MongoQuery.getIdObjectForGroupBy(groupBy);
                id.put(property, (Object)("$" + property));
                return property;
            }
        });
        projectProjectionHandlers.put(Query.PropertyProjection.class, new ProjectionHandler<Query.PropertyProjection>(){

            @Override
            public String handle(PersistentEntity entity, DBObject projectObject, DBObject groupBy, Query.PropertyProjection projection) {
                String property = projection.getPropertyName();
                projectObject.put(property, (Object)1);
                DBObject id = MongoQuery.getIdObjectForGroupBy(groupBy);
                id.put(property, (Object)("$" + property));
                id.put("_id", (Object)"$_id");
                return property;
            }
        });
        projectProjectionHandlers.put(Query.IdProjection.class, new ProjectionHandler<Query.IdProjection>(){

            @Override
            public String handle(PersistentEntity entity, DBObject projectObject, DBObject groupBy, Query.IdProjection projection) {
                projectObject.put("_id", (Object)1);
                DBObject id = MongoQuery.getIdObjectForGroupBy(groupBy);
                id.put("_id", (Object)"$_id");
                return "_id";
            }
        });
    }

    private static class ProjectedProperty {
        Query.Projection projection;
        String projectionKey;
        PersistentProperty property;

        private ProjectedProperty() {
        }
    }

    public static class MongoResultList
    extends AbstractList
    implements Closeable {
        private MongoEntityPersister mongoEntityPersister;
        private Cursor cursor;
        private int offset = 0;
        private int internalIndex;
        private List initializedObjects = new ArrayList();
        private Integer size;
        private boolean initialized = false;

        public MongoResultList(Cursor cursor, int offset, MongoEntityPersister mongoEntityPersister) {
            this.cursor = cursor;
            this.mongoEntityPersister = mongoEntityPersister;
            this.offset = offset;
        }

        @Override
        public String toString() {
            this.initializeFully();
            return this.initializedObjects.toString();
        }

        public Cursor getCursor() {
            return this.cursor;
        }

        @Override
        public boolean isEmpty() {
            return this.initializedObjects.isEmpty() && !this.cursor.hasNext();
        }

        @Override
        public Object get(int index) {
            if (this.initializedObjects.size() > index) {
                return this.initializedObjects.get(index);
            }
            if (!this.initialized) {
                while (this.cursor.hasNext()) {
                    if (this.internalIndex > index) {
                        throw new ArrayIndexOutOfBoundsException("Cannot retrieve element at index " + index + " for cursor size " + this.size());
                    }
                    Object o = this.convertDBObject(this.cursor.next());
                    this.initializedObjects.add(this.internalIndex, o);
                    if (index != this.internalIndex++) continue;
                    return o;
                }
                this.initialized = true;
            }
            throw new ArrayIndexOutOfBoundsException("Cannot retrieve element at index " + index + " for cursor size " + this.size());
        }

        @Override
        public Object set(int index, Object o) {
            if (index > this.size() - 1) {
                throw new ArrayIndexOutOfBoundsException("Cannot set element at index " + index + " for cursor size " + this.size());
            }
            this.get(index);
            return this.initializedObjects.set(index, o);
        }

        @Override
        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator listIterator(int index) {
            this.initializeFully();
            return this.initializedObjects.listIterator(0);
        }

        private void initializeFully() {
            if (this.initialized) {
                return;
            }
            while (this.cursor.hasNext()) {
                DBObject dbo = (DBObject)this.cursor.next();
                Object current = this.convertDBObject(dbo);
                this.initializedObjects.add(current);
            }
            this.initialized = true;
        }

        @Override
        public Iterator iterator() {
            Cursor cursor;
            if (this.initialized) {
                return this.initializedObjects.iterator();
            }
            if (this.cursor instanceof DBCursor) {
                DBCursor dbCursor = (DBCursor)this.cursor;
                DBCursor newDbCursor = dbCursor.copy();
                cursor = newDbCursor;
                newDbCursor.skip(this.offset);
            } else {
                cursor = this.cursor;
            }
            return new Iterator(){
                Object current;

                @Override
                public boolean hasNext() {
                    boolean hasMore = cursor.hasNext();
                    if (!hasMore) {
                        MongoResultList.this.initialized = true;
                    }
                    return hasMore;
                }

                public Object next() {
                    DBObject dbo = (DBObject)cursor.next();
                    this.current = MongoResultList.this.convertDBObject(dbo);
                    MongoResultList.this.initializedObjects.add(this.current);
                    return this.current;
                }

                @Override
                public void remove() {
                    MongoResultList.this.initializedObjects.remove(this.current);
                }
            };
        }

        @Override
        public int size() {
            if (this.initialized) {
                return this.initializedObjects.size();
            }
            if (this.size == null) {
                if (this.cursor instanceof DBCursor) {
                    this.size = ((DBCursor)this.cursor).size();
                } else {
                    this.size = 0;
                    while (this.cursor.hasNext()) {
                        DBObject object = (DBObject)this.cursor.next();
                        this.initializedObjects.add(this.convertDBObject(object));
                        MongoResultList mongoResultList = this;
                        Integer n = mongoResultList.size;
                        Integer n2 = mongoResultList.size = Integer.valueOf(mongoResultList.size + 1);
                    }
                    this.initialized = true;
                }
            }
            return this.size;
        }

        protected Object convertDBObject(Object object) {
            Class type;
            DBObject dbObject = (DBObject)object;
            Object id = dbObject.get("_id");
            SessionImplementor session = (SessionImplementor)this.mongoEntityPersister.getSession();
            Object instance = session.getCachedInstance(type = this.mongoEntityPersister.getPersistentEntity().getJavaClass(), (Serializable)id);
            if (instance == null) {
                instance = this.mongoEntityPersister.createObjectFromNativeEntry(this.mongoEntityPersister.getPersistentEntity(), (Serializable)id, dbObject);
                session.cacheInstance(type, (Serializable)id, instance);
            }
            return instance;
        }

        public Object clone() {
            return new MongoResultList(this.cursor, this.offset, this.mongoEntityPersister);
        }

        @Override
        public void close() throws IOException {
            this.cursor.close();
        }
    }

    public static class AggregatedResultList
    extends AbstractList
    implements Closeable {
        private Cursor cursor;
        private List<ProjectedProperty> projectedProperties;
        private List initializedObjects = new ArrayList();
        private int internalIndex = 0;
        private boolean initialized = false;
        private boolean containsAssociations = false;
        private Session session;

        public AggregatedResultList(Session session, Cursor cursor, List<ProjectedProperty> projectedProperties) {
            this.cursor = cursor;
            this.projectedProperties = projectedProperties;
            this.session = session;
            for (ProjectedProperty projectedProperty : projectedProperties) {
                if (!(projectedProperty.property instanceof Association)) continue;
                this.containsAssociations = true;
                break;
            }
        }

        @Override
        public String toString() {
            return this.initializedObjects.toString();
        }

        @Override
        public Object get(int index) {
            if (this.containsAssociations) {
                this.initializeFully();
            }
            if (this.initializedObjects.size() > index) {
                return this.initializedObjects.get(index);
            }
            if (!this.initialized) {
                boolean hasResults = false;
                while (this.cursor.hasNext()) {
                    hasResults = true;
                    DBObject dbo = (DBObject)this.cursor.next();
                    Object projected = this.addInitializedObject(dbo);
                    if (index != this.internalIndex) continue;
                    return projected;
                }
                if (!hasResults) {
                    this.handleNoResults();
                }
                this.initialized = true;
            }
            throw new ArrayIndexOutOfBoundsException("Index value " + index + " exceeds size of aggregate list");
        }

        @Override
        public Object set(int index, Object element) {
            this.initializeFully();
            return this.initializedObjects.set(index, element);
        }

        @Override
        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator listIterator(int index) {
            this.initializeFully();
            return this.initializedObjects.listIterator(index);
        }

        protected void initializeFully() {
            if (this.initialized) {
                return;
            }
            if (this.containsAssociations) {
                if (this.projectedProperties.size() == 1) {
                    ProjectedProperty projectedProperty = this.projectedProperties.get(0);
                    PersistentProperty property = projectedProperty.property;
                    ArrayList<Serializable> identifiers = new ArrayList<Serializable>();
                    boolean hasResults = false;
                    while (this.cursor.hasNext()) {
                        hasResults = true;
                        DBObject dbo = (DBObject)this.cursor.next();
                        Object id = this.getProjectedValue(dbo, projectedProperty.projectionKey);
                        identifiers.add((Serializable)id);
                    }
                    if (!hasResults) {
                        this.handleNoResults();
                    } else {
                        this.initializedObjects = this.session.retrieveAll(property.getType(), identifiers);
                    }
                } else {
                    Map<Integer, Map<Class, List<Serializable>>> associationMap = this.createAssociationMap();
                    boolean hasResults = false;
                    while (this.cursor.hasNext()) {
                        hasResults = true;
                        DBObject dbo = (DBObject)this.cursor.next();
                        ArrayList<Object> projectedResult = new ArrayList<Object>();
                        int index = 0;
                        for (ProjectedProperty projectedProperty : this.projectedProperties) {
                            PersistentProperty property = projectedProperty.property;
                            Object value = this.getProjectedValue(dbo, projectedProperty.projectionKey);
                            if (property instanceof Association) {
                                Map<Class, List<Serializable>> identifierMap = associationMap.get(index);
                                Class type = ((Association)property).getAssociatedEntity().getJavaClass();
                                identifierMap.get(type).add((Serializable)value);
                            }
                            projectedResult.add(value);
                            ++index;
                        }
                        this.initializedObjects.add(projectedResult);
                    }
                    if (!hasResults) {
                        this.handleNoResults();
                        return;
                    }
                    HashMap<Integer, List> finalResults = new HashMap<Integer, List>();
                    for (Integer index : associationMap.keySet()) {
                        Map<Class, List<Serializable>> associatedEntityIdentifiers = associationMap.get(index);
                        for (Class associationClass : associatedEntityIdentifiers.keySet()) {
                            List<Serializable> identifiers = associatedEntityIdentifiers.get(associationClass);
                            finalResults.put(index, this.session.retrieveAll(associationClass, identifiers));
                        }
                    }
                    for (Integer initializedObject : this.initializedObjects) {
                        List projected = (List)((Object)initializedObject);
                        for (Integer index : finalResults.keySet()) {
                            List resultsByIndex = (List)finalResults.get(index);
                            if (index < resultsByIndex.size()) {
                                projected.set(index, resultsByIndex.get(index));
                                continue;
                            }
                            projected.set(index, null);
                        }
                    }
                }
            } else {
                boolean hasResults = false;
                while (this.cursor.hasNext()) {
                    hasResults = true;
                    DBObject dbo = (DBObject)this.cursor.next();
                    this.addInitializedObject(dbo);
                }
                if (!hasResults) {
                    this.handleNoResults();
                }
            }
            this.initialized = true;
        }

        protected void handleNoResults() {
            ProjectedProperty projectedProperty = this.projectedProperties.get(0);
            if (projectedProperty.projection instanceof Query.CountProjection) {
                this.initializedObjects.add(0);
            }
        }

        private Map<Integer, Map<Class, List<Serializable>>> createAssociationMap() {
            HashMap<Integer, Map<Class, List<Serializable>>> associationMap = new HashMap();
            associationMap = DefaultGroovyMethods.withDefault(associationMap, (Closure)new Closure(this){

                public Object doCall(Object o) {
                    Map subMap = new HashMap();
                    subMap = DefaultGroovyMethods.withDefault(subMap, (Closure)new Closure((Object)this){

                        public Object doCall(Object o) {
                            return new ArrayList();
                        }
                    });
                    return subMap;
                }
            });
            return associationMap;
        }

        @Override
        public Iterator iterator() {
            if (this.initialized || this.containsAssociations || this.internalIndex > 0) {
                this.initializeFully();
                return this.initializedObjects.iterator();
            }
            if (!this.cursor.hasNext()) {
                this.handleNoResults();
                return this.initializedObjects.iterator();
            }
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    boolean hasMore = AggregatedResultList.this.cursor.hasNext();
                    if (!hasMore) {
                        AggregatedResultList.this.initialized = true;
                    }
                    return hasMore;
                }

                public Object next() {
                    DBObject dbo = (DBObject)AggregatedResultList.this.cursor.next();
                    return AggregatedResultList.this.addInitializedObject(dbo);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Aggregate result list cannot be mutated.");
                }
            };
        }

        private Object addInitializedObject(DBObject dbo) {
            if (this.projectedProperties.size() > 1) {
                ArrayList<Object> projected = new ArrayList<Object>();
                for (ProjectedProperty projectedProperty : this.projectedProperties) {
                    Object value = this.getProjectedValue(dbo, projectedProperty.projectionKey);
                    projected.add(value);
                }
                this.initializedObjects.add(this.internalIndex, projected);
                ++this.internalIndex;
                return projected;
            }
            ProjectedProperty projectedProperty = this.projectedProperties.get(0);
            Object projected = this.getProjectedValue(dbo, projectedProperty.projectionKey);
            this.initializedObjects.add(this.internalIndex, projected);
            ++this.internalIndex;
            return projected;
        }

        private Object getProjectedValue(DBObject dbo, String projectionKey) {
            Object value;
            if (projectionKey.startsWith("id.")) {
                projectionKey = projectionKey.substring(3);
                DBObject id = (DBObject)dbo.get("_id");
                value = id.get(projectionKey);
            } else {
                value = dbo.get(projectionKey);
            }
            return value;
        }

        @Override
        public int size() {
            this.initializeFully();
            return this.initializedObjects.size();
        }

        @Override
        public void close() throws IOException {
            this.cursor.close();
        }
    }

    private static interface ProjectionHandler<T extends Query.Projection> {
        public String handle(PersistentEntity var1, DBObject var2, DBObject var3, T var4);
    }

    private static interface QueryHandler<T> {
        public void handle(Session var1, T var2, DBObject var3, PersistentEntity var4);
    }

    public static class GeoIntersects
    extends GeoCriterion {
        public GeoIntersects(String name, Object value) {
            super(name, value);
        }
    }

    public static class GeoWithin
    extends GeoCriterion {
        public GeoWithin(String name, Object value) {
            super(name, value);
        }
    }

    public static class GeoCriterion
    extends Query.PropertyCriterion {
        public GeoCriterion(String name, Object value) {
            super(name, value);
        }
    }

    public static class WithinCircle
    extends Query.PropertyCriterion {
        public WithinCircle(String name, List value) {
            super(name, (Object)value);
        }

        public List getValues() {
            return (List)this.getValue();
        }

        public void setValue(List matrix) {
            this.value = matrix;
        }
    }

    public static class WithinPolygon
    extends Query.PropertyCriterion {
        public WithinPolygon(String name, List value) {
            super(name, (Object)value);
        }

        public List getValues() {
            return (List)this.getValue();
        }

        public void setValue(List value) {
            this.value = value;
        }
    }

    public static class WithinBox
    extends Query.PropertyCriterion {
        public WithinBox(String name, List value) {
            super(name, (Object)value);
        }

        public List getValues() {
            return (List)this.getValue();
        }

        public void setValue(List matrix) {
            this.value = matrix;
        }
    }

    public static class NearSphere
    extends Near {
        public NearSphere(String name, Object value) {
            super(name, value);
        }

        public NearSphere(String name, Object value, Distance maxDistance) {
            super(name, value, maxDistance);
        }

        public NearSphere(String name, Object value, Number maxDistance) {
            super(name, value, maxDistance);
        }
    }

    public static class Near
    extends GeoCriterion {
        Distance maxDistance = null;

        public Near(String name, Object value) {
            super(name, value);
        }

        public Near(String name, Object value, Distance maxDistance) {
            super(name, value);
            this.maxDistance = maxDistance;
        }

        public Near(String name, Object value, Number maxDistance) {
            super(name, value);
            this.maxDistance = Distance.valueOf(maxDistance.doubleValue());
        }

        public void setMaxDistance(Distance maxDistance) {
            this.maxDistance = maxDistance;
        }
    }
}

