/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.mongo.bean.factory;

import com.gmongo.GMongo;
import com.gmongo.GMongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.datastore.mapping.model.DatastoreConfigurationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class GMongoFactoryBean
implements FactoryBean<GMongo>,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private GMongo mongo;
    private MongoOptions mongoOptions;
    private String host;
    private Integer port;
    private List<ServerAddress> replicaSetSeeds;
    private List<ServerAddress> replicaPair;
    private String connectionString;

    public void setReplicaPair(List<ServerAddress> replicaPair) {
        this.replicaPair = replicaPair;
    }

    public void setReplicaSetSeeds(List<ServerAddress> replicaSetSeeds) {
        this.replicaSetSeeds = replicaSetSeeds;
    }

    public void setMongoOptions(MongoOptions mongoOptions) {
        this.mongoOptions = mongoOptions;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public GMongo getObject() throws Exception {
        Assert.notNull((Object)this.mongo, (String)"Mongo must not be null");
        return this.mongo;
    }

    public Class<? extends GMongo> getObjectType() {
        return GMongo.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() throws UnknownHostException {
        if (this.mongo != null) {
            return;
        }
        ServerAddress defaultOptions = new ServerAddress();
        if (this.mongoOptions == null) {
            this.mongoOptions = new MongoOptions();
        }
        if (this.replicaPair != null) {
            if (this.replicaPair.size() < 2) {
                throw new DatastoreConfigurationException("A replica pair must have two server entries");
            }
            this.mongo = new GMongo(this.replicaPair.get(0), this.replicaPair.get(1), this.mongoOptions);
        } else if (this.replicaSetSeeds != null) {
            this.mongo = new GMongo(this.replicaSetSeeds, this.mongoOptions);
        } else if (this.connectionString != null) {
            this.mongo = new GMongoClient(new MongoClientURI(this.connectionString));
        } else {
            String mongoHost = this.host != null ? this.host : defaultOptions.getHost();
            this.mongo = this.port != null ? new GMongo(new ServerAddress(mongoHost, this.port.intValue()), this.mongoOptions) : new GMongo(mongoHost, this.mongoOptions);
        }
    }

    public void destroy() {
        if (this.mongo == null) {
            return;
        }
        this.mongo.close();
        this.mongo = null;
    }
}

