/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.config;

import com.mongodb.DBObject;
import com.mongodb.DBRef;
import groovy.lang.Closure;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;
import org.grails.datastore.gorm.mongo.geo.BoxType;
import org.grails.datastore.gorm.mongo.geo.CircleType;
import org.grails.datastore.gorm.mongo.geo.LineStringType;
import org.grails.datastore.gorm.mongo.geo.PointType;
import org.grails.datastore.gorm.mongo.geo.PolygonType;
import org.grails.datastore.gorm.mongo.geo.ShapeType;
import org.grails.datastore.mapping.config.AbstractGormMappingFactory;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.document.config.Collection;
import org.grails.datastore.mapping.document.config.DocumentMappingContext;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.AbstractClassMapping;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.EmbeddedPersistentEntity;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.mongo.config.MongoAttribute;
import org.grails.datastore.mapping.mongo.config.MongoCollection;

public class MongoMappingContext
extends DocumentMappingContext {
    private static final Set<String> MONGO_NATIVE_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Double.class.getName(), String.class.getName(), DBObject.class.getName(), Binary.class.getName(), ObjectId.class.getName(), DBRef.class.getName(), Boolean.class.getName(), Date.class.getName(), Pattern.class.getName(), Symbol.class.getName(), Integer.class.getName(), BSONTimestamp.class.getName(), Code.class.getName(), CodeWScope.class.getName(), Long.class.getName(), UUID.class.getName(), byte[].class.getName(), Byte.class.getName())));

    public static boolean isMongoNativeType(Class clazz) {
        return MONGO_NATIVE_TYPES.contains(clazz.getName()) || DBObject.class.isAssignableFrom(clazz.getClass());
    }

    public MongoMappingContext(String defaultDatabaseName) {
        super(defaultDatabaseName);
        this.registerMongoTypes();
    }

    public MongoMappingContext(String defaultDatabaseName, Closure defaultMapping) {
        super(defaultDatabaseName, defaultMapping);
        this.registerMongoTypes();
    }

    protected void registerMongoTypes() {
        MappingFactory.registerCustomType((CustomTypeMarshaller)new PointType());
        MappingFactory.registerCustomType((CustomTypeMarshaller)new PolygonType());
        MappingFactory.registerCustomType((CustomTypeMarshaller)new LineStringType());
        MappingFactory.registerCustomType((CustomTypeMarshaller)new ShapeType());
        MappingFactory.registerCustomType((CustomTypeMarshaller)new BoxType());
        MappingFactory.registerCustomType((CustomTypeMarshaller)new CircleType());
    }

    protected MappingFactory createDocumentMappingFactory(Closure defaultMapping) {
        MongoDocumentMappingFactory mongoDocumentMappingFactory = new MongoDocumentMappingFactory();
        mongoDocumentMappingFactory.setDefaultMapping(defaultMapping);
        return mongoDocumentMappingFactory;
    }

    public PersistentEntity createEmbeddedEntity(Class type) {
        return new DocumentEmbeddedPersistentEntity(type, (MappingContext)this);
    }

    class DocumentEmbeddedPersistentEntity
    extends EmbeddedPersistentEntity {
        private DocumentCollectionMapping classMapping;

        public DocumentEmbeddedPersistentEntity(Class type, MappingContext ctx) {
            super(type, ctx);
            this.classMapping = new DocumentCollectionMapping((PersistentEntity)this, ctx);
        }

        public ClassMapping getMapping() {
            return this.classMapping;
        }

        public class DocumentCollectionMapping
        extends AbstractClassMapping<Collection> {
            private Collection mappedForm;

            public DocumentCollectionMapping(PersistentEntity entity, MappingContext context) {
                super(entity, context);
                this.mappedForm = (Collection)context.getMappingFactory().createMappedForm((PersistentEntity)DocumentEmbeddedPersistentEntity.this);
            }

            public Collection getMappedForm() {
                return this.mappedForm;
            }
        }
    }

    private final class MongoDocumentMappingFactory
    extends AbstractGormMappingFactory<MongoCollection, MongoAttribute> {
        private MongoDocumentMappingFactory() {
        }

        protected Class<MongoAttribute> getPropertyMappedFormType() {
            return MongoAttribute.class;
        }

        protected Class<MongoCollection> getEntityMappedFormType() {
            return MongoCollection.class;
        }

        protected IdentityMapping getIdentityMappedForm(final ClassMapping classMapping, final MongoAttribute property) {
            if (property == null) {
                return super.getIdentityMappedForm(classMapping, (Property)property);
            }
            return new IdentityMapping(){

                public String[] getIdentifierName() {
                    if (property.getName() == null) {
                        return new String[]{"id"};
                    }
                    return new String[]{property.getName()};
                }

                public ClassMapping getClassMapping() {
                    return classMapping;
                }

                public Property getMappedForm() {
                    return property;
                }
            };
        }

        public boolean isSimpleType(Class propType) {
            if (propType == null) {
                return false;
            }
            if (propType.isArray()) {
                return this.isSimpleType(propType.getComponentType()) || super.isSimpleType(propType);
            }
            return MongoMappingContext.isMongoNativeType(propType) || super.isSimpleType(propType);
        }
    }
}

