/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.engine;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.grails.datastore.mapping.core.IdentityGenerationException;
import org.grails.datastore.mapping.core.OptimisticLockingException;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.SessionImplementor;
import org.grails.datastore.mapping.engine.AssociationIndexer;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.NativeEntryEntityPersister;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.engine.PropertyValueIndexer;
import org.grails.datastore.mapping.model.EmbeddedPersistentEntity;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.EmbeddedCollection;
import org.grails.datastore.mapping.model.types.Identity;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.mongo.MongoDatastore;
import org.grails.datastore.mapping.mongo.MongoSession;
import org.grails.datastore.mapping.mongo.config.MongoAttribute;
import org.grails.datastore.mapping.mongo.config.MongoMappingContext;
import org.grails.datastore.mapping.mongo.query.MongoQuery;
import org.grails.datastore.mapping.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongoEntityPersister
extends NativeEntryEntityPersister<DBObject, Object> {
    static Logger log = LoggerFactory.getLogger(MongoEntityPersister.class);
    private static final String NEXT_ID_SUFFIX = ".next_id";
    private boolean hasNumericalIdentifier = false;
    private boolean hasStringIdentifier = false;
    public static final String MONGO_ID_FIELD = "_id";
    public static final String MONGO_CLASS_FIELD = "_class";

    public MongoEntityPersister(MappingContext mappingContext, PersistentEntity entity, MongoSession mongoSession, ApplicationEventPublisher publisher) {
        super(mappingContext, entity, (Session)mongoSession, publisher);
        PersistentProperty identity;
        MongoDatastore datastore = (MongoDatastore)mongoSession.getDatastore();
        if (!(entity instanceof EmbeddedPersistentEntity) && (identity = entity.getIdentity()) != null) {
            this.hasNumericalIdentifier = Long.class.isAssignableFrom(identity.getType());
            this.hasStringIdentifier = String.class.isAssignableFrom(identity.getType());
        }
    }

    protected void refreshObjectStateFromNativeEntry(PersistentEntity persistentEntity, Object obj, Serializable nativeKey, DBObject nativeEntry, boolean isEmbedded) {
        if (isEmbedded) {
            Object id = nativeEntry.get(MONGO_ID_FIELD);
            super.refreshObjectStateFromNativeEntry(persistentEntity, obj, (Serializable)id, (Object)nativeEntry, isEmbedded);
        } else {
            super.refreshObjectStateFromNativeEntry(persistentEntity, obj, nativeKey, (Object)nativeEntry, isEmbedded);
        }
    }

    protected DBObject getEmbedded(DBObject nativeEntry, String key) {
        Object embeddedDocument = nativeEntry.get(key);
        if (embeddedDocument instanceof DBObject) {
            return (DBObject)embeddedDocument;
        }
        return null;
    }

    protected void setEmbedded(DBObject nativeEntry, String key, DBObject embeddedEntry) {
        nativeEntry.put(key, (Object)embeddedEntry);
    }

    protected void setEmbeddedCollection(DBObject nativeEntry, String key, Collection<?> instances, List<DBObject> embeddedEntries) {
        if (instances == null || instances.isEmpty()) {
            nativeEntry.put(key, null);
            return;
        }
        nativeEntry.put(key, embeddedEntries);
    }

    protected List loadEmbeddedCollectionKeys(Association association, EntityAccess ea, DBObject nativeEntry) {
        if (nativeEntry == null) {
            return super.loadEmbeddedCollectionKeys(association, ea, (Object)nativeEntry);
        }
        Object entry = nativeEntry.get(this.getPropertyKey((PersistentProperty)association));
        ArrayList<Object> keys = new ArrayList<Object>();
        if (entry instanceof List) {
            List entries = (List)entry;
            for (Object o : entries) {
                if (o instanceof DBRef) {
                    DBRef dbref = (DBRef)o;
                    keys.add(dbref.getId());
                    continue;
                }
                if (o != null) {
                    keys.add(o);
                    continue;
                }
                keys.add(null);
            }
        }
        return keys;
    }

    protected void setEmbeddedCollectionKeys(Association association, EntityAccess embeddedEntityAccess, DBObject embeddedEntry, List<Serializable> keys) {
        ArrayList<Object> dbRefs = new ArrayList<Object>();
        boolean reference = this.isReference(association);
        for (Serializable foreignKey : keys) {
            if (reference) {
                dbRefs.add(new DBRef((DB)this.session.getNativeInterface(), this.getCollectionName(association.getAssociatedEntity()), (Object)foreignKey));
                continue;
            }
            dbRefs.add(foreignKey);
        }
        embeddedEntry.put(association.getName(), dbRefs);
    }

    protected void loadEmbeddedCollection(EmbeddedCollection embeddedCollection, EntityAccess ea, Object embeddedInstances, String propertyKey) {
        AbstractCollection instances = List.class.isAssignableFrom(embeddedCollection.getType()) ? new ArrayList() : new HashSet();
        if (embeddedInstances instanceof List) {
            List list = (List)embeddedInstances;
            for (Object dbo : list) {
                if (!(dbo instanceof BasicDBObject)) continue;
                BasicDBObject nativeEntry = (BasicDBObject)dbo;
                Object instance = this.createObjectFromEmbeddedNativeEntry(embeddedCollection.getAssociatedEntity(), nativeEntry);
                SessionImplementor si = (SessionImplementor)this.getSession();
                si.cacheEntry(embeddedCollection.getAssociatedEntity(), (Serializable)((Object)this.createEmbeddedKey(instance)), (Object)nativeEntry);
                instances.add(instance);
            }
        }
        ea.setProperty(embeddedCollection.getName(), instances);
    }

    protected boolean isEmbeddedEntry(Object entry) {
        return entry instanceof DBObject;
    }

    public Query createQuery() {
        return new MongoQuery((MongoSession)this.getSession(), this.getPersistentEntity());
    }

    protected boolean doesRequirePropertyIndexing() {
        return false;
    }

    protected List<Object> retrieveAllEntities(PersistentEntity persistentEntity, Iterable<Serializable> keys) {
        Query query = this.session.createQuery(persistentEntity.getJavaClass());
        PersistentProperty identity = persistentEntity.getIdentity();
        if (keys instanceof List) {
            ArrayList<Object> actualKeys = new ArrayList<Object>();
            for (Serializable key : keys) {
                Object id = this.getIdentifierForKey(key);
                actualKeys.add(id);
            }
            query.in(identity.getName(), actualKeys);
        } else {
            ArrayList<Serializable> keyList = new ArrayList<Serializable>();
            for (Serializable key : keys) {
                keyList.add(key);
            }
            query.in(identity.getName(), keyList);
        }
        ArrayList<Object> entityResults = new ArrayList<Object>();
        Iterator<Serializable> keyIterator = keys.iterator();
        HashMap resultMap = new HashMap();
        for (Object o : query.list()) {
            if (o instanceof DBObject) {
                DBObject dbo = (DBObject)o;
                o = this.createObjectFromNativeEntry(this.getPersistentEntity(), (Serializable)dbo.get(MONGO_ID_FIELD), dbo);
            }
            resultMap.put(this.getObjectIdentifier(o), o);
        }
        while (keyIterator.hasNext()) {
            Object key = this.getIdentifierForKey(keyIterator.next());
            ConversionService conversionService = this.getMappingContext().getConversionService();
            key = conversionService.convert(key, identity.getType());
            Object o = resultMap.get(key);
            entityResults.add(o);
        }
        return entityResults;
    }

    private Object getIdentifierForKey(Object key) {
        Object id = key;
        if (key instanceof DBRef) {
            DBRef ref = (DBRef)key;
            id = ref.getId();
        }
        return id;
    }

    protected List<Object> retrieveAllEntities(PersistentEntity persistentEntity, Serializable[] keys) {
        return this.retrieveAllEntities(persistentEntity, Arrays.asList(keys));
    }

    public String getEntityFamily() {
        return this.getMongoSession().getCollectionName(this.getPersistentEntity());
    }

    protected void deleteEntry(String family, final Object key, Object entry) {
        this.getMongoTemplate().execute((DbCallback)new DbCallback<Object>(){

            public Object doInDB(DB con) throws MongoException, DataAccessException {
                DBCollection dbCollection = this.getCollection(con);
                DBObject dbo = MongoEntityPersister.this.createDBObjectWithKey(key);
                MongoSession mongoSession = (MongoSession)MongoEntityPersister.this.session;
                WriteConcern writeConcern = mongoSession.getDeclaredWriteConcern(MongoEntityPersister.this.getPersistentEntity());
                if (writeConcern != null) {
                    dbCollection.remove(dbo, writeConcern);
                } else {
                    dbCollection.remove(dbo);
                }
                return null;
            }

            protected DBCollection getCollection(DB con) {
                return con.getCollection(MongoEntityPersister.this.getCollectionName(MongoEntityPersister.this.getPersistentEntity()));
            }
        });
    }

    protected MongoTemplate getMongoTemplate() {
        return this.getMongoSession().getMongoTemplate(this.getPersistentEntity());
    }

    protected Object generateIdentifier(final PersistentEntity persistentEntity, final DBObject nativeEntry) {
        return this.getMongoTemplate().execute((DbCallback)new DbCallback<Object>(){

            public Object doInDB(DB con) throws MongoException, DataAccessException {
                String collectionName = MongoEntityPersister.this.getCollectionName(persistentEntity, nativeEntry);
                DBCollection dbCollection = con.getCollection(collectionName + MongoEntityPersister.NEXT_ID_SUFFIX);
                if (MongoEntityPersister.this.hasNumericalIdentifier) {
                    DBObject result;
                    block3: {
                        int attempts = 0;
                        do {
                            if ((result = dbCollection.findAndModify((DBObject)new BasicDBObject(MongoEntityPersister.MONGO_ID_FIELD, (Object)collectionName), null, null, false, (DBObject)new BasicDBObject("$inc", (Object)new BasicDBObject("next_id", (Object)1)), true, true)) != null && con.getLastError().ok()) break block3;
                        } while (++attempts <= 3);
                        throw new IdentityGenerationException("Unable to generate identity using findAndModify after 3 attempts: " + con.getLastError().getErrorMessage());
                    }
                    long nextId = (Long)MongoEntityPersister.this.getMappingContext().getConversionService().convert(result.get("next_id"), Long.class);
                    nativeEntry.put(MongoEntityPersister.MONGO_ID_FIELD, (Object)nextId);
                    return nativeEntry.get(MongoEntityPersister.MONGO_ID_FIELD);
                }
                ObjectId objectId = ObjectId.get();
                if (ObjectId.class.isAssignableFrom(persistentEntity.getIdentity().getType())) {
                    nativeEntry.put(MongoEntityPersister.MONGO_ID_FIELD, (Object)objectId);
                    return objectId;
                }
                String stringId = objectId.toString();
                nativeEntry.put(MongoEntityPersister.MONGO_ID_FIELD, (Object)stringId);
                return stringId;
            }
        });
    }

    public PropertyValueIndexer getPropertyIndexer(PersistentProperty property) {
        return null;
    }

    public AssociationIndexer getAssociationIndexer(DBObject nativeEntry, Association association) {
        return new MongoAssociationIndexer(nativeEntry, association, (MongoSession)this.session);
    }

    protected DBObject createNewEntry(String family) {
        BasicDBObject dbo = new BasicDBObject();
        PersistentEntity persistentEntity = this.getPersistentEntity();
        if (!persistentEntity.isRoot()) {
            dbo.put(MONGO_CLASS_FIELD, (Object)persistentEntity.getDiscriminator());
        }
        return dbo;
    }

    protected Object getEntryValue(DBObject nativeEntry, String property) {
        Object value = nativeEntry.get(property);
        if (value instanceof DBRef) {
            return this.getIdentifierForKey(value);
        }
        return value;
    }

    protected Object formulateDatabaseReference(PersistentEntity persistentEntity, Association association, Serializable associationId) {
        DB db = (DB)this.session.getNativeInterface();
        boolean isReference = this.isReference(association);
        if (isReference) {
            return new DBRef(db, this.getCollectionName(association.getAssociatedEntity()), (Object)associationId);
        }
        return associationId;
    }

    private boolean isReference(Association association) {
        MongoAttribute attribute;
        PropertyMapping mapping = association.getMapping();
        if (mapping != null && (attribute = (MongoAttribute)mapping.getMappedForm()) != null) {
            return attribute.isReference();
        }
        return true;
    }

    protected void setEntryValue(DBObject nativeEntry, String key, Object value) {
        MappingContext mappingContext = this.getMappingContext();
        MongoEntityPersister.setDBObjectValue(nativeEntry, key, value, mappingContext);
    }

    protected String getPropertyKey(PersistentProperty prop) {
        if (prop instanceof Identity) {
            return MONGO_ID_FIELD;
        }
        return super.getPropertyKey(prop);
    }

    public static void setDBObjectValue(DBObject nativeEntry, String key, Object value, MappingContext mappingContext) {
        Object nativeValue = MongoEntityPersister.getSimpleNativePropertyValue(value, mappingContext);
        nativeEntry.put(key, nativeValue);
    }

    public static Object getSimpleNativePropertyValue(Object value, MappingContext mappingContext) {
        Cloneable nativeValue;
        if (value == null || mappingContext.isPersistentEntity((Object)value)) {
            nativeValue = null;
        } else if (MongoMappingContext.isMongoNativeType(value.getClass())) {
            nativeValue = value;
        } else if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            ArrayList<Object> nativeColl = new ArrayList<Object>(array.length);
            for (Object item : array) {
                nativeColl.add(MongoEntityPersister.getSimpleNativePropertyValue(item, mappingContext));
            }
            nativeValue = nativeColl;
        } else if (value instanceof Collection) {
            Collection existingColl = value;
            ArrayList<Object> nativeColl = new ArrayList<Object>(existingColl.size());
            for (Object item : existingColl) {
                nativeColl.add(MongoEntityPersister.getSimpleNativePropertyValue(item, mappingContext));
            }
            nativeValue = nativeColl;
        } else if (value instanceof Map) {
            Map existingMap = (Map)((Object)value);
            LinkedHashMap newMap = new LinkedHashMap();
            for (Map.Entry entry : existingMap.entrySet()) {
                newMap.put(entry.getKey(), MongoEntityPersister.getSimpleNativePropertyValue(entry.getValue(), mappingContext));
            }
            nativeValue = newMap;
        } else {
            nativeValue = MongoEntityPersister.convertPrimitiveToNative(value, mappingContext);
        }
        return nativeValue;
    }

    private static Object convertPrimitiveToNative(Object item, MappingContext mappingContext) {
        Object nativeValue;
        if (item != null) {
            ConversionService conversionService = mappingContext.getConversionService();
            TypeDescriptor itemTypeDescriptor = TypeDescriptor.forObject((Object)item);
            nativeValue = (itemTypeDescriptor.getObjectType() == Integer.class || itemTypeDescriptor.getObjectType() == Short.class) && conversionService.canConvert(itemTypeDescriptor, TypeDescriptor.valueOf(Integer.class)) ? conversionService.convert(item, Integer.class) : (conversionService.canConvert(itemTypeDescriptor, TypeDescriptor.valueOf(String.class)) ? conversionService.convert(item, String.class) : item.toString());
        } else {
            nativeValue = null;
        }
        return nativeValue;
    }

    protected PersistentEntity discriminatePersistentEntity(PersistentEntity persistentEntity, DBObject nativeEntry) {
        Object o = nativeEntry.get(MONGO_CLASS_FIELD);
        if (o != null) {
            String className = o.toString();
            PersistentEntity childEntity = this.getMappingContext().getChildEntityByDiscriminator(persistentEntity.getRootEntity(), className);
            if (childEntity != null) {
                return childEntity;
            }
        }
        return super.discriminatePersistentEntity(persistentEntity, (Object)nativeEntry);
    }

    protected DBObject retrieveEntry(final PersistentEntity persistentEntity, String family, final Serializable key) {
        return (DBObject)this.getMongoTemplate().execute((DbCallback)new DbCallback<DBObject>(){

            public DBObject doInDB(DB con) throws MongoException, DataAccessException {
                DBCollection dbCollection = con.getCollection(MongoEntityPersister.this.getCollectionName(persistentEntity));
                return dbCollection.findOne(MongoEntityPersister.this.createDBObjectWithKey(key));
            }
        });
    }

    private DBObject removeNullEntries(DBObject nativeEntry) {
        for (String key : new HashSet(nativeEntry.keySet())) {
            Object o = nativeEntry.get(key);
            if (o == null) {
                nativeEntry.removeField(key);
                continue;
            }
            if (o instanceof Object[]) {
                for (Object o2 : (Object[])o) {
                    if (!(o2 instanceof DBObject)) continue;
                    this.removeNullEntries((DBObject)o2);
                }
                continue;
            }
            if (o instanceof List) {
                for (Object o2 : (List)o) {
                    if (!(o2 instanceof DBObject)) continue;
                    this.removeNullEntries((DBObject)o2);
                }
                continue;
            }
            if (!(o instanceof DBObject)) continue;
            this.removeNullEntries((DBObject)o);
        }
        return nativeEntry;
    }

    protected Object storeEntry(PersistentEntity persistentEntity, EntityAccess entityAccess, final Object storeId, final DBObject nativeEntry) {
        return this.getMongoTemplate().execute((DbCallback)new DbCallback<Object>(){

            public Object doInDB(DB con) throws MongoException, DataAccessException {
                MongoEntityPersister.this.removeNullEntries(nativeEntry);
                nativeEntry.put(MongoEntityPersister.MONGO_ID_FIELD, storeId);
                return nativeEntry.get(MongoEntityPersister.MONGO_ID_FIELD);
            }
        });
    }

    public String getCollectionName(PersistentEntity persistentEntity) {
        return this.getCollectionName(persistentEntity, null);
    }

    private String getCollectionName(PersistentEntity persistentEntity, DBObject nativeEntry) {
        String collectionName;
        if (persistentEntity.isRoot()) {
            MongoSession mongoSession = (MongoSession)this.getSession();
            collectionName = mongoSession.getCollectionName(persistentEntity);
        } else {
            MongoSession mongoSession = (MongoSession)this.getSession();
            collectionName = mongoSession.getCollectionName(persistentEntity.getRootEntity());
        }
        return collectionName;
    }

    private DBObject modifyNullsToUnsets(DBObject nativeEntry) {
        BasicDBObject unsets = new BasicDBObject();
        BasicDBObject sets = new BasicDBObject();
        for (String key : nativeEntry.keySet()) {
            Object o = nativeEntry.get(key);
            if (o == null) {
                unsets.put(key, (Object)1);
                continue;
            }
            if (MONGO_ID_FIELD.equals(key)) continue;
            if (o instanceof Object[]) {
                sets.put(key, o);
                for (Object o2 : (Object[])o) {
                    if (!(o2 instanceof DBObject)) continue;
                    this.removeNullEntries((DBObject)o2);
                }
                continue;
            }
            if (o instanceof List) {
                sets.put(key, o);
                for (Object o2 : (List)o) {
                    if (!(o2 instanceof DBObject)) continue;
                    this.removeNullEntries((DBObject)o2);
                }
                continue;
            }
            if (o instanceof DBObject) {
                sets.put(key, (Object)this.removeNullEntries((DBObject)o));
                continue;
            }
            sets.put(key, o);
        }
        BasicDBObject newEntry = new BasicDBObject();
        newEntry.put("$set", (Object)sets);
        if (!unsets.keySet().isEmpty()) {
            newEntry.put("$unset", (Object)unsets);
        }
        return newEntry;
    }

    public void updateEntry(final PersistentEntity persistentEntity, final EntityAccess ea, final Object key, final DBObject entry) {
        this.getMongoTemplate().execute((DbCallback)new DbCallback<Object>(){

            public Object doInDB(DB con) throws MongoException, DataAccessException {
                String collectionName = MongoEntityPersister.this.getCollectionName(persistentEntity, entry);
                DBCollection dbCollection = con.getCollection(collectionName);
                DBObject dbo = MongoEntityPersister.this.createDBObjectWithKey(key);
                boolean versioned = MongoEntityPersister.this.isVersioned(ea);
                Object currentVersion = null;
                if (versioned) {
                    currentVersion = MongoEntityPersister.this.getCurrentVersion(ea);
                    MongoEntityPersister.this.incrementVersion(ea);
                    if (currentVersion != null) {
                        dbo.put("version", currentVersion);
                    }
                }
                DBObject newEntry = MongoEntityPersister.this.modifyNullsToUnsets(entry);
                MongoSession mongoSession = (MongoSession)MongoEntityPersister.this.session;
                WriteConcern writeConcern = mongoSession.getDeclaredWriteConcern(MongoEntityPersister.this.getPersistentEntity());
                WriteResult result = writeConcern != null ? dbCollection.update(dbo, newEntry, false, false, writeConcern) : dbCollection.update(dbo, newEntry, false, false);
                if (versioned && !((SessionImplementor)MongoEntityPersister.this.getSession()).isStateless(persistentEntity)) {
                    CommandResult error = result.getLastError(WriteConcern.ACKNOWLEDGED);
                    error.throwOnError();
                    if (error.getInt("n") == 0) {
                        if (currentVersion != null) {
                            ea.setProperty("version", currentVersion);
                        }
                        throw new OptimisticLockingException(persistentEntity, key);
                    }
                }
                return null;
            }
        });
    }

    protected void setManyToMany(PersistentEntity persistentEntity, Object obj, DBObject nativeEntry, ManyToMany manyToMany, Collection associatedObjects, Map<Association, List<Serializable>> toManyKeys) {
        ArrayList<Object> ids = new ArrayList<Object>();
        if (associatedObjects != null) {
            for (Object o : associatedObjects) {
                if (o == null) {
                    ids.add(null);
                    continue;
                }
                PersistentEntity childPersistentEntity = this.getMappingContext().getPersistentEntity(o.getClass().getName());
                EntityAccess entityAccess = this.createEntityAccess(childPersistentEntity, o);
                ids.add(entityAccess.getIdentifier());
            }
        }
        nativeEntry.put(manyToMany.getName() + "_$$manyToManyIds", ids);
    }

    protected Collection getManyToManyKeys(PersistentEntity persistentEntity, Object object, Serializable nativeKey, DBObject nativeEntry, ManyToMany manyToMany) {
        return (Collection)nativeEntry.get(manyToMany.getName() + "_$$manyToManyIds");
    }

    protected Object getCurrentVersion(EntityAccess ea) {
        Object currentVersion = ea.getProperty("version");
        if (Number.class.isAssignableFrom(ea.getPropertyType("version"))) {
            currentVersion = currentVersion != null ? Long.valueOf(((Number)currentVersion).longValue()) : currentVersion;
        }
        return currentVersion;
    }

    protected void deleteEntries(String family, final List<Object> keys) {
        this.getMongoTemplate().execute((DbCallback)new DbCallback<Object>(){

            public Object doInDB(DB con) throws MongoException, DataAccessException {
                String collectionName = MongoEntityPersister.this.getCollectionName(MongoEntityPersister.this.getPersistentEntity());
                DBCollection dbCollection = con.getCollection(collectionName);
                MongoSession mongoSession = (MongoSession)MongoEntityPersister.this.getSession();
                MongoQuery query = mongoSession.createQuery(MongoEntityPersister.this.getPersistentEntity().getJavaClass());
                query.in(MongoEntityPersister.this.getPersistentEntity().getIdentity().getName(), keys);
                dbCollection.remove(query.getMongoQuery());
                return null;
            }
        });
    }

    protected void cascadeDeleteCollection(EntityAccess entityAccess, Association association) {
        Object propValue = entityAccess.getProperty(association.getName());
        if (!(propValue instanceof Collection)) {
            return;
        }
        Collection collection = (Collection)propValue;
        Persister persister = null;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object child = iter.next();
            if (child == null) {
                log.warn("Encountered a null associated reference while cascade-deleting '{}' as part of {} (ID {})", new Object[]{association.getReferencedPropertyName(), entityAccess.getEntity().getClass().getName(), entityAccess.getIdentifier()});
                continue;
            }
            if (persister == null) {
                persister = this.session.getPersister(child);
            }
            persister.delete(child);
            iter.remove();
        }
    }

    protected DBObject createDBObjectWithKey(Object key) {
        BasicDBObject dbo = new BasicDBObject();
        if (this.hasNumericalIdentifier || this.hasStringIdentifier) {
            dbo.put(MONGO_ID_FIELD, key);
        } else if (key instanceof ObjectId) {
            dbo.put(MONGO_ID_FIELD, key);
        } else {
            dbo.put(MONGO_ID_FIELD, (Object)new ObjectId(key.toString()));
        }
        return dbo;
    }

    public boolean isDirty(Object instance, Object entry) {
        if (super.isDirty(instance, entry)) {
            return true;
        }
        DBObject dbo = (DBObject)entry;
        PersistentEntity entity = this.getPersistentEntity();
        EntityAccess entityAccess = this.createEntityAccess(entity, instance, dbo);
        DBObject cached = (DBObject)((SessionImplementor)this.getSession()).getCachedEntry(entity, (Serializable)entityAccess.getIdentifier(), true);
        return !dbo.equals(cached);
    }

    public MongoSession getMongoSession() {
        return (MongoSession)this.getSession();
    }

    private class MongoAssociationIndexer
    implements AssociationIndexer {
        private DBObject nativeEntry;
        private Association association;
        private MongoSession session;
        private boolean isReference = true;

        public MongoAssociationIndexer(DBObject nativeEntry, Association association, MongoSession session) {
            this.nativeEntry = nativeEntry;
            this.association = association;
            this.session = session;
            this.isReference = MongoEntityPersister.this.isReference(association);
        }

        public void preIndex(Object primaryKey, List foreignKeys) {
            if (!this.association.isBidirectional()) {
                DB db = this.session.getNativeInterface();
                ArrayList<Object> dbRefs = new ArrayList<Object>();
                for (Object foreignKey : foreignKeys) {
                    if (this.isReference) {
                        dbRefs.add(new DBRef(db, MongoEntityPersister.this.getCollectionName(this.association.getAssociatedEntity()), foreignKey));
                        continue;
                    }
                    dbRefs.add(foreignKey);
                }
                this.nativeEntry.put(this.association.getName(), dbRefs);
            }
        }

        public void index(Object primaryKey, List foreignKeys) {
        }

        public List query(Object primaryKey) {
            if (!this.association.isBidirectional()) {
                Object indexed = this.nativeEntry.get(this.association.getName());
                if (!(indexed instanceof Collection)) {
                    return Collections.emptyList();
                }
                List indexedList = this.getIndexedAssociationsAsList(indexed);
                if (this.associationsAreDbRefs(indexedList)) {
                    return this.extractIdsFromDbRefs(indexedList);
                }
                return indexedList;
            }
            Association inverseSide = this.association.getInverseSide();
            MongoQuery query = this.session.createQuery(this.association.getAssociatedEntity().getJavaClass());
            query.eq(inverseSide.getName(), primaryKey);
            query.projections().id();
            return query.list();
        }

        public PersistentEntity getIndexedEntity() {
            return this.association.getAssociatedEntity();
        }

        public void index(Object primaryKey, Object foreignKey) {
        }

        private List getIndexedAssociationsAsList(Object indexed) {
            return indexed instanceof List ? (List)indexed : new ArrayList((Collection)indexed);
        }

        private boolean associationsAreDbRefs(List indexedList) {
            return !indexedList.isEmpty() && indexedList.get(0) instanceof DBRef;
        }

        private List extractIdsFromDbRefs(List indexedList) {
            ArrayList<Object> resolvedDbRefs = new ArrayList<Object>();
            for (Object indexedAssociation : indexedList) {
                resolvedDbRefs.add(((DBRef)indexedAssociation).getId());
            }
            return resolvedDbRefs;
        }
    }
}

