/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins;

import grails.core.GrailsApplication;
import grails.plugins.DefaultGrailsPluginManager;
import grails.plugins.GrailsPlugin;
import grails.plugins.exceptions.PluginException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import org.grails.core.exceptions.GrailsConfigurationException;
import org.grails.spring.RuntimeSpringConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class ProfilingGrailsPluginManager
extends DefaultGrailsPluginManager {
    public ProfilingGrailsPluginManager(GrailsApplication application) {
        super(application);
    }

    public ProfilingGrailsPluginManager(Class<?>[] plugins, GrailsApplication application) {
        super(plugins, application);
    }

    public ProfilingGrailsPluginManager(Resource[] pluginFiles, GrailsApplication application) {
        super(pluginFiles, application);
    }

    public ProfilingGrailsPluginManager(String resourcePath, GrailsApplication application) {
        super(resourcePath, application);
    }

    public ProfilingGrailsPluginManager(String[] pluginResources, GrailsApplication application) {
        super(pluginResources, application);
    }

    @Override
    public void loadPlugins() throws PluginException {
        long time = System.currentTimeMillis();
        System.out.println("Loading plugins started");
        super.loadPlugins();
        System.out.println("Loading plugins took " + (System.currentTimeMillis() - time));
    }

    @Override
    public void doDynamicMethods() {
        long time = System.currentTimeMillis();
        System.out.println("doWithDynamicMethods started");
        this.checkInitialised();
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        for (Class COMMON_CLASS : COMMON_CLASSES) {
            registry.removeMetaClass(COMMON_CLASS);
        }
        for (GrailsPlugin plugin : this.pluginList) {
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            try {
                long pluginTime = System.currentTimeMillis();
                System.out.println("doWithDynamicMethods for plugin [" + plugin.getName() + "] started");
                plugin.doWithDynamicMethods(this.applicationContext);
                System.out.println("doWithDynamicMethods for plugin [" + plugin.getName() + "] took " + (System.currentTimeMillis() - pluginTime));
            }
            catch (Throwable t) {
                throw new GrailsConfigurationException("Error configuring dynamic methods for plugin " + String.valueOf(plugin) + ": " + t.getMessage(), t);
            }
        }
        System.out.println("doWithDynamicMethods took " + (System.currentTimeMillis() - time));
    }

    @Override
    public void doRuntimeConfiguration(RuntimeSpringConfiguration springConfig) {
        long time = System.currentTimeMillis();
        System.out.println("doWithSpring started");
        this.checkInitialised();
        for (GrailsPlugin plugin : this.pluginList) {
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            long pluginTime = System.currentTimeMillis();
            System.out.println("doWithSpring for plugin [" + plugin.getName() + "] started");
            plugin.doWithRuntimeConfiguration(springConfig);
            System.out.println("doWithSpring for plugin [" + plugin.getName() + "] took " + (System.currentTimeMillis() - pluginTime));
        }
        System.out.println("doWithSpring took " + (System.currentTimeMillis() - time));
    }

    @Override
    public void doPostProcessing(ApplicationContext ctx) {
        long time = System.currentTimeMillis();
        System.out.println("doWithApplicationContext started");
        this.checkInitialised();
        for (GrailsPlugin plugin : this.pluginList) {
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            long pluginTime = System.currentTimeMillis();
            System.out.println("doWithApplicationContext for plugin [" + plugin.getName() + "] started");
            plugin.doWithApplicationContext(ctx);
            System.out.println("doWithApplicationContext for plugin [" + plugin.getName() + "] took " + (System.currentTimeMillis() - pluginTime));
        }
        System.out.println("doWithApplicationContext took " + (System.currentTimeMillis() - time));
    }

    @Override
    public void doArtefactConfiguration() {
        long time = System.currentTimeMillis();
        System.out.println("doArtefactConfiguration started");
        super.doArtefactConfiguration();
        System.out.println("doArtefactConfiguration took " + (System.currentTimeMillis() - time));
    }
}

