/*
 * Decompiled with CFR 0.152.
 */
package org.grails.core.util;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;

public class StopWatch {
    private final String id;
    private final Deque<TaskInfo> runningTasks = new LinkedList<TaskInfo>();
    private final Deque<TaskInfo> taskList = new LinkedList<TaskInfo>();
    private boolean running;
    private String currentTaskName;
    private TaskInfo lastTaskInfo;
    private int taskCount;
    private long totalTimeMillis;

    public StopWatch() {
        this.id = "";
    }

    public StopWatch(String id) {
        this.id = id;
    }

    public void start() throws IllegalStateException {
        this.start("");
    }

    public void start(String taskName) throws IllegalStateException {
        this.lastTaskInfo = new TaskInfo(taskName, System.currentTimeMillis());
        this.runningTasks.push(this.lastTaskInfo);
        ++this.taskCount;
        this.running = true;
        this.currentTaskName = taskName;
    }

    public void stop() throws IllegalStateException {
        if (!this.running) {
            throw new IllegalStateException("Can't stop StopWatch: it's not running");
        }
        if (!this.runningTasks.isEmpty()) {
            TaskInfo lastTask = this.runningTasks.pop();
            lastTask.stop();
            this.taskList.add(lastTask);
            this.currentTaskName = null;
            this.totalTimeMillis += lastTask.getTimeMillis();
        }
    }

    public void complete() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getLastTaskTimeMillis() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task interval");
        }
        return this.lastTaskInfo.getTimeMillis();
    }

    public String getLastTaskName() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task name");
        }
        return this.lastTaskInfo.getTaskName();
    }

    public TaskInfo getLastTaskInfo() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task info");
        }
        return this.lastTaskInfo;
    }

    public long getTotalTimeMillis() {
        return this.totalTimeMillis;
    }

    public double getTotalTimeSeconds() {
        return (double)this.totalTimeMillis / 1000.0;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public TaskInfo[] getTaskInfo() {
        return this.taskList.toArray(new TaskInfo[this.taskList.size()]);
    }

    public String shortSummary() {
        return "StopWatch '" + this.id + "': running time (millis) = " + this.getTotalTimeMillis();
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder(this.shortSummary());
        sb.append('\n');
        sb.append("-----------------------------------------\n");
        sb.append("ms     %     Task name\n");
        sb.append("-----------------------------------------\n");
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumIntegerDigits(5);
        nf.setGroupingUsed(false);
        NumberFormat pf = NumberFormat.getPercentInstance();
        pf.setMinimumIntegerDigits(3);
        pf.setGroupingUsed(false);
        TaskInfo[] taskInfos = this.getTaskInfo();
        Arrays.sort(taskInfos, new Comparator<TaskInfo>(){

            @Override
            public int compare(TaskInfo o1, TaskInfo o2) {
                return Long.compare(o1.getTimeMillis(), o2.getTimeMillis());
            }
        });
        for (TaskInfo task : taskInfos) {
            sb.append(nf.format(task.getTimeMillis())).append("  ");
            sb.append(pf.format(task.getTimeSeconds() / this.getTotalTimeSeconds())).append("  ");
            sb.append(task.getTaskName()).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.shortSummary());
        for (TaskInfo task : this.getTaskInfo()) {
            sb.append("; [").append(task.getTaskName()).append("] took ").append(task.getTimeMillis());
            long percent = Math.round(100.0 * task.getTimeSeconds() / this.getTotalTimeSeconds());
            sb.append(" = ").append(percent).append("%");
        }
        return sb.toString();
    }

    public static final class TaskInfo {
        private final String taskName;
        private final long startTime;
        private long endTime;

        TaskInfo(String taskName, long startTime) {
            this.taskName = taskName;
            this.startTime = startTime;
        }

        public void stop() {
            this.endTime = System.currentTimeMillis();
        }

        public String getTaskName() {
            return this.taskName;
        }

        public long getTimeMillis() {
            return this.endTime - this.startTime;
        }

        public double getTimeSeconds() {
            return (double)this.getTimeMillis() / 1000.0;
        }
    }
}

