/*
 * Decompiled with CFR 0.152.
 */
package org.grails.core.util;

import grails.util.GrailsClassUtils;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.Script;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedField;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ClassInfo;
import org.springframework.beans.BeanUtils;

public class ClassPropertyFetcher {
    private static final Set<String> IGNORED_FIELD_NAMES = new HashSet<String>(){
        {
            this.add("class");
            this.add("metaClass");
        }
    };
    private final Class<?> clazz;
    private final Map<String, PropertyFetcher> staticFetchers = new HashMap<String, PropertyFetcher>();
    private final Map<String, PropertyFetcher> instanceFetchers = new HashMap<String, PropertyFetcher>();
    private final ReferenceInstanceCallback callback;
    private final FieldCallback fieldCallback;
    private final MethodCallback methodCallback;
    private static Map<Class<?>, ClassPropertyFetcher> cachedClassPropertyFetchers = new ConcurrentHashMap();

    public static void clearClassPropertyFetcherCache() {
        cachedClassPropertyFetchers.clear();
    }

    public static ClassPropertyFetcher forClass(Class<?> c) {
        return ClassPropertyFetcher.forClass(c, null);
    }

    public static ClassPropertyFetcher forClass(final Class<?> c, ReferenceInstanceCallback callback) {
        ClassPropertyFetcher cpf = cachedClassPropertyFetchers.get(c);
        if (cpf == null) {
            if (callback == null) {
                callback = new ReferenceInstanceCallback(){
                    private Object o;

                    @Override
                    public Object getReferenceInstance() {
                        if (this.o == null) {
                            try {
                                this.o = c.newInstance();
                            }
                            catch (InstantiationException e) {
                                throw new RuntimeException("Could not instantiate instance: " + e.getMessage(), e);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException("Could not instantiate instance: " + e.getMessage(), e);
                            }
                        }
                        return this.o;
                    }
                };
            }
            cpf = new ClassPropertyFetcher(c, callback);
            cachedClassPropertyFetchers.put(c, cpf);
        }
        return cpf;
    }

    protected ClassPropertyFetcher(Class<?> clazz, ReferenceInstanceCallback callback) {
        this.clazz = clazz;
        this.callback = callback;
        this.fieldCallback = new FieldCallback(){

            @Override
            public void doWith(CachedField field) {
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers)) {
                    return;
                }
                String name = field.getName();
                if (name.indexOf(36) == -1) {
                    if (IGNORED_FIELD_NAMES.contains(name)) {
                        return;
                    }
                    boolean staticField = Modifier.isStatic(modifiers);
                    if (staticField) {
                        ClassPropertyFetcher.this.staticFetchers.put(name, new FieldReaderFetcher(field, true));
                    } else {
                        ClassPropertyFetcher.this.instanceFetchers.put(name, new FieldReaderFetcher(field, false));
                    }
                }
            }
        };
        this.methodCallback = new MethodCallback(){

            @Override
            public void doWith(CachedMethod method) throws IllegalArgumentException, IllegalAccessException {
                Class returnType = method.getReturnType();
                if (!method.isPublic()) {
                    return;
                }
                if (returnType == Void.class || returnType == Void.TYPE || method.getParameterTypes().length != 0) {
                    return;
                }
                String propertyName = GrailsClassUtils.getPropertyForGetter(method.getName(), method.getReturnType());
                if (propertyName == null || propertyName.indexOf(36) != -1) {
                    return;
                }
                if (method.getName().startsWith("is") && returnType != Boolean.class && returnType != Boolean.TYPE) {
                    return;
                }
                if (method.isStatic()) {
                    ClassPropertyFetcher.this.staticFetchers.put(propertyName, new GetterPropertyFetcher(method, true));
                } else {
                    ClassPropertyFetcher.this.instanceFetchers.put(propertyName, new GetterPropertyFetcher(method, false));
                }
            }
        };
        this.init();
    }

    public Object getReference() {
        if (this.callback != null) {
            return this.callback.getReferenceInstance();
        }
        return null;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.getPropertyDescriptors(this.clazz);
    }

    public boolean isReadableProperty(String name) {
        return this.staticFetchers.containsKey(name) || this.instanceFetchers.containsKey(name);
    }

    private void init() {
        CachedMethod[] methods;
        CachedField[] fields;
        ClassInfo classInfo = ClassInfo.getClassInfo(this.clazz);
        for (Class<?> superclass = this.clazz.getSuperclass(); superclass != Object.class && superclass != Script.class && superclass != GroovyObjectSupport.class && superclass != null; superclass = superclass.getSuperclass()) {
            ClassPropertyFetcher superFetcher = ClassPropertyFetcher.forClass(superclass);
            this.staticFetchers.putAll(superFetcher.staticFetchers);
            this.instanceFetchers.putAll(superFetcher.instanceFetchers);
        }
        CachedClass cachedClass = classInfo.getCachedClass();
        for (CachedField field : fields = cachedClass.getFields()) {
            try {
                this.fieldCallback.doWith(field);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Shouldn't be illegal to access field '" + field.getName() + "': " + ex);
            }
        }
        for (CachedMethod method : methods = cachedClass.getMethods()) {
            try {
                this.methodCallback.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Shouldn't be illegal to access method '" + method.getName() + "': " + ex);
            }
        }
    }

    private PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) {
        return BeanUtils.getPropertyDescriptors(clazz);
    }

    public Object getPropertyValue(String name) {
        return this.getPropertyValue(name, false);
    }

    public Object getPropertyValue(final Object object, String name) {
        PropertyFetcher fetcher = this.resolveFetcher(name, true);
        return this.getPropertyWithFetcherAndCallback(name, fetcher, new ReferenceInstanceCallback(){

            @Override
            public Object getReferenceInstance() {
                return object;
            }
        });
    }

    public Object getPropertyValue(String name, boolean onlyInstanceProperties) {
        PropertyFetcher fetcher = this.resolveFetcher(name, onlyInstanceProperties);
        return this.getPropertyValueWithFetcher(name, fetcher);
    }

    private Object getPropertyValueWithFetcher(String name, PropertyFetcher fetcher) {
        ReferenceInstanceCallback referenceInstanceCallback = this.callback;
        return this.getPropertyWithFetcherAndCallback(name, fetcher, referenceInstanceCallback);
    }

    private Object getPropertyWithFetcherAndCallback(String name, PropertyFetcher fetcher, ReferenceInstanceCallback referenceInstanceCallback) {
        if (fetcher != null) {
            try {
                return fetcher.get(referenceInstanceCallback);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public <T> T getStaticPropertyValue(String name, Class<T> c) {
        PropertyFetcher fetcher = this.staticFetchers.get(name);
        if (fetcher != null) {
            Object v = this.getPropertyValueWithFetcher(name, fetcher);
            return this.returnOnlyIfInstanceOf(v, c);
        }
        return null;
    }

    public <T> T getPropertyValue(String name, Class<T> c) {
        return this.returnOnlyIfInstanceOf(this.getPropertyValue(name, false), c);
    }

    private <T> T returnOnlyIfInstanceOf(Object value, Class<T> type) {
        if (value != null && (type == Object.class || GrailsClassUtils.isGroovyAssignableFrom(type, value.getClass()))) {
            return (T)value;
        }
        return null;
    }

    private PropertyFetcher resolveFetcher(String name, boolean onlyInstanceProperties) {
        PropertyFetcher fetcher = null;
        if (!onlyInstanceProperties) {
            fetcher = this.staticFetchers.get(name);
        }
        if (fetcher == null) {
            fetcher = this.instanceFetchers.get(name);
        }
        return fetcher;
    }

    public Class<?> getPropertyType(String name) {
        return this.getPropertyType(name, false);
    }

    public Class<?> getPropertyType(String name, boolean onlyInstanceProperties) {
        PropertyFetcher fetcher = this.resolveFetcher(name, onlyInstanceProperties);
        if (fetcher != null) {
            return fetcher.getPropertyType(name);
        }
        return null;
    }

    private static interface MethodCallback {
        public void doWith(CachedMethod var1) throws IllegalAccessException;
    }

    private static interface FieldCallback {
        public void doWith(CachedField var1) throws IllegalAccessException;
    }

    static class FieldReaderFetcher
    implements PropertyFetcher {
        private final CachedField field;
        private final boolean staticField;

        public FieldReaderFetcher(CachedField field, boolean staticField) {
            this.field = field;
            this.staticField = staticField;
        }

        @Override
        public Object get(ReferenceInstanceCallback callback) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.staticField) {
                return this.field.getProperty(null);
            }
            if (callback != null) {
                return this.field.getProperty(callback.getReferenceInstance());
            }
            return null;
        }

        @Override
        public Class<?> getPropertyType(String name) {
            return this.field.getType();
        }
    }

    static class GetterPropertyFetcher
    implements PropertyFetcher {
        private static final Object[] ZERO_ARGS = new Object[0];
        private final CachedMethod readMethod;
        private final boolean staticMethod;

        GetterPropertyFetcher(CachedMethod readMethod, boolean staticMethod) {
            this.readMethod = readMethod;
            this.staticMethod = staticMethod;
        }

        @Override
        public Object get(ReferenceInstanceCallback callback) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.staticMethod) {
                return this.readMethod.invoke(null, ZERO_ARGS);
            }
            if (callback != null) {
                return this.readMethod.invoke(callback.getReferenceInstance(), ZERO_ARGS);
            }
            return null;
        }

        @Override
        public Class<?> getPropertyType(String name) {
            return this.readMethod.getReturnType();
        }
    }

    static interface PropertyFetcher {
        public Object get(ReferenceInstanceCallback var1) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

        public Class<?> getPropertyType(String var1);
    }

    public static interface ReferenceInstanceCallback {
        public Object getReferenceInstance();
    }
}

